

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCustomProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCustomProperty.sp,v $ $Id: AppGetCustomProperty.sp,v 1.2.12.6 2018/03/22 01:50:34 jiechen Exp $";
--	+===================================================================+
--	|  					  AppGetCustomProperty								|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCustomProperty <<<'

IF EXISTS (select * from sysobjects where name='AppGetCustomProperty')
	drop procedure AppGetCustomProperty
IF EXISTS (select * from GxQscripts where name='AppGetCustomProperty')
	delete from GxQscripts where name = 'AppGetCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCustomProperty')
	delete from GXDBVersions where aliasname = 'AppGetCustomProperty'
GO
print '... Creating Procedure: AppGetCustomProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCustomProperty
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @propertyXML		XML
	DECLARE @allProps			INT = 0
	DECLARE @securityXML		XML
	DECLARE @propertyInfo TABLE
	(propertyId INT)
	-- Read the XML
	DECLARE @propertyId			INT				= ISNULL (( SELECT ref.value('@propertyId', 'INT')
														FROM @inXml.nodes ('App_GetCustomPropertyRequest/property') R(ref)), 0)
	DECLARE @propertyName	NVARCHAR(MAX)		= ISNULL (( SELECT ref.value('@propertyName', 'NVARCHAR(MAX)')
														FROM @inXml.nodes ('App_GetCustomPropertyRequest/property') R(ref)), '')
	DECLARE @inPropertyLevel	INT	= ISNULL (( SELECT ref.value('@propertyLevel', 'INT')
													FROM @inXml.nodes ('App_GetCustomPropertyRequest') R(ref)), 30) -- ListPropertyLevels_AllProperties
	DECLARE @clientId			INT	= ISNULL (( SELECT ref.value('@clientId', 'INT')
													FROM @inXml.nodes ('App_GetCustomPropertyRequest/client') R(ref)), 0)
	-- CHECK IF CLIENT EXIST
	IF @clientId = 0
	BEGIN
		SELECT @clientId = A.clientId FROM APP_SubClientProp SC WITH(NOLOCK)
			JOIN APP_Application A WITH(NOLOCK) ON A.id = SC.componentNameId
			WHERE SC.attrname='Edge Drive User Id' AND SC.attrVal = @inUserId
		-- CUSTOM PROPERTY FOR NOW IS ONLY SUPPORTED FOR RECORDS MANAGER AND CVLEGAL OBJECT STORE CLIENT
		IF ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK)
			WHERE componentNameId = @clientId AND attrName = 'System Drive Type'), 0) <> 3 /*RECORDS_MANAGER_CLIENT*/
		BEGIN
			-- FALL BACK TO CVLEGAL OBJECTSTORE CLIENT. I KNOW IT'S NOT A GOOD WAY TO DETECT BUT WE WILL FIX THIS EVENTUALLY.
			DECLARE @shareId INT = ISNULL((SELECT value FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CvLegalAppShareId'), 0)
			SELECT @clientId = clientId FROM App_SyncCloudConfig WITH(NOLOCK) WHERE syncWebFolderId = @shareId
		END
	END
	IF NOT EXISTS (SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @clientId)
	BEGIN
SET @errorCode = (1800 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
		SET @errorString = REPLACE(@errorString, '^1%s', @clientId)
		GOTO ERROR_EXIT
	END
	-- TO CHECK IF USER HAS RIGHTS TO RETRIEVE INFORMATION ABOUT PROPERTY
    -- GET THE LIST OF PROPERTIES WHICH ARE VISIBLE TO USER
    IF OBJECT_ID('tempdb.dbo.#propertyList') IS NOT NULL
        DROP TABLE #propertyList
	CREATE TABLE #propertyList (propertyId integer NOT NULL)
EXEC sec_getNonIdaObjectsForThisUser @inUserId, 166, 0, '#propertyList'
	IF @propertyId <> 0
	BEGIN
		INSERT INTO @propertyInfo
		VALUES(@propertyId)
	END
	ELSE IF @propertyName <> ''
	BEGIN
		SET @propertyId = ISNULL((SELECT propertyId FROM App_CustomProperty WITH (NOLOCK) WHERE propertyName = @propertyName), 0)
		IF @propertyId = 0
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
		INSERT INTO @propertyInfo
		VALUES(@propertyId)
	END
	ELSE
	BEGIN
		-- All Props
		INSERT INTO @propertyInfo
		SELECT CP.propertyId
			FROM App_CustomProperty CP WITH(NOLOCK)
			JOIN App_ComponentProp C WITH(NOLOCK)
ON C.componentId = CP.propertyId AND C.componentType = 18 AND C.longVal = @clientId AND C.propertyTypeId=1008
		SET @allProps = 1
	END
	-- Add global props
	IF @propertyId = 0 AND @allProps = 0
	BEGIN
		INSERT INTO @propertyInfo
		SELECT CP.propertyId
		FROM App_CustomProperty CP WITH(NOLOCK)
		JOIN App_ComponentProp C WITH(NOLOCK)
ON C.componentId = CP.propertyId AND C.componentType = 18 AND C.longVal = @clientId AND C.propertyTypeId=1008
WHERE CP.statusFlags & 0x10 = 0x10
	END
	-- GET SECURITY ASSOCIATIONS FOR THE PROPERTY. ONLY IF PropertyId IS PASSED
	IF @propertyId <> 0 AND @inPropertyLevel = 30
	BEGIN
		--DECLARE @userHasCapability INT = 0
		--EXEC sec_checkPermissionOnEntity @inUserId, CAT_USER_MANAGMENT_ASSOC_ON_ENTITY, @userHasCapability OUTPUT, CUSTOM_PROPERTY_ENTITY, @propertyId
		--IF @userHasCapability = 1
EXEC sec_getSecurityForEntity @inUserId, @securityXML OUTPUT, 166, @propertyId
	END
	DELETE FROM @propertyInfo WHERE propertyId NOT IN (SELECT propertyid FROM #propertyList)
	IF @inPropertyLevel = 30 -- ListPropertyLevels_AllProperties
	BEGIN
		SET @propertyXML =	(
								SELECT	P.propertyId '@propertyId',
										propertyName '@propertyName',
										P.description '@description',
										defaultValue '@defaultValue',
										indexingFieldName '@indexingFieldName',
										dataType  '@dataType',
										CASE
WHEN statusFlags & 0x1 = 0x1 THEN 1
											ELSE 0
										END '@disabled',
										CASE
WHEN statusFlags & 0x2 = 0x2 THEN 1
											ELSE 0
										END  '@isList',
										CASE
WHEN statusFlags & 0x4 = 0x4 THEN 2
											ELSE 1
										END '@type',
										(
											SELECT	U.id '@userId',
													U.login '@userName'
											FOR XML PATH('owner'), TYPE
										),
										(SELECT @securityXML FOR XML PATH ('securityAssociations'), TYPE)
								FROM App_CustomProperty P WITH (NOLOCK)
								INNER JOIN @propertyInfo PI ON P.propertyId = PI.propertyId
								LEFT OUTER JOIN UMUsers U WITH(NOLOCK) ON P.ownerId = U.id
								FOR XML PATH('properties'), TYPE
							)
	END
	ELSE IF @inPropertyLevel = 10 -- ListPropertyLevels_BasicProperties
	BEGIN
		SET @propertyXML =	(
								SELECT	P.propertyId '@propertyId',
										propertyName '@propertyName',
										indexingFieldName '@indexingFieldName',
										dataType  '@dataType'
								FROM App_CustomProperty P WITH (NOLOCK)
								INNER JOIN @propertyInfo PI ON P.propertyId = PI.propertyId
								FOR XML PATH('properties'), TYPE
							)
	END
ERROR_EXIT:
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE),
									@propertyXML
							FOR XML PATH('App_CustomPropertyResponse'), TYPE)
		IF OBJECT_ID('tempdb.dbo.#propertyList') IS NOT NULL
        	DROP TABLE #propertyList
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCustomProperty')
	delete from GxQscripts where name = 'AppGetCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCustomProperty')
	delete from GXDBVersions where aliasname = 'AppGetCustomProperty'
GO

insert into GXDBVersions values(2, 'AppGetCustomProperty',  '00010002001200060000', 'AppGetCustomProperty', '00010002001200060000')
GO

