

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCustomDomainInfo.sp] ---------- 

--  +==============================================================================================================+
--  | Name:  AppGetCustomDomainInfo
--  | Description: Takes Client Id and userid and returns ownerCompany, OwnerId, DomainName and User Group Name
--  +==============================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCustomDomainInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCustomDomainInfo <<<'
	drop procedure AppGetCustomDomainInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetCustomDomainInfo')
	delete from GxQscripts where name = 'AppGetCustomDomainInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCustomDomainInfo')
	delete from GXDBVersions where aliasname = 'AppGetCustomDomainInfo'
GO
print '... Creating Procedure: AppGetCustomDomainInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCustomDomainInfo
  @i_clientId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @ownerCompanyId INT
  DECLARE @ownerUserID INT
  DECLARE @domainName NVARCHAR(255)
  DECLARE @userGroupName NVARCHAR(255)
  DECLARE @errorCode INT 
  DECLARE @errorString VARCHAR(MAX) 
------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetCustomDomainInfo.spb  ----------
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @scgID INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @errorCode = 0
    SET @errorString = ''
SET @domainName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = @i_clientId)
SET @userGroupName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'DefaultUserGroupName' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = @i_clientId)
	-- If we are checking owner company directly from installation property companyid, then we have to make sure that owner company is not 0.
	-- Because it might be the case that commcell Admin installed some laptop for some user but later on gave some company user access to it.
	-- In that case, out fallback approach to SCG first and company later will be success. In any case, we will figure out owner company to be 0
	SELECT @ownerCompanyId=CAST(AC.attrval AS INT) FROM APP_ClientProp AC
							INNER JOIN UMDSProviders UD
ON CAST(UD.id AS NVARCHAR(64))=AC.attrval AND UD.serviceType = 5
WHERE attrname='Installation Company ID' AND componentNameId=@i_clientId
	-- If for some reason, we don't find valid installation company id or if its 0, then check via Auth code
	IF ((@ownerCompanyId IS NULL) OR (@ownerCompanyId = 0))
	BEGIN
		SELECT @ownerCompanyId=ACOP.componentNameId
			FROM APP_ClientProp ACLP
			INNER JOIN APP_CompanyProp  ACOP
				ON ACOP.attrval=ACLP.attrval
WHERE ACLP.attrname='Authorization Code' AND ACLP.componentNameId=@i_clientId AND ACLP.modified=0 AND
ACOP.attrname='Authorization Code' AND ACOP.modified=0 AND ACOP.cs_attrName=checksum('Authorization Code')
	END
	-- If we reach here and have valid companyid , then get the relevant SCG ID
	IF ((@ownerCompanyId >= 0))
	BEGIN
SET @scgID = ISNULL((SELECT attrValInt FROM APP_CompanyProp WHERE attrName='Associated Smart Client Group' AND componentnameid = @ownerCompanyId AND modified=0 AND cs_attrName=checksum('Associated Smart Client Group')),0)
	END
	IF @scgID = 0
	BEGIN
SET @scgID = ISNULL((SELECT TOP 1 entityId FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND cast(value AS NVARCHAR(1024)) = @domainName),0)
	END
    -- If we are not able to fetch owner company via SCG setting, then we will check if this client is part of some Company SCG. If yes, then that company is owner for that new provider
    IF @scgID = 0
    BEGIN
        SET @scgID = ISNULL((SELECT TOP 1 ACG.id FROM APP_ClientGroup ACG
	                                INNER JOIN APP_ClientGroupAssoc ACGA
		                                ON ACGA.clientGroupId=ACG.id AND ACGA.clientId=@i_clientId
                                    INNER JOIN APP_CompanyProp ACP
ON ACP.attrName='Associated Smart Client Group' AND attrValInt = ACG.id  AND ACP.cs_attrName=checksum('Associated Smart Client Group')
WHERE ACG.flag & 0x1000 <> 0),0)
		-- If we got SCG id by directly looking up client to SCG association, then we won't have owner company set at thig moment
		-- In that case, fetch it now.
SET @ownerCompanyId = ISNULL((SELECT TOP 1 componentNameId FROM APP_CompanyProp WHERE attrname = 'Associated Smart Client Group' AND attrValInt = @scgID AND modified=0 AND cs_attrName=checksum('Associated Smart Client Group')),0)
    END
    IF ((@domainName IS NULL OR LEN(@domainName) <=0) OR (@userGroupName IS NULL OR LEN(@userGroupName) <=0))
    BEGIN
SET @domainName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND entityId = @scgID)
SET @userGroupName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'DefaultUserGroupName' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND entityId = @scgID)
    END
    -- Default Value
    SET @ownerUserID = 1
    IF @ownerCompanyId > 0
    BEGIN
        -- If we get valid company id, then we will get tenant admin id too.
        SET @ownerUserID = (SELECT TOP 1 UU.id FROM UMUsers UU
			                    INNER JOIN UMUserGroup UUG
			                    ON UUG.userId=UU.id
			                    INNER JOIN UMGroups UG
ON UG.id=UUG.groupId AND UG.groupFlags&0x10000<> 0 and UG.umdsProviderId=@ownerCompanyId)
    END
	ELSE IF @ownerCompanyId = 0
	BEGIN
		-- We got company id as 0. As per this case, we won't have domainName and userGroupName populated
		-- Lets check GxGlobalParam for the same key
		-- For company id 0, there is no way user could set this
SET @domainName = (SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'sCustomDomain')
SET @userGroupName = (SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'sCustomUserGroupName')
	END
	-- If we have an user group with format - CompanyName\Tenant Users, then we should only return the relevant user group name wihtout domain name.
	DECLARE @pos INT = 0
	IF (LEN(@userGroupName) > 0)
	BEGIN
		SET @pos=CHARINDEX('\',@userGroupName,1)
		IF @pos <> 0
		BEGIN
			SET @userGroupName= RIGHT(@userGroupName,LEN(@userGroupName)-@pos)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
--- CODE Till HERE IS FROM AppGetCustomDomainInfo.spb  ----------
------------------------------------------------------------------------------------------------------
SELECT @ownerCompanyId, @ownerUserID, @domainName, @userGroupName, @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCustomDomainInfo')
	delete from GxQscripts where name = 'AppGetCustomDomainInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCustomDomainInfo')
	delete from GXDBVersions where aliasname = 'AppGetCustomDomainInfo'
GO

insert into GXDBVersions values(2, 'AppGetCustomDomainInfo',  '00000000000000000000', 'AppGetCustomDomainInfo', '00000000000000000000')
GO

