

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCriticalEventsCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCriticalEventsCount.sp,v $ $Id: AppGetCriticalEventsCount.sp,v 1.1.4.9 2020/11/19 09:43:13 jswaminathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetCriticalEventsCount"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCriticalEventsCount')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCriticalEventsCount <<<'
	drop procedure AppGetCriticalEventsCount
END
IF EXISTS (select * from GxQscripts where name='AppGetCriticalEventsCount')
	delete from GxQscripts where name = 'AppGetCriticalEventsCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCriticalEventsCount')
	delete from GXDBVersions where aliasname = 'AppGetCriticalEventsCount'
GO
print '... Creating Procedure: AppGetCriticalEventsCount'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCriticalEventsCount
-- Input arguments
  @i_userId INT,
  @i_NumberOfDays INT
AS
  DECLARE @JobStatus INT
  DECLARE @JobCount INT
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @startTime INT = datediff(second, '01/01/1970', (dateadd(hour,-@i_NumberOfDays*24,getutcdate())))
	DECLARE @endTime INT = datediff(second, '01/01/1970', (getutcdate()))
	DECLARE @ccID INT
	SET @ccID = 2
	-- Check whether the user has view capability at commcell level. If so, he is unrestricted user
	DECLARE @userHasCapability int = 0
	DECLARE @isUserAdmin INT = 0
	EXEC sec_checkPermissionOnEntity @i_userId, 31, @userHasCapability OUTPUT, 2018, 2
	EXECUTE sec_isUserAdmin   @i_userId , @isUserAdmin  OUTPUT
	--SET @userHasCapability = 0
	-- If user has view at commcell level, he can see everything
	if @userHasCapability=1
	begin
		   -- Just find critical events for this time range and return
		   SELECT count(Distinct evmsg.id) as 'CriticalEventsCount'
		   FROM evMsg WITH (READUNCOMMITTED)
		   WHERE (type <> 2
		   --and (dbo.isVisible(@i_userId, jobId_l,evmsg.commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
		   and severity= 9
		   and evmsg.commCellID = @ccID
		   AND timeserver>=@starttime
		   AND (timeserver<=@endTime or @endTime=0)
		   )
		   RETURN
	end
	IF OBJECT_ID(N'tempdb.dbo.#CriticalEventsList') IS NOT NULL
			DROP TABLE #CriticalEventsList
	SELECT id, timeSource, timeServer, severity, ack, acked, type, paramNum, messageId, jobId_h, jobId_l, CASE WHEN clientID = 0 THEN 2 ELSE clientID END as clientID, commCellID, userID, subsystemID,
        client, commCell, userName, subsystem, msgEnglish, repeatCount, lastOccurrence, nextPost, mediaId, driveId, libraryId, maClientId
		INTO #CriticalEventsList
	FROM EvMsg WITH (READUNCOMMITTED)
	WHERE (type <> 2
	--and (dbo.isVisible(@i_userId, jobId_l,evmsg.commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
	and severity= 9
	and evmsg.commCellID = @ccID
	AND timeserver>=@starttime
	AND (timeserver<=@endTime or @endTime=0)
	)
	create index #CriticalEventsList_userId on #CriticalEventsList (userID);;
	create index #CriticalEventsList_jobId_l on #CriticalEventsList (jobId_l);;
	IF OBJECT_ID('tempdb.dbo.#AppGetCriticalEventsCount_userObjects') IS NOT NULL
	    DROP TABLE #AppGetCriticalEventsCount_userObjects
create table  #AppGetCriticalEventsCount_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 0, 0, '#AppGetCriticalEventsCount_userObjects'
	DECLARE @criticalEventsCountNonJob INT = 0
	DECLARE @criticalEventsCountJob INT = 0
	SELECT @criticalEventsCountNonJob = count(Distinct evmsg.id)
	FROM #CriticalEventsList evMsg WITH (READUNCOMMITTED)
	INNER JOIN #AppGetCriticalEventsCount_userObjects UO WITH (NOLOCK) ON
				  evmsg.jobId_h = 0 AND evmsg.jobId_l = 0 AND capabilities <> 0 AND
						 ( ((UO.commcellid=2 AND UO.clientid=0 AND UO.clientgroupid=0 AND UO.mediaAgentId=0 AND UO.libraryId=0 AND UO.archGroupId=0 and UO.vtContainerId=0 and UO.vtPolicyId=0 and UO.vtShelfId=0 and UO.reviewSetId = 0 and UO.querySetId = 0 and UO.downloadSetId = 0 and UO.tagId = 0 and UO.legalHoldId = 0 and UO.ermId = 0 and UO.cdPolicyId = 0 and UO.complianceReportId = 0 and UO.taskId = 0 AND UO.workflowId=0 AND UO.logMonitoringPolicyId=0 AND UO.arrayId=0 AND UO.cloudId=0 AND UO.userGroupId=0 AND UO.providerId=0 AND UO.entityId1=0 AND UO.entityId2=0 AND UO.entityId3=0 AND UO.entityId4=0 AND UO.entityId5=0 AND UO.entityId6=0 AND UO.entityId7=0 AND UO.entityId8=0 AND UO.entityId9=0)) -- will be true if the user has any commcell level capabilities
					OR ( (UO.clientid=evMsg.clientID OR UO.mediaAgentId=evMsg.clientID OR (evMsg.maClientId <> 0 AND UO.mediaAgentId=evMsg.maClientId)) AND UO.clientgroupid=0 AND UO.libraryId=0 AND UO.archGroupId=0) OR
				  (evmsg.libraryId <> 0 AND UO.libraryId = evmsg.libraryId) )
	IF OBJECT_ID(N'tempdb.dbo.#VisibleEventsList') IS NOT NULL
			DROP TABLE #VisibleEventsList
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
			DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_rstObject
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_ClientID] ON [#SecIDANodeAccessTemp_Bkp]([t_clientId] ASC)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
	create table  #JMCanManageJob_adminObject ( [capabilities]  bigint   NOT null, [flag]             int NOT null default 0, [commCellId]    int  NOT null default 2, [clientGroupId] int  NOT null default 0, [clientId]      int     NOT null default 0, [appTypeId]     int  NOT null default 0, [instanceId]    int    NOT null default 0, [backupsetId]   int  NOT null default 0, [subClientId]   int  NOT null default 0, [mediaAgentId]  int    NOT null default 0, [libraryId]     int  NOT null default 0, [archGroupId]   int  NOT null default 0, [vtContainerId] int  NOT null default 0, [vtPolicyId]    int       NOT null default 0, [vtShelfId]     int  NOT null default 0, [reviewSetId]   int  NOT null default 0, [querySetId]      int  NOT null default 0, [downloadSetId] int  NOT null default 0, [ermId]         int  NOT null default 0, [legalHoldId]   int  NOT null default 0, [tagId]         int       NOT null default 0, [cdPolicyId]    int  NOT null default 0, [complianceReportId]   int  NOT null default 0, [taskId]        int      NOT null default 0, [workflowId]    int  NOT null default 0, [logMonitoringPolicyId] int    NOT null default 0, [arrayId]       int  NOT null default 0, [cloudId]       int  NOT null default 0, [userGroupId]   int  NOT null default 0, [providerId]    int       NOT null default 0, [entityId1]     int  NOT null default 0, [entityId2]     int  NOT null default 0, [entityId3]     int    NOT null default 0, [entityId4]     int  NOT null default 0, [entityId5]     int  NOT null default 0, [entityId6]     int  NOT null default 0, [entityId7]     int       NOT null default 0, [entityId8]     int  NOT null default 0, [entityId9]     int  NOT null default 0  )
	create table  #JMCanManageJob_rstObject ( [capabilities]  bigint     NOT null, [flag]             int NOT null default 0, [commCellId]    int  NOT null default 2, [clientGroupId] int  NOT null default 0, [clientId]      int     NOT null default 0, [appTypeId]     int  NOT null default 0, [instanceId]    int    NOT null default 0, [backupsetId]   int  NOT null default 0, [subClientId]   int  NOT null default 0, [mediaAgentId]  int    NOT null default 0, [libraryId]     int  NOT null default 0, [archGroupId]   int  NOT null default 0, [vtContainerId] int  NOT null default 0, [vtPolicyId]    int       NOT null default 0, [vtShelfId]     int  NOT null default 0, [reviewSetId]   int  NOT null default 0, [querySetId]      int  NOT null default 0, [downloadSetId] int  NOT null default 0, [ermId]         int  NOT null default 0, [legalHoldId]   int  NOT null default 0, [tagId]         int       NOT null default 0, [cdPolicyId]    int  NOT null default 0, [complianceReportId]   int  NOT null default 0, [taskId]        int      NOT null default 0, [workflowId]    int  NOT null default 0, [logMonitoringPolicyId] int    NOT null default 0, [arrayId]       int  NOT null default 0, [cloudId]       int  NOT null default 0, [userGroupId]   int  NOT null default 0, [providerId]    int       NOT null default 0, [entityId1]     int  NOT null default 0, [entityId2]     int  NOT null default 0, [entityId3]     int    NOT null default 0, [entityId4]     int  NOT null default 0, [entityId5]     int  NOT null default 0, [entityId6]     int  NOT null default 0, [entityId7]     int       NOT null default 0, [entityId8]     int  NOT null default 0, [entityId9]     int  NOT null default 0  )
	Create table #VisibleEventsList
	(
		   eventId INT
	)
	CREATE CLUSTERED INDEX [#VisibleEventsList_eventId] ON [#VisibleEventsList]([eventId] ASC)
	DECLARE @adminCap INTEGER
	SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
	--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
	DECLARE @restoreCap INTEGER
	-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
	SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
	-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
	exec sec_getIdaObjectsForUser @i_userId,7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
	exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
	exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
	exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
	exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
	DELETE FROM #JMCanManageJob_adminObject
		   WHERE  (Capabilities & @adminCap) = 0
	DELETE FROM #JMCanManageJob_rstObject
		   WHERE  (Capabilities & @restoreCap) = 0
	DECLARE @isCSLevelAssociated INT = 0
	IF EXISTS(SELECT 1 FROM #JMCanManageJob_adminObject userObject
	WHERE (userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0                                                             AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
	)
	BEGIN
		   SET @isCSLevelAssociated = 1
	END
	ELSE
	BEGIN
				  MERGE #JMCanManageJob_rstObject DST
				  USING (SELECT dbo.BitWiseOR(SEC.capabilities) AS capabilities, CGA.clientId
							FROM #JMCanManageJob_rstObject SEC
							INNER JOIN App_ClientGroupAssoc CGA ON SEC.clientGroupId = CGA.clientGroupId
							GROUP BY CGA.clientId ) SRC
				  ON SRC.clientId = DST.clientId
				  WHEN MATCHED THEN
						 UPDATE SET DST.capabilities = DST.capabilities | SRC.capabilities
				  WHEN NOT MATCHED THEN
						 INSERT (capabilities, clientId)
				VALUES( SRC.capabilities, SRC.clientId);
	END
	INSERT INTO #VisibleEventsList
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMBkpStats WITH (READUNCOMMITTED) ON
	 EvMsg.jobId_l = JMBkpStats.jobId AND JMBkpStats.CommcellId = @ccID
	AND (servStartDate>=@starttime OR servEndDate<=@endTime)
	INNER JOIN #SecIDANodeAccessTemp_Bkp secIDANode ON secIDANode.t_subclientId = JMBkpStats.appID
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMBkpJobInfo WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JMBkpJobInfo.jobId AND JMBkpJobInfo.CommcellId = @ccID
	INNER JOIN #SecIDANodeAccessTemp_Bkp secIDANode ON secIDANode.t_subclientId = JMBkpJobInfo.applicationId
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMAdminJobStatsTable JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	AND (servStart>=@starttime OR servEnd<=@endTime)
	LEFT JOIN JMJobOptions WITH(NOLOCK) ON JMJobOptions.jobId = JM.jobID AND JMJobOptions.commCellId = JM.commCellId AND JMJobOptions.attributeId = 10
	INNER JOIN #JMCanManageJob_adminObject userObject ON
	(JM.opType = 85 AND @isUserAdmin = 1)
		OR
			(JM.opType = 90 AND JM.workFlowID <> 0 AND userObject.workflowId = JM.workFlowID)
		OR
			(JM.opType IN (104,13) AND JM.archGrpId <> 0 AND userObject.archGroupId = JM.archGrpId)
		OR @isCSLevelAssociated = 1
		OR
			(JM.opType IN (21,32,41,42,46,47)  AND (userObject.libraryId =-10 OR userObject.libraryId = IsNull(JMJobOptions.attributeValueInt,0) ))
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMAdminJobInfoTable JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	LEFT JOIN JMJobOptions WITH(NOLOCK) ON JMJobOptions.jobId = JM.jobID AND JMJobOptions.commCellId = JM.commCellId AND JMJobOptions.attributeId = 10
	INNER JOIN #JMCanManageJob_adminObject userObject ON
	(JM.opType = 85 AND @isUserAdmin = 1)
											 OR
													(JM.opType = 90 AND JM.workFlowID <> 0 AND userObject.workflowId = JM.workFlowID)
											 OR
													(JM.opType IN (104,13) AND JM.archGrpId <> 0 AND userObject.archGroupId = JM.archGrpId)
											 OR @isCSLevelAssociated = 1
											 OR
													(JM.opType IN (21,32,41,42,46,47)  AND (userObject.libraryId =-10 OR userObject.libraryId =  IsNull(JMJobOptions.attributeValueInt,0) ))
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMRestoreStats JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	AND (servStartTime>=@starttime OR servEndTime<=@endTime)
	INNER JOIN #JMCanManageJob_rstObject rstUserObject ON
	(@isCSLevelAssociated = 1)
						 OR
						 -- if you have the rights on the destination at any level then you will see the restore job
	(rstUserObject.clientId=-10) OR
						 (rstUserObject.clientid=destClientID) OR
						 (rstUserObject.clientid=srcClientID AND apptypeid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=JM.instanceID AND rstUserObject.backupsetid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=JM.instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
	--(rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID)))
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMRstJobInfo JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	INNER JOIN #JMCanManageJob_rstObject rstUserObject ON
	(@isCSLevelAssociated = 1)
						 OR
						 -- if you have the rights on the destination at any level then you will see the restore job
	(rstUserObject.clientId=-10) OR
						 (rstUserObject.clientid=destClientID) OR
						 (rstUserObject.clientid=srcClientID AND apptypeid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=JM.instanceID AND rstUserObject.backupsetid=0) OR
						 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=JM.instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
	--(rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID)))
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMRstJobInfo JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = userName
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMBkpJobInfo JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = userName
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMAdminJobInfoTable JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = userName
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMRestoreStats JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	AND (servStartTime>=@starttime OR servEndTime<=@endTime)
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = JM.username
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMBkpStats JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	AND (servStartDate>=@starttime OR servEndDate<=@endTime)
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = JM.userName
	UNION
	SELECT EvMsg.Id FROM #CriticalEventsList EvMsg WITH (READUNCOMMITTED)
	INNER JOIN JMAdminJobStatsTable JM WITH (READUNCOMMITTED) ON
	EvMsg.jobId_l = JM.jobId AND JM.CommcellId = @ccID
	AND (servStart>=@starttime OR servEnd<=@endTime)
	INNER JOIN UMUsers ON @i_userId = UMUsers.id AND UMUsers.login = JM.userName
	SELECT @criticalEventsCountJob = count(Distinct VisibleEventsList.eventId)
	FROM #VisibleEventsList VisibleEventsList
	IF OBJECT_ID(N'tempdb.dbo.#VisibleEventsList') IS NOT NULL
			DROP TABLE #VisibleEventsList
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
			DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.##JMCanManageJob_rstObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_rstObject
	IF OBJECT_ID(N'tempdb.dbo.#CriticalEventsList') IS NOT NULL
			DROP TABLE #CriticalEventsList
	IF OBJECT_ID('tempdb.dbo.#AppGetCriticalEventsCount_userObjects') IS NOT NULL
	    DROP TABLE #AppGetCriticalEventsCount_userObjects
	SELECT @criticalEventsCountJob + @criticalEventsCountNonJob as 'CriticalEventsCount'
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCriticalEventsCount')
	delete from GxQscripts where name = 'AppGetCriticalEventsCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCriticalEventsCount')
	delete from GXDBVersions where aliasname = 'AppGetCriticalEventsCount'
GO

insert into GXDBVersions values(2, 'AppGetCriticalEventsCount',  '00010001000400090000', 'AppGetCriticalEventsCount', '00010001000400090000')
GO

