

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetContentStoreClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetContentStoreClients							|
--	|		 Procedure to get list of content store clients				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetContentStoreClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetContentStoreClients <<<'
	drop procedure AppGetContentStoreClients
END
IF EXISTS (select * from GxQscripts where name='AppGetContentStoreClients')
	delete from GxQscripts where name = 'AppGetContentStoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetContentStoreClients')
	delete from GXDBVersions where aliasname = 'AppGetContentStoreClients'
GO
print '... Creating Procedure: AppGetContentStoreClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetContentStoreClients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlText XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	 -- READ THE XML
	DECLARE @includeDeConfigPackages			INT = 0
	SELECT	@includeDeConfigPackages = ISNULL(ref.value('@includeDeConfigPackages', 'INT'), 0)
		FROM @xmlText.nodes ('Ida_GetContentStoreClientsReq') R(ref)
	-- Create the Temp Table
	    DECLARE @memberServers TABLE
		(
         clientId INT,
         clientName NVARCHAR(MAX)
        )
		INSERT INTO @memberServers
		SELECT C.id, C.name
		FROM  APP_Client C (NOLOCK)
JOIN simInstalledPackages S (NOLOCK) ON C.Id = S.ClientId AND S.simPackageID = 151
WHERE (C.status & 0x00002) != 0x00002
AND (C.status & 0x00004) != 0x00004
AND (C.status & 0x00020) != 0x00020
		--Delete all the Access node having SMTP role set to IMAP
		DELETE FROM @memberServers WHERE clientId IN ( SELECT R.componentnameid FROM APP_ClientProp R (NOLOCK) WHERE R.attrName = 'Content Store Mail Server Role' AND R.attrVal = 1 AND R.modified = 0 )
	SET @xmlText = (SELECT 1 '@isActive',
							(
								SELECT C.clientId '@clientId', C.clientName '@clientName'
								FOR XML PATH('client'), TYPE
							)
							FROM @memberServers C
							FOR XML PATH('contentStoreClients'),
							ROOT ('Ida_GetContentStoreClientsResp')
						)
	IF @xmlText IS NULL
		SET @xmlText = '<Ida_GetContentStoreClientsResp/>'
	SELECT @xmlText
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetContentStoreClients')
	delete from GxQscripts where name = 'AppGetContentStoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetContentStoreClients')
	delete from GXDBVersions where aliasname = 'AppGetContentStoreClients'
GO

insert into GXDBVersions values(2, 'AppGetContentStoreClients',  '00000000000000000000', 'AppGetContentStoreClients', '00000000000000000000')
GO

