

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetConsoleSettingsList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetConsoleSettingsList.sp,v $ $Id: AppGetConsoleSettingsList.sp,v 1.5.56.4 2018/05/02 21:33:57 nramalingam Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppAddProps   - Add properties for the AppAddResgistryStaticList table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetConsoleSettingsList <<<'

IF EXISTS (select * from sysobjects where name='AppGetConsoleSettingsList')
	drop procedure AppGetConsoleSettingsList
IF EXISTS (select * from GxQscripts where name='AppGetConsoleSettingsList')
	delete from GxQscripts where name = 'AppGetConsoleSettingsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetConsoleSettingsList')
	delete from GXDBVersions where aliasname = 'AppGetConsoleSettingsList'
GO
print '... Creating Procedure: AppGetConsoleSettingsList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetConsoleSettingsList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userID INTEGER,
  @onlyConsoleSettings INTEGER,
  @xmlStr xml OUTPUT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @errorCode  INT
set @errorCode = 0
------------------------------------------------------------------------------------
--  GATHERED ENOUGH INFORMATION, TIME TO START INSERTING SOME DATA TO THE TABLES! --
------------------------------------------------------------------------------------
BEGIN
SET NOCOUNT ON
DECLARE  @temp_APP_AdvanceSettings TABLE
    (
		keyName         nvarchar(MAX),
		value           ntext,
		type            INTEGER,
		relativePath	nvarchar(MAX)
    );
	IF object_id('tempdb.dbo.#filterKeyNameList') IS NOT null DROP TABLE #filterKeyNameList
		CREATE TABLE #filterKeyNameList (KeyName nvarchar(512))
	INSERT INTO #filterKeyNameList
	SELECT DISTINCT ref.value('(.)[1]', 'NVARCHAR(MAX)')FROM  @xmlStr.nodes('/App_ConsoleSettingsFilter/keyNameList/@val') doc(ref)
	DECLARE @iSFilterSet INT = (SELECT CASE WHEN @@ROWCOUNT>0 THEN 1 ELSE 0 END)
	INSERT INTO @temp_APP_AdvanceSettings
	SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
								   WHEN N'BOOLEAN' THEN '1'
								   WHEN N'STRING' THEN '2'
								   WHEN N'ENCRYPTED' THEN '3'
								   WHEN N'MULTISTRING' THEN '4'
								   END) as iType,
								   relativePath
						FROM APP_AdvanceSettings WITH(NOLOCK)
						WHERE (relativePath = N'CommServDB.Console' OR (@onlyConsoleSettings = 0 AND (relativePath = N'CommServDB.WebConsole' OR relativePath = N'CommServDB.AdminConsole')))  and deleted = 0 and enabled = 1 and entityId = 2 and entityType = 3
						AND (@iSFilterSet = 0 OR keyName in (SELECT keyname from #filterKeyNameList))
	DELETE tAdv
	FROM @temp_APP_AdvanceSettings tAdv INNER JOIN
			(SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
									   WHEN N'BOOLEAN' THEN '1'
									   WHEN N'STRING' THEN '2'
									   WHEN N'ENCRYPTED' THEN '3'
									   WHEN N'MULTISTRING' THEN '4'
									   END) as iType,
									   relativePath as iRelativePath
			FROM APP_AdvanceSettings WITH(NOLOCK)
			WHERE relativePath = N'CommServDB.Console' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13) uAdv
	ON tAdv.keyName = uAdv.KeyName AND tAdv.type = uAdv.iType AND tAdv.relativePath = uAdv.iRelativePath
	INSERT INTO @temp_APP_AdvanceSettings
	SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
										WHEN N'BOOLEAN' THEN '1'
										WHEN N'STRING' THEN '2'
										WHEN N'ENCRYPTED' THEN '3'
										WHEN N'MULTISTRING' THEN '4'
										END) as iType,
										relativePath
			FROM APP_AdvanceSettings WITH(NOLOCK)
			WHERE relativePath = N'CommServDB.Console' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13
			AND (@iSFilterSet = 0 OR keyName in (SELECT keyname from #filterKeyNameList))
	IF @onlyConsoleSettings <> 1
	BEGIN
		DELETE tAdv
		FROM @temp_APP_AdvanceSettings tAdv INNER JOIN
				(SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
										   WHEN N'BOOLEAN' THEN '1'
										   WHEN N'STRING' THEN '2'
										   WHEN N'ENCRYPTED' THEN '3'
										   WHEN N'MULTISTRING' THEN '4'
										   END) as iType,
										   relativePath as iRelativePath
				FROM APP_AdvanceSettings WITH(NOLOCK)
				WHERE relativePath = N'CommServDB.WebConsole' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13) uAdv
		ON tAdv.keyName = uAdv.KeyName AND tAdv.type = uAdv.iType AND tAdv.relativePath = uAdv.iRelativePath
		INSERT INTO @temp_APP_AdvanceSettings
		SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
										   WHEN N'BOOLEAN' THEN '1'
										   WHEN N'STRING' THEN '2'
										   WHEN N'ENCRYPTED' THEN '3'
										   WHEN N'MULTISTRING' THEN '4'
										   END) as iType,
										   relativePath
				FROM APP_AdvanceSettings WITH(NOLOCK)
				WHERE relativePath = N'CommServDB.WebConsole' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13
				AND (@iSFilterSet = 0 OR keyName in (SELECT keyname from #filterKeyNameList))
		DELETE tAdv
		FROM @temp_APP_AdvanceSettings tAdv INNER JOIN
				(SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
										   WHEN N'BOOLEAN' THEN '1'
										   WHEN N'STRING' THEN '2'
										   WHEN N'ENCRYPTED' THEN '3'
										   WHEN N'MULTISTRING' THEN '4'
										   END) as iType,
										   relativePath as iRelativePath
				FROM APP_AdvanceSettings WITH(NOLOCK)
				WHERE relativePath = N'CommServDB.AdminConsole' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13) uAdv
		ON tAdv.keyName = uAdv.KeyName AND tAdv.type = uAdv.iType AND tAdv.relativePath = uAdv.iRelativePath
		INSERT INTO @temp_APP_AdvanceSettings
		SELECT keyName,	value, (case type WHEN N'INTEGER' THEN '0'
										   WHEN N'BOOLEAN' THEN '1'
										   WHEN N'STRING' THEN '2'
										   WHEN N'ENCRYPTED' THEN '3'
										   WHEN N'MULTISTRING' THEN '4'
										   END) as iType,
										   relativePath
				FROM APP_AdvanceSettings WITH(NOLOCK)
				WHERE relativePath = N'CommServDB.AdminConsole' and deleted = 0 and enabled = 1 and entityId = @i_userID and entityType = 13
				AND (@iSFilterSet = 0 OR keyName in (SELECT keyname from #filterKeyNameList))
	END
	IF object_id('tempdb.dbo.#filterKeyNameList') IS NOT null DROP TABLE #filterKeyNameList
	SET @xmlStr = ISNULL((SELECT
						keyName as '@attrName',
						value as '@atterValue',
						type as '@attrType',
						(CASE WHEN @onlyConsoleSettings = 1 THEN NULL ELSE relativePath END) as '@relativePath'
						FROM @temp_APP_AdvanceSettings
						FOR XML PATH('consoleSettings'),ROOT('App_ConsoleSettingsListResp')),'<App_ConsoleSettingsListResp/>')
SET NOCOUNT OFF
END
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetConsoleSettingsList')
	delete from GxQscripts where name = 'AppGetConsoleSettingsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetConsoleSettingsList')
	delete from GXDBVersions where aliasname = 'AppGetConsoleSettingsList'
GO

insert into GXDBVersions values(2, 'AppGetConsoleSettingsList',  '00010005005600040000', 'AppGetConsoleSettingsList', '00010005005600040000')
GO

