

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetConfiguredSubClientDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetConfiguredSubClientDetails.sp,v $ $Id: AppGetConfiguredSubClientDetails.sp,v 1.1.2.2 2018/03/27 08:02:14 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetConfiguredSubClientDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetConfiguredSubClientDetails')
	drop procedure AppGetConfiguredSubClientDetails
IF EXISTS (select * from GxQscripts where name='AppGetConfiguredSubClientDetails')
	delete from GxQscripts where name = 'AppGetConfiguredSubClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetConfiguredSubClientDetails')
	delete from GXDBVersions where aliasname = 'AppGetConfiguredSubClientDetails'
GO
print '... Creating Procedure: AppGetConfiguredSubClientDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetConfiguredSubClientDetails
  @iClientId INT, 
  @iAppTypeID INT,
  @iHide INT 
AS
  DECLARE @oSubclientid integer 
  DECLARE @oSubclientname nvarchar(256)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/*
	Code gets instances and then loops to fetch subclients of all those instances.
	- https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/CVInstallManager/CVInstallManagerApplication.cpp#2067
	We need to replace the code here to one SP
	--https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/AppMgr/DB/AdaptersInterfaceDB.cpp#getInstanceList
	https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/AppMgr/DB/AdaptersInterfaceDB.cpp#getAppIdList
	-- #define HIDE_DUMMY                  0x0001
	-- #define HIDE_UNINST                 0x0002
	-- #define HIDE_DELETED                0x0004
	-- #define HIDE_HIDDEN                 0x0008
*/
DECLARE @hideStatus INT = 0
IF @iHide & 0x0001 =  0x0001
SET @hideStatus |= 0x00010
IF @iHide & 0x0002 = 0x0002
SET @hideStatus |= 0x00002
IF @iHide & 0x0004 = 0x0004
SET @hideStatus |= 0x00004
IF @iHide & 0x0008 = 0x0008
SET @hideStatus |= 0x00020
SELECT subclient.id, subclient.subclientName
        FROM APP_Client client
        JOIN APP_Application subclient  ON subclient.clientid = client.id
		JOIN APP_IDAName IDName  on subclient.apptypeId = IDName.appTypeId
        JOIN APP_InstanceName instance  ON subclient.instance = instance.id
WHERE instance.name NOT in ('DefaultOracleInstanceName','DefaultSAPInstanceName')
-- Get all or filter the hidden ones
AND  (@hideStatus = 0  OR subclient.subclientStatus & @hideStatus <> @hideStatus)
AND subclient.clientid=@iClientID
AND subclient.appTypeId=@iAppTypeID

IF EXISTS (select * from GxQscripts where name = 'AppGetConfiguredSubClientDetails')
	delete from GxQscripts where name = 'AppGetConfiguredSubClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetConfiguredSubClientDetails')
	delete from GXDBVersions where aliasname = 'AppGetConfiguredSubClientDetails'
GO

insert into GXDBVersions values(2, 'AppGetConfiguredSubClientDetails',  '00010001000200020000', 'AppGetConfiguredSubClientDetails', '00010001000200020000')
GO

