

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyUserOrUserGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetCompanyUserOrUserGroup()
--  |
--  | Description:  SP for returning company id for provided user or user group id
--  |
--  |       Input:  user or user group id, isUser
--  |      Output:  Company Id, ErrorCode, ErrorString
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  alakra  	To fetch company Id
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCompanyUserOrUserGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyUserOrUserGroup <<<'
	drop procedure AppGetCompanyUserOrUserGroup
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyUserOrUserGroup')
	delete from GxQscripts where name = 'AppGetCompanyUserOrUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyUserOrUserGroup')
	delete from GXDBVersions where aliasname = 'AppGetCompanyUserOrUserGroup'
GO
print '... Creating Procedure: AppGetCompanyUserOrUserGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCompanyUserOrUserGroup
  @userIdOrGroupId INT,
  @isUser INT,
  @localeId INT,
  @isFromCPP INT,   
  @o_companyId INT OUTPUT,
  @o_errorCode INT OUTPUT,
  @o_errorString NVARCHAR(MAX) OUTPUT
AS
  DECLARE @companyId INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorString = N''
SET @companyId = -1
BEGIN TRY
	-- Error Handling will be added later
	-- this is just a wrapper for the below function
	SET @o_companyId = dbo.AppGetCompanyForUserOrUserGroup(@userIdOrGroupId , @isUser)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
			SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
	SET @o_errorCode  = @errorCode
	SET @o_errorString  = @errorString
	SET @companyId = @o_companyId
	IF (@isFromCPP = 1)
	BEGIN
		SELECT @companyId, @errorCode, @errorString
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyUserOrUserGroup')
	delete from GxQscripts where name = 'AppGetCompanyUserOrUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyUserOrUserGroup')
	delete from GXDBVersions where aliasname = 'AppGetCompanyUserOrUserGroup'
GO

insert into GXDBVersions values(2, 'AppGetCompanyUserOrUserGroup',  '00000000000000000000', 'AppGetCompanyUserOrUserGroup', '00000000000000000000')
GO

