

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyProperties.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyProperties.sp,v $ $Id: AppGetCompanyProperties.sp,v 1.1.2.84.4.1 2021/01/27 23:59:04 snandhini Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCompanyProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyProperties <<<'
	drop procedure AppGetCompanyProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyProperties')
	delete from GxQscripts where name = 'AppGetCompanyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyProperties')
	delete from GXDBVersions where aliasname = 'AppGetCompanyProperties'
GO
print '... Creating Procedure: AppGetCompanyProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCompanyProperties
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @callerId     		INTEGER
DECLARE @i_providerId  		INTEGER
DECLARE @localeId INT
DECLARE @xmlerrors xml
DECLARE @canSeeProvider INT=0
DECLARE @portNumber INT = 0
DECLARE @tempUserTable TABLE (userIdPrimaryContact INT, userName nvarchar(1024), userDisplayName nvarchar(1024))
-- NOTE: May want to investigate changing to TempTable with CLUSTERED INDEX on taskId
DECLARE @tempPlanTable TABLE (
	entityId INT,
	taskId INT,
	jobStartTime INT,
	isStartTimeOverridden INT,
	entityTypeSelectedForJobStartTime INT,
	jobStartTimeForPlan INT,
	numCopies INT DEFAULT NULL,
	numAssocEntities INT DEFAULT NULL,
	rpoInMinutes INT DEFAULT NULL
)
DECLARE @tenantAdminGroupId INT = 0
DECLARE @secAssocXML XML
DECLARE @encryptionXML XML
DECLARE @ownerCompany INT = 0
DECLARE @companyGroup INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @level INT=10
DECLARE @isPrivacyFeatureEnabled INT= 0
DECLARE @filterxml XML
DECLARE @isJobStartTimeEnabled INT = 0
DECLARE @jobStartTime INT = NULL
DECLARE @authType       integer=1
DECLARE @enableAuthorizeForRestore integer=0
DECLARE @expirationTimeStamp integer = 0
DECLARE @callerHasInstallRights INT = 0
DECLARE @canSeeAuthCode INT = 0
DECLARE @checkInstallRightsForAuthcode INT = 0
 SET @callerId = ISNULL (( SELECT ref.value('@userId', 'INT')
                     FROM @o_xmlText.nodes ('Api_GetOrganizationPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
SET @i_providerId = ISNULL (( SELECT ref.value('@organizationId', 'INT')
                     FROM @o_xmlText.nodes ('Api_GetOrganizationPropertiesRequest') R(ref)), -1)
SET @localeId = ISNULL(@o_xmlText.value('(//Api_GetOrganizationPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
EXEC sec_canSeeOrManageNameServer  @callerId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
SET @level = ISNULL(@o_xmlText.value('(/Api_GetOrganizationPropertiesRequest/@propertyLevel)[1]', 'int'), 10)
SET @checkInstallRightsForAuthcode = ISNULL((SELECT TOP 1 1 FROM GxGlobalParam WHERE name = 'bCheckInstallRightsForAuthCode' AND modified = 0 AND value = 'true'), 0)
IF @checkInstallRightsForAuthcode = 1
BEGIN
EXEC sec_userHAsCapability @callerId, 0, @callerHasInstallRights out, 0, 0, 65
	SET  @canSeeAuthCode = @callerHasInstallRights
END
ELSE
BEGIN
	SET @canSeeAuthCode = 1
END
IF object_id('tempdb.dbo.#OrgClientsTbl') IS NOT NULL DROP TABLE #OrgClientsTbl
			CREATE TABLE #OrgClientsTbl (clientId INT PRIMARY KEY, clientType INT, isVM INT DEFAULT 0)
IF @canSeeProvider = 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
            DROP TABLE #getPlans
		CREATE TABLE #getPlans
        (
            planId INT
        )
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
		SET @portNumber = ISNULL((Select fromPortNumber from APP_FirewallTppm with (nolock) where CAST(tppmParams AS INT) = @i_providerId AND tppmType = 4 AND status = 1),0)
SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@ownerCompany
		--@tenantAdminGroupId will be 0 when requested for commcell as company(id=0), or in case of misconfiguration.
		--No need to check for primary contact or plans when Tenanat Admin Group Id was not found. As these properties are set on Tenant Admin Group only.
		IF(@tenantAdminGroupId > 0)
		BEGIN
		INSERT INTO @tempUserTable SELECT UMU.id, UMU.login, UMU.name
						FROM UMUsers UMU  with (nolock)
						INNER JOIN UMUsersProp UUP  with (nolock)
							ON UMU.id=UUP.componentNameId
						INNER JOIN UMUserGroup UUG  with (nolock)
							ON UUG.userId=UUP.componentNameId
						WHERE UUG.groupId= @tenantAdminGroupId
										AND UUP.attrName = 'Primary Contact' and UUP.attrVal=N'1' AND UUP.cs_attrName = checksum(N'Primary Contact')
		END
		-- Populate the smart clientgroup id associated with this company
		IF @i_providerId > 0
		BEGIN
			SELECT @companyGroup = CG.id FROM APP_ClientGroup CG
				INNER JOIN App_CompanyProp C ON C.attrValInt = CG.id
WHERE C.componentNameId = @i_providerId AND C.attrName = 'Associated Smart Client Group' AND C.modified = 0 AND C.cs_attrName = checksum('Associated Smart Client Group')
		END
		-- create the provider property temporary table
		IF object_id('tempdb.dbo.#OrgPropTbl') IS NOT null DROP TABLE #OrgPropTbl
		CREATE TABLE #OrgPropTbl (
									PropertyName        varchar(256),
									propertyValue          nvarchar(MAX)
								)
		-- Get Encryption from App_company prop.
		-- Commcell with provider Id 0 , does not have default SCG, so use App_Company prop
		INSERT INTO #OrgPropTbl
		SELECT attrName, attrVal FROM  App_CompanyProp WHERE componentNameId=@ownerCompany
AND attrName in('Customization','Default Server Plan','Default Laptop Plan',
'Default Snap Plan','Primary Domain', 'Notification Email','Notification Sender Name',
'Creation Time','Default DB Plan','Default File System Plan','Default Virtual Server Backup Plan',
'Default Virtual Server Replication Plan', 'Authorization Code', 'Enable Auth Code Generation', '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807',
'Header Template', 'Footer Template',
'Encryption Settings','Encrypt: Type','Encrypt: Key Length','Encrypt: drToolAccess',
'Prefer Machine Centric Client', 'Allow Users To Enable Privacy' ,'Use UPN For Email',
'EnableTwoFactorAuthentication','AllowOnPremiseStorage', 'completedSetups', 'supportedSolutions', 'PremiseStorageType',
'Disable Login','Disable Backup','Disable Restore', 'API Quota Limit','API Quota Time Frame', 'Always activate with default plan', 'Allow to Manage Other Companies',
'ClientOwnerAssignmentType', 'ClientOwnerAssignmentValue', 'AllowSettingPasskey','vOrg Name', 'vOrg Guid', 'Salesforce Customer Id', 'Contract Id', 'License Usage VM Count', 'License Usage User Count','Force delete devices after days','Retire devices after days', 'Enable eDiscovery for Laptop', 'Enable eDiscovery for O365') and modified=0
		UNION
SELECT 'Sub Domain', _ID FROM dbo.SplitStringByDelimiter((SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany  AND attrName = 'Sub Domain' and modified=0 AND cs_attrName = checksum('Sub Domain')),',')
		UNION
		SELECT CONVERT(VARCHAR(256),propertyTypeId), stringVal FROM  APP_ComponentProp WHERE componentId=@i_providerId AND componentType=10 and modified=0
		UNION
SELECT CONVERT(VARCHAR(256),propertyTypeId), CONVERT(NVARCHAR(MAX),longVal) FROM  APP_ComponentProp WITH(NOLOCK) WHERE componentId=@companyGroup AND propertyTypeId=3623 AND modified=0
		IF @callerId > 0
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#copyListTemp') IS NOT NULL
        	DROP TABLE #copyListTemp
    		CREATE TABLE #copyListTemp (t_copyId INT)
EXEC sec_getNonIdaObjectsForThisUser @callerId, 17, 0, '#copyListTemp'
			IF EXISTS(select 1 from #copyListTemp CL INNER JOIN archGroup AG ON CL.t_copyId = AG.id and (
AG.flags & 33554432 = 33554432 OR
AG.flags & 256 = 256 OR
AG.flags & 16384 = 16384 OR
AG.flags & 8388608 = 8388608
			))
			BEGIN
INSERT INTO #OrgPropTbl values('canViewStoragePool', '1')
			END
			IF OBJECT_ID('tempdb.dbo.#copyListTemp') IS NOT NULL
        		DROP TABLE #copyListTemp
		END
		IF(@level > 10)
		BEGIN
			-- To get All the clients and there type for provided Organization
			IF(@tenantAdminGroupId > 0)
			BEGIN
				-- Get Associated plan from security associations
EXEC AppGetCompanyPlanList @ownerCompany,159,'#getPlans'
			END
			INSERT INTO @tempPlanTable (entityId ,taskId , jobStartTime ,isStartTimeOverridden, entityTypeSelectedForJobStartTime,jobStartTimeForPlan)
SELECT planId,dbo.AppPlanGetEntityValueV2(planId, 'Schedule policy', default),NULL,NULL,NULL,NULL from #getPlans where planid>0 -- Setting jobstarttime to null in case its not set at plan level or overridden at company level
			-- Get number of copies
			UPDATE T
				SET numCopies = (
					SELECT
						COUNT(agc.id)
					FROM archGroup ag WITH(NOLOCK)
						INNER JOIN archGroupCopy agc WITH(NOLOCK) ON
							ag.id = agc.archGroupId
							AND agc.type <> 5
							AND (agc.flags & 524288) = 0
							AND  agc.isSnapCopy=0
					WHERE
ag.id = dbo.AppPlanGetEntityValueV2(T.entityId, 'Storage policy', default)
				)
			FROM @tempPlanTable T
			-- Get number of entity associations
			-- Generate Temporary information before populating XML
			IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL
				DROP TABLE #getPermissionsOnEntities_InputTable
			CREATE TABLE #getPermissionsOnEntities_InputTable
			(
				entityId1 INT,
				entityId2 INT DEFAULT 0,
				entityId3 INT DEFAULT 0,
				entityId4 INT DEFAULT 0,
				entityId5 INT DEFAULT 0,
				planId    INT DEFAULT 0
			)
			CREATE CLUSTERED INDEX getPermissionsOnEntities_InputTable_idx ON #getPermissionsOnEntities_InputTable(planId)
			IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL
				DROP TABLE #getPermissionsOnEntities_OutputTable
			CREATE TABLE #getPermissionsOnEntities_OutputTable
			(
				entityId1 INT,
				entityId2 INT,
				entityId3 INT,
				entityId4 INT,
				entityId5 INT,
				permissionsString VARCHAR(512),
				isChildRow BIT DEFAULT 0
			)
			INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5, planId)
				SELECT
					A.clientId,
					A.appTypeId,
					A.instance,
					A.backupSet,
					A.id,
					t.entityId
				FROM APP_Application A WITH(NOLOCK)
					INNER JOIN APP_SubclientProp SP WITH(NOLOCK) ON
						A.id = SP.componentNameId
AND SP.attrName = 'Associated Plan'
						AND SP.modified = 0
AND SP.cs_attrName = checksum(N'Associated Plan')
					INNER JOIN @tempPlanTable t ON
						CAST (t.entityId AS NVARCHAR(12)) = SP.attrVal
				WHERE
A.subclientStatus & 0x00004 = 0
AND A.subclientStatus & 0x00002 = 0
				UNION
				SELECT
					CP.componentNameId,
					0 appTypeId,
					0 instance,
					0 backupSet,
					0 id,
					t.entityId
				FROM APP_CLIENT C WITH(NOLOCK)
					INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON
						C.id = CP.componentNameId
						AND (
CP.attrName = 'Associated Plan'
OR CP.attrName LIKE 'Default % Plan'
						)
						AND CP.modified = 0
AND (C.status & 0x00004) = 0
AND (C.status & 0x00002) = 0
					INNER JOIN @tempPlanTable t ON
						CAST (t.entityId AS NVARCHAR(12)) = CP.attrVal
			DECLARE @isCommCellAdmin INT = 0
EXEC sec_checkPermissionOnEntity @callerId, 1, @isCommCellAdmin OUT, 1, 2
			IF(@isCommCellAdmin != 1)
			BEGIN
EXEC sec_getPermissionsOnEntities @callerId, 7  /* 7 (7) */
				-- have to delete the entities which user has no permission on as above sp doesnt remove entities that user doesnt have rights on
				DELETE FROM #getPermissionsOnEntities_OutputTable
					WHERE (SUBSTRING(permissionsString,1,1) != CAST(1 AS NVARCHAR(2)))
			END
			IF (@isCommCellAdmin = 1)
			BEGIN
				UPDATE T
					SET numAssocEntities = (
						SELECT
							COUNT(*)
						FROM #getPermissionsOnEntities_InputTable
						WHERE planId = T.entityId
					)
				FROM @tempPlanTable T
			END
			ELSE
			BEGIN
				UPDATE T
					SET numAssocEntities = (
						SELECT
							COUNT(*)
						FROM #getPermissionsOnEntities_OutputTable OP
							INNER JOIN #getPermissionsOnEntities_InputTable IP ON
								OP.entityId1 = IP.entityId1
								AND OP.entityId2 = IP.entityId2
								AND OP.entityId3 = IP.entityId3
								AND OP.entityId4 = IP.entityId4
								AND OP.entityId5 = IP.entityId5
						WHERE IP.planId = T.entityId
					)
				FROM @tempPlanTable T
			END
			-- done with temp tables
			DROP TABLE #getPermissionsOnEntities_InputTable
			DROP TABLE #getPermissionsOnEntities_OutputTable
			-- Get RPO in minutes
			UPDATE T
				SET rpoInMinutes = (
					CASE
WHEN p.subType = 33579013 AND ppLog.attrVal IS NULL THEN -1
WHEN p.subType = 33579013 AND ppLog.attrVal IS NOT NULL THEN CAST(ppLog.attrVal AS INT)
						WHEN pp.attrVal IS NOT NULL THEN CAST(pp.attrVal AS INT)
						ELSE -1
					END
				)
			FROM @tempPlanTable T
				INNER JOIN APP_Plan p WITH(NOLOCK) ON
					p.id = T.entityId
				LEFT OUTER JOIN APP_PlanProp ppLog WITH(NOLOCK) ON
					ppLog.componentNameId = p.id
					AND ppLog.modified = 0
AND ppLog.attrName = 'Log RPO In Minutes'
				LEFT OUTER JOIN APP_PlanProp pp WITH(NOLOCK) ON
					pp.componentNameId = p.id
					AND pp.modified = 0
AND pp.attrName = 'RPO In Minutes'
			WHERE
				pp.attrName = (
					CASE p.subType
WHEN 33579013 THEN 'Log RPO In Minutes'
ELSE 'RPO In Minutes'
					END
				)
			DECLARE @packages AS NVARCHAR(1024) = ''
			DECLARE @ClientType_SERVER INT = 1
			DECLARE @ClientType_DEVICE INT = 2
			DECLARE @ClientType_HYPERVISIOR INT = 3
			DECLARE @ClientType_VM INT = 4
			DECLARE @ClientType_Physical INT = 5
			DECLARE @ClientType_MISC INT = 6
			DECLARE @ClientType_VM_NOT_TO_BE_INCLUDED INT = 7
			INSERT INTO #OrgClientsTbl (clientId)
	                SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
	                        INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrVal=CAST(ACGA.clientGroupId AS nvarchar(max)) AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@i_providerId AND ACP.modified=0 AND ACP.cs_attrName = checksum('Associated Smart Client Group')
			DECLARE @AppGrp35AppTypes TABLE ( appTypeId		INT PRIMARY KEY)
			INSERT INTO @AppGrp35AppTypes
				SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35,0)			-- This Criteria is added from AppGetDevices SP.
			SET @packages = '20,23,51,726,251,252,255,257'				-- These Package ID's are mapped from APPGetServerClientList SP. We have to be in sync
			-- Update Laptop Device Type
			-- Logic is taken from APPGetDevices
			UPDATE CL SET CL.clientType=@ClientType_DEVICE FROM #OrgClientsTbl AS CL
					INNER JOIN APP_Client c
						ON c.STATUS & 0x1000 = 0x1000 AND c.id=CL.clientId
						INNER JOIN APP_IDAName ida
								ON ida.clientId = c.id
									AND	ida.appTypeId <> 13
									AND ida.appTypeId IN (
										SELECT appTypeId
										FROM @AppGrp35AppTypes
									)
			DELETE #OrgClientsTbl
            WHERE clientid IN (
                    SELECT CAST(cp2.attrVal AS INT)
                    FROM #OrgClientsTbl cl
INNER JOIN APP_ClientProp cp on cp.componentNameId=cl.clientId and cp.modified=0 and cp.attrName='User Centric Client' and cp.attrVal = '1'
INNER JOIN APP_ClientProp cp2 on cp2.componentNameId=cl.clientId and cp2.modified=0 and cp2.attrName='Physical Client Id'
                    )  AND clientType=@ClientType_DEVICE -- Delete all physical clients for which there is atleaset 1 user centric client
			-- Update SERVER Device Type
			-- Logic is taken from APPGetServerClientList
			UPDATE CL SET CL.clientType=@ClientType_SERVER FROM #OrgClientsTbl AS CL
				INNER JOIN APP_Client s
					ON s.specialClientFlags = 0 AND s.id=CL.clientId
				INNER JOIN APP_Platform sap
					ON sap.platformType=4 AND s.id=sap.clientId
				INNER JOIN simInstalledPackages sim ON sap.clientId = sim.ClientId
						AND sim.simPackageID IN (
							SELECT _ID
							FROM SplitIDString(@packages)
							)
					WHERE CL.clientType IS NULL
			-- Update HYPERVISIOR Device Type
			-- Logic is taken from AppgetVSPPseudoClients
			UPDATE CL SET CL.clientType=@ClientType_HYPERVISIOR FROM #OrgClientsTbl AS CL INNER JOIN APP_IDAName IDA      ON (IDA.clientId = CL.clientId)
                          INNER JOIN APP_Application APP  ON (APP.clientId = CL.clientId AND App.appTypeId = IDA.appTypeId)
                          INNER JOIN APP_InstanceProp IP  ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
						  INNER JOIN APP_InstanceName AIN ON (AIN.id = APP.instance)
						  INNER JOIN APP_Client AC  ON (AC.id = CL.clientId)
					WHERE   (IDA.appTypeId = 106)
							AND((AC.status  & 0x00004)	    = 0)
							AND((AIN.status & 0x00002)   = 0) -- instance should not be deconfigured or uninstalled
							AND((AIN.status & 0x00004)		= 0)
							AND((IDA.status & 0x00002)   = 0) -- ida should not be deconfigured or uninstalled
							AND((IDA.status & 0x00004)		= 0)
							AND CL.clientType IS NULL
			-- Update VM Device Type
			-- Logic is little deviated from SP AppGetVMStatusInfoForUser - which actually return VM's on AdminConsole Page
			-- Updating logic in sync with above SP. Need to be made more generic for SP7
			-- Get List of All VM's for there last job
			-- this will be list of VM Protected or Backed up with error
			DECLARE @clientListTbl Table
			(
				clientId    INT,
				jobId               INT
			)
			INSERT INTO @clientListTbl
            SELECT componentNameId , CAST(attrVal AS INT) FROM APP_ClientProp WITH (NOLOCK)
            WHERE attrName='Last Backup JobID' AND modified=0
			-- Update Physical Server's Device Type
			-- This is totally new as these type of Servers/Agents are only seen on Servers/All Agents Page
			UPDATE CL SET CL.clientType=@ClientType_Physical FROM #OrgClientsTbl AS CL
			INNER JOIN APP_Client AC
				ON AC.id=CL.clientId AND AC.specialClientFlags & 2 = 0
				WHERE CL.clientType IS NULL
			-- Protected OR Backed UP with Error vms
			UPDATE CL SET CL.clientType=@ClientType_VM FROM #OrgClientsTbl AS CL
            WHERE CL.clientType IS NULL AND CL.clientID IN (SELECT  DISTINCT(clientId) FROM @clientListTbl)
			-- After this step, we anyways don't want to include any VM which is not yet identified.
			-- Lets mark them internally and not return in any count
			UPDATE CL SET CL.clientType=@ClientType_VM_NOT_TO_BE_INCLUDED FROM #OrgClientsTbl AS CL
			INNER JOIN APP_ClientProp ACP
				ON ACP.componentNameId=CL.clientId AND ACP.attrName='Virtual Server Discovered Clients' AND ACP.attrVal=N'1' AND modified=0
				WHERE CL.clientType IS NULL
			-- Protected OR Backed UP with Error vms
			-- This is the actual count that will be reported to Companies page
			UPDATE CL SET CL.isVM=1 FROM #OrgClientsTbl AS CL
            WHERE CL.clientID IN (SELECT  DISTINCT(clientId) FROM @clientListTbl)
			-- All Remaininig Device Type
			-- They might include Device with no Agents/Package installed
			UPDATE #OrgClientsTbl SET clientType=@ClientType_MISC WHERE clientType IS NULL
			-- Client Details till here
			DECLARE @includeUsersFlags int = -1;
			DECLARE @excludeUsersFlags int = 0;
SET @includeUsersFlags = ( CAST (0x001 AS INT) )
SET @excludeUsersFlags = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
			-- User and Created Time For that Organization
			DECLARE @orgUsers INT = ISNULL ((SELECT COUNT(*) FROM UMUsers WHERE umDSproviderId IN (SELECT id FROM UMDSProviders WHERE id=@i_providerId OR ownerCompany=@i_providerId ) AND(flags & @excludeUsersFlags = 0) AND (flags & @includeUsersFlags <> 0)), 0)
			--Fill in the details here
			DECLARE @totalMachineCount INT = ISNULL ((SELECT	COUNT(*) FROM #OrgClientsTbl WHERE (clientType NOT IN (@ClientType_VM, @ClientType_VM_NOT_TO_BE_INCLUDED))),0)    -- All Agent Page doesn't show VM's
			DECLARE	@serverCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_SERVER),0)
			DECLARE	@deviceCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_DEVICE),0)
			DECLARE	@hypervisiorCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_HYPERVISIOR),0)
			DECLARE	@vmCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE isVM=1) ,0)
			DECLARE	@physicalDeviceCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_Physical),0)
			DECLARE	@miscMachineCount INT = ISNULL ((SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_MISC),0)
			-- Get privacy settings for company (passkey feature)
IF EXISTS(SELECT 1 FROM APP_CompanyProp WITH (NOLOCK) WHERE componentNameId = @i_providerId AND attrName='AuthorizationType' AND attrVal = '2' AND modified = 0 AND cs_attrName = checksum('AuthorizationType'))
			BEGIN
				SET @authType = 2  -- USE_PASSKEY (attrVal = '2')
				DECLARE @authUsers XML = ISNULL((SELECT cast(attrVal as xml) FROM APP_CompanyProp WITH(NOLOCK) WHERE componentNameId = @i_providerId
AND attrName='AuthorizedUsersForRestore' AND modified = 0 AND cs_attrName = checksum('AuthorizedUsersForRestore')),'')
				SET @expirationTimeStamp = ISNULL((select T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]','integer') from @authUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
				WHERE T.c.value('@userId','int') = @callerId),0)
				IF @expirationTimeStamp > dbo.GetUnixTime(GETUTCDATE())
				BEGIN
					SET @enableAuthorizeForRestore = 1
				END
			END
			-- Get Nav Items Settings For this company
			DECLARE @settingXML XML
			EXEC AppNavSettingsGet @callerId,@ownerCompany, @settingXML OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = '3c8d1ac5575382ed39b961906a331a2ac82766fdcfa15580a' and value = '1' and modified =0)
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = (SELECT csGUID FROM App_Commcell WITH(NOLOCK) where id = 2) and value = '3b43937232ab5b572bf6bb373d33ca779a47427f93c82b196b881417e07eca1db3601baf45fe32f14'
							and modified =0)
						SET @isPrivacyFeatureEnabled = 1
				ELSE
					SET @isPrivacyFeatureEnabled = 0
			ELSE
				SET @isPrivacyFeatureEnabled = 0
			--Get Company Global Filters
			IF @i_providerId > 0
			BEGIN
				DECLARE @useCompanyGlobalFilter INT =
					ISNULL((SELECT longVal
						FROM APP_ComponentProp
					WHERE
componentType = 8
						AND componentId = @companyGroup
AND propertyTypeId = 3622
						AND modified = 0), 1)
				DECLARE @companyGlobalFiler TABLE (o_filterStr VARCHAR(MAX), o_filterXml XML, o_errorCode INT, o_errorMessage VARCHAR(MAX))
				INSERT @companyGlobalFiler
EXEC AppGetCompanyGlobalFilter @companyGroup, 28, 0
				SELECT @filterxml = o_filterXml FROM @companyGlobalFiler
				SET @filterxml = REPLACE(CAST(@filterxml AS NVARCHAR(MAX)), '+1', ' ')
				SET @filterxml = @filterxml.query('/App_GlobalFiltersInfo/globalFiltersInfoList')
				SELECT @isJobStartTimeEnabled = 1,@jobStartTime = longVal
				FROM APP_ComponentProp (NOLOCK)
WHERE componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1303
				AND modified = 0
				IF @jobStartTime = -1
				BEGIN
					SET @isJobStartTimeEnabled = 0
				END
				UPDATE T
				SET jobStartTime = APP_ComponentProp.longVal ,
				isStartTimeOverridden = 1
				FROM @tempPlanTable T
				INNER JOIN APP_ComponentProp (NOLOCK)
ON componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1304
				AND modified = 0
				AND dataType = T.taskId -- TaskId is stored in dataType field since dataType doesnt have any meaning as such.
				UPDATE T
				SET entityTypeSelectedForJobStartTime = APP_ComponentProp.longVal
				FROM @tempPlanTable T
				INNER JOIN APP_ComponentProp (NOLOCK)
ON componentType = 8 and componentId =  @companyGroup and propertyTypeId = 1305
				AND modified = 0
				AND dataType = T.taskId -- TaskId is stored in dataType field since dataType doesnt have any meaning as such.
				AND (t.isStartTimeOverridden IS NULL OR t.isStartTimeOverridden = 0)
				-- Update start time specified at plan level.
				UPDATE TP
				SET jobStartTimeForPlan = TMP.active_start_time
				FROM @tempPlanTable TP
INNER JOIN App_Plan ON App_Plan.id = TP.entityId AND App_Plan.flag & 0x40000000 = 0
				AND (TP.isStartTimeOverridden IS NULL OR TP.isStartTimeOverridden = 0)
INNER JOIN TM_SubTask ST WITH (READUNCOMMITTED) ON ST.taskId = TP.taskId AND (ST.flags & 0x10000) > 0
				INNER JOIN TM_PatternAssoc PA WITH(READUNCOMMITTED) ON PA.subtaskId = ST.subTaskID
				INNER JOIN TM_Pattern TMP WITH(READUNCOMMITTED) ON TMP.patternId = PA.patternId
AND TMP.freq_type = 4096
				WHERE TMP.active_start_time IS NOT NULL AND TMP.active_start_time >= 0
				-- Update job start time in case its from specific entity
				UPDATE T
				SET jobStartTime = CASE WHEN entityTypeSelectedForJobStartTime = 189 AND @isJobStartTimeEnabled = 1 THEN @jobStartTime
				WHEN entityTypeSelectedForJobStartTime = 158 THEN jobStartTimeForPlan
				ELSE jobStartTime
				END
				FROM @tempPlanTable T
				WHERE entityTypeSelectedForJobStartTime IS NOT NULL AND entityTypeSelectedForJobStartTime>0
				-- Update job start time in case level for job start time is not set and we need to set system detected job start time for plan and level.
				UPDATE T
				SET jobStartTime = CASE WHEN @isJobStartTimeEnabled = 1 THEN @jobStartTime
				WHEN jobStartTimeForPlan>=0 THEN jobStartTimeForPlan
				ELSE jobStartTime
				END,
				entityTypeSelectedForJobStartTime = CASE WHEN @isJobStartTimeEnabled = 1 THEN 189 -- Company entity
				WHEN jobStartTimeForPlan>=0 THEN 158 -- plan entity
				ELSE entityTypeSelectedForJobStartTime
				END
				FROM @tempPlanTable T
				WHERE (T.isStartTimeOverridden IS NULL OR t.isStartTimeOverridden = 0)
				AND (entityTypeSelectedForJobStartTime IS NULL OR entityTypeSelectedForJobStartTime=0)
			END
		END
DECLARE @enableAutoDiscovery INT = ISNULL((SELECT 1 FROM APP_AdvanceSettings WHERE entityId = @companyGroup AND entityType = 28 AND keyName = 'nEnableAutoDetectApp' AND type = 'INTEGER' AND relativePath = 'iDataAgent' AND enabled = 1 AND value LIKE '2'), 0)
		SET @o_xmlText =(SELECT
					(SELECT ISNULL((UD.login), '') as '@login' , ISNULL((UD.hostName), '') as '@connectName', ISNULL((UD.description), '') as '@description',
										UD.flags as '@flags', UD.enabled as '@enabled', UD.serviceType as '@serviceType', UD.useSecureLdap as '@useSecureLdap', @portNumber as '@port',
(SELECT attrVal from UMDSProviderProp where attrName='Password History Count' and componentNameId=@i_providerId and modified=0) as '@pswdHistoryCount',
										(SELECT attrVal as '@val'   from UMDSProviderProp where attrName='Email Domain' and componentNameId=@i_providerId FOR XML PATH ('emailDomainNames') ,Type),
										(SELECT UD.id as '@id', UD.domainName as '@domainName' FOR XML PATH('shortName'),TYPE),
(SELECT ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Login'),0) AS '@disableLogin',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Backup'),0) AS '@disableBackup',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Disable Restore'),0) AS '@disableRestore' FOR XML PATH('deactivateOptions'),TYPE),
										(SELECT UD.resourceId as '@id', ISNULL((Select domainName from UMDSproviders UMDS with (nolock) where UMDS.id = UD.resourceId), 'N/A') as '@domainName' FOR XML PATH('resourceProvider'),TYPE)
								FROM UMDSProviders UD with (nolock) where UD.id in (@i_providerId) FOR XML PATH('organization'),TYPE),
								(SELECT P.type          AS '@type',
										P.subType       AS '@subtype',
										P.description   AS '@descripiton',
										P.flag			AS '@planStatusFlag',
										TP.jobStartTime '@jobStartTime',
										TP.isStartTimeOverridden '@isStartTimeOverridden',
										TP.entityTypeSelectedForJobStartTime '@entityTypeSelectedForJobStartTime',
										TP.numCopies '@numCopies',
										TP.numAssocEntities '@numAssocEntities',
										TP.rpoInMinutes '@rpoInMinutes',
										(SELECT COUNT(A.userId) FROM
											(SELECT DISTINCT userId FROM UMUserGroup WHERE groupId IN
												(SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName IN
('Assigned user group', 'Associated internal user group', 'Associated external user group' ))) A ) AS '@numUsers',
												0  AS '@numDevices',
ISNULL((SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Derivation restrictions'), 0)  AS '@restrictions',
										(SELECT P.id            AS '@planId',
												 P.name	        AS '@planName',
158    AS '@_type_'    -- defined in CVEntities.x
										  FOR XML PATH('plan'), TYPE
										),
										(SELECT PP.id           AS '@planId',
												 PP.name	     AS '@planName',
158     AS '@_type_'    -- defined in CVEntities.x
										  FROM	 APP_Plan PP
WHERE	 PP.id IN (SELECT CAST(attrVal AS INT) FROM APP_PlanProp WHERE componentNameId = P.id AND attrName = 'Base plan')
										  FOR XML PATH('parent'), TYPE
										)
									FROM App_Plan P
										INNER JOIN @tempPlanTable TP
ON P.id = TP.entityId WHERE P.flag & 0x40000000 = 0
								 FOR XML PATH('planDetails'),TYPE),
								(
									SELECT @orgUsers AS '@userCount',
									@totalMachineCount AS '@totalMachineCount',    -- All Agent Page doesn't show VM's
									@serverCount AS '@serverCount',
									@deviceCount AS '@deviceCount',
									@hypervisiorCount AS '@hypervisiorCount',
									@vmCount AS '@vmCount',
									@physicalDeviceCount AS '@physicalDeviceCount',
									@jobStartTime '@jobStartTime',
									@isJobStartTimeEnabled '@isJobStartTimeEnabled',
									@useCompanyGlobalFilter '@useCompanyGlobalFilter',
									(SELECT COUNT(*) FROM #OrgClientsTbl WHERE clientType=@ClientType_MISC) AS '@miscMachineCount',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Primary Domain') AS '@primaryDomain',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Customization') AS '@customization',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Notification Email') AS '@senderSmtp',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Notification Sender Name') AS '@senderName',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Prefer Machine Centric Client') AS '@preferenceMachineCentricClient',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Creation Time') AS '@orgCreationDateTime',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Use UPN For Email') AS '@useUPNForEmail',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Salesforce Customer Id') AS '@salesforceCustomerId',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Contract Id') AS '@contractId',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='License Usage VM Count') AS '@quotaVMCount',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='License Usage User Count') AS '@quotaUserCount',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='vOrg Name') AS '@vOrgName',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='vOrg Guid') AS '@vOrgGuid',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='AllowOnPremiseStorage'),0) AS '@allowOnPremiseStorage',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Allow to Manage Other Companies'),0) AS '@canCreateCompanies',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName=CONVERT(varchar(256),3623)),0) AS '@showDLP',
									@isPrivacyFeatureEnabled AS '@isPrivacyFeatureEnabledAtCommcell',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='EnableTwoFactorAuthentication') AS '@enableTwoFactorAuthentication',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='completedSetups'),'') AS '@completedSetups',
									-- for null supportedSolutions and supported solutions value 0, we fetch from GxGlobalParam
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='supportedSolutions' AND propertyValue <> '0'),ISNULL((SELECT value FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'supportedSolutions'),4127)) AS '@supportedSolutions',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='canViewStoragePool'),0) AS '@canViewStoragePool',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='PremiseStorageType'),0) AS '@infrastructureType',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Enable eDiscovery for Laptop'),0) AS '@enableEDiscoveryForLaptop',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Enable eDiscovery for O365'),0) AS '@enableEDiscoveryForO365',
(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Authorization Code' AND @canSeeAuthCode = 1 AND ((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation') = 1)) AS '@authCode',
									@enableAutoDiscovery AS '@enableAutoDiscovery',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='ClientOwnerAssignmentType'),
ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'ClientOwnerAssignmentType'), 0)) AS '@autoClientOwnerAssignmentType',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='ClientOwnerAssignmentValue'),
ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'ClientOwnerAssignmentValue'), '')) AS '@autoClientOwnerAssignmentValue',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='AllowSettingPasskey'),
ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'AllowSettingPasskey' AND modified = 0), 0)) AS '@allowUsersToEnablePasskey',
ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'AllowSettingPasskey' AND modified = 0), 0) AS '@isPasskeyFeatureEnabledAtCommcell',
ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation'),0) AS '@enableAuthCodeGen',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName='Allow Users To Enable Privacy') AS '@allowUsersToEnablePrivacy',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName='Always activate with default plan'),0) AS '@alwaysActivateWithDefaultPlan',
									(SELECT (SELECT @settingXML.query('Api_GetNavItemsResp/navSettings') FOR XML PATH(''),TYPE)),
									(
										SELECT  33554437     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Server Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Server Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(
										SELECT  33554439     AS '@subtype' ,
										(
											SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
WHERE t.PropertyName='Default Laptop Plan'
										  FOR XML PATH('plan'), TYPE
										)
FROM #OrgPropTbl t1 	where t1.PropertyName='Default Laptop Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(SELECT  67108869     AS '@subtype' ,
								(SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Snap Plan'
										  FOR XML PATH('plan'), TYPE
										)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Snap Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                ----
                                	(
										SELECT  33579013     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default DB Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default DB Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                	(
										SELECT  50331655     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default File System Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default File System Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                	(
										SELECT  83886085     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Virtual Server Backup Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Virtual Server Backup Plan'
								FOR XML PATH('defaultPlans'), TYPE),
                                (
										SELECT  83918853     AS '@subtype' ,
											(
												SELECT PP.id           AS '@planId', PP.name	     AS '@planName'
										FROM	 #OrgPropTbl t
										inner join APP_Plan PP on pp.id=t.propertyValue
where t.PropertyName='Default Virtual Server Replication Plan'
											FOR XML PATH('plan'), TYPE)
FROM	 #OrgPropTbl t1 	where t1.PropertyName='Default Virtual Server Replication Plan'
								FOR XML PATH('defaultPlans'), TYPE),
									(SELECT TU.userDisplayName as '@fullName',
									(SELECT 13 '@_type_', TU.userIdPrimaryContact as '@userId', TU.userName as '@userName'  FOR XML PATH('user'),TYPE)
									FROM @tempUserTable TU FOR XML PATH('primaryContacts'),TYPE),
(SELECT propertyValue AS '@val' FROM #OrgPropTbl WHERE PropertyName='Sub Domain'  FOR XML PATH('additionalDomains'), TYPE),
								(SELECT
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encryption Settings'),3 /*Not Set*/) as  '@encryptionSettings',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: Type'),2) as '@cipherType',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: drToolAccess'),0) as '@directMediaAccess',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Encrypt: Key Length'),128) as '@encryptKeyLength'
									FOR XML PATH('encryptionInfo'),TYPE),
								(SELECT
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Force delete devices after days'),365) as '@forceDeleteDevicesAfterDays',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Retire devices after days'),183) as '@retireDevicesAfterDays'
									FOR XML PATH('autoRetireDevices'),TYPE),
								(SELECT
(SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Header Template') as  '@headerTemplate',
(SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'Footer Template') as '@footerTemplate'
									FOR XML PATH('emailTemplateSettings'),TYPE),
								(SELECT @filterxml FOR XML PATH ('globalFiltersInfo'), TYPE),
								(SELECT
									 ISNULL((SELECT	(
													 CASE
WHEN propertyValue = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
													 ELSE 0
													 END
)  FROM #OrgPropTbl where PropertyName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'),0) AS '@enableDataSecurity'
									 FOR XML PATH('privacy'),TYPE),
								(
									SELECT CASE WHEN userId <> 0 THEN email END AS '@email',			-- Anand and Bhavyan want to display these details as well.
										   CASE WHEN userId <> 0 THEN fullName END AS '@fullName',
										   CASE WHEN userId <> 0 THEN
												(SELECT userId AS '@userId',
														login AS '@userName'
												FOR XML PATH ('user'), TYPE)
										   END,
										   CASE WHEN userGroupId <> 0 THEN
												(SELECT userGroupId AS '@userGroupId',
														userGroupName AS '@userGroupName'
												FOR XML PATH ('userGroup'), TYPE)
										   END,
										   CASE WHEN roleId <> 0 THEN
												(SELECT roleId AS '@roleId',
														roleName AS '@roleName'
												FOR XML PATH ('role'), TYPE
												)
										   END
									FROM dbo.sec_getCommvaultResellersForCompany(@i_providerId)
									FOR XML PATH('operators'), TYPE
								)
								,(
									SELECT CAST(attrVal AS INT) AS '@roleId'
										   ,R.name AS '@roleName'
									FROM APP_CompanyProp (NOLOCK) CP
										INNER JOIN UMRoles R (NOLOCK)
											ON CP.attrValInt = R.id
									WHERE
										componentNameId = @i_providerId
AND attrName = 'Operator Role'
AND CP.modified = 0 AND CP.cs_attrName = checksum('Operator Role')
									FOR XML PATH ('operatorRole'), TYPE
								)
								,(
									SELECT @authType AS '@authType',
										 (SELECT @enableAuthorizeForRestore as '@enableAuthorizeForRestore',
										 (SELECT @expirationTimeStamp as '@time'
											 FOR XML PATH('expirationTime'), TYPE)
										 FOR XML PATH('passkeySettings'), TYPE)
										 FOR XML PATH('advancedPrivacySettings'),TYPE
								)
,(SELECT id as '@IdentityServerId',domainName as '@IdentityServerName','AD' as '@type',1 as '@isConfigured' from UMDSProviders where ownerCompany = @i_providerId and serviceType in  (2,8,9,10,14)  for xml path ('ExternalAuthentication'),type),
(SELECT id as '@IdentityServerId',domainName as '@IdentityServerName','AD' as '@type',0 as '@isConfigured' from UMDSProviders where ownerCompany = @i_providerId and serviceType = 12 and (flags & 8 = 0)  for xml path ('ExternalAuthentication'),type),
(SELECT ATPA.id as '@IdentityServerId',appName as '@IdentityServerName','SAML' as '@type',1 as '@isConfigured' from App_ThirdPartyApp ATPA inner join UMDSProviderProp UPP on UPP.attrVal = ATPA.id INNER JOIN UMDSProviders UP on UP.id = UPP.componentNameId where  UPP.attrName='SAML IDP' and UP.ownerCompany = @i_providerId and UP.serviceType = 11  for xml path ('ExternalAuthentication'),type)
,(SELECT entityId1 as '@commCellId',aliasName as '@commCellName' from UMSecurityAssociations inner join APP_CommCell on APP_CommCell.id = entityId1 where  isUser = 2 and userOrGroupId = @i_providerId and entityType1 = 194 for xml path('associatedCommcells'),type)
								,(SELECT
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'API Quota Limit'),0) as  '@APILimit',
ISNULL((SELECT propertyValue FROM #OrgPropTbl where PropertyName = 'API Quota Time Frame'),0) as '@APItimeFrame'
									FOR XML PATH('apiQuota'),TYPE)
								FOR XML PATH('organizationProperties'), TYPE),
								(SELECT
                                             CR.keyName as '@keyName',
                                             CR.type as '@type',
                                             (CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
                                             CR.relativepath as '@relativepath',
                                             --CR.deleted as '@deleted',
                                             CR.enabled as '@enabled',
                                             ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
											 NULL as '@isInheritedFromClientGroup'
                                             FROM APP_AdvanceSettings as CR
                                             LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx
                                                 ON CR.id = AdvEx.keyId
                                             WHERE CR.entityId =  @i_providerId
													AND CR.entityType = 189 -- CvEntities::EntityType_COMPANY_ENTITY
													AND CR.deleted = 0
													AND ISNULL(AdvEx.hidden,0) = 0
                                             FOR XML PATH('regKeys'),TYPE)
						FOR XML PATH('organizationInfo'),TYPE)
	END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
END
IF(@o_errCode > 0)
BEGIN
	SET @xmlerrors = (SELECT @o_errString as '@errorMessage', @o_errCode as '@errorCode' FOR XML PATH('error'),TYPE)
	END
SET @o_xmlText = (SELECT @o_xmlText , @xmlerrors FOR XML PATH('') , ROOT('Api_GetOrganizationPropertiesResponse'))
select @o_xmlText
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT '' FOR XML PATH ('Api_OrganizationInfo'),TYPE)
	select @o_xmlText
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
  	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
            DROP TABLE #getPlans
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyProperties')
	delete from GxQscripts where name = 'AppGetCompanyProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyProperties')
	delete from GXDBVersions where aliasname = 'AppGetCompanyProperties'
GO

insert into GXDBVersions values(2, 'AppGetCompanyProperties',  'v1.1.2.84.4.1', 'AppGetCompanyProperties', 'v1.1.2.84.4.1')
GO

