

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyPlanList.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetTenantAdminForCompany()
--  | Description:  Allows for GET of Tenant Admin provided ProviderID
--  +==============================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCompanyPlanList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyPlanList <<<'
	drop procedure AppGetCompanyPlanList
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyPlanList')
	delete from GxQscripts where name = 'AppGetCompanyPlanList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyPlanList')
	delete from GXDBVersions where aliasname = 'AppGetCompanyPlanList'
GO
print '... Creating Procedure: AppGetCompanyPlanList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCompanyPlanList
  @i_companyId INT,
  @permissionId INT,
  @tableOutput NVARCHAR(MAX) = ''
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	--THERE IS NO SECURITY CHECK FOR THE LOGGED IN USER ID SO DO THE SECURITY CHECK BEFORE CALLING THIS SP
	DECLARE @ownerCompany INT = dbo.AppGetCompanyForProvider(@i_companyId)
	DECLARE @tenantAdminGroupId INT = 0
	IF(@ownerCompany > 0)
	BEGIN
SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@ownerCompany
		DECLARE @createAsUserID int =0
		EXEC sec_getCreateAsUserId 0,0 , @createAsUserID OUTPUT,0,0,@tenantAdminGroupId
		IF @createAsUserID > 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @createAsUserID, 158, @permissionId,@tableOutput
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	;THROW;
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyPlanList')
	delete from GxQscripts where name = 'AppGetCompanyPlanList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyPlanList')
	delete from GXDBVersions where aliasname = 'AppGetCompanyPlanList'
GO

insert into GXDBVersions values(2, 'AppGetCompanyPlanList',  '00000000000000000000', 'AppGetCompanyPlanList', '00000000000000000000')
GO

