

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyGlobalFilter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyGlobalFilter.sp,v $ $Id: AppGetCompanyGlobalFilter.sp,v 1.1.2.8 2020/11/21 12:25:11 abilbrey Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetCompanyGlobalFilter()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
-- Inputs:
--i_entityId = Id of the entity
--i_entityType = SUBCLIENT_ENTITY(7) | CLIENT_GROUP_ENTITY(28). If entity type is SUBCLIENT_ENTITY then get filters from all client groups it is associated.
--																If entity type is CLIENT_GROUP_ENTITY then get filters from given client group.
--i_appType = CV_APPTYPE_WINDOWS_FILESYSTEM(33) | CV_APPTYPE_NOT_DEFINED(0)
--
--AppMgr API initContent can call with parameters: i_entityId = subclientID, i_entityType = SUBCLIENT_ENTITY(7), i_appType = CV_APPTYPE_WINDOWS_FILESYSTEM(33)
--The stored proc identifies all associated client group. It combines the filters from all client group for given apptype and returns in o_filterStr.
--
--Adminconsole can call with parameters: i_entityId = clientGroupId, i_entityType = CLIENT_GROUP_ENTITY(28), i_appType = CV_APPTYPE_NOT_DEFINED(0)
--The output is o_filterXml, it has all filters(win, unix,....) on given client group.
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCompanyGlobalFilter')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyGlobalFilter <<<'
	drop procedure AppGetCompanyGlobalFilter
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyGlobalFilter')
	delete from GxQscripts where name = 'AppGetCompanyGlobalFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyGlobalFilter')
	delete from GXDBVersions where aliasname = 'AppGetCompanyGlobalFilter'
GO
print '... Creating Procedure: AppGetCompanyGlobalFilter'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCompanyGlobalFilter
  @i_entityId INT,
  @i_entityType INT,
  @i_appType INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_filterStr VARCHAR(MAX)
  DECLARE @o_filterXml XML
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorMessage VARCHAR(MAX) = 'Success'
--== IMPORTANT NOTE! ==========================================================================
--==
--== If this SP is modified and changes impact Laptop Backups (SubClient area) then similar
--== changes need to done in the AppMgr/CCSDb/SCInterfaceCCSDb.cpp file in method:
--==
--==    SCInterfaceCCSDB::initContent(...) where this SP is implemented as CPP
--==    and SQLite code inline directly.
--==
--==    Last NCVS V11 Version Sync'd: 1.1.2.8
--==
--== IMPORTANT NOTE! ==========================================================================
DECLARE @winFilterStr VARCHAR(MAX) = ''
DECLARE @unixFilterStr VARCHAR(MAX) = ''
SET @o_filterStr = ''
SET @o_filterXml = ''
DECLARE @OFF INT = 0
DECLARE @ON INT = 1
DECLARE @USE_CLIENT_GROUP_SETTING INT = 2
IF @i_entityType = 7 --SUBCLIENT_ENTITY
BEGIN
	--Following logic is from initContent() of SCInterfaceDB.cpp to identify if client group global filter is enabled on subclient
	DECLARE @useClientGroupFilter INT = @OFF
	DECLARE @deferToCSsetting INT = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentnameid = @i_entityId AND attrName = N'use cs setting for global filters' AND cs_attrName = CHECKSUM(N'use cs setting for global filters') AND modified = 0), @ON)
	IF @deferToCSsetting = @ON
	BEGIN
		SET @useClientGroupFilter = @USE_CLIENT_GROUP_SETTING
	END
	ELSE
	BEGIN
		SET @useClientGroupFilter = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentnameid = @i_entityId AND cs_attrName = CHECKSUM(N'use global filters') AND attrName = N'use global filters' AND modified = 0), @OFF)
	END
	IF @useClientGroupFilter = @OFF
		GOTO EXITSP
	IF @useClientGroupFilter = @ON
	BEGIN
		SELECT @winFilterStr = @winFilterStr + ' ' + prop.stringVal
		FROM APP_Application subclient
		INNER JOIN APP_ClientGroupAssoc cg ON cg.clientId = subclient.clientId
		INNER JOIN APP_ComponentProp prop ON cg.clientGroupId = prop.componentId
		WHERE subclient.id = @i_entityId
AND prop.componentType = 8
AND prop.propertyTypeId = 3620
		AND prop.modified = 0
		SELECT @unixFilterStr = @unixFilterStr + ' ' + prop.stringVal
		FROM APP_Application subclient
		INNER JOIN APP_ClientGroupAssoc cg ON cg.clientId = subclient.clientId
		INNER JOIN APP_ComponentProp prop ON cg.clientGroupId = prop.componentId
		WHERE subclient.id = @i_entityId
AND prop.componentType = 8
AND prop.propertyTypeId = 3621
		AND prop.modified = 0
	END
	ELSE IF @useClientGroupFilter = @USE_CLIENT_GROUP_SETTING
	BEGIN
		SELECT @winFilterStr = @winFilterStr + ' ' + prop.stringVal
		FROM APP_Application subclient
		INNER JOIN APP_ClientGroupAssoc cg ON cg.clientId = subclient.clientId
		INNER JOIN APP_ComponentProp prop ON cg.clientGroupId = prop.componentId
LEFT OUTER JOIN APP_ComponentProp prop1 ON cg.clientGroupId = prop1.componentId AND prop1.componentType = 8 AND prop1.propertyTypeId = 3622 AND prop1.modified = 0
		WHERE subclient.id = @i_entityId
AND prop.componentType = 8
AND prop.propertyTypeId = 3620
		AND prop.modified = 0
		AND (prop1.longVal IS NULL OR prop1.longVal = 1)
		SELECT @unixFilterStr = @unixFilterStr + ' ' + prop.stringVal
		FROM APP_Application subclient
		INNER JOIN APP_ClientGroupAssoc cg ON cg.clientId = subclient.clientId
		INNER JOIN APP_ComponentProp prop ON cg.clientGroupId = prop.componentId
LEFT OUTER JOIN APP_ComponentProp prop1 ON cg.clientGroupId = prop1.componentId AND prop1.componentType = 8 AND prop1.propertyTypeId = 3622 AND prop1.modified = 0
		WHERE subclient.id = @i_entityId
AND prop.componentType = 8
AND prop.propertyTypeId = 3621
		AND prop.modified = 0
		AND (prop1.longVal IS NULL OR prop1.longVal = 1)
	END
	SET @winFilterStr = LTRIM(@winFilterStr)
	SET @unixFilterStr = LTRIM(@unixFilterStr)
END
ELSE IF @i_entityType = 28 --CLIENT_GROUP_ENTITY
BEGIN
	SELECT @winFilterStr = stringVal
	FROM APP_ComponentProp
	WHERE componentId = @i_entityId
AND componentType = 8
AND propertyTypeId = 3620
	AND modified = 0
	SELECT @unixFilterStr = stringVal
	FROM APP_ComponentProp
	WHERE componentId = @i_entityId
AND componentType = 8
AND propertyTypeId = 3621
	AND modified = 0
END
ELSE IF @i_entityType = 3 --CLIENT_ENTITY
BEGIN
	DECLARE @groupFilters TABLE (componentId INT, useFilterOnAllSubclient INT, winfilters NVARCHAR(MAX), unixfilters NVARCHAR(MAX))
	INSERT @groupFilters(componentId)
	SELECT DISTINCT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @i_entityId
	UPDATE T
		SET winfilters = stringVal
	FROM @groupFilters T
	INNER JOIN APP_ComponentProp componentProp ON componentProp.componentId = T.componentId
WHERE componentProp.propertyTypeId = 3620
	AND componentProp.modified = 0
	UPDATE T
		SET unixfilters = stringVal
	FROM @groupFilters T
	INNER JOIN APP_ComponentProp componentProp ON componentProp.componentId = T.componentId
WHERE componentProp.propertyTypeId = 3621
	AND componentProp.modified = 0
	UPDATE T
		SET T.useFilterOnAllSubclient = ISNULL(longVal, 1)
	FROM @groupFilters T
	INNER JOIN APP_ComponentProp componentProp ON componentProp.componentId = T.componentId
WHERE componentProp.propertyTypeId = 3622
	AND componentProp.modified = 0
	DELETE @groupFilters WHERE useFilterOnAllSubclient IS NULL AND winfilters IS NULL AND unixfilters IS NULL
END
IF @i_appType = 1
OR @i_appType = 11
OR @i_appType = 91
OR @i_appType = 33
OR @i_appType = 34
OR @i_appType = 42
OR @i_appType = 43
OR @i_appType = 93
BEGIN
	SET @o_filterStr = @winFilterStr
END
ELSE IF @i_appType = 29
OR @i_appType = 17
OR @i_appType = 18
OR @i_appType = 19
OR @i_appType = 20
OR @i_appType = 21
OR @i_appType = 36
OR @i_appType = 63
OR @i_appType = 64
OR @i_appType = 74
OR @i_appType = 86
BEGIN
	SET @o_filterStr = @unixFilterStr
END
ELSE IF @i_appType != 0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorMessage = 'Invalid appType[' + CAST(@i_appType AS VARCHAR(16)) + ']'
END
IF @i_entityType = 3 --CLIENT_ENTITY
BEGIN
	SET @o_filterXml =
		(SELECT
			(SELECT
					componentProp.useFilterOnAllSubclient AS '@usefilterOnAllsubclients',
					(SELECT componentProp.componentId AS '@clientGroupId'
						FOR XML PATH('clientGroup'),TYPE),
					(SELECT DISTINCT _ID AS 'windowsGlobalFilters'
						FROM dbo.SplitStringByDelimiter(componentProp.winfilters,' ')
						FOR XML PATH(''),TYPE),
					(SELECT DISTINCT _ID AS 'unixGlobalFilters'
						FROM dbo.SplitStringByDelimiter(componentProp.unixfilters,' ')
						FOR XML PATH(''),TYPE)
			FROM @groupFilters componentProp
			FOR XML PATH('clientGroupFilters'), TYPE)
		FOR XML PATH('Api_GetGlobalFiltersResp'), TYPE)
END
ELSE
BEGIN
	SET @o_filterXml =
                (SELECT
                    (SELECT
						1 AS 'operatingSystemType',
						(SELECT
							(SELECT DISTINCT _ID AS 'filters'
								FROM dbo.SplitStringByDelimiter(@winFilterStr,' ')
								FOR XML PATH(''),TYPE)
							FOR XML PATH('globalFilters'),TYPE)
                    FOR XML PATH('globalFiltersInfoList'), TYPE),
					(SELECT
						2 AS 'operatingSystemType',
						(SELECT
							(SELECT DISTINCT _ID AS 'filters'
								FROM dbo.SplitStringByDelimiter(@unixFilterStr,' ')
								FOR XML PATH(''),TYPE)
							FOR XML PATH('globalFilters'),TYPE)
                    FOR XML PATH('globalFiltersInfoList'), TYPE)
                FOR XML PATH('App_GlobalFiltersInfo'), type)
END
EXITSP:
SELECT @o_filterStr, @o_filterXml, @o_errorCode, @o_errorMessage
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyGlobalFilter')
	delete from GxQscripts where name = 'AppGetCompanyGlobalFilter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyGlobalFilter')
	delete from GXDBVersions where aliasname = 'AppGetCompanyGlobalFilter'
GO

insert into GXDBVersions values(2, 'AppGetCompanyGlobalFilter',  '00010001000200080000', 'AppGetCompanyGlobalFilter', '00010001000200080000')
GO

