

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyEmailCustomization.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyEmailCustomization()
--  | Description:  Allows for GET of email related company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyEmailCustomization.sp,v $ $Id: AppGetCompanyEmailCustomization.sp,v 1.1.4.2 2018/04/23 23:53:45 dtrivedi Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCompanyEmailCustomization <<<'

IF EXISTS (select * from sysobjects where name='AppGetCompanyEmailCustomization')
	drop procedure AppGetCompanyEmailCustomization
IF EXISTS (select * from GxQscripts where name='AppGetCompanyEmailCustomization')
	delete from GxQscripts where name = 'AppGetCompanyEmailCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyEmailCustomization')
	delete from GXDBVersions where aliasname = 'AppGetCompanyEmailCustomization'
GO
print '... Creating Procedure: AppGetCompanyEmailCustomization'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCompanyEmailCustomization
  @i_userId INT,
  @i_localeId INT,
  @i_providerId INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canSeeProvider INT=0
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
EXEC sec_canSeeOrManageNameServer  @i_userId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
IF @canSeeProvider = 1
	BEGIN
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
	SET @o_xmlText =(SELECT
							(SELECT value from GXGlobalParam where name = 'MasterEmailTemplate' and modified=0 ) as '@masterEmailTemplate'
							,(SELECT
(SELECT attrVal from App_CompanyProp where componentNameId=@ownerCompany and attrName='Header Template' and modified=0 ) AS '@headerTemplate',
(SELECT attrVal from App_CompanyProp where componentNameId=@ownerCompany and attrName='Footer Template' and modified=0 ) as '@footerTemplate'
							FOR XML PATH('companySettings'),TYPE)
							,(SELECT
										(SELECT value from GXGlobalParam where name = 'EmailTemplateHeader' and modified=0 ) AS '@headerTemplate',
										(SELECT value from GXGlobalParam where name = 'EmailTemplateFooter' and modified=0 ) as '@footerTemplate'
							FOR XML PATH('defaultSettings'),TYPE)
					FOR XML PATH('Api_GetEmailTemplateSettingsResponse'))
	END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
END
IF(@o_errCode > 0)
BEGIN
	SET @o_xmlText = (SELECT
							 (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage'
								 FOR XML PATH('error'), TYPE)
						 FOR XML PATH('Api_GetEmailTemplateSettingsResponse'), TYPE)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT
							 (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage'
								 FOR XML PATH('error'), TYPE)
						 FOR XML PATH('Api_GetEmailTemplateSettingsResponse'), TYPE)
END CATCH
SCRIPT_EXIT:
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyEmailCustomization')
	delete from GxQscripts where name = 'AppGetCompanyEmailCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyEmailCustomization')
	delete from GXDBVersions where aliasname = 'AppGetCompanyEmailCustomization'
GO

insert into GXDBVersions values(2, 'AppGetCompanyEmailCustomization',  '00010001000400020000', 'AppGetCompanyEmailCustomization', '00010001000400020000')
GO

