

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyDefaultPlans.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyDefaultPlans.sp,v $ $Id: AppGetCompanyDefaultPlans.sp,v 1.1.2.1 2018/03/07 18:30:18 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCompanyDefaultPlans <<<'

IF EXISTS (select * from sysobjects where name='AppGetCompanyDefaultPlans')
	drop procedure AppGetCompanyDefaultPlans
IF EXISTS (select * from GxQscripts where name='AppGetCompanyDefaultPlans')
	delete from GxQscripts where name = 'AppGetCompanyDefaultPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyDefaultPlans')
	delete from GXDBVersions where aliasname = 'AppGetCompanyDefaultPlans'
GO
print '... Creating Procedure: AppGetCompanyDefaultPlans'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCompanyDefaultPlans
  @callerId INT,
  @localeId INT,
  @i_providerId INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canSeeProvider INT=0
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @xmlerrors xml
EXEC sec_canSeeOrManageNameServer  @callerId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
IF @canSeeProvider = 1
	BEGIN
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
		-- create the provider property temporary table
		IF object_id('tempdb.dbo.#OrgPropTbl') IS NOT null DROP TABLE #OrgPropTbl
		CREATE TABLE #OrgPropTbl (
									PropertyName        varchar(256),
									propertyValue          nvarchar(MAX)
								)
		INSERT INTO #OrgPropTbl
		SELECT attrName, attrVal FROM  App_CompanyProp WHERE componentNameId=@ownerCompany
AND attrName in('Default Server Plan','Default Laptop Plan','Default Snap Plan','Default DB Plan','Default File System Plan','Default Virtual Server Backup Plan', 'Default Virtual Server Replication Plan') and modified=0
	SET @o_xmlText =	(SELECT
				(SELECT ISNULL((UD.hostName), '') as '@connectName',
					(SELECT UD.id as '@id', UD.domainName as '@domainName' FOR XML PATH('shortName'),TYPE)
						FROM UMDSProviders UD with (nolock) where UD.id in (@i_providerId) FOR XML PATH('organization'),TYPE),
					(SELECT(SELECT  pp.subtype     AS '@subtype' ,
						(SELECT PP.id           AS '@planId', PP.name	     AS '@planName' 	FOR XML PATH('plan'), TYPE)
						FROM	 #OrgPropTbl t
						INNER JOIN APP_Plan PP ON pp.id=t.propertyValue
					FOR XML PATH('defaultPlans'), TYPE)
			FOR XML PATH('organizationProperties'), TYPE)
			FOR XML PATH('organizationInfo'),TYPE)
	END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
END
IF(@o_errCode > 0)
BEGIN
	SET @xmlerrors = (SELECT @o_errString as '@errorMessage', @o_errCode as '@errorCode' FOR XML PATH('error'),TYPE)
	END
SET @o_xmlText = (SELECT @o_xmlText , @xmlerrors FOR XML PATH('') , ROOT('Api_GetOrganizationPropertiesResponse'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT '' FOR XML PATH ('Api_OrganizationInfo'),TYPE)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyDefaultPlans')
	delete from GxQscripts where name = 'AppGetCompanyDefaultPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyDefaultPlans')
	delete from GXDBVersions where aliasname = 'AppGetCompanyDefaultPlans'
GO

insert into GXDBVersions values(2, 'AppGetCompanyDefaultPlans',  '00010001000200010000', 'AppGetCompanyDefaultPlans', '00010001000200010000')
GO

