

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyCustomization.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyCustomization.sp,v $ $Id: AppGetCompanyCustomization.sp,v 1.1.2.5.14.1 2021/03/05 00:45:09 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCompanyCustomization')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyCustomization <<<'
	drop procedure AppGetCompanyCustomization
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyCustomization')
	delete from GxQscripts where name = 'AppGetCompanyCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyCustomization')
	delete from GXDBVersions where aliasname = 'AppGetCompanyCustomization'
GO
print '... Creating Procedure: AppGetCompanyCustomization'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCompanyCustomization
  @callerId INT,
  @localeId INT,
  @i_providerId INT,
  @i_pushCustomization INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canSeeProvider INT=0
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @xmlerrors XML
DECLARE @OrgOwnerCompany INT = 0
EXEC sec_canSeeOrManageNameServer  @callerId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
IF @canSeeProvider = 1
	BEGIN
	DECLARE @customizationValue NVARCHAR(MAX)
	SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
	SET @OrgOwnerCompany =@ownerCompany
SET @customizationValue = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName =  'Customization'   AND modified=0)
	WHILE ((@customizationValue IS NULL) AND (@ownerCompany > 0))
    BEGIN
SET @customizationValue = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId=@ownerCompany AND attrName =  'Customization'   AND modified=0)
		SET @ownerCompany = (SELECT UD.ownerCompany FROM UMDSProviders UD WHERE UD.id=@ownerCompany)
    END
	SET @o_xmlText =(SELECT
						(SELECT ISNULL((UD.hostName), '') as '@connectName',
							(SELECT UD.id as '@id', UD.domainName as '@domainName' FOR XML PATH('shortName'),TYPE)
								FROM UMDSProviders UD with (nolock) where UD.id = @OrgOwnerCompany FOR XML PATH('organization'),TYPE),
							(SELECT @customizationValue AS '@customization' FOR XML PATH('organizationProperties'), TYPE)
					FOR XML PATH('organizationInfo'))
	IF(@i_pushCustomization = 1 AND @customizationValue is not null  AND @customizationValue <> '')
	BEGIN
		DECLARE @nowTime   integer  =   dbo.GetUnixTime (GetUTCdate())
		DECLARE @webconsoleClients  table(clientId int)
		DECLARE @newSettings TABLE
		(
			ActionType VARCHAR(50),
			keyId int
		);
		INSERT INTO @webconsoleClients
		SELECT c.id
		FROM app_client c
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
		LEFT JOIN App_VMToPMMAp vm ON vm.PMClientId=c.id WHERE VMClientId IS NULL
		UNION
		SELECT vm.VMClientId
		FROM app_client c
		INNER JOIN App_VMToPMMAp vm ON c.id=PMClientId
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
		--Add key for custom settings
		MERGE APP_AdvanceSettings AS AV
		USING
		(
			SELECT clientId,cast( @OrgOwnerCompany as nvarchar) keyName, 'STRING' type, 'WebConsole\Customization' relativePath, 1 enabled, 0 deleted, 3 entityType, @customizationValue stringVal
			FROM @webconsoleClients
		) AS CT
		ON CT.clientId = AV.entityId AND CT.keyName = AV.keyName AND CT.type = AV.type AND CT.relativePath = AV.relativePath
		WHEN MATCHED THEN
			UPDATE SET value = CT.stringVal
		WHEN NOT MATCHED THEN
			INSERT (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			VALUES (CT.clientId, CT.keyName, CT.type, CT.relativePath, CT.stringVal, CT.enabled, 0, CT.entityType, 0, 0)
		OUTPUT $action AS ActionType, Inserted.id INTO @newSettings;
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
		FROM @webconsoleClients
		--Mark the keys hidden
		INSERT INTO APP_AdvanceSettingsEx(keyId  , details, hidden)
		SELECT keyId, '',1 from @newSettings WHERE ActionType = 'INSERT';
	END
	END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
END
IF(@o_errCode > 0)
BEGIN
	SET @o_xmlText = (SELECT @o_errString as '@errorMessage', @o_errCode as '@errorCode' FOR XML PATH('error'),TYPE)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @o_xmlText = (SELECT @o_xmlText , @xmlerrors FOR XML PATH('') , ROOT('Api_GetOrganizationPropertiesResponse'))
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyCustomization')
	delete from GxQscripts where name = 'AppGetCompanyCustomization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyCustomization')
	delete from GXDBVersions where aliasname = 'AppGetCompanyCustomization'
GO

insert into GXDBVersions values(2, 'AppGetCompanyCustomization',  'v1.1.2.5.14.1', 'AppGetCompanyCustomization', 'v1.1.2.5.14.1')
GO

