

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyClients.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyClients()
--  | Description:  Allows for GET of company clients for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyClients.sp,v $ $Id: AppGetCompanyClients.sp,v 1.1.2.1 2019/11/04 05:02:29 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCompanyClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCompanyClients <<<'
	drop procedure AppGetCompanyClients
END
IF EXISTS (select * from GxQscripts where name='AppGetCompanyClients')
	delete from GxQscripts where name = 'AppGetCompanyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyClients')
	delete from GXDBVersions where aliasname = 'AppGetCompanyClients'
GO
print '... Creating Procedure: AppGetCompanyClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCompanyClients
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @callerId     		INTEGER
DECLARE @i_providerId  		INTEGER
DECLARE @localeId INT
DECLARE @canSeeProvider INT=0
DECLARE @ownerCompany INT = 0
DECLARE @companyGroup INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @level INT=10
DECLARE @isJobStartTimeEnabled INT = 0
DECLARE @jobStartTime INT = NULL
 SET @callerId = ISNULL (( SELECT ref.value('@userId', 'INT')
                     FROM @o_xmlText.nodes ('Api_GetOrganizationPropertiesRequest/processinginstructioninfo/user') R(ref)), 0)
SET @i_providerId = ISNULL (( SELECT ref.value('@organizationId', 'INT')
                     FROM @o_xmlText.nodes ('Api_GetOrganizationPropertiesRequest') R(ref)), -1)
SET @localeId = ISNULL(@o_xmlText.value('(//Api_GetOrganizationPropertiesRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
EXEC sec_canSeeOrManageNameServer  @callerId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
SET @level = ISNULL(@o_xmlText.value('(/Api_GetOrganizationPropertiesRequest/@propertyLevel)[1]', 'int'), 10)
SET @o_xmlText = ''
IF @canSeeProvider = 1 AND @i_providerId > 0
	BEGIN
		-- Populate the smart clientgroup id associated with this company
		-- If AD providerId is provided, then the below SP will get the companyId from that.
		SET @i_providerId = dbo.AppGetCompanyForProvider(@i_providerId)
		SELECT @companyGroup = CAST(C.attrVal AS INT) FROM APP_ClientGroup CG
			INNER JOIN App_CompanyProp C ON C.attrVal = CAST(CG.id AS NVARCHAR(MAX))
WHERE C.componentNameId = @i_providerId AND C.attrName = 'Associated Smart Client Group' AND C.modified = 0 AND C.cs_attrName = checksum('Associated Smart Client Group')
--
		BEGIN
			-- To get All the clients and there type for provided Organization
			IF OBJECT_ID('tempdb.dbo.#orgClients') IS NOT NULL
				DROP TABLE #orgClients
			CREATE TABLE #orgClients (clientId INT, clientType INT, name NVARCHAR(255), isVM INT DEFAULT 0)
			CREATE CLUSTERED INDEX orgClients_idx ON #orgClients(clientId, clientType)
--
			DECLARE @packages AS NVARCHAR(1024) = ''
			DECLARE @ClientType_SERVER INT = 1
			DECLARE @ClientType_DEVICE INT = 2
			DECLARE @ClientType_HYPERVISIOR INT = 3
			DECLARE @ClientType_VM INT = 4
			DECLARE @ClientType_Physical INT = 5
			DECLARE @ClientType_MISC INT = 6
			DECLARE @ClientType_VM_NOT_TO_BE_INCLUDED INT = 7
--
			INSERT INTO #orgClients (clientId)
	                SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
	                        INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrVal=CAST(ACGA.clientGroupId AS nvarchar(max)) AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@i_providerId AND ACP.modified=0 AND ACP.cs_attrName = checksum('Associated Smart Client Group')
			IF NOT EXISTS (SELECT 1 FROM #orgClients)
				GOTO SCRIPT_EXIT
			/*
			DECLARE @AppGrp35AppTypes TABLE ( appTypeId		INT PRIMARY KEY)
			INSERT INTO @AppGrp35AppTypes
				SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35,0)			-- This Criteria is added from AppGetDevices SP.
			SET @packages = '20,23,51,726,251,252,255,257'				-- These Package ID's are mapped from APPGetServerClientList SP. We have to be in sync
			-- Update Laptop Device Type
			-- Logic is taken from APPGetDevices
			UPDATE CL SET CL.name=c.name, CL.clientType=@ClientType_DEVICE FROM #orgClients AS CL
INNER JOIN APP_Client c ON c.STATUS & 0x1000 = 0x1000 AND c.id=CL.clientId
					INNER JOIN APP_IDAName ida ON ida.clientId = c.id
									AND	ida.appTypeId <> 13
									AND ida.appTypeId IN (
										SELECT appTypeId
										FROM @AppGrp35AppTypes
									)
LEFT OUTER JOIN APP_ClientProp ACP ON ACP.componentNameId=CL.clientId AND ACP.attrName='User Centric Client' AND ACP.modified=0
                        WHERE (CL.clientType IS NULL) AND (ACP.attrVal IS NULL OR ACP.attrVal=0)
			-- Update SERVER Device Type
			-- Logic is taken from APPGetServerClientList
			UPDATE CL SET CL.name=s.name, CL.clientType=@ClientType_SERVER FROM #orgClients AS CL
				INNER JOIN APP_Client s ON s.specialClientFlags = 0 AND s.id=CL.clientId
				INNER JOIN APP_Platform sap ON sap.platformType=4 AND s.id=sap.clientId
				INNER JOIN simInstalledPackages sim ON sap.clientId = sim.ClientId
						AND sim.simPackageID IN (
							SELECT _ID
							FROM SplitIDString(@packages)
							)
					WHERE CL.clientType IS NULL
			-- Update HYPERVISIOR Device Type
			-- Logic is taken from AppgetVSPPseudoClients
			UPDATE CL SET CL.name=AC.name, CL.clientType=@ClientType_HYPERVISIOR FROM #orgClients AS CL INNER JOIN APP_IDAName IDA      ON (IDA.clientId = CL.clientId)
                          INNER JOIN APP_Application APP  ON (APP.clientId = CL.clientId AND App.appTypeId = IDA.appTypeId)
                          INNER JOIN APP_InstanceProp IP  ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
						  INNER JOIN APP_InstanceName AIN ON (AIN.id = APP.instance)
						  INNER JOIN APP_Client AC  ON (AC.id = CL.clientId)
					WHERE   (IDA.appTypeId = 106)
AND((AC.status  & 0x00004)	    = 0)
AND((AIN.status & 0x00002)   = 0) -- instance should not be deconfigured or uninstalled
AND((AIN.status & 0x00004)		= 0)
AND((IDA.status & 0x00002)   = 0) -- ida should not be deconfigured or uninstalled
AND((IDA.status & 0x00004)		= 0)
							AND CL.clientType IS NULL
			-- Update VM Device Type
			-- Logic is little deviated from SP AppGetVMStatusInfoForUser - which actually return VM's on AdminConsole Page
			-- Updating logic in sync with above SP. Need to be made more generic for SP7
			-- Get List of All VM's for there last job
			-- this will be list of VM Protected or Backed up with error
			IF OBJECT_ID('tempdb.dbo.#clientListTbl') IS NOT NULL
				DROP TABLE #clientListTbl
			CREATE TABLE #clientListTbl
			(
				clientId    INT PRIMARY KEY,
				jobId       INT
			)
--
			INSERT INTO #clientListTbl
            SELECT componentNameId , CAST(attrVal AS INT) FROM APP_ClientProp WITH (NOLOCK)
            WHERE attrName='Last Backup JobID' AND modified=0
			-- Update Physical Server's Device Type
			-- This is totally new as these type of Servers/Agents are only seen on Servers/All Agents Page
			UPDATE CL SET CL.name=AC.name, CL.clientType=@ClientType_Physical FROM #orgClients AS CL
			INNER JOIN APP_Client AC
				ON AC.id=CL.clientId AND AC.specialClientFlags & 2 = 0
				WHERE CL.clientType IS NULL
			-- Protected OR Backed UP with Error vms
			UPDATE CL SET CL.clientType=@ClientType_VM FROM #orgClients AS CL
            WHERE CL.clientType IS NULL AND CL.clientID IN (SELECT  DISTINCT(clientId) FROM #clientListTbl)
			-- After this step, we anyways don't want to include any VM which is not yet identified.
			-- Lets mark them internally and not return in any count
			UPDATE CL SET CL.clientType=@ClientType_VM_NOT_TO_BE_INCLUDED FROM #orgClients AS CL
			INNER JOIN APP_ClientProp ACP
				ON ACP.componentNameId=CL.clientId AND ACP.attrName='Virtual Server Discovered Clients' AND ACP.attrVal=1 AND modified=0
				WHERE CL.clientType IS NULL
			-- Protected OR Backed UP with Error vms
			-- This is the actual count that will be reported to Companies page
			UPDATE CL SET CL.isVM=1 FROM #orgClients AS CL
            WHERE CL.clientID IN (SELECT  DISTINCT(clientId) FROM #clientListTbl)
			-- All Remaininig Device Type
			-- They might include Device with no Agents/Package installed
			UPDATE #orgClients SET clientType=@ClientType_MISC WHERE clientType IS NULL
			-- Client Details till here
			*/
		END
		SET @o_xmlText = (SELECT
							(SELECT
								(SELECT clientId AS '@clientId', name AS '@clientName' FROM #orgClients
									FOR XML PATH('clientEntity'), TYPE)
							FOR XML PATH('clients'),TYPE)
						FOR XML PATH('organizationInfo'),TYPE)
	END
ELSE IF @i_providerId > 0
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = ''
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	SET @o_xmlText = (SELECT
						(SELECT @o_errCode AS '@errorCode',
								@o_errString AS '@errorMessage'
							FOR XML PATH('error'), TYPE),
						(SELECT @o_xmlText
							FOR XML PATH('') , TYPE)
						FOR XML PATH(''), ROOT('App_GetOrganizationPropertiesResponse'))
	SELECT @o_xmlText
--
	IF OBJECT_ID('tempdb.dbo.#orgClients') IS NOT NULL
		DROP TABLE #orgClients
	IF OBJECT_ID('tempdb.dbo.#clientListTbl') IS NOT NULL
		DROP TABLE #clientListTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyClients')
	delete from GxQscripts where name = 'AppGetCompanyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyClients')
	delete from GXDBVersions where aliasname = 'AppGetCompanyClients'
GO

insert into GXDBVersions values(2, 'AppGetCompanyClients',  '00010001000200010000', 'AppGetCompanyClients', '00010001000200010000')
GO

