

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCompanyAuthToken.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCompanyAuthToken.sp,v $ $Id: AppGetCompanyAuthToken.sp,v 1.1.2.1 2018/03/07 18:32:31 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCompanyAuthToken <<<'

IF EXISTS (select * from sysobjects where name='AppGetCompanyAuthToken')
	drop procedure AppGetCompanyAuthToken
IF EXISTS (select * from GxQscripts where name='AppGetCompanyAuthToken')
	delete from GxQscripts where name = 'AppGetCompanyAuthToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyAuthToken')
	delete from GXDBVersions where aliasname = 'AppGetCompanyAuthToken'
GO
print '... Creating Procedure: AppGetCompanyAuthToken'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCompanyAuthToken
  @callerId INT,
  @localeId INT,
  @i_providerId INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @canSeeProvider INT
DECLARE @ownerCompany INT = 0
DECLARE @o_errCode integer
DECLARE @o_errString nvarchar(1024)
DECLARE @xmlerrors XML
EXEC sec_canSeeOrManageNameServer  @callerId, @i_providerId, 1, 0, 0, @canSeeProvider OUTPUT
IF @canSeeProvider = 1
	BEGIN
		SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_providerId)
		-- create the provider property temporary table
		IF object_id('tempdb.dbo.#OrgPropTbl') IS NOT null DROP TABLE #OrgPropTbl
		CREATE TABLE #OrgPropTbl (
									PropertyName        varchar(256),
									propertyValue          nvarchar(MAX)
								)
	INSERT INTO #OrgPropTbl
		SELECT attrName, attrVal FROM  App_CompanyProp WHERE componentNameId=@ownerCompany
AND attrName in('Authorization Code', 'Enable Auth Code Generation') and modified=0
	SET @o_xmlText =(SELECT
						(SELECT ISNULL((UD.hostName), '') as '@connectName',
							(SELECT UD.id as '@id', UD.domainName as '@domainName' FOR XML PATH('shortName'),TYPE)
								FROM UMDSProviders UD with (nolock) where UD.id = @ownerCompany FOR XML PATH('organization'),TYPE),
			(SELECT(SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Authorization Code' AND (SELECT propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation') = 1) AS '@authCode',
			ISNULL((SELECT	propertyValue FROM #OrgPropTbl where PropertyName='Enable Auth Code Generation'),0) AS '@enableAuthCodeGen'
									FOR XML PATH('organizationProperties'), TYPE)
					FOR XML PATH('organizationInfo'))
	END
ELSE
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
END
IF(@o_errCode > 0)
BEGIN
	SET @o_xmlText = (SELECT @o_errString as '@errorMessage', @o_errCode as '@errorCode' FOR XML PATH('error'),TYPE)
	END
SET @o_xmlText = (SELECT @o_xmlText , @xmlerrors FOR XML PATH('') , ROOT('Api_GetOrganizationPropertiesResponse'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT '' FOR XML PATH ('Api_OrganizationInfo'),TYPE)
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
select @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCompanyAuthToken')
	delete from GxQscripts where name = 'AppGetCompanyAuthToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCompanyAuthToken')
	delete from GXDBVersions where aliasname = 'AppGetCompanyAuthToken'
GO

insert into GXDBVersions values(2, 'AppGetCompanyAuthToken',  '00010001000200010000', 'AppGetCompanyAuthToken', '00010001000200010000')
GO

