

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommservEventsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCommservEventsXML.sp,v $ $Id: AppGetCommservEventsXML.sp,v 1.2.200.7 2020/03/17 20:34:02 vmishra Exp $";
--	+===================================================================+
--	| AppGetCommservEventsXML - Get Comserv Events							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCommservEventsXML')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCommservEventsXML <<<'
	drop procedure AppGetCommservEventsXML
END
IF EXISTS (select * from GxQscripts where name='AppGetCommservEventsXML')
	delete from GxQscripts where name = 'AppGetCommservEventsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEventsXML')
	delete from GXDBVersions where aliasname = 'AppGetCommservEventsXML'
GO
print '... Creating Procedure: AppGetCommservEventsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommservEventsXML
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xml XML ,
  @o_xml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @Default_MaxEventCount INT = 25
	DECLARE @Default_Filter VARCHAR(MAX) = 'severity = 6 or severity = 9'
	DECLARE @userId INT = 0
	DECLARE @localeId INT = 0
	DECLARE @maxEventCount INT = 25
	DECLARE @filter VARCHAR(MAX) = 'severity = 6 or severity = 9'
	DECLARE @POWER_2_32 BIGINT = POWER(CONVERT(BIGINT, 2), 32)
	DECLARE @POWER_2_17 INTEGER = POWER(2, 17)
	DECLARE @POWER_2_18 INTEGER = POWER(2, 18)
	DECLARE @POWER_2_24 INTEGER = POWER(2, 24)
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
					FROM @i_xml.nodes ('App_GetCommservEventsReq/user') R(ref)), @userId)
	SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
					FROM @i_xml.nodes ('App_GetCommservEventsReq/locale') R(ref)), 0)
	SET @maxEventCount = ISNULL (( SELECT ref.value('@maxEventCount', 'INT')
					FROM @i_xml.nodes ('App_GetCommservEventsReq') R(ref)), @Default_MaxEventCount)
	SET @filter = ISNULL (( SELECT ref.value('@filter', 'NVARCHAR(MAX)')
					FROM @i_xml.nodes ('App_GetCommservEventsReq') R(ref)), @Default_Filter)
	IF @filter = ''
		SET @filter = @Default_Filter
	-- Remove variable references from filter clause like @ and @@
	SET @filter = replace(@filter,'@','')
	SET @filter = replace(@filter,'''','''''')
	-- Check whether the user has view capability at commcell level. If so, he is unrestricted user
	declare @userHasCapability int = 0
	EXEC sec_checkPermissionOnEntity @userId, 31, @userHasCapability OUTPUT, 2018, 2
	 -- If user has view at commcell level, he can see everything
	 if @userHasCapability=1
	 begin
		set @userId=0
	 end
	DECLARE @Events TABLE
	(
		id				INTEGER,
		timeSource		INTEGER,
		severity		INTEGER,
		ack       		INTEGER,
		type      		INTEGER,
		jobId_h   		INTEGER,
		jobId_l   		INTEGER,
		messageId 		INTEGER,
		clientID  		INTEGER,
		commCellID    	INTEGER,
		userID    		INTEGER,
		subsystemID		INTEGER,
		client			VARCHAR(128),
		commCell		VARCHAR(128),
		userName		VARCHAR(128),
		subsystem		VARCHAR(128),
		msgEnglish		VARCHAR(1024),
		displayText		NVARCHAR(max)
	)
    DECLARE @eventLookupTime INT = (dbo.GetUnixTime(GETUTCDATE()) - 172800 )-- ( this is the number of seconds in last 2 days )
	DECLARE @SQLQuery NVARCHAR(MAX)
	IF (@filter = @Default_Filter AND @maxEventCount = @Default_MaxEventCount)
	BEGIN
		INSERT INTO @Events
		(
			id,
			timeSource,
			severity,
			ack,
			type,
			jobId_h,
			jobId_l,
			messageId,
			clientID,
			commCellID,
			userID,
			subsystemID,
			client,
			commCell,
			userName,
			subsystem,
			msgEnglish
		)
		SELECT id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, clientID, commCellID, userID,
		    subsystemID, Client, CommCell, userName, subsystem, msgEnglish FROM
		    (SELECT TOP 25 id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, clientID, commCellID, userID,
		    subsystemID, Client, CommCell, userName, subsystem, msgEnglish
		    FROM evMsg
		    WHERE ((severity = 6 or severity = 9) and timeSource > @eventLookupTime and type <> 2 and (dbo.isClientVisibleEvents(@userId, jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0))
		    ORDER BY timeSource DESC, id DESC) A
		ORDER BY id DESC
	END
	ELSE
	BEGIN
		SET @SQLQuery =
		' SELECT id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, clientID, commCellID, userID,
		    subsystemID, Client, CommCell, userName, subsystem, msgEnglish FROM
			(SELECT TOP ' + CAST(@maxEventCount AS NVARCHAR(10)) +' id, timeSource, severity, ack, type, jobId_h, jobId_l, messageId, clientID, commCellID, userID,
			subsystemID, Client, CommCell, userName, subsystem, msgEnglish'
			+ ' FROM evMsg
			WHERE ( (' + @filter + ') and timeSource > '+ CAST(@eventLookupTime AS NVARCHAR(20)) +' and type <> 2 and (dbo.isClientVisibleEvents(' + CAST(@userId AS NVARCHAR(20)) + ', jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0))
			ORDER BY timeSource DESC) A
		ORDER BY id DESC'
		INSERT INTO @Events
		(
			id,
			timeSource,
			severity,
			ack,
			type,
			jobId_h,
			jobId_l,
			messageId,
			clientID,
			commCellID,
			userID,
			subsystemID,
			client,
			commCell,
			userName,
			subsystem,
			msgEnglish
		)
		EXECUTE sp_executesql @SQLQuery
	END
	DECLARE @useMsgCache INT = 1
	IF(@useMsgCache = 0)
		UPDATE @Events SET displayText = DBO.fn_EvFormatEventMsgText(id, @localeId, messageId, 1, commCell)
	ELSE
	BEGIN
		DECLARE @id INT
		DECLARE @messageId INT
		DECLARE @commCellID INT
		DECLARE @text nVARCHAR(4000)
		DECLARE @MsgText TABLE
		(
			r_MsgId    INTEGER,
			r_MsgTxt   nVARCHAR(4000)
		)
		DECLARE Events_Cursor CURSOR FOR
		SELECT id, commCellID FROM @Events
		FOR UPDATE OF displayText
		OPEN Events_Cursor;
		FETCH NEXT FROM Events_Cursor INTO @id, @commCellID;
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO @MsgText
				EXEC EvGetEventMsgText @id, @localeId, @commCellID
			SET @text = (SELECT TOP 1 r_MsgTxt FROM @MsgText)
			UPDATE @Events SET displayText = @text
			WHERE CURRENT OF Events_Cursor
			--WHERE id = @id;
			DELETE FROM @MsgText
		FETCH NEXT FROM Events_Cursor INTO @id, @commCellID;
		END
		CLOSE Events_Cursor;
		DEALLOCATE Events_Cursor;
	END
	SET @o_xml =
		(	SELECT E.severity as '@severity', E.id as '@id'
			, case when E.jobId_h>0 OR E.jobId_l>0 then (@POWER_2_32 * E.jobId_h + E.jobId_l) else NULL end as '@jobId'
			, E.timeSource as '@timeSource', E.subsystem '@subsystem', E.type as'@type', E.ack as '@acknowledge'
			, E.messageId as '@eventCode'
			, CONVERT(NVARCHAR(128),(CASE WHEN (E.messageId & @POWER_2_17) <> 0 THEN	(E.messageId / (@POWER_2_18) & 0xFFFF)
									ELSE (E.messageId / (@POWER_2_24) & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(E.messageId & 0x7FFF)) '@eventCodeString'
			, E.displayText as '@description'
			, (SELECT E.clientID as '@clientId', E.client as '@clientName' for XML PATH ('clientEntity'), TYPE)
			FROM @Events E
			FOR XML PATH ('commservEvents')
			, ROOT ('App_GetCommservEventsResp')
		)
	-- Incase xml is emtpy, then assign emtpy response.
	if @o_xml is null
	begin
		set @o_xml = '<App_GetCommservEventsResp/>'
	end
	SELECT @o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommservEventsXML')
	delete from GxQscripts where name = 'AppGetCommservEventsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEventsXML')
	delete from GXDBVersions where aliasname = 'AppGetCommservEventsXML'
GO

insert into GXDBVersions values(2, 'AppGetCommservEventsXML',  '00010002020000070000', 'AppGetCommservEventsXML', '00010002020000070000')
GO

