

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommservEventsV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCommservEventsV2.sp,v $ $Id: AppGetCommservEventsV2.sp,v 1.1.2.1 2020/08/07 10:59:08 jswaminathan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCommservEventsV2')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCommservEventsV2 <<<'
	drop procedure AppGetCommservEventsV2
END
IF EXISTS (select * from GxQscripts where name='AppGetCommservEventsV2')
	delete from GxQscripts where name = 'AppGetCommservEventsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEventsV2')
	delete from GXDBVersions where aliasname = 'AppGetCommservEventsV2'
GO
print '... Creating Procedure: AppGetCommservEventsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommservEventsV2
  @userId INT,
  @localeId INT,
  @clientId INT,	
  @fromTime BIGINT,
  @toTime BIGINT,
  @showInfo INT = 0,
  @showMinor INT = 0,
  @showMajor INT = 1,
  @showCritical INT = 1,
  @pageNo INT = -1,
  @pageSize INT = -1,
  @showGuiAuditEvents INT = 0,
  @orderByClause NVARCHAR(128) = '',
  @jobId INT = 0,
  @showAnomalous INT = 0
AS
  DECLARE @id INT
  DECLARE @messageId INT
  DECLARE @outClientId INT
  DECLARE @clientName NVARCHAR(510)
  DECLARE @displayName NVARCHAR(1024)
  DECLARE @severity INT
  DECLARE @outJobId BIGINT
  DECLARE @eventTime DATETIME
  DECLARE @subsystem NVARCHAR(128)
  DECLARE @type INT
  DECLARE @acknowledge INT
  DECLARE @description NVARCHAR(1024)
  DECLARE @eventCodeString NVARCHAR(128)
  DECLARE @anomaly INT
  DECLARE @occurance INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @rowNo AS INT = 0
IF OBJECT_ID('tempdb.dbo.#CommServEvents_tmp__events') IS NOT NULL DROP TABLE #CommServEvents_tmp__events
IF OBJECT_ID('tempdb.dbo.#CommServEvents_Visible__events') IS NOT NULL DROP TABLE #CommServEvents_Visible__events
IF OBJECT_ID('tempdb.dbo.#CommServEvents_getUserObjects') IS NOT NULL DROP TABLE #CommServEvents_getUserObjects
 -- Check whether the user has view capability at commcell level. If so, he is unrestricted user
declare @userHasCapability int = 0
EXEC sec_checkPermissionOnEntity @userId, 31, @userHasCapability OUTPUT, 1, 2
 -- If user has view at commcell level, he can see everything
 if @userHasCapability=1
 begin
	set @userId=0
 end
CREATE TABLE #CommServEvents_tmp__events
(
    rowNo			INTEGER IDENTITY (1,1),
    id              INTEGER,
    commCell        INTEGER,
    messageId       INTEGER,
    clientId        INTEGER,
    clientName      NVARCHAR(510),
    severity        INTEGER,
    jobId           BIGINT,
    eventTime       INTEGER,
    subsystem       NVARCHAR(128),
    [type]          INTEGER,
    acknowledge     INTEGER,
	anomaly			INTEGER,
	occurance		INTEGER,
	displayName     NVARCHAR(1024),
    PRIMARY KEY(rowNo)
)
CREATE TABLE #CommServEvents_Visible__events
(
	id INTEGER PRIMARY KEY		-- evMsgId
)
create table  #CommServEvents_getUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
CREATE CLUSTERED INDEX CommServEvents_getUserObjects_Idx1 ON #CommServEvents_getUserObjects (clientId);;
-- Security SPs and temp table
IF @userID <> 0
BEGIN
	-- Calling get user objects with nodeType = 0 gets all the entities that this user has rights on - like clients (expanded from CG), storage policies, WF, libraries.
	-- These are the entities that we need for Security computation.
	EXEC sec_getUserObjects @userId, 0, 0, '#CommServEvents_getUserObjects'
	DECLARE @capsOnCommcell BIGINT = 0
DECLARE @backupCap BIGINT = POWER(2,16-1) | POWER(2,12-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,13-1) | POWER(2,15-1) | POWER(2,31-1)
DECLARE @restoreCap BIGINT = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
DECLARE @adminCap BIGINT = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,31-1)
DECLARE @adminCapLibraryOp BIGINT = @adminCap | POWER(2,8-1)
	DECLARE @userHasCSBackup INT = 0
	DECLARE @userHasCSRestore INT = 0
	DECLARE @userHasCSAdmin INT = 0
	DECLARE @userName NVARCHAR(MAX) = (SELECT login FROM UMusers WHERE  id = @userId)
	SELECT @capsOnCommcell = ISNULL(capabilities,0)
	FROM #CommServEvents_getUserObjects Sec
	WHERE
Sec.commCellId=2 AND Sec.clientGroupId=0 AND Sec.clientId=0 AND Sec.appTypeId=0 AND Sec.instanceId=0 AND Sec.backupsetId=0 AND Sec.subClientId=0 AND Sec.mediaAgentId=0 AND Sec.libraryId=0 AND Sec.archGroupId=0 AND Sec.vtContainerId=0 AND Sec.vtPolicyId=0 AND Sec.vtShelfId=0 AND Sec.reviewSetId=0 AND Sec.querySetId=0 AND Sec.downloadSetId=0 AND Sec.ermId=0 AND Sec.legalHoldId=0 AND Sec.tagId=0 AND Sec.cdPolicyId=0 AND Sec.complianceReportId=0 AND Sec.taskId=0 AND Sec.workflowId=0 AND Sec.logMonitoringPolicyId=0 AND Sec.arrayId=0 AND Sec.cloudId=0 AND Sec.userGroupId=0 AND Sec.providerId=0 AND Sec.entityId1=0 AND Sec.entityId2=0 AND Sec.entityId3=0 AND Sec.entityId4=0 AND Sec.entityId5=0									AND Sec.entityId6=0 AND Sec.entityId7=0 AND Sec.entityId8=0 AND Sec.entityId9=0
	IF @capsOnCommcell > 0
	BEGIN
		SET @userHasCSBackup = @capsOnCommcell & @backupCap
		SET @userHasCSRestore = @capsOnCommcell & @restoreCap
		SET @userHasCSAdmin = @capsOnCommcell & @adminCap
	END
	-- Getting list of Subclients separately, as Backup Stats table has only Subclient Id and not the hierarchy.
--EXEC sec_getIdaObjectsForUser @userId, 7, 0, 0, '#CommServEvents_getIdaObjects', 0, '12, 13, 15, 16, 20, 22, 31'
END
-- if all severity levels flags are disabled then there is nothing to show.
IF @showInfo = 1 OR @showMinor = 1 OR @showMajor = 1 OR @showCritical = 1
BEGIN
    IF @pageNo < 0 OR @pageSize < 0
	BEGIN
        SET @pageNo = 0
        SET @pageSize = (SELECT COUNT(*) FROM evMsg)
    END
	DECLARE @POWER_2_32 BIGINT = POWER(CONVERT(BIGINT, 2), 32)
	DECLARE @POWER_2_17 INTEGER = POWER(2, 17)
	DECLARE @POWER_2_18 INTEGER = POWER(2, 18)
	DECLARE @POWER_2_24 INTEGER = POWER(2, 24)
	IF (@userId = 0)
	BEGIN
		-- build basic sql statment
		-- Here the below query should use index evMsg_timeSource_type_severity_commCellID_id_idx since it includes all columns from this select. So any change in select below
		-- mite need change to index evMsg_timeSource_type_severity_commCellID_id_idx
		IF @showAnomalous = 0
		BEGIN
		-- build basic sql statment
		-- Here the below query should use index evMsg_timeSource_type_severity_commCellID_id_idx since it includes all columns from this select. So any change in select below
		-- mite need change to index evMsg_timeSource_type_severity_commCellID_id_idx
		INSERT  INTO #CommServEvents_tmp__events(id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, displayName)
			SELECT  TOP ((@pageNo+1) * @pageSize) evMsg.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, ISNULL(client.displayName,'')
			FROM    evMsg WITH (READUNCOMMITTED)
			LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON evMsg.clientId = client.id
			WHERE       (timeSource BETWEEN @fromTime AND @toTime )
					AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
					AND (@showGuiAuditEvents = 1 OR [type] <> 2)
					AND (@clientId < 2 OR clientId = @clientId)
					AND (@jobId = 0 OR ((@POWER_2_32 * jobId_h + jobId_l) = @jobId))
					ORDER BY timeSource DESC
		END
		ELSE
		BEGIN
		INSERT  INTO #CommServEvents_tmp__events(id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, anomaly, occurance, displayName)
			SELECT  TOP ((@pageNo+1) * @pageSize) Ev.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, anomalous, ANOM.occurance, ISNULL(client.displayName,'')
			FROM EvMsg Ev INNER JOIN
			(
				SELECT  MAX(id) AS eventId, count(1) AS occurance  FROM evMsg WITH (READUNCOMMITTED)
				 WHERE       (timeSource BETWEEN @fromTime AND @toTime )
					AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
					AND (@showGuiAuditEvents = 1 OR [type] <> 2)
					AND (@clientId < 2 OR clientId = @clientId)
					AND (@jobId = 0 OR ((@POWER_2_32 * jobId_h + jobId_l) = @jobId))
					AND  anomalous > 0
					GROUP BY messageId,clientId
					) ANOM ON Anom.eventId = Ev.id
			LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON Ev.clientId = client.id
			ORDER BY timeSource DESC
		END
	END
	ELSE
	BEGIN
			-- First get the event Ids that this user can see and satisyfing all the input criterion.
			INSERT  INTO #CommServEvents_Visible__events(id)
				-- 1. Events mathching with same user Id.
				-- 2a. Non job based events --> if user has any cap on Commcell.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
						AND ((E.userId = @userId) OR (@capsOnCommcell <> 0 AND jobId_l = 0 AND jobId_h = 0))
				UNION
				 -- 2b. Non-job based events --> on entities on which user has rights.
				SELECT   E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((E.clientId = 0 AND Sec.clientId = 2 AND Sec.appTypeId = 0) OR (E.clientId <> 0 AND E.clientId = Sec.clientId AND Sec.appTypeId = 0) OR (E.maClientId <> 0 AND E.maClientId = Sec.clientId AND Sec.appTypeId = 0) OR (E.maClientId <> 0 AND E.maClientId = Sec.mediaAgentId) OR (E.libraryId <> 0 AND E.libraryId = Sec.libraryId))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
						AND (jobId_l = 0 AND jobId_h = 0)
				UNION
				-- 3. Running backups.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN RunningBackups BkpInfo
						ON (BkpInfo.jobId = jobId_l) AND (BkpInfo.commcellId = 2)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSBackup <> 0)
							OR	(BkpInfo.userId = @userId)
							OR	(
									(capabilities & @backupCap <> 0)
									AND (BkpInfo.clientId = Sec.clientId)
									AND (BkpInfo.appTypeId = Sec.appTypeId OR Sec.appTypeId = 0)
									AND (BkpInfo.instance = Sec.instanceId OR Sec.instanceId = 0)
									AND (BkpInfo.backupset = Sec.backupsetId OR Sec.backupsetId = 0)
									AND (BkpInfo.applicationId = Sec.subclientId OR Sec.subclientId = 0)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
				UNION
				-- 4. Running Restores.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN RunningRestores RstInfo
						ON (RstInfo.jobId = jobId_l) AND (RstInfo.commcellId = 2)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSRestore <> 0)
							OR	(RstInfo.userId = @userId)
							OR	(
									(capabilities & @restoreCap <> 0)
									AND (RstInfo.srcClientId = Sec.clientId OR ((RstInfo.destClientId = Sec.clientId) AND (Sec.appTypeId <> 78)))
									AND (RstInfo.appType = Sec.appTypeId OR Sec.appTypeId = 0)
									AND (RstInfo.instanceId = Sec.instanceId OR Sec.instanceId = 0)
									AND (RstInfo.bkpSetID = Sec.backupsetId OR Sec.backupsetId = 0)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
				UNION
				-- 5. Running Admins.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN RunningAdminJobs AdminInfo
						ON (AdminInfo.jobId = jobId_l) AND (AdminInfo.commcellId = 2)
					INNER JOIN JMAdminJobInfoTable JMAdminJobInfo
						ON (JMAdminJobInfo.jobId = jobId_l) AND (JMAdminJobInfo.commcellId = 2)
					LEFT OUTER JOIN JMJobOptions JobOptions
						ON (AdminInfo.jobId = JobOptions.jobId AND JobOptions.commCellId = 2 AND JobOptions.attributeId = 10)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSAdmin <> 0)
							OR	(AdminInfo.userId = @userId)
							OR	(
									(capabilities & @adminCap <> 0)
									AND
										(
											(AdminInfo.opType = 90 AND JMAdminJobInfo.workFlowId <> 0 AND JMAdminJobInfo.workFlowId = Sec.workflowId)
											OR (AdminInfo.archGrpID <> 0 AND Sec.archGroupId = AdminInfo.archGrpId)
										)
								)
							OR	(
									(capabilities & @adminCapLibraryOp <> 0)
									AND (AdminInfo.opType IN (21,32,41,42,46,47) AND JobOptions.attributeValueInt IS NOT NULL AND JobOptions.attributeValueInt > 0 AND JobOptions.attributeValueInt = sec.libraryId)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
				UNION
				-- 6. Backup stats.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN JMBkpStats BkpStats
						ON (BkpStats.jobId = jobId_l) AND (BkpStats.commcellId = 2)
					INNER JOIN APP_Application A
						ON BkpStats.appId = A.id
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSBackup <> 0)
							OR	(BkpStats.userName = @userName)
							OR	(
									(capabilities & @backupCap <> 0)
									AND (A.clientId = Sec.clientId)
									AND (A.appTypeId = Sec.appTypeId OR Sec.appTypeId = 0)
									AND (A.instance = Sec.instanceId OR Sec.instanceId = 0)
									AND (A.backupset = Sec.backupsetId OR Sec.backupsetId = 0)
									AND (A.id = Sec.subclientId OR Sec.subclientId = 0)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
				UNION
				-- 7. Restore Stats.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN JMRestoreStats RstStats
						ON (RstStats.jobId = jobId_l) AND (RstStats.commcellId = 2)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSRestore <> 0)
							OR	(RstStats.userName = @userName)
							OR	(
									(capabilities & @restoreCap <> 0)
									AND (RstStats.srcClientId = Sec.clientId OR ((RstStats.destClientId = Sec.clientId) AND (Sec.appTypeId <> 78)))
									AND (RstStats.appType = Sec.appTypeId OR Sec.appTypeId = 0)
									AND (RstStats.instanceId = Sec.instanceId OR Sec.instanceId = 0)
									AND (RstStats.bkpSetID = Sec.backupsetId OR Sec.backupsetId = 0)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
				UNION
				-- 8. Admin Stats.
				SELECT  E.id
				FROM    evMsg E WITH (READUNCOMMITTED)
					INNER JOIN JMAdminJobStatsTable AdminStats
						ON (AdminStats.jobId = jobId_l) AND (AdminStats.commcellId = 2)
					LEFT OUTER JOIN JMJobOptions JobOptions
						ON (AdminStats.jobId = JobOptions.jobId AND JobOptions.commCellId = 2 AND JobOptions.attributeId = 10)
					INNER JOIN #CommServEvents_getUserObjects Sec
						ON ((@userHasCSAdmin <> 0)
							OR	(AdminStats.userName = @userName)
							OR	(
									(capabilities & @adminCap <> 0)
									AND
										(
											(AdminStats.opType = 90 AND AdminStats.workFlowId <> 0 AND AdminStats.workFlowId = Sec.workflowId)
											OR (AdminStats.archGrpID <> 0 AND Sec.archGroupId = AdminStats.archGrpId)
										)
								)
							OR	(
									(capabilities & @adminCapLibraryOp <> 0)
									AND (AdminStats.opType IN (21,32,41,42,46,47) AND JobOptions.attributeValueInt IS NOT NULL AND JobOptions.attributeValueInt > 0 AND JobOptions.attributeValueInt = sec.libraryId)
								))
				WHERE       (timeSource BETWEEN @fromTime AND @toTime )
						AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
						AND (@showGuiAuditEvents = 1 OR [type] <> 2)
						AND (@clientId < 2 OR E.clientId = @clientId)
						AND (@jobId = 0 OR (@POWER_2_32 * jobId_h + jobId_l) = @jobId)
						AND (@showAnomalous = 0 OR E.anomalous > 0)
		-- build basic sql statment
		-- Here the below query should use index evMsg_timeSource_type_severity_commCellID_id_idx since it includes all columns from this select. So any change in select below
		-- mite need change to index evMsg_timeSource_type_severity_commCellID_id_idx
		IF (@showAnomalous = 0)
		BEGIN
				INSERT INTO #CommServEvents_tmp__events (id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, displayName)
					SELECT  TOP ((@pageNo+1) * @pageSize) E.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, ISNULL(client.displayName,'')
					FROM EvMsg E
						INNER JOIN #CommServEvents_Visible__events Sec
							ON E.id = Sec.id
						LEFT OUTER JOIN APP_Client client
							ON E.clientId = Client.id
					ORDER BY E.timeSource DESC
		END
		ELSE
		BEGIN
			INSERT  INTO #CommServEvents_tmp__events(id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, anomaly, occurance, displayName)
				SELECT  TOP ((@pageNo+1) * @pageSize) E.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, anomalous, ANOM.occurance, ISNULL(client.displayName,'')
				FROM EvMsg E
					INNER JOIN
						(
							SELECT  MAX(E.id) AS eventId, count(1) AS occurance
							FROM EvMsg E
								INNER JOIN #CommServEvents_Visible__events Sec
									ON E.id = Sec.id		-- already filtered for anomaly
							GROUP BY messageId, clientId
						) ANOM
							ON Anom.eventId = E.id
					LEFT OUTER JOIN APP_Client client
							ON E.clientId = Client.id
				ORDER BY E.timeSource DESC
		END
	END
    -- remove from temporary table everything except requested page
	DELETE  FROM #CommServEvents_tmp__events
    WHERE   rowNo <= @pageNo * @pageSize
END
SELECT  T.id, T.messageId, T.clientId, T.clientName, ISNULL(T.displayName,'') AS displayName, T.severity,
        CASE T.jobId WHEN 0 THEN null ELSE T.jobId END AS jobId,
        dbo.GetDateTime(T.eventTime) AS eventTime, T.subsystem, T.type, T.acknowledge,
		dbo.fn_EvFormatEventMsgText(T.id, @localeId, messageId, 1, commCell) as description,
		CONVERT(NVARCHAR(128),(CASE WHEN (T.messageId & @POWER_2_17) <> 0 THEN	(T.messageId / (@POWER_2_18) & 0xFFFF)
									ELSE (T.messageId / (@POWER_2_24) & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(T.messageId & 0x7FFF)) as eventCodeString, anomaly, occurance
FROM    #CommServEvents_tmp__events T
Order by T.EventTime desc,T.Id desc
IF OBJECT_ID('tempdb.dbo.#CommServEvents_tmp__events') IS NOT NULL DROP TABLE #CommServEvents_tmp__events
IF OBJECT_ID('tempdb.dbo.#CommServEvents_Visible__events') IS NOT NULL DROP TABLE #CommServEvents_Visible__events
IF OBJECT_ID('tempdb.dbo.#CommServEvents_getUserObjects') IS NOT NULL DROP TABLE #CommServEvents_getUserObjects
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommservEventsV2')
	delete from GxQscripts where name = 'AppGetCommservEventsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEventsV2')
	delete from GXDBVersions where aliasname = 'AppGetCommservEventsV2'
GO

insert into GXDBVersions values(2, 'AppGetCommservEventsV2',  '00010001000200010000', 'AppGetCommservEventsV2', '00010001000200010000')
GO

