

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommservEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCommservEvents.sp,v $ $Id: AppGetCommservEvents.sp,v 1.2.64.11 2020/08/07 10:59:14 jswaminathan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCommservEvents')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCommservEvents <<<'
	drop procedure AppGetCommservEvents
END
IF EXISTS (select * from GxQscripts where name='AppGetCommservEvents')
	delete from GxQscripts where name = 'AppGetCommservEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEvents')
	delete from GXDBVersions where aliasname = 'AppGetCommservEvents'
GO
print '... Creating Procedure: AppGetCommservEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommservEvents
  @userId INT,
  @localeId INT,
  @clientId INT,	
  @fromTime BIGINT,
  @toTime BIGINT,
  @showInfo INT = 0,
  @showMinor INT = 0,
  @showMajor INT = 1,
  @showCritical INT = 1,
  @pageNo INT = -1,
  @pageSize INT = -1,
  @showGuiAuditEvents INT = 0,
  @orderByClause NVARCHAR(128) = '',
  @jobId INT = 0,
  @showAnomalous INT = 0
AS
  DECLARE @id INT
  DECLARE @messageId INT
  DECLARE @outClientId INT
  DECLARE @clientName NVARCHAR(510)
  DECLARE @displayName NVARCHAR(1024)
  DECLARE @severity INT
  DECLARE @outJobId BIGINT
  DECLARE @eventTime DATETIME
  DECLARE @subsystem NVARCHAR(128)
  DECLARE @type INT
  DECLARE @acknowledge INT
  DECLARE @description NVARCHAR(1024)
  DECLARE @eventCodeString NVARCHAR(128)
  DECLARE @anomaly INT
  DECLARE @occurance INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @optimizeEventViewer INT = 1
SELECT @optimizeEventViewer = CAST(value AS INT) FROM GXGlobalParam WHERE name = 'OptimizeEventViewerLoading' AND modified = 0
IF @optimizeEventViewer IS NULL
	SET @optimizeEventViewer = 1
IF @optimizeEventViewer = 1
BEGIN
	EXEC AppGetCommservEventsV2 @userId, @localeId, @clientId, @fromTime, @toTime, @showInfo, @showMinor, @showMajor, @showCritical, @pageNo, @pageSize, @showGuiAuditEvents, @orderByClause, @jobId, @showAnomalous
	RETURN
END
DECLARE @rowNo AS INT = 0
IF OBJECT_ID('tempdb.dbo.#CommServEvents_tmp__events') IS NOT null DROP TABLE #CommServEvents_tmp__events
 -- Check whether the user has view capability at commcell level. If so, he is unrestricted user
declare @userHasCapability int = 0
EXEC sec_checkPermissionOnEntity @userId, 31, @userHasCapability OUTPUT, 2018, 2
 -- If user has view at commcell level, he can see everything
 if @userHasCapability=1
 begin
	set @userId=0
 end
CREATE TABLE #CommServEvents_tmp__events
(
    rowNo			INTEGER IDENTITY (1,1),
    id              INTEGER,
    commCell        INTEGER,
    messageId       INTEGER,
    clientId        INTEGER,
    clientName      NVARCHAR(510),
    severity        INTEGER,
    jobId           BIGINT,
    eventTime       INTEGER,
    subsystem       NVARCHAR(128),
    [type]          INTEGER,
    acknowledge     INTEGER,
	anomaly			INTEGER,
	occurance		INTEGER,
	displayName     NVARCHAR(1024),
    PRIMARY KEY(rowNo)
)
-- if all severity levels flags are disabled then there is nothing to show.
IF @showInfo = 1 OR @showMinor = 1 OR @showMajor = 1 OR @showCritical = 1 BEGIN
    IF @pageNo < 0 OR @pageSize < 0 BEGIN
        SET @pageNo = 0
        SET @pageSize = (SELECT COUNT(*) FROM evMsg)
    END
	DECLARE @POWER_2_32 BIGINT = POWER(CONVERT(BIGINT, 2), 32)
	DECLARE @POWER_2_17 INTEGER = POWER(2, 17)
	DECLARE @POWER_2_18 INTEGER = POWER(2, 18)
	DECLARE @POWER_2_24 INTEGER = POWER(2, 24)
    -- build basic sql statment
	-- Here the below query should use index evMsg_timeSource_type_severity_commCellID_id_idx since it includes all columns from this select. So any change in select below
	-- mite need change to index evMsg_timeSource_type_severity_commCellID_id_idx
    IF @showAnomalous = 0
	BEGIN
    -- build basic sql statment
	-- Here the below query should use index evMsg_timeSource_type_severity_commCellID_id_idx since it includes all columns from this select. So any change in select below
	-- mite need change to index evMsg_timeSource_type_severity_commCellID_id_idx
    INSERT  INTO #CommServEvents_tmp__events(id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, displayName)
        SELECT  TOP ((@pageNo+1) * @pageSize) evMsg.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, ISNULL(client.displayName,'')
        FROM    evMsg WITH (READUNCOMMITTED)
		LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON evMsg.clientId = client.id
        WHERE       (timeSource BETWEEN @fromTime AND @toTime )
                AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
				AND (@showGuiAuditEvents = 1 OR [type] <> 2)
				AND (@clientId < 2 OR clientId = @clientId)
				AND (@jobId = 0 OR ((@POWER_2_32 * jobId_h + jobId_l) = @jobId))
				AND (dbo.isClientVisibleEvents(@userId, jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
				ORDER BY timeSource DESC
	END
	ELSE
	BEGIN
	INSERT  INTO #CommServEvents_tmp__events(id, commCell, messageId, clientId, clientName, severity, jobId, eventTime, subsystem, [type], acknowledge, anomaly, occurance, displayName)
        SELECT  TOP ((@pageNo+1) * @pageSize) Ev.id, commCellID, messageId, clientID, client, severity, (@POWER_2_32 * jobId_h + jobId_l), timeSource, subsystem, [type], ack, anomalous, ANOM.occurance, ISNULL(client.displayName,'')
        FROM EvMsg Ev INNER JOIN
		(
			SELECT  MAX(id) AS eventId, count(1) AS occurance  FROM evMsg WITH (READUNCOMMITTED)
			 WHERE       (timeSource BETWEEN @fromTime AND @toTime )
                AND ((@showInfo = 1 AND severity = 0) OR (@showMinor = 1 AND severity = 3) OR (@showMajor = 1 AND severity = 6) OR (@showCritical = 1 AND severity = 9))
				AND (@showGuiAuditEvents = 1 OR [type] <> 2)
				AND (@clientId < 2 OR clientId = @clientId)
				AND (@jobId = 0 OR ((@POWER_2_32 * jobId_h + jobId_l) = @jobId))
				AND  anomalous > 0
				AND (dbo.isClientVisibleEvents(@userId, jobId_l, commCellID, clientID, userID, libraryId, maClientId, mediaId, driveId) > 0)
				GROUP BY messageId,clientId
				) ANOM ON Anom.eventId = Ev.id
		LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON Ev.clientId = client.id
		ORDER BY timeSource DESC
	END
    -- remove from temporary table everything except requested page
	DELETE  FROM #CommServEvents_tmp__events
    WHERE   rowNo <= @pageNo * @pageSize
END
SELECT  T.id, T.messageId, T.clientId, T.clientName, ISNULL(T.displayName,'') AS displayName, T.severity,
        CASE T.jobId WHEN 0 THEN null ELSE T.jobId END AS jobId,
        dbo.GetDateTime(T.eventTime) AS eventTime, T.subsystem, T.type, T.acknowledge,
		dbo.fn_EvFormatEventMsgText(T.id, @localeId, messageId, 1, commCell) as description,
		CONVERT(NVARCHAR(128),(CASE WHEN (T.messageId & @POWER_2_17) <> 0 THEN	(T.messageId / (@POWER_2_18) & 0xFFFF)
									ELSE (T.messageId / (@POWER_2_24) & 0xFF) END)) + ':' + CONVERT(NVARCHAR(MAX),(T.messageId & 0x7FFF)) as eventCodeString, anomaly, occurance
FROM    #CommServEvents_tmp__events T
Order by T.EventTime desc,T.Id desc
IF OBJECT_ID('tempdb.dbo.#CommServEvents_tmp__events') IS NOT null DROP TABLE #CommServEvents_tmp__events
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommservEvents')
	delete from GxQscripts where name = 'AppGetCommservEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommservEvents')
	delete from GXDBVersions where aliasname = 'AppGetCommservEvents'
GO

insert into GXDBVersions values(2, 'AppGetCommservEvents',  '00010002006400110000', 'AppGetCommservEvents', '00010002006400110000')
GO

