

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommcellNotifications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCommcellNotifications.sp,v $ $Id: AppGetCommcellNotifications.sp,v 1.1.2.3 2018/09/16 03:29:01 vdevassy Exp $";
-- =============================================================
-- Author:		Rohit Iyer
-- Create date: 03/14/2018
-- Description:	Get commcell push notifications
-- =============================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCommcellNotifications <<<'

IF EXISTS (select * from sysobjects where name='AppGetCommcellNotifications')
	drop procedure AppGetCommcellNotifications
IF EXISTS (select * from GxQscripts where name='AppGetCommcellNotifications')
	delete from GxQscripts where name = 'AppGetCommcellNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommcellNotifications')
	delete from GXDBVersions where aliasname = 'AppGetCommcellNotifications'
GO
print '... Creating Procedure: AppGetCommcellNotifications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommcellNotifications
  @in_xml XML
AS
  DECLARE @outXml XML
BEGIN TRY
SET NOCOUNT ON
DECLARE @userId						      		INT
DECLARE @localeId           					INT
DECLARE @isAdminUser        					INT
DECLARE @errorCode 							INT
DECLARE @notifType 							INT
DECLARE @title 								VARCHAR(50)
DECLARE @msgStr 							VARCHAR(512)
DECLARE @errorMessage 						VARCHAR(MAX)
declare @r_errorsXml						XML
declare @r_notificationXml					XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
select  @userId 	= isnull(userRef.value('@userId', 'int'),0),
		@localeId 	= isnull(locRef.value('@localeId', 'int'),0),
		@notifType 	= isnull(ref.value('@notifType', 'int'),0)
FROM    @in_xml.nodes('App_GetCommcellNotificationReq') A ( ref )
        outer apply ref.nodes('./processinginstructioninfo/user') B ( userRef )
		outer apply ref.nodes('./processinginstructioninfo/locale') C ( locRef )
--check requesting user details
IF (NOT EXISTS(SELECT 1 FROM UMUsers WITH(nolock) WHERE id = @userId))
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	SET @errorMessage = REPLACE(@errorMessage, '^1%s', @userId)
	GOTO SEND_RESPONSE
END
--Users with Administrative capability at commcell level
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser = 0)
BEGIN
	SET @errorCode  = 1
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2034 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO SEND_RESPONSE
END
------------------------------------------------Message Status----------------------------------------------
--WAITING_ON_USER_ACK = 1
--WAITING_ON_TASK_COMPLETION = 2
--COMPLETED = 4
--ERROR = 8
if @notifType = 1 --	CRITICAL FIX
BEGIN
	SET @r_notificationXml = (select distinct entityIdentifier 	as '@entityIdentifier',
											 msgGUID			as '@notifGuid',
											 flag				as '@status'
									  from	CommcellPopupNotifications with(nolock) where msgType = @notifType and (flag & 1) > 0
									  for xml path('notification'))
	--Todo : Localize message strings
	SET @title = 'Critical Updates Available'
	SET @msgStr = 'You need to install the following critical updates on this commcell:'
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    IF @@TRANCOUNT > 0
        ROLLBACK TRANSACTION;
END CATCH
SEND_RESPONSE:
SET @r_errorsXml = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @outXml = ( select 	@title	as '@title',
						@msgStr	as '@msgStr',
						isnull(@r_errorsXml, ''),
						isnull(@r_notificationXml, '')
				for xml path('App_GetCommcellNotificationResp'))
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommcellNotifications')
	delete from GxQscripts where name = 'AppGetCommcellNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommcellNotifications')
	delete from GXDBVersions where aliasname = 'AppGetCommcellNotifications'
GO

insert into GXDBVersions values(2, 'AppGetCommcellNotifications',  '00010001000200030000', 'AppGetCommcellNotifications', '00010001000200030000')
GO

