

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommNetServerList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCommNetServerList.sp,v $ $Id: AppGetCommNetServerList.sp,v 1.3 2012/09/07 15:37:42 sgupta Exp $";
-- =============================================
-- Author:		Chandrashekar Maranna
-- Create date: 09/26/2007
-- Description:	Get the CommNet Server List
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCommNetServerList <<<'

IF EXISTS (select * from sysobjects where name='AppGetCommNetServerList')
	drop procedure AppGetCommNetServerList
IF EXISTS (select * from GxQscripts where name='AppGetCommNetServerList')
	delete from GxQscripts where name = 'AppGetCommNetServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommNetServerList')
	delete from GXDBVersions where aliasname = 'AppGetCommNetServerList'
GO
print '... Creating Procedure: AppGetCommNetServerList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommNetServerList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @commCellId integer
AS
SET NOCOUNT ON
BEGIN
DECLARE @commNetReadinessStatus int
SET @commNetReadinessStatus = 0
IF EXISTS (SELECT * FROM GxGlobalParam WHERE name = 'Re-Enable CCRCheck With CommNet')
BEGIN
	SELECT @commNetReadinessStatus = value FROM GxGlobalParam WHERE name = 'Re-Enable CCRCheck With CommNet'
END
SELECT	1								as TAG,
		NULL							as Parent,
		@commNetReadinessStatus			as [EVGui_GetCommNetServerListResp!1!enableReadinessCheck],
		NULL							as [servers!2!regId],
		NULL							as [servers!2!regStatus],
		NULL							as [servers!2!displayName],
		NULL							as [servers!2!interfaceName],
		NULL							as [servers!2!version],
		NULL							as [servers!2!isPrimaryServer],
		NULL							as [servers!2!lastCommCellUpdateTime],
		NULL							as [servers!2!lastHistoryJobUpdateTime],
		NULL							as [servers!2!lastHistoryMMUpdateTime]
UNION ALL
select 2,1, @commNetReadinessStatus,
	ID, RegStatus, QNetDisplayName, QNetInterfaceName, QNetServerVersion, IsPrimaryServer,
	dbo.GetUnixTime(LastCommCellUpdateTime),dbo.GetUnixTime(LastHistoryJobUpdateTime),dbo.GetUnixTime(LastHistoryMMUpdateTime)
	FROM QNetReg
ORDER BY [servers!2!regId]
FOR XML EXPLICIT
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommNetServerList')
	delete from GxQscripts where name = 'AppGetCommNetServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommNetServerList')
	delete from GXDBVersions where aliasname = 'AppGetCommNetServerList'
GO

insert into GXDBVersions values(2, 'AppGetCommNetServerList',  '00010003000000000000', 'AppGetCommNetServerList', '00010003000000000000')
GO

