

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCommCellProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: GetCommCellProperties
--  |
--  | Description:
--  |  To get the basic properties of CommCell
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To get CommCell Properties
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCommCellProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCommCellProperties <<<'
	drop procedure AppGetCommCellProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetCommCellProperties')
	delete from GxQscripts where name = 'AppGetCommCellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommCellProperties')
	delete from GXDBVersions where aliasname = 'AppGetCommCellProperties'
GO
print '... Creating Procedure: AppGetCommCellProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCommCellProperties
  @xmlText XML
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @commCellID INT
DECLARE @userId INT
DECLARE @outXML XML
DECLARE @description NVARCHAR(MAX)
DECLARE @hostName NVARCHAR(MAX)
DECLARE @csClientId INT
DECLARE @networkErrorRetryFlag INT
DECLARE @networkErrorRetryFreq INT
DECLARE @networkErrorRetryCount INT
DECLARE @enablePrivacy INT
DECLARE @enableSharedLaptopUsage INT
DECLARE @useUPNForEmail INT
DECLARE @enableTwoFactorAuthentication INT
DECLARE @autoClientOwnerAssignmentType INT
DECLARE @autoClientOwnerAssignmentValue NVARCHAR(MAX)
DECLARE @allowSettingPasskey INT
DECLARE @tfaInfo XML
DECLARE @localeId INT
-- PROPERTY FLAGS FLAT
DECLARE @getSecurityProperty		INT = 0
DECLARE @getActivityControlProperty INT = 0
DECLARE @getRegistryProperty		INT = 0
DECLARE @getFirewallProperty		INT = 0
DECLARE @getNetworkThrottleProperty	INT = 0
DECLARE @getVersionInfoProperty		INT = 0
DECLARE @getAdvanceFeatureProperty	INT = 0
DECLARE @getAllProperties			INT = 0
DECLARE @getGeneralProperties		INT = 0
DECLARE @getEncryptionProperties	INT = 0
-- Property XMLs
DECLARE @clientAssociationEntity XML
DECLARE @associationEntity XML
DECLARE @securityInfo XML
DECLARE @firewallConfiguration XML
DECLARE @networkThrottle XML
DECLARE @registryProperty XML
DECLARE @activityControlXML XML
DECLARE @versionInfoXML XML
DECLARE @advanceFeatureInfo XML
DECLARE @generalInfo XML
DECLARE @encryptionXML XML
	-- Populating Activity Control in Table
		    --PROPERTY FLAGS
		SET @getSecurityProperty = ISNULL((SELECT  ref.value('@security', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getActivityControlProperty = ISNULL((SELECT  ref.value('@activityControl', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getRegistryProperty = ISNULL((SELECT  ref.value('@registry', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getFirewallProperty = ISNULL((SELECT  ref.value('@firewallConfiguration', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getNetworkThrottleProperty = ISNULL((SELECT  ref.value('@networkThrottle', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getVersionInfoProperty = ISNULL((SELECT  ref.value('@versionInfo', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getAdvanceFeatureProperty = ISNULL((SELECT  ref.value('@advanceFeatureInfo', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getAllProperties = ISNULL((SELECT  ref.value('@all', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getGeneralProperties = ISNULL((SELECT  ref.value('@general', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		SET @getEncryptionProperties = ISNULL((SELECT  ref.value('@encryption', 'int') AS client  FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/propertiesFilter') R ( ref )),0)
		-- If all properties set then load only basic properties.
		IF @getAllProperties = 1
			BEGIN
				SET @getSecurityProperty = 1
				SET @getActivityControlProperty = 1
				SET @getRegistryProperty = 1
				SET @getFirewallProperty = 1
				SET @getNetworkThrottleProperty = 1
				SET @getVersionInfoProperty = 1
				SET @getAdvanceFeatureProperty = 1
				SET @getGeneralProperties = 1
				SET @getEncryptionProperties = 1
			END
		--Populating Entity Info
		SET @commCellID = ISNULL((SELECT  ref.value('@commCellId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/commCellEntity') R ( ref )),2)
		SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/processinginstructioninfo/user') R ( ref )),0)
		SET @csClientId = (SELECT clientId FROM APP_CommCell WHERE id = @commCellID)
		SET @clientAssociationEntity = (SELECT @csClientId AS '@clientId' FOR XML PATH('entity'))
		SET @associationEntity = (SELECT @commCellId AS '@commCellId' FOR XML PATH('entity'))
		SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetCommCellPropertiesReq/processinginstructioninfo/locale') R ( ref )),0)
		--Populating General Properties
		IF @getGeneralProperties = 1
		BEGIN
			SET @description = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'User Description' AND modified = 0 ),'')
			SET @networkErrorRetryFlag = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = N'NW Err Retry Flag' AND modified = 0 AND componentNameId = @csClientId), 1 )
			SET @networkErrorRetryFreq = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = N'NW Err Retry Frequency' AND modified = 0 AND componentNameId = @csClientId), 1 )
			SET @networkErrorRetryCount = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = N'NW Err Retry Count' AND modified = 0 AND componentNameId = @csClientId), 1 )
			SET @hostName = ISNULL((SELECT net_hostname FROM APP_Client WHERE id = @commCellID),'')
IF EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = '3c8d1ac5575382ed39b961906a331a2ac82766fdcfa15580a' and value = '1' and modified = 0)
			BEGIN
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = (SELECT csGUID FROM App_Commcell where id = 2) and value = '3b43937232ab5b572bf6bb373d33ca779a47427f93c82b196b881417e07eca1db3601baf45fe32f14'
                                         and modified =0)
				BEGIN
					SET @enablePrivacy = 1
				END
				ELSE
				BEGIN
					SET @enablePrivacy = 0
				END
			END
			ELSE
			BEGIN
				SET @enablePrivacy = 0
			END
			DECLARE @getTFADetailsResponse XML
			DECLARE @tmptable TABLE (response XML)
			INSERT INTO @tmptable
			EXEC AppGetTwoFactorAuthenticationDetails @userId, 0, @localeId
			SET @getTFADetailsResponse = (SELECT TOP 1 response FROM @tmptable)
			SET @tfaInfo = (SELECT  @getTFADetailsResponse.query('App_GetTwoFactorAuthenticationDetailsResponse/twoFactorAuthenticationInfo'))
			DECLARE @autoRetireDevices XML
			SET @autoRetireDevices = (SELECT
ISNULL((SELECT value FROM GxGlobalParam where name = 'Force delete devices after days' AND modified = 0),365) as '@forceDeleteDevicesAfterDays',
ISNULL((SELECT value FROM GxGlobalParam where name = 'Retire devices after days' AND modified = 0),183) as '@retireDevicesAfterDays'
									FOR XML PATH('autoRetireDevices'),TYPE)
SET @useUPNForEmail = ISNULL((SELECT CAST(value AS INTEGER) FROM GXGlobalParam WHERE name = 'Use UPN For Email' AND modified = 0),0)
SET @enableTwoFactorAuthentication = ISNULL((SELECT CAST(value AS INTEGER) FROM GXGlobalParam WHERE name = 'EnableTwoFactorAuthentication' AND modified = 0),0)
			SET @enableTwoFactorAuthentication = (CASE WHEN @enableTwoFactorAuthentication > 0 THEN 1 ELSE 0 END)
SET @enableSharedLaptopUsage = ISNULL((SELECT CAST(IIF(value=N'1',0,1) AS INTEGER) FROM GXGlobalParam WHERE name = 'Prefer Machine Centric Client' AND modified = 0),0)
SET @autoClientOwnerAssignmentType = ISNULL((SELECT CAST(value AS INTEGER) FROM GxGlobalParam WHERE name = 'ClientOwnerAssignmentType' AND modified = 0), 0)
SET @autoClientOwnerAssignmentValue = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'ClientOwnerAssignmentValue' AND modified = 0), 'Administrators,admin,')
SET @allowSettingPasskey = ISNULL((SELECT CAST(value AS INTEGER) FROM GXGlobalParam WHERE name = 'AllowSettingPasskey' AND modified = 0),0)
			SET @generalInfo = (SELECT
							@hostName AS '@hostName',
							@description AS '@description',
							flags AS '@flags',
							CASE @networkErrorRetryFlag
								WHEN 0 THEN 'false'
								ELSE 'true' END
								AS '@networkErrorRetryFlag',
							@networkErrorRetryFreq AS '@networkErrorRetryFreq',
							@networkErrorRetryCount AS '@networkErrorRetryCount',
							@enablePrivacy AS '@enablePrivacy',
							@useUPNForEmail AS '@useUPNForEmail',
							@enableSharedLaptopUsage AS '@enableSharedLaptopUsage',
							@enableTwoFactorAuthentication AS '@enableTwoFactorAuthentication',
							@autoClientOwnerAssignmentType AS '@autoClientOwnerAssignmentType',
							@autoClientOwnerAssignmentValue AS '@autoClientOwnerAssignmentValue',
							@allowSettingPasskey AS '@allowUsersToEnablePasskey',
							@autoRetireDevices,
							(SELECT @tfaInfo)
						FROM APP_CommCell WHERE clientId = @commCellId
						FOR XML PATH ('generalInfo'),TYPE)
		END
		--Get the EncryptionInfo for Commcell saved in App_company properties.
		IF @getEncryptionProperties = 1
		BEGIN
			DECLARE  @OrgPropTbl TABLE (
									PropertyName        varchar(256),
									propertyValue          nvarchar(MAX)
								)
			INSERT INTO @OrgPropTbl
				SELECT attrName, attrVal FROM  App_CompanyProp WHERE componentNameId=0
AND attrName in( 'Encryption Settings',
'Encrypt: Type',
'Encrypt: Key Length',
'Encrypt: drToolAccess')
								and modified=0
			SET @encryptionXML=	(SELECT
ISNULL((SELECT propertyValue FROM @OrgPropTbl where PropertyName = 'Encryption Settings'),3/*Not Set*/) as  '@encryptionSettings',
ISNULL((SELECT propertyValue FROM @OrgPropTbl where PropertyName = 'Encrypt: Type'),2) as '@cipherType',
ISNULL((SELECT propertyValue FROM @OrgPropTbl where PropertyName = 'Encrypt: drToolAccess'),0) as '@directMediaAccess',
ISNULL((SELECT propertyValue FROM @OrgPropTbl where PropertyName = 'Encrypt: Key Length'),128) as '@encryptKeyLength'
									FOR XML PATH('encryptionInfo'),TYPE)
		END
		--Populating Security Properties
		IF @getSecurityProperty  = 1
        BEGIN
			DECLARE @secureAgentInstall INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'Secure Agent Install' AND modified = 0 ), 0)
			DECLARE @enablePasswordCheck INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'Enable password check for Commcell Console' AND modified = 0 ), 0)
			DECLARE @flags INT = (SELECT (flags & 0x002) FROM APP_CommCell WHERE id = @commCellID) -- CV_HIDE_NCO_MASK = 0x0002
			DECLARE @datasecurityEnabled INT = ISNULL((SELECT (	 CASE
WHEN attrval = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
																 ELSE 0
																 END)
														FROM App_CompanyProp where componentNameId = 0 and
attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified=0),0)
			DECLARE @newSecurityInfo XML
			DECLARE @oldSecurityInfo XML
			EXEC [dbo].[sec_getSecurityForEntity]
					@userId,
					@newSecurityInfo OUTPUT,
					1, --CommCell Entity
					@commCellId
			SET @newSecurityInfo = (SELECT @newSecurityInfo
					FOR XML PATH('securityAssociationsInfo'),TYPE)
			SET @oldSecurityInfo = @associationEntity
			EXEC [dbo].[APPGetEntitySecurityXML]
					@xmlText = @oldSecurityInfo OUTPUT
			SET @oldSecurityInfo = (SELECT @oldSecurityInfo
					FOR XML PATH ('commCellSecurityInfo'),TYPE)
			SET @securityInfo = (SELECT
					@secureAgentInstall AS '@useSecureAgentInstall',
					@enablePasswordCheck AS '@enablePasswordCheck',
					CASE @flags WHEN 2 THEN 1 ELSE 0 END AS '@visibilityCheck',
					(SELECT @datasecurityEnabled as '@enableDataSecurity'
					FOR XML PATH('privacy'),TYPE),
					(SELECT @newSecurityInfo ),
					(SELECT @oldSecurityInfo )
				FOR XML PATH ('securityInfo'),TYPE)
		END
		--Populating Firewall Properties
		IF @getFirewallProperty  = 1
        BEGIN
				SET @firewallConfiguration = @clientAssociationEntity
				EXEC [dbo].[APPGetEntityFirewallXML] @userId,
						@entityInfo = @firewallConfiguration OUTPUT
				SET @firewallConfiguration = (SELECT @firewallConfiguration
						FOR XML PATH ('firewallConfigurationInfo'),TYPE)
		END
		--Populating Network Throttle Properties
		IF @getNetworkThrottleProperty  = 1
        BEGIN
				SET @networkThrottle = @clientAssociationEntity
				EXEC [dbo].[APPGetEntityNetworkThrottleXML]
						@entityInfo = @networkThrottle OUTPUT
				SET @networkThrottle = (SELECT @networkThrottle
                        FOR XML PATH ('networkThrottleInfo'),TYPE)
		END
		--Populating Activity Control Properties
		IF @getActivityControlProperty  = 1
        BEGIN
				SET @activityControlXML = @associationEntity
				EXEC [dbo].[APPGetActivityControlXML]
						@xmlText = @activityControlXML OUTPUT
				SET @activityControlXML = (SELECT @activityControlXML
						FOR XML PATH ('commCellActivityControlInfo'),TYPE)
		END
		--Populating Version Properties
		IF @getVersionInfoProperty  = 1
        BEGIN
				DECLARE @cryptoVersion VARCHAR(3) = '2.0' -- Crypto Library Version is static variable with value 2.0, below is the reference
				--Reference http:--ncvs.commvault.com/source/xref/win/vaultcx/Source/Common/CvCryptLib/cvcl.c#43
				DECLARE @installDir VARCHAR(MAX) = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = N'Patch Local Location' AND modified = 0 AND componentNameId = @csClientId), '' )
				EXEC [dbo].[AppGetVersionInfoForCommCell]
					@commCellId = @commCellId,
					@xmlText = @versionInfoXML OUTPUT
				SET @versionInfoXML = (SELECT
							@installDir AS '@installDirectory',
							@cryptoVersion AS '@cryptoLibraryVersion',
						(SELECT @versionInfoXML
							FOR XML PATH ('versionInfo'),TYPE)
						FOR XML PATH('versionPropertiesInfo'),TYPE)
		END
		--Populating Registry (Advance Settings) Properties
		IF @getRegistryProperty  = 1
        BEGIN
				SET @registryProperty =  (SELECT
					(SELECT
					CR.keyName as '@keyName',
					CR.type as '@type',
					(CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE dbo.EncodeInvalidXMLChar(CR.value) END) as '@value',
					CR.relativepath as '@relativepath',
					CR.enabled as '@enabled',
					ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
					(CASE CR.sourceId WHEN 0 THEN 0 ELSE 1 END) as '@isInheritedFromClientGroup', --source entityType assumed as 28 i.e CLIENT_GROUP_ENTITY
                            (SELECT
                            CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
                            CASE CR.sourceEntityType WHEN 28 THEN CR.sourceId ELSE NULL END AS '@clientGroupId',
                            CASE CR.sourceEntityType WHEN 28 THEN (SELECT name FROM APP_ClientGroup WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@clientGroupName'
                            FOR XML PATH('sourceEntity'),TYPE)
					FROM APP_AdvanceSettings as CR
					LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx
						ON CR.id = AdvEx.keyId
					WHERE CR.entityId = @csClientId AND CR.entityType = 3 --CLIENT_ENTITY
					AND CR.deleted = 0 AND ISNULL(AdvEx.hidden,0) = 0
					FOR XML PATH('registryKeys'),TYPE)
				FOR XML PATH ('registryKeysInfo'),TYPE)
		END
		--Populating Advance Feature Properties
		IF @getAdvanceFeatureProperty  = 1
        BEGIN
				SET @advanceFeatureInfo = (SELECT
							(SELECT
								LU.LicType AS '@licType',
								LU.AppType AS '@appType',
								[DBO].GetLicNameFromType(LU.LicType) AS '@name',
								LU.TokensUsed AS '@tokensUsed',
								LU.Eval AS '@evalInstall',
								LU.OpTimeUTC AS '@opTime',
								LU.ExpiryDateUTC AS '@expiryTime',
								CASE LU.OpType
									WHEN 'Install' THEN 1
									ELSE 0 END
									AS '@isInstall'
								FROM LicUsage LU
									INNER JOIN simAppTypeLicTypeMap LT
									ON LU.LicType = LT.simLicAppType WHERE LU.id > 0 AND LT.isCellLevel > 0 ORDER BY LU.LicType
							FOR XML PATH ('advanceFeature'),TYPE)
					FOR XML PATH ('advanceFeatureInfo'),TYPE)
		END
		--- Generating XML for CommCell Properties
		SET @outXML = (SELECT
					(SELECT
							id AS '@commCellId',
							aliasName AS '@commCellName',
1 AS '@_type_'
						FROM APP_CommCell WHERE id = @commCellID
					FOR XML PATH ('commCellEntity'), TYPE),
					(SELECT @generalInfo),
					(SELECT @securityInfo ),
					(SELECT @versionInfoXML),
					(SELECT @firewallConfiguration),
					(SELECT @networkThrottle ),
					(SELECT @registryProperty ),
					(SELECT @advanceFeatureInfo ),
					(SELECT @activityControlXML ),
					(SELECT @encryptionXML)
				FOR XML PATH('commCellInfo'),
			ROOT('App_GetCommCellPropertiesResp'))
   SELECT @outXML AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCommCellProperties')
	delete from GxQscripts where name = 'AppGetCommCellProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCommCellProperties')
	delete from GXDBVersions where aliasname = 'AppGetCommCellProperties'
GO

insert into GXDBVersions values(2, 'AppGetCommCellProperties',  '00000000000000000000', 'AppGetCommCellProperties', '00000000000000000000')
GO

