

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudVendorRegions.sp] ---------- 

-- Additional header files can be included for constants used in this stored procedure.
-- Stored procedure has to be rebuilt if any constant value changed in those header file.
-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudVendorRegions.sp,v $ $Id: AppGetCloudVendorRegions.sp,v 1.1.2.1 2017/01/31 18:14:10 bhegde Exp $";
-- Name of the stored procedure
-- It must match with the name of the .sp file
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCloudVendorRegions <<<'

IF EXISTS (select * from sysobjects where name='AppGetCloudVendorRegions')
	drop procedure AppGetCloudVendorRegions
IF EXISTS (select * from GxQscripts where name='AppGetCloudVendorRegions')
	delete from GxQscripts where name = 'AppGetCloudVendorRegions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudVendorRegions')
	delete from GXDBVersions where aliasname = 'AppGetCloudVendorRegions'
GO
print '... Creating Procedure: AppGetCloudVendorRegions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudVendorRegions
-- Input variables of the stored procedure
  @i_xml XML
-- Tell the AWK processor that body of query starts here
AS
DECLARE @cloudVendor int =  (SELECT @i_xml.value('(/App_GetRegionsInfoReq/@vendor)[1]', 'INT'))
DECLARE	@o_xml	XML
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
IF @cloudVendor = 4 --AMAZON_RDS
BEGIN
	SET @o_xml =
				(SELECT region.RegionName as '@regionName',
						region.Id as '@regionId',
						region.RegionCode as '@regionCode',
						(SELECT zone.id as '@zoneid',
								zone.ZoneName as '@zoneCode'
						FROM App_CloudVendorZone zone
						WHERE zone.RegionId = region.Id
						FOR XML PATH('zones'), TYPE)
				FROM App_CloudVendorRegion region
				WHERE VendorId = (SELECT id FROM App_CloudVendorInfo WHERE VendorName = 'AWS') --_CLD_APP_VENDOR_AWS
				FOR XML PATH('regions'), TYPE)
END
ELSE
BEGIN
	SET @errorCode = 1
	SET @errorMsg = 'Cloud vendor type not recognized ' + CAST (@cloudVendor AS NVARCHAR(3))
END
SELECT  @o_xml,
		(SELECT
					@errorCode as '@errorCode',
					@errorMsg as '@errorMessage'
					FOR XML PATH('response'), TYPE)
		FOR XML PATH('App_GetRegionsInfoResp'), TYPE
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudVendorRegions')
	delete from GxQscripts where name = 'AppGetCloudVendorRegions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudVendorRegions')
	delete from GXDBVersions where aliasname = 'AppGetCloudVendorRegions'
GO

insert into GXDBVersions values(2, 'AppGetCloudVendorRegions',  '00010001000200010000', 'AppGetCloudVendorRegions', '00010001000200010000')
GO

