

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudVMInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudVMInfo.sp,v $ $Id: AppGetCloudVMInfo.sp,v 1.1.2.1 2020/10/15 11:59:49 kbora Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"AppGetCloudVMInfo"               				|
--  |       Author	    :	 kbora                        	    			|
--  |                					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudVMInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudVMInfo <<<'
	drop procedure AppGetCloudVMInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudVMInfo')
	delete from GxQscripts where name = 'AppGetCloudVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudVMInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudVMInfo'
GO
print '... Creating Procedure: AppGetCloudVMInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetCloudVMInfo
  @i_clientId Integer
AS
  DECLARE @o_VmGUID VARCHAR(1024)
  DECLARE @o_VmName VARCHAR(1024)
  DECLARE @o_hyperVisorClientId INTEGER 
  DECLARE @o_hyperVisorClientName VARCHAR(1024)
  DECLARE @o_InstanceId INTEGER
  DECLARE @o_InstanceType INTEGER
  DECLARE @o_VSADataCenterName NVARCHAR(1024)
  DECLARE @o_ErrorCode INTEGER
DECLARE @VmGUID VARCHAR(1024) = ''
DECLARE @VmName VARCHAR(1024) = ''
DECLARE @InstanceId INTEGER = 0
DECLARE @hyperVisorClientId INTEGER = 0
DECLARE @hyperVisorClientName VARCHAR(1024) = ''
DECLARE @InstanceType INTEGER = 0
DECLARE @VSADataCenterName VARCHAR(1024) = ''
DECLARE @ErrorCode INTEGER = 0
SELECT @VmName = name FROM APP_Client WITH (NOLOCK) WHERE id = @i_clientId
SELECT @VmGUID = attrVal FROM APP_ClientProp PROP WITH (NOLOCK)
WHERE PROP.componentNameId = @i_clientId
AND PROP.attrName = 'Virtual Machine GUID'
AND PROP.modified = 0
IF @VmGUID = ''
BEGIN
	SELECT @ErrorCode = 1  			-- VM_GUID_NOT_FOUND
	GOTO ERROREXIT
END
SET @hyperVisorClientId = ISNULL((SELECT value FROM GxGlobalParam WHERE name = 'nCSFailoverHyperVisorClientId' and modified = 0), 0)
IF @hyperVisorClientId = 0
BEGIN
	SELECT @ErrorCode = 2			-- VIRTUAL_CLIENT_NOT_ASSOCIATED
	GOTO ERROREXIT
END
SELECT @VSADataCenterName = LOWER(attrVal) FROM APP_ClientProp PROP WITH (NOLOCK)
WHERE PROP.componentNameId = @i_clientId
AND PROP.attrName = 'VSA DataCenter Name'
AND PROP.modified = 0
SELECT @hyperVisorClientName = name FROM APP_Client WITH (NOLOCK) WHERE id = @hyperVisorClientId
SELECT TOP 1 @InstanceId = APP.instance FROM APP_APPLICATION APP WITH (NOLOCK)
WHERE APP.clientId = @hyperVisorClientId AND APP.appTypeId = 106
SELECT @InstanceType = CAST(attrVal as INTEGER) FROM APP_InstanceProp WITH (NOLOCK) WHERE componentNameId = @InstanceId AND attrName = 'Virtual Server Instance Type'
ERROREXIT:
	SELECT @VmGUID, @VmName, @hyperVisorClientId, @hyperVisorClientName, @InstanceId, @InstanceType, @VSADataCenterName, @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudVMInfo')
	delete from GxQscripts where name = 'AppGetCloudVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudVMInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudVMInfo'
GO

insert into GXDBVersions values(2, 'AppGetCloudVMInfo',  '00010001000200010000', 'AppGetCloudVMInfo', '00010001000200010000')
GO

