

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudServiceOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudServiceOptions')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudServiceOptions <<<'
	drop procedure AppGetCloudServiceOptions
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudServiceOptions')
	delete from GxQscripts where name = 'AppGetCloudServiceOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudServiceOptions')
	delete from GXDBVersions where aliasname = 'AppGetCloudServiceOptions'
GO
print '... Creating Procedure: AppGetCloudServiceOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudServiceOptions
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @i_vendor integer
	DECLARE @i_instanceType integer
	DECLARE @i_optionGroup integer
	DECLARE @i_regionId integer
	SELECT  @i_vendor = ISNULL(col.value('@vendorId', 'integer'), 1), --AWS
			@i_instanceType = ISNULL(col.value('@instanceType', 'integer'), 4), --RDS
			@i_optionGroup = ISNULL(col.value('@optionGroup', 'integer'), 1),  --All
			@i_regionId = ISNULL(col.value('@regionId', 'integer'), 0)
	FROM @i_xml.nodes('/App_GetCloudServiceOptionsListReq') node(col)
	IF OBJECT_ID('tempdb..#tblCloudOptions') IS NOT NULL DROP TABLE #tblCloudOptions
	CREATE TABLE #tblCloudOptions (optionGroup int, optionVal NVARCHAR(255), optionId int, primary key (optionGroup, optionVal))
	IF(@i_optionGroup = 1) or (@i_optionGroup = 2)
	BEGIN
			-- fill region list
			INSERT INTO #tblCloudOptions
			select 2 optionGroup, RegionName optionVal, Id optionId from App_CloudVendorRegion
	END
	IF(@i_optionGroup = 1) or (@i_optionGroup = 3)
	BEGIN
	-- fill zone list
		IF(@i_regionId = 0)
		BEGIN
			INSERT INTO #tblCloudOptions
			select distinct 3 optionGroup, ZoneName optionVal, Id optionId from App_CloudVendorZone
		END
		ELSE
		BEGIN
			INSERT INTO #tblCloudOptions
			select 3 optionGroup, ZoneName optionVal, Id optionId from App_CloudVendorZone where RegionId = @i_regionId
		END
	END
	IF(@i_optionGroup = 1) or (@i_optionGroup = 4)
	BEGIN
	-- fill storageType list
		IF(@i_instanceType = 4) --RDS
		BEGIN
			INSERT INTO #tblCloudOptions values
			(4, 'standard', 0),
			(4, 'gp2', 0),
			(4, 'io1', 0)
		END
	END
	SET @o_xml = ( SELECT  optionGroup optionGroup, optionVal 'option', optionId optionId
	FROM   #tblCloudOptions
	FOR XML RAW ('optionsList'), ROOT ('App_GetCloudServiceOptionsListResp') )
END TRY
BEGIN CATCH
	SET  @o_xml = (SELECT @@ERROR AS '@errorCode', 'Failed to get backup options.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'App_ArchViewCloudSnapRegionsResp'))
END CATCH
IF @o_xml IS NULL
	SET @o_xml = '<App_ArchViewCloudSnapRegionsResp/>'
IF OBJECT_ID('tempdb..#tblCloudOptions') IS NOT NULL
    DROP TABLE #tblCloudOptions
SELECT @o_xml AS o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudServiceOptions')
	delete from GxQscripts where name = 'AppGetCloudServiceOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudServiceOptions')
	delete from GXDBVersions where aliasname = 'AppGetCloudServiceOptions'
GO

insert into GXDBVersions values(2, 'AppGetCloudServiceOptions',  '00000000000000000000', 'AppGetCloudServiceOptions', '00000000000000000000')
GO

