

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudServerInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetCloudServerInfo()
--  | Description:  Returns the SOLR URLs associated to the 1st subclient of given backupset.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudServerInfo.sp,v $ $Id: AppGetCloudServerInfo.sp,v 1.1.4.14 2020/12/19 10:10:36 gvenugopalsamy Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudServerInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudServerInfo <<<'
	drop procedure AppGetCloudServerInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudServerInfo')
	delete from GxQscripts where name = 'AppGetCloudServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudServerInfo'
GO
print '... Creating Procedure: AppGetCloudServerInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudServerInfo
  @inputXml xml
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @outputXML XML
	DECLARE @corePrefix  nvarchar(max)
	DECLARE @backupSetStr uniqueidentifier
	DECLARE @backupSetId integer = -1
	DECLARE @subClientId integer = -1
	DECLARE @RoleName nvarchar(max) = ''
	DECLARE @ciServerXML XML = NULL
	DECLARE @recoveryPointId INT = 0
	DECLARE @inCIServerXML XML = '<DM2ContentIndexing_CIServers/>'
	DECLARE @indexServerClientId integer = 0
	SET @backupSetStr = (SELECT ref.value('@backupsetGUID', 'uniqueidentifier')FROM @inputXml.nodes('Indexing_GetCloudServerReq') R(ref))
	SET @corePrefix = (SELECT ref.value('@corePrefix', 'nvarchar(max)')FROM @inputXml.nodes('Indexing_GetCloudServerReq') R(ref))
	SET @indexServerClientId = ISNULL((SELECT ref.value('@indexServerClientId', 'int')FROM @inputXml.nodes('Indexing_GetCloudServerReq') R(ref)), 0)
	SET @recoveryPointId = ISNULL((SELECT ref.value('@recoveryPointId', 'int') FROM @inputXml.nodes('Indexing_GetCloudServerReq') R(ref)), 0)
	IF LEN(@backupSetStr) > 0
	BEGIN
		SET @backupSetId = ISNULL((SELECT id FROM App_BackupSetName WHERE GUID = @backupSetStr), -1)
		set @subClientId = ( SELECT TOP 1 id  FROM App_Application WHERE backupSet = @backupSetId )
	END
	DECLARE @appType int = 0
	DECLARE @isFileSystemAppType int = 0
	SET @appType = (SELECT appTypeId from App_Application where id = @subClientId)
	SET @isFileSystemAppType = dbo.isFileSystemAppType(@appType)
	SET @RoleName = (SELECT CASE
WHEN @appType = 137 THEN 'Exchange Index'
WHEN @appType = 139 THEN '' -- we dont want to use roleName to get the index servers as role will be added during collection creation only
WHEN @appType = 78 THEN ''
WHEN @appType = 106 THEN ''
WHEN @isFileSystemAppType = 1 THEN 'FileSystem Index'
			END )
	DECLARE @idxAppType int = ISNULL((SELECT TOP 1 TYPE FROM App_IndexDBInfo WHERE backupSetGUID = @backupSetStr),0)
IF @appType = 134 -- CV_APPTYPE_CLOUD_APPS
	BEGIN
SET @RoleName = CASE WHEN @idxAppType = 200118 THEN 'OneDrive Index'
						ELSE ''
						END
	END
IF @appType = 137
	BEGIN
		IF @recoveryPointId > 0 OR @indexServerClientId > 0
		BEGIN
			SET @inCIServerXML = (
									SELECT
									@recoveryPointId '@recoveryPointId',
									@indexServerClientId AS '@indexServerClientId'
									FOR XML PATH('listOfCIServer'), ROOT('DM2ContentIndexing_CIServers')
								 )
		END
	END
	--For File System we store metainfo information in data collection itself
	IF(@corePrefix = 'metainfo' AND  @isFileSystemAppType = 1)
		SET @corePrefix = 'fsindex'
	IF OBJECT_ID('tempdb.dbo.#AppGetAnalyticsServerByRoleOutTable') IS NOT NULL
            DROP TABLE #AppGetAnalyticsServerByRoleOutTable
	CREATE TABLE #AppGetAnalyticsServerByRoleOutTable(ciServerXML xml)
	exec AppGetAnalyticsServerByRole @subClientId, @RoleName, @corePrefix, 0/*CloudId*/, @inCIServerXML, 0/*IncludeSearchEngine*/
	SELECT @ciServerXML = ciServerXML FROM #AppGetAnalyticsServerByRoleOutTable
	IF(@ciServerXML IS NOT NULL AND @ciServerXML.exist('DM2ContentIndexing_CIServers/listOfCIServer') <> 0)
		SET @outputXML = (SELECT @idxAppType AS '@appType',
								 @backupSetId AS '@backupsetId',
								 (SELECT R.ref.query('listOfCIServer') AS ciServers FROM @ciServerXML.nodes('DM2ContentIndexing_CIServers') AS R(ref) FOR XML PATH (''),type)
								 FOR XML PATH('DM2ContentIndexing_GetCloudServerResp'), TYPE)
	IF OBJECT_ID('tempdb.dbo.#AppGetAnalyticsServerByRoleOutTable') IS NOT NULL
            DROP TABLE #AppGetAnalyticsServerByRoleOutTable
	 IF @outputXML IS NULL
        SET @outputXML = '<DM2ContentIndexing_GetCloudServerResp/>'
    SELECT @outputXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudServerInfo')
	delete from GxQscripts where name = 'AppGetCloudServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudServerInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudServerInfo'
GO

insert into GXDBVersions values(2, 'AppGetCloudServerInfo',  '00010001000400140000', 'AppGetCloudServerInfo', '00010001000400140000')
GO

