

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudObjStorageAccounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudObjStorageAccounts.sp,v $ $Id: AppGetCloudObjStorageAccounts.sp,v 1.1.2.14.4.1 2021/01/08 11:33:09 snandhini Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudObjStorageAccounts')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudObjStorageAccounts <<<'
	drop procedure AppGetCloudObjStorageAccounts
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudObjStorageAccounts')
	delete from GxQscripts where name = 'AppGetCloudObjStorageAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudObjStorageAccounts')
	delete from GXDBVersions where aliasname = 'AppGetCloudObjStorageAccounts'
GO
print '... Creating Procedure: AppGetCloudObjStorageAccounts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudObjStorageAccounts
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE INDEX getIdaObjects_instanceID_Idx ON #getIdaObjects(instanceID)
	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails
	(
		[InstanceId] INT,
		[InstanceName] NVARCHAR(255),
		[ClientId] INT,
		[ClientName] NVARCHAR(255),
		[VendorType] INT,
		[VendorName] NVARCHAR(255) DEFAULT '',
		[LastBackupTime] INT DEFAULT 0,
		[Size] BIGINT DEFAULT 0,
		[SLA] INT DEFAULT 1,
		[slaMissReasonList] XML,
		[Status] INT DEFAULT 0,
		[PlanId] INT DEFAULT '0',
		[PlanName] NVARCHAR(256) DEFAULT ''
		PRIMARY KEY([InstanceId],[ClientId])
	)
	DECLARE @localeId INT = ISNULL((select ref.value('@localeId','INT') FROM @i_xmlString.nodes('/Api_CloudStorageAccountsReq/processinginstructioninfo/locale')  R(ref)), 0)
	DECLARE @userId INT = ISNULL((select ref.value('@userId','INT') FROM @i_xmlString.nodes('/Api_CloudStorageAccountsReq/processinginstructioninfo/user')  R(ref)), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudStorageAccountsReq/@instanceId)[1]','INT')), 0)
	DECLARE @vendorType INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudStorageAccountsReq/@vendorType)[1]','INT')), 0)
	DECLARE @propertyLevel INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudStorageAccountsReq/@propertyLevel)[1]','INT')), 10)
	--Get list of instances user has visibility to
	EXEC dbo.sec_getIdaObjectsForUser @userid, 7, 0, 1, '#getIdaObjects' -- 7 = SUBCLIENT_ENTITY from CvEntities.x
	DELETE	#getIdaObjects
WHERE	apptypeId != 134
	-- filter by InstanceId
	IF (@InstanceId <> 0)
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, VendorType, Status)
		SELECT	DISTINCT I.id, I.name, C.id, C.name, CAST(IP.attrVal AS INT), I.status
		FROM	#getIdaObjects sec
			INNER JOIN APP_Application A
				ON sec.instanceID = A.instance
			INNER JOIN APP_Client C
ON A.clientId = C.id AND A.appTypeId = 134
			INNER JOIN APP_InstanceName I
				ON I.id = A.instance AND (I.id = @InstanceId)
			INNER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.id AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
		WHERE	IP.attrVal in ('5', '6', '20', '21', '24', '25') --Add instanceType when it supports at adminconsole 14, 15
			AND	(I.status&4) = 0 AND (I.status&16) = 0 AND (I.status & 32) = 0 AND (I.status & 2048) = 0
	END
	ELSE
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, VendorType, Status)
		SELECT	DISTINCT I.id, I.name, C.id, C.name, CAST(IP.attrVal AS INT), I.status
		FROM	#getIdaObjects sec
			INNER JOIN APP_Application A
				ON sec.instanceID = A.instance
			INNER JOIN APP_Client C
ON A.clientId = C.id AND A.appTypeId = 134
			INNER JOIN APP_InstanceName I
				ON I.id = A.instance
			INNER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.id AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
		WHERE	IP.attrVal in ('5', '6', '20', '21', '24', '25') --Add instanceType when it supports at adminconsole 14, 15
			AND	(I.status&4) = 0 AND (I.status&16) = 0 AND (I.status & 32) = 0 AND (I.status & 2048) = 0
	END
	UPDATE	C
	SET		VendorName = attrVal
	FROM	#ClientInstanceDetails C
		INNER JOIN APP_InstanceProp	I ON C.InstanceId = I.componentNameId
			AND I.attrName = 'Cloud Apps Instance Display Name' and I.modified = 0
	UPDATE	C
	SET		VendorName = 'Azure File'
	FROM	#ClientInstanceDetails C
		INNER JOIN APP_InstanceProp I ON C.instanceId = I.componentNameId
			AND I.attrName = 'Azure Host URL' AND modified = 0 AND attrVal = 'file.core.windows.net'
	UPDATE	#ClientInstanceDetails
	SET		VendorName =
			(CASE WHEN VendorType = 5 THEN 'Amazon S3'
				WHEN VendorType = 6 THEN 'Azure Blob'
				WHEN VendorType = 14 THEN 'Oracle Storage Service'
				WHEN VendorType = 15 THEN 'Openstack'
				WHEN VendorType = 20 THEN 'Google Cloud'
				WHEN VendorType = 21 THEN 'Azure Data Lake Storage Gen2'
				WHEN VendorType = 24 THEN 'IBM Cloud Object Storage'
				WHEN VendorType = 25 THEN 'Alibaba Cloud OSS' END)
	WHERE	VendorName = ''
	--Update plan info
	UPDATE	#ClientInstanceDetails
	SET		PlanId = ISNULL(AP.id, 0),
			PlanName = ISNULL(AP.name, N'')
	FROM	#ClientInstanceDetails I
		INNER JOIN APP_InstanceProp IP
ON IP.componentNameId = I.InstanceId  AND IP.attrName = 'Associated Plan' AND IP.modified=0
		LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
	--Update SLA status
	/*
	Rules:
	For the instance to meet SLA, all subclients should meet SLA. Or all subclients should be 'Met' or 'Excluded' with at least one 'Met' subclient.
	For the instance to become 'Excluded' all the subclients must be 'Excluded'.
	If at least one subclient misses SLA, then instance misses SLA.
	Check for missed subclients --> if yes, instance is 'Missed' SLA (2)
	Check for excluded subclients --> If excluded = total or no rows in RptSLASubclient, then instance is 'Excluded' SLA (3)
	Else it means there are no missed subclients and at least 1 'Met' subclient. Which means instance 'Met' SLA (1).
	*/
	UPDATE	I
	SET		I.SLA = (CASE WHEN R.missed > 0 THEN 2 WHEN (R.excluded = R.totalSubclients OR R.instanceID IS NULL) THEN 3 ELSE 1 END) -- when all subclients are met or excluded totalSubClients will match, so slaStatus is valid from min operator
	FROM	#ClientInstanceDetails I
		LEFT OUTER JOIN (
				SELECT	SEC.instanceId,
						SUM(CASE WHEN S.status = 1 THEN 1 ELSE 0 END) met,
						SUM(CASE WHEN S.status = 2 THEN 1 ELSE 0 END) missed,
						SUM(CASE WHEN S.status not in (1, 2) THEN 1 ELSE 0 END) excluded,
						COUNT(S.appId) AS totalSubclients
				FROM	RptSLASubclient S INNER JOIN #getIdaObjects SEC on S.appId = SEC.subclientID AND S.clientId = SEC.clientId AND S.fullJobsOnly = 0
				GROUP BY SEC.instanceId) R
		ON	I.InstanceId = R.instanceId
	UPDATE I
	SET I.SLA =  5, /*MIGHT_MISS_SLA*/
		I.slaMissReasonList = CAST(stringval AS XML)
	FROM #ClientInstanceDetails I
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = I.InstanceId AND Prop.componentType =  21 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	CREATE TABLE #lastSuccBackupJob (instanceId INT, backupJobId INT, commCellId INT, servEndDate INT, size BIGINT)
	INSERT INTO #lastSuccBackupJob
	SELECT MAX(InstanceId), MAX(jobId), MAX(commCellID), MAX(servEndDate), SUM(totalUnCompBytes)
	FROM
	(
		SELECT	I.InstanceId, A.id 'subclientId', B.jobId, B.commCellID, B.servEndDate, B.totalUnCompBytes, ROW_NUMBER() OVER (PARTITION BY I.instanceId, A.id  ORDER BY B.servEndDate DESC) AS rowId
		FROM	#ClientInstanceDetails I
			INNER JOIN APP_Application A
				ON I.instanceId = A.instance
			INNER JOIN APP_IdaType IDA
				ON A.appTypeId = IDA.type
			INNER JOIN JMBkpStats B
				ON A.id = B.appId AND (B.status IN (1, 14) OR (B.status = 3 AND IDA.isCWEJobValid = 1))
	) S
	WHERE S.rowId = 1
	GROUP BY InstanceId
	--All agents
	--If we don't have size and backup time already populated, get it from job history
	UPDATE	I
	SET		I.LastBackupTime = (CASE WHEN I.LastBackupTime > 0 THEN I.LastBackupTime ELSE J.servEndDate END),
			I.Size = (CASE WHEN I.Size > 0 THEN I.Size ELSE J.size END)
	FROM	#ClientInstanceDetails I
		INNER JOIN #lastSuccBackupJob J
			ON I.InstanceId = J.instanceId
	WHERE	(I.LastBackupTime = 0 OR I.Size = 0)
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	-- instance application size table
	IF OBJECT_ID('tempdb.dbo.#InstanceApplicationSize') IS NOT NULL
		DROP TABLE #InstanceApplicationSize
	CREATE TABLE #InstanceApplicationSize (instanceId INT PRIMARY KEY, applicationSize BIGINT DEFAULT 0)
	INSERT INTO #InstanceApplicationSize
	SELECT InstanceId, SUM(AppSizeMB)*1024*1024 -- to bytes
	FROM (
			SELECT InstanceId, AppsizeMB,
			ROW_NUMBER() OVER(PARTITION BY SubclientId ORDER BY rankOrder ASC) AS rownum
			FROM(
					SELECT
						LC.InstanceId,
						LC.AppsizeMB,
						LC.SubclientId,
						(CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
					FROM   #ClientInstanceDetails CLI
						INNER JOIN  Lic_CurrentUsage LC WITH(NOLOCK)
							ON LC.InstanceId = CLI.InstanceId
					WHERE LC.UsageType in (1,2,3,4)
			) TMP
		)LIC
	WHERE LIC.rownum=1
	GROUP BY InstanceId
	Update I
		SET I.Size = IA.applicationSize
	FROM #ClientInstanceDetails I
		INNER JOIN #InstanceApplicationSize IA
			ON I.InstanceId = IA.instanceId
	IF OBJECT_ID('tempdb.dbo.#InstanceApplicationSize') IS NOT NULL
		DROP TABLE #InstanceApplicationSize
	SET @o_xmlString =
	(
		SELECT
		(	SELECT	0 AS '@errorCode',
					N'' AS '@errorMessage'
			FOR XML PATH('error'), TYPE),
		(	SELECT	D.LastBackupTime AS '@backupTime',
					D.Size AS '@backupSize',
					D.SLA AS '@slaStatus',
					D.Status AS '@status',
					D.vendorType AS '@vendorType',
					D.vendorName AS '@vendorDisplayName',
					D.InstanceId AS 'instance/@instanceId',
					D.InstanceName AS 'instance/@instanceName',
					D.ClientId AS 'instance/@clientId',
					D.ClientName AS 'instance/@clientName',
					D.PlanId AS 'plan/@planId',
					D.PlanName AS 'plan/@planName',
					D.slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList
			FROM #ClientInstanceDetails AS D for XML PATH('account'), TYPE)
		FOR XML PATH(''), ROOT('Api_CloudStorageAccountsResp')
	)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xmlString = (SELECT @@ERROR AS '@errorCode', 'Failed to get database details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'Api_CloudStorageAccountsResp'))
END CATCH
IF @o_xmlString IS NULL
	SET @o_xmlString = '<Api_CloudStorageAccountsResp/>'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
	DROP TABLE #ClientInstanceDetails
IF OBJECT_ID('tempdb.dbo.#cloudStorageAccountsOut') IS NOT NULL
	INSERT INTO #cloudStorageAccountsOut(cloudStorageAccountsInfo)
		SELECT @o_xmlString
ELSE
        select @o_xmlString as o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudObjStorageAccounts')
	delete from GxQscripts where name = 'AppGetCloudObjStorageAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudObjStorageAccounts')
	delete from GXDBVersions where aliasname = 'AppGetCloudObjStorageAccounts'
GO

insert into GXDBVersions values(2, 'AppGetCloudObjStorageAccounts',  'v1.1.2.14.4.1', 'AppGetCloudObjStorageAccounts', 'v1.1.2.14.4.1')
GO

