

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudListWithStatus.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppGetCloudListWithStatus
--  | Description:   Provide cloud list for SP level, search engine level
--  |
--  |		Max Node limit is 4, it is configurable using gxgloabalparam 'MaxCINodesLimitForCloud'
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCloudListWithStatus <<<'

IF EXISTS (select * from sysobjects where name='AppGetCloudListWithStatus')
	drop procedure AppGetCloudListWithStatus
IF EXISTS (select * from GxQscripts where name='AppGetCloudListWithStatus')
	delete from GxQscripts where name = 'AppGetCloudListWithStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudListWithStatus')
	delete from GXDBVersions where aliasname = 'AppGetCloudListWithStatus'
GO
print '... Creating Procedure: AppGetCloudListWithStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudListWithStatus
  @i_archGroupId integer,
  @i_excludeCloudWithMaxNodeLimit integer = 0,
  @i_ciEngineType integer = 0
AS
  DECLARE @cloudId INT
  DECLARE @cloudName NVARCHAR(255)
  DECLARE @status INT 
  DECLARE @indexType INT
  DECLARE @isMultiNode INT
  DECLARE @engineType INT
DECLARE @cloudresulttbl TABLE
(
	t_cloudId INT,
t_cloudName NVARCHAR(255),
	t_roleId INT,
	t_cliId INT,
	t_status INT,
	t_indexType INT,
	t_isMultiNode INT,
	t_noOfNodes	INT
)
--Fetch the clients on  whom the CI nodes have been installed for each CI engine/cloud
INSERT INTO @cloudresulttbl (t_cloudId,t_cloudName, t_cliId, t_status, t_indexType, t_isMultiNode, t_noOfNodes, t_roleId )
SELECT CP.id,CP.stringVal,CLP.componentNameId, 0, 0, 0, 0, 0
	FROM APP_ComponentProp CP with(nolock) INNER JOIN APP_ClientProp CLP with(nolock)
	ON CP.id = CONVERT(INT,CLP.attrVal)
WHERE CP.componentType = 1 AND CP.componentId = 2 AND CP.propertyTypeId = 1 AND CP.modified = 0
			AND CLP.modified = 0 AND CLP.attrName = 'CLOUD_ID'
--analytics engine
INSERT INTO @cloudresulttbl (t_cloudId,t_cloudName, t_cliId, t_status, t_indexType, t_isMultiNode, t_noOfNodes, t_roleId )
SELECT C.cloudid, C.name, S.ClientId, 1, 28, 0, 1, CR.roleId
FROM DM2Cloud C WITH (NOLOCK)
	INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON C.cloudId=S.CloudId
	INNER JOIN DM2CloudCoreRole CR WITH (NOLOCK) ON CR.CloudId=S.CloudId
--DO NOT INCLUDE PREVIEW / STORE TAGS CLOUD IF assoicated to existing cloud
IF @i_archGroupId > 0
begin
	DELETE T
	FROM @cloudresulttbl T
	 INNER JOIN DM2SearchEngineCloudMapping M  WITH (NOLOCK) ON T.t_cloudId = M.DestCloudId AND  M.Flags=0
INNER JOIN archContentIndexingRules R  WITH (NOLOCK) ON R.cloudId = M.SrcCloudId AND R.enabled=1 AND R.archGroupId = @i_archGroupId AND R.operationType = 1
end
--update roleId for SOLR/CJK/FAST
UPDATE @cloudresulttbl
SET t_roleId = CASE WHEN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE propertyTypeId = 1014 AND componentId = t_cloudId AND modified = 0) like 'Solr%' THEN 1
WHEN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE propertyTypeId = 1014 AND componentId = t_cloudId AND modified = 0) like 'CJKSolr%' THEN 6
WHEN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE propertyTypeId = 1014 AND componentId = t_cloudId AND modified = 0) LIKE '5.1.5' THEN 5
WHEN (SELECT stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE propertyTypeId = 1014 AND componentId = t_cloudId AND modified = 0) LIKE '4.3' THEN 5
ELSE 0
					END
WHERE t_roleId = 0
IF @i_ciEngineType = 0
	DELETE T
	FROM @cloudresulttbl T
WHERE t_roleId NOT IN (1, 5, 6)
ELSE
	DELETE T
	FROM @cloudresulttbl T
	WHERE t_roleId NOT IN (@i_ciEngineType)
/*
enum IndexType
{
  NONE = 0,
  CONTENT = 1,
  METADATA = 2
}
*/
UPDATE @cloudresulttbl
SET t_indexType = (CASE WHEN stringVal = 'Solr 1.0' THEN 1
						WHEN stringVal = 'Solr 1.1' THEN 2
						ELSE 0
					END)
FROM @cloudresulttbl, APP_ComponentProp WITH (NOLOCK)
WHERE t_cloudid = componentId and propertyTypeId = 1014
--count no of nodes within a cloud
UPDATE @cloudresulttbl
SET t_noOfNodes =  (SELECT count (t_cloudId) FROM @cloudresulttbl TMP  WHERE TMP.t_cloudId =N.t_cloudId GROUP BY t_cloudId )
FROM @cloudresulttbl N
--delete cloud entries for which MAX (default=4) no of nodes reached
IF @i_excludeCloudWithMaxNodeLimit > 0
	DELETE FROM @cloudresulttbl
	WHERE t_noOfNodes >= ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'MaxCINodesLimitForCloud'), 4)
OR t_roleId = 5
--singleNode = 0, multinode =1
UPDATE @cloudresulttbl
SET t_isMultiNode = 1
WHERE t_noOfNodes >1
--Mark the status as 1, only if the package 257 (Search server), 251 (Content Indexing Engine) for FAST, 260 Multi lingual SE is installed on the client
UPDATE @cloudresulttbl
SET t_status = 1
WHERE t_cliId in (SELECT clientId FROM simInstalledPackages WITH (NOLOCK) WHERE simPackageId IN (251, 257, 260, 261))
--MR 77625: When a SP is pointing to SOLR server, then FAST should not be shown in the drop-down list.
IF @i_archGroupId > 0
begin
 declare @roleId INT
 declare @relaxCheckForSPtoCICloud int
set @roleId = ISNULL((SELECT DISTINCT t_roleId from @cloudresulttbl, archContentIndexingRules WITH (NOLOCK)  where archGroupId = @i_archGroupId AND t_cloudId = cloudId AND enabled = 1 AND operationType = 1), 1) --SOLR
if @roleId  = 1 OR (@roleId is NULL AND Exists (select * from @cloudresulttbl where t_roleId = 1))
	UPDATE @cloudresulttbl
SET t_status = 0
WHERE t_roleId = 5
	--MR 92875:Restrict one cloud per SP
	set @relaxCheckForSPtoCICloud  = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'RELAX_CHECK_FOR_SP_TO_CI_CLOUD'), 0)
	IF  @relaxCheckForSPtoCICloud = 0
		DELETE FROM @cloudresulttbl
		WHERE t_cloudId IN (SELECT cloudid from archContentIndexingRules WITH (NOLOCK) WHERE enabled =1 AND archGroupId <>  @i_archGroupId)
AND t_cloudId <> ISNULL(( SELECT cloudId from archContentIndexingRules WITH (NOLOCK)  where archGroupId = @i_archGroupId AND enabled = 1 AND operationType = 1), 0)
OR (t_roleId = 5 AND @roleId = 1)
end
-- Status values 0 or 1
-- Status should be 0 from the cloud level if even one of the client has status 0
SELECT t_cloudId AS cloudId, t_cloudName AS cloudName,MIN(t_status) AS status, MIN(t_indexType) AS indexType, MIN(t_isMultiNode) AS isMultiNode, MAX(t_roleId) AS engineType
FROM @cloudresulttbl
GROUP BY t_cloudId, t_cloudName
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudListWithStatus')
	delete from GxQscripts where name = 'AppGetCloudListWithStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudListWithStatus')
	delete from GXDBVersions where aliasname = 'AppGetCloudListWithStatus'
GO

insert into GXDBVersions values(2, 'AppGetCloudListWithStatus',  '00000000000000000000', 'AppGetCloudListWithStatus', '00000000000000000000')
GO

