

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudLaptopConfig.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudLaptopConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudLaptopConfig <<<'
	drop procedure AppGetCloudLaptopConfig
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudLaptopConfig')
	delete from GxQscripts where name = 'AppGetCloudLaptopConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudLaptopConfig')
	delete from GXDBVersions where aliasname = 'AppGetCloudLaptopConfig'
GO
print '... Creating Procedure: AppGetCloudLaptopConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudLaptopConfig
  @inxml XML
AS
DECLARE @outXML xml = (
select tempStore.Bguid as 'guid', max(tempStore.Bstatus) as 'status'
FROM
		(
			SELECT BKP.GUID as 'Bguid', (CASE WHEN SCP.attrVal IS NOT NULL THEN 1 ELSE 0 END) 'Bstatus'
			FROM @inxml.nodes('/Indexing_AppGetCloudLaptopConfig/backupset') AS T(BackupSetXml)
			INNER JOIN APP_BackupSetName BKP WITH (NOLOCK) ON BKP.GUID = BackupSetXml.value('@guid','nvarchar(36)')
			INNER JOIN APP_Application SUB WITH (NOLOCK) on SUB.backupSet = BKP.id
			LEFT OUTER JOIN APP_SubClientProp SCP WITH (NOLOCK) ON SCP.componentNameId = SUB.id  -- left outer join since we need backup sets even for 0 status
AND  SCP.attrName = 'Cloud Mode Enabled'
				AND SCP.modified = 0
				AND SCP.attrVal = '1'
AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
WHERE (BKP.status & 0x00008) = 0x00008
AND    (SUB.subclientStatus & 0x00008) = 0x00008
		) tempStore
GROUP BY Bguid
FOR XML path('backupset'), ROOT('Indexing_AppGetCloudLaptopConfig'))
IF @outXML IS NULL
BEGIN
	SET @outXML = N'<Indexing_AppGetCloudLaptopConfig/>'
END
SELECT @outXML

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudLaptopConfig')
	delete from GxQscripts where name = 'AppGetCloudLaptopConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudLaptopConfig')
	delete from GXDBVersions where aliasname = 'AppGetCloudLaptopConfig'
GO

insert into GXDBVersions values(2, 'AppGetCloudLaptopConfig',  '00000000000000000000', 'AppGetCloudLaptopConfig', '00000000000000000000')
GO

