

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCloudIds <<<'

IF EXISTS (select * from sysobjects where name='AppGetCloudIds')
	drop procedure AppGetCloudIds
IF EXISTS (select * from GxQscripts where name='AppGetCloudIds')
	delete from GxQscripts where name = 'AppGetCloudIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudIds')
	delete from GXDBVersions where aliasname = 'AppGetCloudIds'
GO
print '... Creating Procedure: AppGetCloudIds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudIds
  @i_subclientId integer,
  @i_backupSetId integer,
  @i_fromTime integer,
  @i_endTime integer,
  @i_isCICheck integer
AS
  DECLARE @o_archGrpId integer
  DECLARE @o_cloudId integer
  DECLARE @o_engineType nvarchar(max) 
SELECT
		   appClouds.archGroupId,
		   CASE WHEN CHARINDEX('SOLR', acp.stringVal) = 0 THEN -1
				ELSE appClouds.cloudId END,
		   acp.stringVal
FROM
		   (
				SELECT appId, archGroupId, cloudId
				FROM ArchFile(NOLOCK)
				WHERE appId IN(SELECT id FROM App_Application(NOLOCK) WHERE ((@i_backupSetId = 0 OR backupSet = @i_backupSetId) AND (@i_subclientId = 0 OR id = @i_subclientId)))
				AND cloudId > 0
				AND ( (@i_isCICheck = 0 AND (@i_fromTime = 0 OR cTime >= @i_fromTime) AND (@i_endTime = 0 OR cTime <= @i_endTime) )
					 OR (@i_isCICheck = 1 AND (@i_fromTime = 0 OR contentIndexTime >= @i_fromTime) AND (@i_endTime = 0 OR contentIndexTime <= @i_endTime) ))
				GROUP BY appId, archGroupId, cloudId
		   ) appClouds,
		   App_ComponentProp(NOLOCK) acp
WHERE
		   appClouds.cloudId = acp.componentId AND
		   acp.modified = 0 AND
acp.propertyTypeId = 1014
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudIds')
	delete from GxQscripts where name = 'AppGetCloudIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudIds')
	delete from GXDBVersions where aliasname = 'AppGetCloudIds'
GO

insert into GXDBVersions values(2, 'AppGetCloudIds',  '00000000000000000000', 'AppGetCloudIds', '00000000000000000000')
GO

