

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudId')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudId <<<'
	drop procedure AppGetCloudId
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudId')
	delete from GxQscripts where name = 'AppGetCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudId')
	delete from GXDBVersions where aliasname = 'AppGetCloudId'
GO
print '... Creating Procedure: AppGetCloudId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudId
  @i_subclientId integer,
  @i_backupSetId integer
AS
  DECLARE @o_CIEnabled integer
  DECLARE @o_cloudId integer
  DECLARE @o_engineType nvarchar(max) 
DECLARE @i_shouldSelectOutput INT = 0
IF OBJECT_ID('tempdb.dbo.#AppGetCloudIdOutTable') IS NULL
BEGIN
	SET @i_shouldSelectOutput = 1
	CREATE TABLE #AppGetCloudIdOutTable(     CIEnabled integer, cloudId integer, engineType nvarchar(max) )
END
-- variable to hold the VM CI policy details
DECLARE @vm_IndexServerPseudoClientId INT
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
SELECT     @o_CIEnabled = ISNULL(archContentIndexingRules.enabled, 0), @o_cloudId = ISNULL(archContentIndexingRules.cloudId, 0), @o_engineType=cp.stringVal
FROM         archContentIndexingRules WITH (NOLOCK) INNER JOIN
                      archGroup WITH (NOLOCK) ON archContentIndexingRules.archGroupId = archGroup.id INNER JOIN
                      APP_Application WITH (NOLOCK) ON archGroup.id = APP_Application.logArchGrpID AND archGroup.id = APP_Application.dataArchGrpID
INNER JOIN APP_ComponentProp cp WITH (NOLOCK) ON  cp.componentId = archContentIndexingRules.cloudId AND cp.modified = 0 AND propertyTypeId = 1014
AND archContentIndexingRules.operationType = 1
WHERE   (@i_subclientId <> 0 AND APP_Application.id = @i_subclientId) OR (@i_backupSetId <> 0 AND APP_Application.backupSet = @i_backupSetId)
SET @o_CIEnabled = ISNULL(@o_CIEnabled, 0)
IF EXISTS (SELECT * FROM APP_Application WHERE subclientStatus & 0x20000 > 0 AND id = @i_subclientId) -- Check if this is edge subclient
BEGIN
	DECLARE @indexServerRoleName NVARCHAR(MAX) = (SELECT CASE ISNULL(CP.attrVal , 0)
														WHEN 4 THEN 'NFS Index'
														ELSE 'EDGE Drive'
													END
											  FROM APP_Application APP
											  LEFT OUTER JOIN APP_ClientProp CP ON CP.componentNameId = APP.clientId AND CP.attrName = 'System Drive Type'
											  WHERE APP.id = @i_subclientId)
	DECLARE @indexServerClientId INT = 0
	SELECT @indexServerClientId = entityId FROM App_EdgeDriveAssociation AE (NOLOCK) WHERE AE.entityType = 3
							AND  AE.clientId IN (SELECT ClientId FROM APP_Application (NOLOCK) WHERE id = @i_subclientId)
	EXEC DM2GetIndexServers @indexServerRoleName, @indexServerClientId
	SELECT @o_cloudId = ( SELECT TOP 1 cloudId FROM #getIndexServers)
END
ELSE IF EXISTS (SELECT 1 FROM APP_Application WHERE id = @i_subclientId AND appTypeId = 137) -- Check for the Exchange Index
BEGIN
	SET @o_cloudId = (SELECT TOP 1 cloudId From DM2Cloud(NOLOCK)
						WHERE pseudoClientId = ( SELECT TOP 1 CAST(A.attrVal AS INT)
							FROM App_IdaProp(NOLOCK) A, App_IdaName(NOLOCK) B, App_Application(NOLOCK) C
						WHERE A.componentNameId = B.id AND A.attrName = 'OnePass Index Server'
						AND A.modified = 0
						AND C.id = @i_subclientId
						AND C.clientId = B.clientId
						AND C.appTypeId = B.appTypeId))
END
ELSE IF EXISTS (SELECT 1 FROM App_IndexDBInfo(NOLOCK) idxInfo, App_Application(NOLOCK) App
WHERE idxInfo.backupSetId = App.backupSet AND App.id = @i_subclientId and idxDbEngineType = 2 AND appTypeId != 137) -- Check for the FileSystem Index, Cloud PaaS Index, SharePoint Index, OneDrive Index
BEGIN
DECLARE @isClId INT = 0
DECLARE @roleName NVARCHAR(256)
SELECT	@isClId = currentIdxServer,
			@roleName = CASE idxInfo.type
WHEN 200115 THEN 'Cloud PaaS Index'
WHEN 78 THEN ''
WHEN 139 THEN '' -- we dont want to use roleName to get the index servers as role will be added during collection creation only
WHEN 200127 THEN ''
WHEN 200128 THEN ''
WHEN 200118 THEN ''
WHEN 200108 THEN ''
						ELSE 'FileSystem Index' END
	FROM App_IndexDBInfo(NOLOCK) idxInfo, App_Application(NOLOCK) App
	WHERE idxInfo.backupSetId = App.backupSet AND App.id = @i_subclientId and idxDbEngineType = 2 AND appTypeId != 137
	DELETE FROM #getIndexServers
	EXEC DM2GetIndexServers @roleName, @isClId
	SELECT @o_cloudId = ( SELECT TOP 1 cloudId FROM #getIndexServers)
END
ELSE IF EXISTS (SELECT 1 FROM APP_Application WHERE id = @i_subclientId AND appTypeId = 106) -- Check for the Virtual Machine Index
BEGIN
	-- For vsa subclient, we now save idnex server association as a property
	SET @vm_IndexServerPseudoClientId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @i_subclientId AND attrName = N'Associated index server id' AND modified = 0 AND cs_attrName=CHECKSUM(N'Associated index server id')), 0)
	-- Fetch the cloud id using the index server id
	SET @o_cloudId = (SELECT TOP 1 cloudId From DM2Cloud(NOLOCK) WHERE pseudoClientId=@vm_IndexServerPseudoClientId)
END
ELSE
BEGIN
IF @o_cloudId IS NULL
	SET @o_cloudId = 0
ELSE if CHARINDEX('SOLR',@o_engineType) = 0
	SET @o_cloudId = -1
END
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL    DROP TABLE #getIndexServers
INSERT INTO #AppGetCloudIdOutTable SELECT @o_CIEnabled , @o_cloudId ,@o_engineType
IF ( @i_shouldSelectOutput =1)
BEGIN
	SELECT CT.CIEnabled as CIEnabled, CT.cloudId as cloudId,CT.engineType as engineType from #AppGetCloudIdOutTable CT
	DROP TABLE #AppGetCloudIdOutTable
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudId')
	delete from GxQscripts where name = 'AppGetCloudId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudId')
	delete from GXDBVersions where aliasname = 'AppGetCloudId'
GO

insert into GXDBVersions values(2, 'AppGetCloudId',  '00000000000000000000', 'AppGetCloudId', '00000000000000000000')
GO

