

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudDetails.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudDetails.sp,v $ $Id: AppGetCloudDetails.sp,v 1.5.14.9 2018/02/16 06:38:27 bkharabe Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetCloudDetails   - Get cloud details
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCloudDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetCloudDetails')
	drop procedure AppGetCloudDetails
IF EXISTS (select * from GxQscripts where name='AppGetCloudDetails')
	delete from GxQscripts where name = 'AppGetCloudDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudDetails')
	delete from GXDBVersions where aliasname = 'AppGetCloudDetails'
GO
print '... Creating Procedure: AppGetCloudDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_cloudId integer
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @o_XMLStr XML = '<EvGui_FASTCloudGetPropsResp/>'
 --SOLR CLOUD
  IF EXISTS (SELECT * FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE CloudId = @i_cloudId)
  BEGIN
	--Show storage policy association with search engine
	DECLARE @tmpAssociatedSP TABLE (
				 t_archGrpId integer,
				 t_archGrpName NVARCHAR(1024)
				 )
	INSERT INTO @tmpAssociatedSP (t_archGrpId, t_archGrpName)
	SELECT R.archGroupId,  AG.name
	FROM archContentIndexingRules R WITH (NOLOCK)
	INNER JOIN archGroup AG WITH (NOLOCK)
	ON R.archGroupId = AG.id
WHERE R.cloudId = @i_cloudId AND enabled = 1 AND R.operationType = 1
--GET SEARCH ENGINE CONFIGURATION AT CLOUD LEVEL
DECLARE @tmpCIConfigs TABLE (
				 t_keyName NVARCHAR(512),
				 t_keyValue NVARCHAR(1024)
				 )
INSERT INTO @tmpCIConfigs
SELECT keyName, value
FROM APP_AdvanceSettings ST  (NOLOCK)
WHERE ST.entityId= @i_cloudId and ST.entityType =168 --SEARCH_ENGINE_ENTITY
AND ST.keyName IN  ('solr.extract.ifGeneratePreview','solr.extract.DQConfigForContentChain')
--PROC_EXIT:
	SET @o_XMLStr = ISNULL (
							(SELECT
								(SELECT
									MAX(CP.Id) AS '@id',
									MAX(CP.stringVal) AS '@name'
									FOR XML PATH('fastCloud'), TYPE
								),
								(SELECT
									(SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1001)
									AS '@description',
									SUM(S.failedItems) AS '@failedObjects',
									SUM(S.skippedItems) AS '@skippedObjects',
									SUM(S.CollectionSize) AS '@successfulObjects',
									(SELECT TOP 1 longVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1024)
									AS '@supportLargeFiles',
									SUM(S.CollectionSize + S.skippedItems + S.failedItems) AS '@totalObjects',
									(SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1014)
									 AS '@version'
									FOR XML PATH('fastCloudProps'), TYPE
								),
								(SELECT
									ISNULL((SELECT t_keyValue FROM @tmpCIConfigs WHERE t_keyName = 'solr.extract.ifGeneratePreview'), '0')  AS '@ifGeneratePreview',
									ISNULL((SELECT t_keyValue FROM @tmpCIConfigs WHERE t_keyName = 'solr.extract.DQConfigForContentChain'), '0')  AS '@ifExactKeywordMatch'
									FOR XML PATH('solrParam'), TYPE
								),
								(SELECT
									ISNULL(sp.t_archGrpId,0) AS '@storagePolicyId',
									ISNULL(Sp.t_archGrpName,N'') AS '@storagePolicyName'
									FROM @tmpAssociatedSP SP
									FOR XML PATH('storagePolicyList'), TYPE
								)
							FROM APP_ComponentProp CP WITH (NOLOCK)
								INNER JOIN DM2SearchServerCoreInfo S WITH (NOLOCK) ON CP.id= S.cloudid
							WHERE id= @i_cloudId AND modified = 0
							GROUP BY S.CloudId
							FOR XML PATH('EvGui_FASTCloudGetPropsResp')
							), '<EvGui_FASTCloudGetPropsResp/>')
  END
  ELSE
  BEGIN
 --FAST CLOUD
	SET @o_XMLStr = ISNULL (
							(SELECT
								(SELECT
									CP.Id AS '@id',
									CP.stringVal AS '@name'
									FOR XML PATH('fastCloud'), TYPE
								),
								(SELECT
									(SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1001)
									AS '@description',
									(SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1011)
									AS '@adminURL',
									(SELECT TOP 1 longVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1024)
									AS '@supportLargeFiles',
									ISNULL((SELECT TOP 1 longlongVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1016),40)
									AS '@maxNumberOfBatchSlots',
									ISNULL((SELECT TOP 1 longlongVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1017), 100)
									AS '@maxNumberOfDocsPerBatch',
									(SELECT TOP 1 longlongVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1002)
									AS '@totalObjects',
									(SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1014)
									 AS '@version'	,
											(SELECT
											 ISNULL((SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1020),'')
											AS '@folderName'
											FOR XML PATH('stagingPath'), TYPE
											),
											(SELECT
												 ISNULL((SELECT TOP 1 stringVal FROM APP_ComponentProp WITH (NOLOCK) WHERE componentId = @i_cloudId AND modified=0 AND propertyTypeId = 1021),'')
												AS '@userName'
												FOR XML PATH('credentials'), TYPE
									)
									FOR XML PATH('fastCloudProps'), TYPE
								)
							FROM APP_ComponentProp CP WITH (NOLOCK)
							WHERE id= @i_cloudId AND modified = 0
							FOR XML PATH('EvGui_FASTCloudGetPropsResp')
							), '<EvGui_FASTCloudGetPropsResp/>')
  END
  --------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT @o_XMLStr
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudDetails')
	delete from GxQscripts where name = 'AppGetCloudDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudDetails')
	delete from GXDBVersions where aliasname = 'AppGetCloudDetails'
GO

insert into GXDBVersions values(2, 'AppGetCloudDetails',  '00010005001400090000', 'AppGetCloudDetails', '00010005001400090000')
GO

