

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudDBPseudoClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudDBPseudoClientList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudDBPseudoClientList <<<'
	drop procedure AppGetCloudDBPseudoClientList
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudDBPseudoClientList')
	delete from GxQscripts where name = 'AppGetCloudDBPseudoClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudDBPseudoClientList')
	delete from GXDBVersions where aliasname = 'AppGetCloudDBPseudoClientList'
GO
print '... Creating Procedure: AppGetCloudDBPseudoClientList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudDBPseudoClientList
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_xmlString XML
	DECLARE		@i_userId   		INT = 0
	DECLARE		@i_vendorId			INT = 0
	DECLARE		@i_cloudAppsType	INT = 0
    declare		@i_errorCode		INT = 0
	declare		@s_errorString		NVARCHAR(1024) = N''
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE INDEX getIdaObjects_instanceID_Idx ON #getIdaObjects(instanceID)
	IF OBJECT_ID('tempdb.dbo.#cloudDBClients') IS NOT NULL
		DROP TABLE #cloudDBClients
	CREATE TABLE #cloudDBClients (clientId INT, clientName NVARCHAR(1024), displayName NVARCHAR(1024), memberServersStr NVARCHAR(MAX), memberServers XML, isAccessNodeConfigured INT default 0)
	SET @i_userId = ISNULL((select ref.value('@userId','INT')
					FROM @i_xmlString.nodes('/App_CloudAppsClientsRequest/userId')  R(ref)),0)
	SET @i_vendorId = ISNULL((select ref.value('@vendor','INT')
					FROM @i_xmlString.nodes('/App_CloudAppsClientsRequest')  R(ref)),0)
	SET @i_cloudAppsType = ISNULL((select ref.value('@cloudAppsInstance','INT')
					FROM @i_xmlString.nodes('/App_CloudAppsClientsRequest')  R(ref)),0)
	--Get list of instances user has visibility to
EXEC dbo.sec_getIdaObjectsForUser @i_userId, 3, 0, 1, '#getIdaObjects'
	INSERT INTO #cloudDBClients(clientId, clientName, displayName)
	SELECT	DISTINCT C.id, C.name, C.displayName
	FROM	APP_Client	C
		INNER JOIN #getIdaObjects sec
			ON C.id = sec.clientId
		INNER JOIN APP_ClientProp CP
			ON C.id = CP.componentNameId AND CP.attrName = 'Client App Type' AND CP.attrVal = '1' AND CP.modified = 0
		INNER JOIN APP_Application A
			ON A.clientId = C.id
		INNER JOIN APP_InstanceProp IP
			ON A.instance = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
	WHERE	@i_vendorId = 0 OR dbo.MapVSVendorId(CAST(IP.attrVal AS INT), -1) = @i_vendorId
	IF @i_cloudAppsType = 17  -- Vendor:'Microsoft Azure' and Database Engine:'SQL Server'
	BEGIN
		INSERT INTO #cloudDBClients(clientId, clientName, displayName)
		SELECT	DISTINCT C.id, C.name, C.displayName
		FROM	APP_Client	C
			INNER JOIN #getIdaObjects sec
				ON C.id = sec.clientId AND C.id NOT IN (select clientId from #cloudDBClients) --Filter duplicate entries
			INNER JOIN APP_IDAName I
ON I.clientId = C.id AND I.appTypeId = 81
			INNER JOIN APP_ClientProp CP
				ON C.id = CP.componentNameId AND CP.attrName = 'Cloud Hypervisor Type' AND CP.attrVal IN ('401','402') AND CP.modified = 0
	END
	IF @i_cloudAppsType = 16  -- Vendor:'Amazon' and Database Engine:'SQL Server'
	BEGIN
		INSERT INTO #cloudDBClients(clientId, clientName, displayName)
		SELECT	DISTINCT C.id, C.name, C.displayName
		FROM	APP_Client	C
			INNER JOIN #getIdaObjects sec
				ON C.id = sec.clientId AND C.id NOT IN (select clientId from #cloudDBClients) --Filter duplicate entries
			INNER JOIN APP_IDAName I
ON I.clientId = C.id AND I.appTypeId = 81
			INNER JOIN APP_ClientProp CP
				ON C.id = CP.componentNameId AND CP.attrName = 'Cloud Hypervisor Type' AND CP.attrVal IN ('301') AND CP.modified = 0
	END
	IF (@i_cloudAppsType <> 0)
	BEGIN
		DELETE #cloudDBClients
		WHERE	clientId IN (
			SELECT A.clientId
			FROM APP_Application A
				INNER JOIN APP_InstanceProp IP
					ON A.instance = IP.componentNameId
					AND IP.attrName = 'Cloud Apps Instance Type'
					AND IP.modified = 0
					AND IP.attrVal = @i_cloudAppsType
		)
	END
	--- check if chosen cloud account has valid access nodes
	--- 1. load memberServers xml from app_clientprop table
	--- 2. store mapping of cloud account and access node ids (expand client group to get client id)
	--- 3. determine the list of acceptable packages id's required to be installed on access nodes
	--- 4. delete accessNodes if requrired packages are not installed
	--- 5. delete access nodes with deleted or deconfigured required agents
	DECLARE @accessNodesClientList TABLE(clientId INT, accessNodeId INT)
	DECLARE @packagesList TABLE(packageId INT)
	DECLARE @appTypeId INT = 106
	UPDATE dbCls
	SET dbCls.memberServersStr = cp.attrVal
	FROM #cloudDBClients dbCls
	INNER JOIN App_ClientProp cp WITH (NOLOCK) ON dbCls.clientId = cp.componentNameId
	AND cp.attrName = 'Vs Member Servers' AND cp.modified = 0
	UPDATE #cloudDBClients SET memberServersStr = REPLACE(memberServersStr, 'UTF-8', 'UTF-16') WHERE memberServersStr IS NOT NULL
	UPDATE #cloudDBClients SET memberServers = CAST(memberServersStr AS XML) WHERE memberServersStr IS NOT NULL
	INSERT INTO @accessNodesClientList
	SELECT dbCl.clientId, r.i.value('client[1]/@clientId', 'INT')
	FROM #cloudDBClients dbCl
	CROSS APPLY memberServers.nodes('App_MemberServers/memberServers') r(i)
	INNER JOIN #getIdaObjects sec ON sec.clientId = r.i.value('client[1]/@clientId', 'INT')
	INSERT INTO @accessNodesClientList
	SELECT dbCl.clientId, cg.clientId
	FROM #cloudDBClients dbCl
	CROSS APPLY memberServers.nodes('App_MemberServers/memberServers') r(i)
	INNER JOIN APP_ClientGroupAssoc cg WITH (NOLOCK) ON cg.clientGroupId = r.i.value('client[1]/@clientGroupId', 'INT')
	INNER JOIN #getIdaObjects sec ON sec.clientId = cg.clientId
	IF @i_cloudAppsType = 23 -- cosmos db
	BEGIN
SET @appTypeId = 134 -- cloud apps
INSERT INTO @packagesList VALUES (1140), (730), (1136), (713)
	END
	ELSE
INSERT INTO @packagesList VALUES (1136) , (713)
	-- Backup Proxy List : delete clients with no selected packages.
IF @appTypeId = 134 AND @i_cloudAppsType = 23
		-- in case of cosmos db select access nodes with both cloud apps and vsa package
		DELETE C FROM @accessNodesClientList C
		INNER JOIN (
			   SELECT E.accessNodeId, E.clientId, COUNT(sim.simPackageID) AS pkgCount FROM @accessNodesClientList E
			   INNER JOIN simInstalledPackages sim ON E.accessNodeId = sim.ClientId
			   WHERE sim.simPackageID IN (SELECT packageID FROM @packagesList)
			   GROUP BY E.accessNodeId, E.clientId
		) T ON T.accessNodeId = C.accessNodeId AND T.pkgCount < 2
	ELSE
		DELETE @accessNodesClientList WHERE accessNodeId NOT IN (SELECT E.accessNodeId FROM @accessNodesClientList E, @packagesList PKGLIST, simInstalledPackages SIP WHERE
		E.accessNodeId = SIP.ClientId AND SIP.simPackageID = PKGLIST.packageID)
	-- Backup Proxy List : So delete clients with deconfigured/deleted selected agents.
	DELETE @accessNodesClientList WHERE accessNodeId IN (SELECT E.accessNodeId FROM  @accessNodesClientList E JOIN App_IdaName Ida ON
	E.accessNodeId = Ida.ClientId WHERE Ida.appTypeId = @appTypeId and (status & 4) = 4)
	UPDATE dbCls
	SET dbCls.isAccessNodeConfigured = 1
	FROM #cloudDBClients dbCls
	INNER JOIN @accessNodesClientList an ON an.clientId = dbCls.clientId
	SET @o_xmlString =
	(
		SELECT
		(	SELECT	C.isAccessNodeConfigured as '@isAccessNodeConfigured',
					C.clientId AS 'client/@clientId',
					C.clientName AS 'client/@clientName',
					C.displayName AS 'client/@displayName'
			FROM #cloudDBClients AS C for XML PATH('CloudAppsClientsList'), TYPE)
		FOR XML PATH(''), ROOT('App_CloudAppsClientsResponse')
	)
	IF (@o_xmlString IS NULL)
		SET @o_xmlString = '<App_CloudAppsClientsResponse />'
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	IF OBJECT_ID('tempdb.dbo.#cloudDBClients') IS NOT NULL
		DROP TABLE #cloudDBClients
SELECT @o_xmlString AS 'o_xmlString'
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudDBPseudoClientList')
	delete from GxQscripts where name = 'AppGetCloudDBPseudoClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudDBPseudoClientList')
	delete from GXDBVersions where aliasname = 'AppGetCloudDBPseudoClientList'
GO

insert into GXDBVersions values(2, 'AppGetCloudDBPseudoClientList',  '00000000000000000000', 'AppGetCloudDBPseudoClientList', '00000000000000000000')
GO

