

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudCollectionInfoEx.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudCollectionInfoEx.sp,v $ $Id: AppGetCloudCollectionInfoEx.sp,v 1.1.2.2 2020/06/26 12:15:30 sjanakiraman Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetCloudCollectionInfoEx()
--  |
--  | Description:  Returns cloudId, collectionName, multiNodeDataSourceId and schemaVersion for input criteria.
--  |       - criteria can be either datasourceId or combination of multiple DataSourceProperty  (like sourceType, subsourcetype, backupsetguid)
--	|
--  |       Input:  datasourceId or multiple datasource properties, option tableoutput
--	|
--  |      Output:  cloudId,collectionName,multiNodeDataSourceId and schemaVersion matching input criteria
--  |
--  +========================================================================+
--DefineIdListType.spb
IF NOT EXISTS (SELECT * FROM systypes where name = 'IdList')
BEGIN
CREATE TYPE IdList AS TABLE
  (
      id integer
  )
END
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudCollectionInfoEx')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudCollectionInfoEx <<<'
	drop procedure AppGetCloudCollectionInfoEx
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudCollectionInfoEx')
	delete from GxQscripts where name = 'AppGetCloudCollectionInfoEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudCollectionInfoEx')
	delete from GXDBVersions where aliasname = 'AppGetCloudCollectionInfoEx'
GO
print '... Creating Procedure: AppGetCloudCollectionInfoEx'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudCollectionInfoEx
  @i_cloudId INT = '',
  @i_sourceType VARCHAR(24) = '',
  @i_subSourceType VARCHAR(24) = '',
  @i_datasourceId INT = 0, 	
  @i_propertyName1 VARCHAR(512) = '',
  @i_propertyValue1 VARCHAR(512) = '',
  @i_propertyName2 VARCHAR(512) = '',
  @i_propertyValue2 VARCHAR(512) = '',
  @i_shouldSelectOutput INT = 1,
  @i_flattenCvNode INT = 0,
  @i_dataSourceIds IdList READONLY
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTbl
	CREATE TABLE #getCollectionInfoOutTbl
	(
        DatasourceId INT,
		CloudId INT,
		CollectionName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
        IdxServerClientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTblSearch') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTblSearch
	CREATE TABLE #getCollectionInfoOutTblSearch
	(
        DatasourceId INT,
		CloudId INT,
		CollectionName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
        IdxServerClientId INT,
		multiNodeDataSourceId INT,
		schemaVersion INT
	)
	DECLARE @l_schemaVersionPropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid = 'C973E447-14F9-46C4-A987-CB98398023FC')
	DECLARE @l_multiNodeDSIdPropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid = 'B2A95D3F-73F1-42DB-8419-382C2241ABAC')
	exec AppGetCloudCollectionInfo @i_cloudId, @i_sourceType, @i_subSourceType, @i_datasourceId, @i_propertyName1, @i_propertyValue1, @i_propertyName2, @i_propertyValue2, @i_shouldSelectOutput=0, @i_dataSourceIds=@i_dataSourceIds
	INSERT INTO #getCollectionInfoOutTblSearch
	SELECT T.DatasourceId, T.CloudId, T.CollectionName, T.SourceType, T.SubsourceType, T.IdxServerClientId ,
	multiNodeDataSourceId = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = T.DataSourceId AND DSP.PropertyId = @l_multiNodeDSIdPropId),
	schemaVersion = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = T.DataSourceId AND DSP.PropertyId = @l_schemaVersionPropId)
	from #getCollectionInfoOutTbl T
	select * from #getCollectionInfoOutTblSearch
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTbl
	IF OBJECT_ID('tempdb.dbo.#etCollectionInfoOutTblSearch') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTblSearch
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudCollectionInfoEx')
	delete from GxQscripts where name = 'AppGetCloudCollectionInfoEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudCollectionInfoEx')
	delete from GXDBVersions where aliasname = 'AppGetCloudCollectionInfoEx'
GO

insert into GXDBVersions values(2, 'AppGetCloudCollectionInfoEx',  '00010001000200020000', 'AppGetCloudCollectionInfoEx', '00010001000200020000')
GO

