

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudCollectionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetCloudCollectionInfo.sp,v $ $Id: AppGetCloudCollectionInfo.sp,v 1.1.4.12 2020/09/24 13:30:53 canand Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetCloudCollectionInfo()
--  |
--  | Description:  Returns cloudId and collectionName for input criteria.
--  |       - criteria can be either datasourceId or combination of multiple DataSourceProperty  (like sourceType, subsourcetype, backupsetguid)
--	|
--  |       Input:  datasourceId or multiple datasource properties, option tableoutput
--	|
--  |      Output:  cloudId and collectionName matching input criteria
--  |
--  +========================================================================+
IF NOT EXISTS (SELECT * FROM systypes where name = 'IdList')
BEGIN
CREATE TYPE IdList AS TABLE
  (
      id integer
  )
END
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudCollectionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudCollectionInfo <<<'
	drop procedure AppGetCloudCollectionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudCollectionInfo')
	delete from GxQscripts where name = 'AppGetCloudCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudCollectionInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudCollectionInfo'
GO
print '... Creating Procedure: AppGetCloudCollectionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudCollectionInfo
  @i_cloudId INT = '',
  @i_sourceType VARCHAR(24) = '',
  @i_subSourceType VARCHAR(24) = '',
  @i_datasourceId INT = 0, 	
  @i_propertyName1 VARCHAR(512) = '',
  @i_propertyValue1 VARCHAR(512) = '',
  @i_propertyName2 VARCHAR(512) = '',
  @i_propertyValue2 VARCHAR(512) = '',
  @i_shouldSelectOutput INT = 1,
  @i_flattenCvNode INT = 0,
  @i_dataSourceIds IdList READONLY,
  @i_fetchMultiNodeFederatedDsOnly TINYINT = 0
AS
  DECLARE @o_datasourceId integer;
  DECLARE @o_cloudId integer;
  DECLARE @o_collectionName varchar(128);
  DECLARE @o_sourceType varchar(128);
  DECLARE @o_subsourceType varchar(128);
BEGIN
		/*
			Input:
				DataSourceId, if known
				Else, combination of datasource property and cloudId can be used.
			OutPut:
				DataSourceId,
				CloudId,
				CollectionName,
				SourceType,
				SubsourceType
			Operation:
				- Create final datasourceIdTable, on which we generate output table
				-	IF( DataSourceId > 0 )
				-		Insert into the table
				-	Else,
						- Create criteriaTemptable (DataSourceId, cloudCriteria and PropertyCriteria)
						- Populate temp table with cloud criteria, if cloudId is populated
						- If property is populated, then use merge to update/insert temp table with property bit enabled
						- populate final datasourceId table, based on the criteria bit flag
				- Based on final datasourceIdTable, generate the output temp table
		*/
	-- Output tables.
	IF @i_shouldSelectOutput = 1          -- Caller has not created output table.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
			DROP TABLE #getCollectionInfoOutTbl
		CREATE TABLE #getCollectionInfoOutTbl
		(
            DatasourceId INT,
			CloudId INT,
			CollectionName VARCHAR(128),
			SourceType VARCHAR(30),
			SubsourceType VARCHAR(30),
			IdxServerClientId INT
		)
	END
	IF OBJECT_ID('tempdb.dbo.#tempDataSourceTbl') IS NOT NULL
		DROP TABLE #tempDataSourceTbl
	CREATE TABLE #tempDataSourceTbl
	(
		DataSourceId INT
	)
	CREATE INDEX Idx_tempDataSourceTbl_DataSourceId on #tempDataSourceTbl(DataSourceId)
	DECLARE @l_sourceTypePropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyName = 'sourcetype')
	DECLARE @l_subSourceTypePropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyName = 'subsourcetype')
	IF(@i_datasourceId > 0)
	BEGIN
		INSERT INTO #tempDataSourceTbl
		SELECT @i_datasourceId
	END
	ELSE IF EXISTS (SELECT 1 FROM @i_dataSourceIds)
	BEGIN
		INSERT INTO #tempDataSourceTbl SELECT id from @i_dataSourceIds
	END
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tempInputCriteriaDataSourceTbl') IS NOT NULL
			DROP TABLE #tempInputCriteriaDataSourceTbl
		CREATE TABLE #tempInputCriteriaDataSourceTbl
		(
			DataSourceId INT,
			CloudCriteria BIT DEFAULT 0,
			PropertyCriteria BIT DEFAULT 0
		)
		CREATE INDEX Idx_tempInputCriteriaDataSourceTbl_DataSourceId on #tempInputCriteriaDataSourceTbl(DataSourceId);
		IF OBJECT_ID('tempdb.dbo.#tempPropertyInfo') IS NOT NULL
			DROP TABLE #tempPropertyInfo
		CREATE TABLE #tempPropertyInfo
		(
			PropertyId	INT PRIMARY KEY,
			PropertyName VARCHAR(128),
			PropertyValue VARCHAR(256)
		)
		CREATE INDEX Idx_PropertyId on #tempPropertyInfo(PropertyId)
		--add cloud information
		IF(@i_cloudId > 0)
		BEGIN
			INSERT INTO #tempInputCriteriaDataSourceTbl (DataSourceId,  CloudCriteria)
			SELECT DS.DataSourceId, 1 FROM SEDataSource DS WITH (NOLOCK)
				INNER JOIN SECollectionInfo CI WITH (NOLOCK)
			ON DS.CoreId = CI.CoreId AND CI.CloudID = @i_cloudId
		END
		--populate properties
		IF(ISNULL(@i_sourceType,'') != '')
			INSERT INTO #tempPropertyInfo
			SELECT @l_sourceTypePropId, 'sourcetype', @i_sourceType
		IF(ISNULL(@i_subSourceType,'') != '' AND @i_sourceType != @i_subSourceType)
			INSERT INTO #tempPropertyInfo
			SELECT @l_subSourceTypePropId, 'subsourcetype', @i_subSourceType
		IF(ISNULL(@i_propertyValue1,'') != '' AND ISNULL(@i_propertyName1,'') !='' AND
			NOT EXISTS( SELECT TOP 1 1 FROM #tempPropertyInfo WHERE PropertyName = @i_propertyName1))
			INSERT INTO #tempPropertyInfo
			SELECT PropertyId,PropertyName,@i_propertyValue1 FROM SEProperty WHERE PropertyName = @i_propertyName1
		IF(ISNULL(@i_propertyValue2,'') != '' AND ISNULL(@i_propertyName2,'')!='' AND
		NOT EXISTS( SELECT TOP 1 1 FROM #tempPropertyInfo WHERE PropertyName = @i_propertyName2))
			INSERT INTO #tempPropertyInfo
			SELECT PropertyId,PropertyName,@i_propertyValue2 FROM SEProperty WHERE PropertyName = @i_propertyName2
		IF EXISTS (SELECT 1 FROM #tempPropertyInfo)
		BEGIN
			--update proper criteria flag
			--
			DECLARE @backupSetGuidPropertyId INT  = ISNULL( (SELECT PropertyId FROM  SEProperty  WHERE PropertyName = 'backupsetguid'),0)
			Merge #tempInputCriteriaDataSourceTbl as T
			USING (
				SELECT DISTINCT DSP.DataSourceId
		FROM SEDataSourceProperty AS DSP WITH (NOLOCK)
				INNER JOIN #tempPropertyInfo AS T ON DSP.PropertyId = T.PropertyId
				AND (DSP.PropertyValue =T.PropertyValue
						OR (DSP.PropertyId = @backupSetGuidPropertyId
							AND DSP.PropertyValue = 'BackupSetGuid_XML_Property'
							AND dbo.isBackupSetGuidExists(DSP.DataSourceId,T.PropertyValue) = 1)
					 )
		GROUP BY DSP.DataSourceId HAVING COUNT(*) = (SELECT COUNT(*) FROM #tempPropertyInfo)
				) AS S
			ON (T.DataSourceId = S.DataSourceId)
			WHEN NOT MATCHED BY TARGET
				THEN INSERT (DataSourceId,PropertyCriteria) VALUES (S.DataSourceId, 1)
			WHEN MATCHED
				THEN UPDATE SET T.PropertyCriteria = 1 ;
	END
		IF @i_flattenCvNode = 0
		BEGIN
			INSERT INTO #tempDataSourceTbl
			SELECT T.DataSourceId FROM #tempInputCriteriaDataSourceTbl as T
			LEFT JOIN SEDataSourceRoute SER ON T.DataSourceId = SER.DataSourceId OR SER.FederatedDataSourceId = T.DataSourceId
			WHERE (@i_cloudId = 0 OR T.CloudCriteria = 1) AND
				  ( NOT EXISTS (SELECT 1 FROM #tempPropertyInfo) OR T.PropertyCriteria = 1) AND
					SER.DataSourceId IS NULL
		END
		ELSE
		BEGIN
			INSERT INTO #tempDataSourceTbl
			SELECT T.DataSourceId FROM #tempInputCriteriaDataSourceTbl as T
			WHERE (@i_cloudId = 0 OR T.CloudCriteria = 1) AND
				  ( NOT EXISTS (SELECT 1 FROM #tempPropertyInfo) OR T.PropertyCriteria = 1)
		END
		--drop of the tables
		IF OBJECT_ID('tempdb.dbo.#tempPropertyInfo') IS NOT NULL
			DROP TABLE #tempPropertyInfo
		IF OBJECT_ID('tempdb.dbo.#tempInputCriteriaDataSourceTbl') IS NOT NULL
			DROP TABLE #tempInputCriteriaDataSourceTbl
	END
	IF @i_fetchMultiNodeFederatedDsOnly = 1
	BEGIN
		DECLARE @multinodeDSTypeId INT = (SELECT TypeId FROM SEDataSourceType WITH(NOLOCK) WHERE TypeGuid = '04854E90-76E5-47D2-8C7F-28026DAABCC6')
		DELETE DS FROM #tempDataSourceTbl DS, SEDataSource SEDS WITH(NOLOCK)
		WHERE DS.DataSourceId = SEDS.DataSourceId AND SEDS.DataSourceType <> @multinodeDSTypeId
	END
	INSERT INTO #getCollectionInfoOutTbl
	SELECT DISTINCT DS.DataSourceId, CI.CloudID, CI.ActualCoreName,
		SourceType = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = DS.DataSourceId AND DSP.PropertyId = @l_sourceTypePropId),
		SubSourceType = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = DS.DataSourceId AND DSP.PropertyId = @l_subSourceTypePropId),
		CI.ClientId
	FROM SEDataSource DS
		INNER JOIN #tempDataSourceTbl AS T ON T.DataSourceId = DS.DataSourceId
		INNER JOIN SECollectionInfo CI ON DS.CoreId = CI.CoreId
	IF OBJECT_ID('tempdb.dbo.#tempDataSourceTbl') IS NOT NULL
		DROP TABLE #tempDataSourceTbl
	IF @i_shouldSelectOutput = 1
		SELECT * FROM #getCollectionInfoOutTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudCollectionInfo')
	delete from GxQscripts where name = 'AppGetCloudCollectionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudCollectionInfo')
	delete from GXDBVersions where aliasname = 'AppGetCloudCollectionInfo'
GO

insert into GXDBVersions values(2, 'AppGetCloudCollectionInfo',  '00010001000400120000', 'AppGetCloudCollectionInfo', '00010001000400120000')
GO

