

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppsPseudoClients.sp] ---------- 

-- 	+--------------------------------------------------------------------------------------------------------+
--	 			Procedure : "AppGetCloudAppsPseudoClients"
--
--	Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--	This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
--	evidence any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetCloudAppsPseudoClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetCloudAppsPseudoClients')
	drop procedure AppGetCloudAppsPseudoClients
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppsPseudoClients')
	delete from GxQscripts where name = 'AppGetCloudAppsPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsPseudoClients')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsPseudoClients'
GO
print '... Creating Procedure: AppGetCloudAppsPseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudAppsPseudoClients
  @instanceType INT,
  @i_userId INT,
  @capabilities_bigint BIGINT
AS
  DECLARE @Client_id INT
--create a table to store all client ids
IF OBJECT_ID('tempdb.dbo.#ListClientIdTbl') IS NOT NULL	DROP TABLE #ListClientIdTbl
CREATE TABLE #ListClientIdTbl (Client_id INT)
--get all clients
INSERT INTO #ListClientIdTbl
SELECT id FROM APP_Client WHERE id IN
(
	SELECT Distinct clientId FROM APP_Application A INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId
		WHERE appTypeId = 134 /*PROPERTY_CLOUD_APPS*/ AND
		attrName = 'Cloud Apps Instance Type' AND I.modified = 0 AND
		attrVal=@instanceType
)
--Get Security Associations
IF OBJECT_ID('tempdb.dbo.#CloudAppsPseudoClientList_tmp__AssociatedObjects') IS NOT null
DROP TABLE #CloudAppsPseudoClientList_tmp__AssociatedObjects
create table  #CloudAppsPseudoClientList_tmp__AssociatedObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2009, 0, '#CloudAppsPseudoClientList_tmp__AssociatedObjects'
--get commcell level association
DECLARE @isCommcellLevelAssociation int = 0
SELECT @isCommcellLevelAssociation=1 from #CloudAppsPseudoClientList_tmp__AssociatedObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
IF @capabilities_bigint <> 0 AND @isCommcellLevelAssociation = 0
BEGIN
	--delete all client who dont has capability
	DELETE FROM #CloudAppsPseudoClientList_tmp__AssociatedObjects WHERE capabilities & @capabilities_bigint = 0
	--return list of clients
	select Client_id from #ListClientIdTbl lst join  #CloudAppsPseudoClientList_tmp__AssociatedObjects clpt ON lst.Client_id = clpt.clientId
END
ELSE
BEGIN
	--if capability check not set or Commcell level capabilities then return all clients
	select Client_id from #ListClientIdTbl
END
IF OBJECT_ID('tempdb.dbo.#CloudAppsPseudoClientList_tmp__AssociatedObjects') IS NOT null
	DROP TABLE #CloudAppsPseudoClientList_tmp__AssociatedObjects
IF OBJECT_ID('tempdb.dbo.#ListClientIdTbl') IS NOT NULL	DROP TABLE #ListClientIdTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppsPseudoClients')
	delete from GxQscripts where name = 'AppGetCloudAppsPseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsPseudoClients')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsPseudoClients'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppsPseudoClients',  '00000000000000000000', 'AppGetCloudAppsPseudoClients', '00000000000000000000')
GO

