

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppsConnectionDetails.sp] ---------- 

-- 	+--------------------------------------------------------------------------------------------------------+
--	 			Procedure : "AppGetCloudAppsConnectionDetails"
--
--	Copyright (c) 1998  CommVault Systems, Inc. All rights reserved.
--
--	This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
--	evidence any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudAppsConnectionDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudAppsConnectionDetails <<<'
	drop procedure AppGetCloudAppsConnectionDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppsConnectionDetails')
	delete from GxQscripts where name = 'AppGetCloudAppsConnectionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsConnectionDetails')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsConnectionDetails'
GO
print '... Creating Procedure: AppGetCloudAppsConnectionDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudAppsConnectionDetails
  @clientId INT,
  @o_xml XML  OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @instanceId INT
DECLARE @onedriveclientId NVARCHAR(1024)
DECLARE @onedriveclientSecret NVARCHAR(2048)
DECLARE @onedrivetenant NVARCHAR(1024)
SELECT TOP 1 @instanceId = instance FROM App_application where clientId = @clientId
SELECT @onedriveclientId = [Enterprise App client Id], @onedriveclientSecret = [OneDrive Secret Key]  , @onedrivetenant =  [OneDrive Tenant]
FROM
	( SELECT attrName, attrVal from APP_InstanceProp
		WHERE componentNameId = @instanceId AND modified = 0 AND attrName in ('Enterprise App client Id', 'OneDrive Secret Key' , 'OneDrive Tenant')
	) AS INST
PIVOT
  (
     MAX(attrVal) FOR attrName in ([Enterprise App client Id], [OneDrive Secret Key] , [OneDrive Tenant])
  )  AS PVT
DECLARE @decryptedKey NVARCHAR(1024)
EXEC miscProc2 @onedriveclientSecret ,@decryptedKey OUTPUT
DECLARE @xmlquery XML
SET @xmlquery =
	 ( SELECT @onedriveclientId AS '@clientId',
			@decryptedKey AS '@secretKey',
			@onedrivetenant AS '@tenantId'
	FOR XML PATH('oneDriveDetails'),
	ROOT('CloudAppsConnection'))
SET @o_xml = (select @xmlQuery
	FOR XML PATH(''),ROOT('CloudAppsConnection'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppsConnectionDetails')
	delete from GxQscripts where name = 'AppGetCloudAppsConnectionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsConnectionDetails')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsConnectionDetails'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppsConnectionDetails',  '00000000000000000000', 'AppGetCloudAppsConnectionDetails', '00000000000000000000')
GO

