

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppsClients.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 08/11/2016
-- Description:	To get the list of cloudapps clients. Currently it returns only Gmail and Gdrive type. ONce adminConsole screens are ready for other types the where clause can be edited/removed.
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudAppsClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudAppsClients <<<'
	drop procedure AppGetCloudAppsClients
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppsClients')
	delete from GxQscripts where name = 'AppGetCloudAppsClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsClients')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsClients'
GO
print '... Creating Procedure: AppGetCloudAppsClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudAppsClients
  @i_userId INT,
  @i_cloudappType INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @debug  AS INT = 0
--Get Security Associations
IF OBJECT_ID('tempdb.dbo.#CloudAppsPseudoClientList_tmp__AssociatedObjects') IS NOT null
	DROP TABLE #CloudAppsPseudoClientList_tmp__AssociatedObjects
create table  #CloudAppsPseudoClientList_tmp__AssociatedObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 0, 0, '#CloudAppsPseudoClientList_tmp__AssociatedObjects'
IF @debug = 1 BEGIN
    SELECT 'association', * FROM #CloudAppsPseudoClientList_tmp__AssociatedObjects
END
-- temp table that will hold list of pseudo clients
CREATE TABLE #clientsList
(
	ClientId            INT,
ClientName          NVARCHAR(255)	DEFAULT(''),
ClientDisplayName   NVARCHAR(255)	DEFAULT(''),
ClientHostName      NVARCHAR(255)	DEFAULT(''),
    ClientGUID          UNIQUEIDENTIFIER    NOT null,
	CloudAppsClientType		INT,
	PRIMARY KEY(ClientId, CloudAppsClientType)
)
-- filter out uninstalled and deleted pseudo clients and those where user do not have access
-- 1st, get all clients of a certain type with certain attributes into temporary table
INSERT INTO #clientsList (ClientId, ClientName, ClientDisplayName, ClientHostName,  ClientGUID, CloudAppsClientType)
   select distinct cl.id, CL.name, cl.displayName, CL.net_hostname, CL.GUID, cast(AINProp.attrVal as int)
	from APP_Application APP
	join App_InstanceName AIN on App.instance = AIN.id
	join app_client cl on app.clientId = cl.id
	join App_InstanceProp AINProp on AIN.id = AINProp.componentNameId and AINProp.attrName = 'Cloud Apps Instance Type' and AINProp.modified = 0
	join app_idaname IDA on CL.id = IDA.clientId
	join #CloudAppsPseudoClientList_tmp__AssociatedObjects sec on
	(sec.clientId=cl.id)
	OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	where App.appTypeId = 134
	AND (@i_cloudappType = 0 or ((@i_cloudappType != 0) and AINProp.attrVal = @i_cloudappType) )
AND ((CL.status  & 0x00004)	    = 0)
AND((AIN.status & 0x00002)   = 0)
AND((AIN.status & 0x00004)		= 0)
AND((IDA.status & 0x00002)   = 0)
AND((IDA.status & 0x00004)		= 0)
-- insert Azure/Aws SQL pseudo clients.
INSERT INTO	#clientsList (ClientId, ClientName, ClientDisplayName, ClientHostName,  ClientGUID, CloudAppsClientType)
   select distinct cl.id, CL.name, cl.displayName, CL.net_hostname, CL.GUID, case when clp.attrVal in (401, 402) then 17 when clp.attrVal = 301 then 16 else 0 end
   from app_client cl WITH (NOLOCK)
    join app_clientProp clp WITH (NOLOCK) on cl.id = clp.componentNameId
	join app_idaname IDA WITH (NOLOCK) on cl.id = IDA.clientId
	join #CloudAppsPseudoClientList_tmp__AssociatedObjects sec on
	(sec.clientId=cl.id)
	OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
where IDA.appTypeId = 81
	AND clp.attrName = 'Cloud Hypervisor Type'
	AND (@i_cloudappType = 0 or ((@i_cloudappType = 16 AND clp.attrVal = 301)OR(@i_cloudappType = 17 AND clp.attrVal IN (401, 402))))
AND ((CL.status  & 0x00004)	    = 0)
AND((IDA.status & 0x00002)   = 0)
AND((IDA.status & 0x00004)		= 0)
--DELETE FROM #clientsList WHERE EXISTS (SELECT   attrVal FROM     APP_ClientProp WHERE componentNameId = ClientId AND attrName='platformdeleted 4' AND modified = 0 AND attrVal = '1')
IF @debug = 1 BEGIN
    SELECT 'client', * FROM #clientsList
END
-- 4th. generate xml message
SET @o_xmlText = (SELECT
                    (SELECT
						CL.CloudAppsClientType  AS '@cloudAppsInstanceType',
						(SELECT CL.ClientId                     AS '@clientId',
								CL.ClientName                   AS '@clientName',
								CL.ClientDisplayName            AS '@displayName',
								CL.ClientHostName               AS '@hostName',
								CL.ClientGUID                   AS '@clientGUID'
							FOR XML PATH('client'), TYPE)
                     FROM    #clientsList CL order by CL.ClientDisplayName
                     FOR XML PATH('CloudAppsClientsList'), TYPE)
                FOR XML PATH(''), ROOT('App_CloudAppsClientsResponse'))
-- 5th. clean up
IF OBJECT_ID('tempdb.dbo.#CloudAppsPseudoClientList_tmp__AssociatedObjects') IS NOT null DROP TABLE #CloudAppsPseudoClientList_tmp__AssociatedObjects
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppsClients')
	delete from GxQscripts where name = 'AppGetCloudAppsClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsClients')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsClients'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppsClients',  '00000000000000000000', 'AppGetCloudAppsClients', '00000000000000000000')
GO

