

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppsAzureProperties.sp] ---------- 

--ALLOW COMMENTS BELOW HERE!
----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Saiyam Goel
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudAppsAzureProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudAppsAzureProperties <<<'
	drop procedure AppGetCloudAppsAzureProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppsAzureProperties')
	delete from GxQscripts where name = 'AppGetCloudAppsAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsAzureProperties'
GO
print '... Creating Procedure: AppGetCloudAppsAzureProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudAppsAzureProperties
  @i_clientId INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @instanceId INT = 0
	Declare @instanceType INT = 0
	DECLARE @azureApps NVARCHAR(MAX) = NULL
	DECLARE @serviceAccounts NVARCHAR(MAX) = NULL
	DECLARE @v2MSCloudRegion INT
SET @instanceId = (SELECT TOP 1 instance from APP_Application (NOLOCK) where clientId = @i_clientId AND appTypeId = 134)
	IF @instanceId <=0 OR @instanceId = NULL
	BEGIN
		SET @errorString = 'ERROR : Invalid Instance Id'
		GOTO ERROR_EXIT
	END
	Set @instanceType = (SELECT TOP 1 attrval from APP_InstanceProp(NOLOCK) where componentNameId = @instanceId and attrVal = 'Cloud Apps Instance Type')
	IF @instanceType <=0 OR @instanceType = NULL
	BEGIN
		SET @errorString = 'ERROR : Invalid Instance Type'
		GOTO ERROR_EXIT
	END
	SET @serviceAccounts = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'V2CloudApps Service Accounts' AND modified = 0 AND attrType = 1)
SET @v2MSCloudRegion = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'MSCloud Region Type' AND modified = 0 AND attrType = 7)
	IF @serviceAccounts IS NOT NULL
	SET @serviceAccounts =  REPLACE(@serviceAccounts,'App_V2CloudAppsServiceAccounts','serviceAccounts')
	SET @azureApps = (SELECT attrVal FROM APP_InstanceProp (NOLOCK) WHERE componentNameId = @instanceId AND attrName = 'V2CloudApps Azure Connections' AND modified = 0 AND attrType = 1)
	IF @azureApps IS NOT NULL
	BEGIN
	SET @azureApps =  REPLACE(@azureApps,'App_Office365AzureConnections','azureAppList')
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @o_xmlString =
	(
		SELECT @v2MSCloudRegion '@cloudRegion',
		(
			SELECT CAST( REPLACE(@azureApps,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		),
		(
			SELECT  CAST( REPLACE(@serviceAccounts,'encoding="utf-8"', 'encoding="utf-16"') AS XML)
		)
		FOR XML PATH('App_V2CloudAppsInstance')
	)
ERROR_EXIT:
	IF @o_xmlString IS NULL
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('App_V2CloudAppsInstance')
	)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppsAzureProperties')
	delete from GxQscripts where name = 'AppGetCloudAppsAzureProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsAzureProperties')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsAzureProperties'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppsAzureProperties',  '00000000000000000000', 'AppGetCloudAppsAzureProperties', '00000000000000000000')
GO

