

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppsAccessNodes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppGetCloudAppsAccessNodes							|
--	|		 Procedure to get cloud apps access nodes					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetCloudAppsAccessNodes')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudAppsAccessNodes <<<'
	drop procedure AppGetCloudAppsAccessNodes
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppsAccessNodes')
	delete from GxQscripts where name = 'AppGetCloudAppsAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsAccessNodes')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsAccessNodes'
GO
print '... Creating Procedure: AppGetCloudAppsAccessNodes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetCloudAppsAccessNodes
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inXml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
	DECLARE @outputXml XML = '<Api_GetCloudAppsAccessNodesResp />'
	BEGIN TRY
	DECLARE @instanceType INT = ISNULL(@inXml.value('(/Api_GetCloudAppsAccessNodesReq/@instanceType)[1]', 'INT'), 0)
	DECLARE @userId INT = ISNULL(@inXml.value('(/Api_GetCloudAppsAccessNodesReq/processinginstructioninfo/user/@userId)[1]', 'INT'), 0)
DECLARE @appTypeId INT = ISNULL(@inXml.value('(/Api_GetCloudAppsAccessNodesReq/@appTypeId)[1]', 'INT'), 134) -- 135
	DECLARE @excludeClients INT = ISNULL(@inXml.value('(/Api_GetCloudAppsAccessNodesReq/@excludeClients)[1]', 'INT'), 0)
	DECLARE @excludeClientGroups INT = ISNULL(@inXml.value('(/Api_GetCloudAppsAccessNodesReq/@excludeClientGroups)[1]', 'INT'), 0)
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC dbo.sec_getIdaObjectsForUser @userId, 3, 0, 1, '#getIdaObjects'
	DECLARE @packagesList TABLE(packageId INT)
	DECLARE @accessNodesList TABLE(clientId INT, clientName NVARCHAR(1024), entityType INT, clientGroupId INT, clientGroupName NVARCHAR(1024))
	IF @instanceType = 3 -- Salesforce
INSERT INTO @packagesList VALUES (1140)
	ELSE IF @instanceType = 23 -- CosmosDB
INSERT INTO @packagesList VALUES (1140), (730), (1136), (713)
	ELSE
INSERT INTO @packagesList VALUES (1140), (730)
	IF @instanceType = 23 -- Cosmos DB requires both VSA & Cloud Apps package
		INSERT INTO @accessNodesList(clientId, clientName, entityType)
		SELECT C.id, C.displayName, 3 FROM APP_Client C WITH (NOLOCK)
		INNER JOIN (
			SELECT DISTINCT cl.id, COUNT(simPackageID) AS pkgCount FROM APP_Client cl WITH (NOLOCK)
			INNER JOIN simInstalledPackages sim WITH (NOLOCK) ON sim.ClientId = cl.id
			WHERE sim.simPackageID IN (SELECT packageId FROM @packagesList)
			GROUP BY cl.id
		) T ON T.id = C.id AND T.pkgCount >= 2
	ELSE
		INSERT INTO @accessNodesList(clientId, clientName, entityType)
		SELECT DISTINCT cl.id, cl.displayName, 3 FROM APP_Client cl WITH (NOLOCK)
		INNER JOIN #getIdaObjects ida ON ida.clientId = cl.id
		INNER JOIN simInstalledPackages sim WITH (NOLOCK) ON sim.ClientId = cl.id
		INNER JOIN @packagesList pkg ON sim.simPackageID = pkg.packageId
	DELETE @accessNodesList WHERE clientId IN (SELECT E.clientId FROM  @accessNodesList E JOIN App_IdaName Ida ON
		E.clientId = Ida.ClientId WHERE Ida.appTypeId = @appTypeId and (status & 4) = 4)
	IF @excludeClientGroups <> 1
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#sec_ClientGroups') IS NOT NULL DROP TABLE #sec_ClientGroups
			CREATE TABLE #sec_ClientGroups ( entityId INT  PRIMARY KEY)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28 /*CLIENT_GROUP_ENTITY (28) */ , 31 /* 31 (31) */ ,'#sec_ClientGroups'
		INSERT INTO @accessNodesList(clientGroupId, clientGroupName, entityType)
		SELECT DISTINCT cg.id, cg.name, 28 FROM APP_ClientGroup cg WITH (NOLOCK)
		INNER JOIN #sec_ClientGroups sCg ON sCg.entityId = cg.id
		INNER JOIN APP_ClientGroupAssoc cga WITH (NOLOCK) ON cga.clientGroupId = cg.id
		INNER JOIN @accessNodesList an ON an.clientId = cga.clientId
	END
	IF @excludeClients = 1
DELETE @accessNodesList WHERE entityType = 3
	SET @outputXml = (SELECT (SELECT clientId AS 'entity/@clientId',
								clientName AS 'entity/@clientName',
								entityType AS 'entity/@_type_',
								clientGroupId AS 'entity/@clientGroupId',
								clientGroupName AS 'entity/@clientGroupName'
								FROM @accessNodesList
								FOR XML PATH('accessNodes'), TYPE)
					FOR XML PATH(''), ROOT('Api_GetCloudAppsAccessNodesResp'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @outputXml = (
		SELECT ERROR_NUMBER() AS '@errorCode', ERROR_MESSAGE() AS '@errorMessage'
		FOR XML PATH('Api_GenericResp')
	)
END CATCH
SELECT @outputXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppsAccessNodes')
	delete from GxQscripts where name = 'AppGetCloudAppsAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppsAccessNodes')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppsAccessNodes'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppsAccessNodes',  '00000000000000000000', 'AppGetCloudAppsAccessNodes', '00000000000000000000')
GO

