

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetCloudAppAccounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetCloudAppAccounts')
BEGIN
	print '>>> Drop Stored Procedure: AppGetCloudAppAccounts <<<'
	drop procedure AppGetCloudAppAccounts
END
IF EXISTS (select * from GxQscripts where name='AppGetCloudAppAccounts')
	delete from GxQscripts where name = 'AppGetCloudAppAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppAccounts')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppAccounts'
GO
print '... Creating Procedure: AppGetCloudAppAccounts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetCloudAppAccounts
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE INDEX getIdaObjects_instanceID_Idx ON #getIdaObjects(instanceID)
	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails
	(
		[SubClientId] INT DEFAULT 0,
		[BackupSetId] INT DEFAULT 0,
		[InstanceId] INT,
[InstanceName] NVARCHAR(255),
		[ClientId] INT,
[ClientName] NVARCHAR(255),
[ClientDisplayName] NVARCHAR(255),
		[VendorType] INT,
		[VendorName] NVARCHAR(255) DEFAULT '',
		[LastBackupTime] INT DEFAULT 0,
		[Size] BIGINT DEFAULT 0,
		[SLA] INT DEFAULT 1,
		[Status] INT DEFAULT 0,
		[PlanId] INT DEFAULT '0',
[PlanName] NVARCHAR(255) DEFAULT '',
		[ApplicationSize] BIGINT DEFAULT 0,
		PRIMARY KEY([InstanceId],[ClientId])
	)
	DECLARE @localeId INT = ISNULL((select ref.value('@localeId','INT') FROM @i_xmlString.nodes('/Api_CloudAppAccountsReq/processinginstructioninfo/locale')  R(ref)), 0)
	DECLARE @userId INT = ISNULL((select ref.value('@userId','INT') FROM @i_xmlString.nodes('/Api_CloudAppAccountsReq/processinginstructioninfo/user')  R(ref)), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudAppAccountsReq/@instanceId)[1]','INT')), 0)
	DECLARE @vendorType INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudAppAccountsReq/@vendorType)[1]','INT')), 0)
	DECLARE @propertyLevel INT = ISNULL((SELECT @i_xmlString.value('(/Api_CloudAppAccountsReq/@propertyLevel)[1]','INT')), 10)
	--Get list of instances user has visibility to
	EXEC dbo.sec_getIdaObjectsForUser @userid, 7, 0, 1, '#getIdaObjects' -- 7 = SUBCLIENT_ENTITY from CvEntities.x
	DELETE	#getIdaObjects
WHERE	apptypeId != 134
	-- filter by InstanceId
	IF (@InstanceId <> 0)
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, VendorType, VendorName, Status)
		SELECT	DISTINCT I.id, I.name, C.id, C.name, C.displayName, CAST(IP.attrVal AS INT), ISNULL ( IPD.attrVal, (CASE WHEN CAST(IP.attrVal AS INT) = 33 THEN 'GitHub '
																				WHEN CAST(IP.attrVal AS INT) = 34 THEN 'Azure DevOps'
																				WHEN CAST(IP.attrVal AS INT) = 3 THEN 'Salesforce'
																				ELSE '' END)), I.status
		FROM	#getIdaObjects sec
			INNER JOIN APP_Application A
				ON sec.instanceID = A.instance
			INNER JOIN APP_Client C
ON A.clientId = C.id AND A.appTypeId = 134
			INNER JOIN APP_InstanceName I
				ON I.id = A.instance AND (I.id = @InstanceId)
			INNER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.id AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
			LEFT OUTER JOIN APP_InstanceProp	IPD
				ON IPD.componentNameId = I.id AND IPD.attrName = 'Cloud Apps Instance Display Name' and IPD.modified = 0
		WHERE	IP.attrVal in ('33','34', '3')
AND	(I.status & 0x00004) = 0 AND (I.status & 0x00010) = 0 AND (I.status & 0x00020) = 0 AND (I.status & 0x0800) = 0 AND (I.status & 0x00002) = 0
	END
	ELSE
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, VendorType, VendorName, Status)
		SELECT	DISTINCT I.id, I.name, C.id, C.name, C.displayName, CAST(IP.attrVal AS INT), ISNULL ( IPD.attrVal, (CASE WHEN CAST(IP.attrVal AS INT) = 33 THEN 'GitHub '
																				WHEN CAST(IP.attrVal AS INT) = 34 THEN 'Azure DevOps'
																				WHEN CAST(IP.attrVal AS INT) = 3 THEN 'Salesforce'
																				ELSE '' END)), I.status
		FROM	#getIdaObjects sec
			INNER JOIN APP_Application A
				ON sec.instanceID = A.instance
			INNER JOIN APP_Client C
ON A.clientId = C.id AND A.appTypeId = 134
			INNER JOIN APP_InstanceName I
				ON I.id = A.instance
			INNER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.id AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
			LEFT OUTER JOIN APP_InstanceProp	IPD
				ON IPD.componentNameId = I.id AND IPD.attrName = 'Cloud Apps Instance Display Name' and IPD.modified = 0
		WHERE	IP.attrVal in ('33','34', '3')
AND	(I.status & 0x00004) = 0 AND (I.status & 0x00010) = 0 AND (I.status & 0x00020) = 0 AND (I.status & 0x0800) = 0 AND (I.status & 0x00002) = 0
	END
	--Update plan info
	UPDATE	#ClientInstanceDetails
	SET		PlanId = AP.id,
			PlanName = AP.name
	FROM	#ClientInstanceDetails I
		INNER JOIN APP_InstanceProp IP
ON IP.componentNameId = I.InstanceId  AND IP.attrName = 'Associated Plan' AND IP.modified=0
		LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
	--Salesforce backward compatability (might have multiple instances, pick the first one)
	DELETE FROM #ClientInstanceDetails
    WHERE VendorType = 3 AND InstanceId NOT IN
    (
        SELECT MIN(InstanceId)
        FROM #ClientInstanceDetails
        GROUP BY ClientId
    );
	--For Salesforce get plan details from the subclient
	UPDATE	#ClientInstanceDetails
	SET		PlanId = (CASE PlanId
							WHEN 0 THEN AP.id
							ELSE PlanId
					  END),
			PlanName = (CASE PlanId
							WHEN 0 THEN AP.name
							ELSE PlanName
					  END),
			subclientId = SFSubclient.subclientId,
			backupSetId = SFSubclient.backupsetId
	FROM	#ClientInstanceDetails I
			INNER JOIN (SELECT DISTINCT app.id as subclientId , app.backupSet as backupsetId, app.instance as instanceId
				FROM APP_Application app WITH (NOLOCK)
					INNER JOIN #ClientInstanceDetails CID ON app.instance = CID.InstanceId and app.clientId = CID.ClientId
					LEFT OUTER JOIN APP_BackupSetName bp WITH (NOLOCK) ON app.backupSet = bp.id
				WHERE CID.VendorType = 3
					AND ((app.subclientStatus & 8) = 8) -- Pick default subclient
					AND ((bp.status & 8) = 8) -- Pick default backupset
				) SFSubclient ON I.InstanceId = SFSubclient.instanceId
			LEFT OUTER JOIN APP_SubClientProp SP
				ON SP.componentNameId = SFSubclient.subclientId AND SP.attrName = 'Associated Plan' AND SP.cs_attrName = CHECKSUM(N'Associated Plan') AND SP.modified=0
			LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
				ON CAST(AP.id AS NVARCHAR(32)) = SP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
			WHERE I.VendorType = 3
	--Update SLA status
	/*
	Rules:
	For the instance to meet SLA, all subclients should meet SLA. Or all subclients should be 'Met' or 'Excluded' with at least one 'Met' subclient.
	For the instance to become 'Excluded' all the subclients must be 'Excluded'.
	If at least one subclient misses SLA, then instance misses SLA.
	Check for missed subclients --> if yes, instance is 'Missed' SLA (2)
	Check for excluded subclients --> If excluded = total or no rows in RptSLASubclient, then instance is 'Excluded' SLA (3)
	Else it means there are no missed subclients and at least 1 'Met' subclient. Which means instance 'Met' SLA (1).
	*/
	UPDATE	I
	SET		I.SLA = (CASE WHEN R.missed > 0 THEN 2 WHEN (R.excluded = R.totalSubclients OR R.instanceID IS NULL) THEN 3 ELSE 1 END) -- when all subclients are met or excluded totalSubClients will match, so slaStatus is valid from min operator
	FROM	#ClientInstanceDetails I
		LEFT OUTER JOIN (
				SELECT	SEC.instanceId,
						SUM(CASE WHEN S.status = 1 THEN 1 ELSE 0 END) met,
						SUM(CASE WHEN S.status = 2 THEN 1 ELSE 0 END) missed,
						SUM(CASE WHEN S.status not in (1, 2) THEN 1 ELSE 0 END) excluded,
						COUNT(S.appId) AS totalSubclients
				FROM	RptSLASubclient S INNER JOIN #getIdaObjects SEC on S.appId = SEC.subclientID AND S.clientId = SEC.clientId AND S.fullJobsOnly = 0
				GROUP BY SEC.instanceId) R
		ON	I.InstanceId = R.instanceId
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	CREATE TABLE #lastSuccBackupJob (instanceId INT, backupJobId INT, commCellId INT, servEndDate INT, size BIGINT)
	INSERT INTO #lastSuccBackupJob
	SELECT MAX(InstanceId), MAX(jobId), MAX(commCellID), MAX(servEndDate), SUM(totalUnCompBytes)
	FROM
	(
		SELECT	I.InstanceId, A.id 'subclientId', B.jobId, B.commCellID, B.servEndDate, B.totalUnCompBytes, ROW_NUMBER() OVER (PARTITION BY I.instanceId, A.id  ORDER BY B.servEndDate DESC) AS rowId
		FROM	#ClientInstanceDetails I
			INNER JOIN APP_Application A
				ON I.instanceId = A.instance
			INNER JOIN APP_IdaType IDA
				ON A.appTypeId = IDA.type
			INNER JOIN JMBkpStats B
				ON A.id = B.appId AND (B.status IN (1, 14) OR (B.status = 3 AND IDA.isCWEJobValid = 1))
	) S
	WHERE S.rowId = 1
	GROUP BY InstanceId
	--All agents
	--If we don't have size and backup time already populated, get it from job history
	UPDATE	I
	SET		I.LastBackupTime = (CASE WHEN I.LastBackupTime > 0 THEN I.LastBackupTime ELSE J.servEndDate END),
			I.Size = (CASE WHEN I.Size > 0 THEN I.Size ELSE J.size END)
	FROM	#ClientInstanceDetails I
		INNER JOIN #lastSuccBackupJob J
			ON I.InstanceId = J.instanceId
	WHERE	(I.LastBackupTime = 0 OR I.Size = 0)
	-- all agents
	-- Update Application size
	UPDATE I
	SET I.ApplicationSize = T.appSize
	FROM #ClientInstanceDetails I
	 INNER JOIN (
		SELECT InstanceId, SUM(AppSizeMB)*1024*1024 AS appSize -- to bytes
		FROM (
			SELECT InstanceId, AppsizeMB,
			ROW_NUMBER() OVER(PARTITION BY SubclientId ORDER BY rankOrder ASC) AS rownum
			FROM(
					SELECT
						LC.InstanceId,
						LC.AppsizeMB,
						LC.SubclientId,
						(CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
					FROM   #ClientInstanceDetails CLI
						INNER JOIN  Lic_CurrentUsage LC WITH(NOLOCK)
							ON LC.InstanceId = CLI.InstanceId
					WHERE LC.UsageType in (1,2,3,4)
			) TMP
		)LIC
		WHERE LIC.rownum=1
		GROUP BY InstanceId
	 ) T ON T.InstanceId = I.InstanceId
	-- UPDATE Salesforce Properties
	IF OBJECT_ID('tempdb.dbo.#sfProps') IS NOT NULL
		DROP TABLE #sfProps
	CREATE TABLE #sfProps(instanceId INT, environmentType int, sfStats XML)
	IF EXISTS (SELECT TOP 1 1 FROM #ClientInstanceDetails WHERE VendorType = 3)
	BEGIN
		--<salesforceProps>
		--	<salesforceAccount environmentType="0"/>
		--	<salesforceStats objects="10" records="1000" files="5" />
		--</salesforceProps>
		INSERT INTO #sfProps(instanceId, environmentType, sfStats)
		SELECT IP.componentNameId AS instanceId, IP.attrVal , IP2.attrVal
		FROM APP_InstanceProp IP WITH (NOLOCK)
		INNER JOIN #ClientInstanceDetails CI ON CI.InstanceId = IP.componentNameId
		AND CI.VendorType = 3 AND IP.attrName = 'Salesforce Organization Type' AND IP.modified = 0
		LEFT JOIN APP_InstanceProp IP2 WITH (NOLOCK) ON IP2.componentNameId = IP.componentNameId
		AND IP2.attrName ='Salesforce Stats' AND IP2.modified = 0
	END
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	SET @o_xmlString =
	(
		SELECT
		(	SELECT	0 AS '@errorCode',
					N'' AS '@errorMessage'
			FOR XML PATH('error'), TYPE),
		(	SELECT	D.LastBackupTime AS '@backupTime',
					D.Size AS '@backupSize',
					D.SLA AS '@slaStatus',
					D.Status AS '@status',
					D.vendorType AS '@vendorType',
					D.vendorName AS '@vendorDisplayName',
					D.ApplicationSize AS '@applicationSize',
					(SELECT
						D.InstanceId AS '@instanceId',
						D.InstanceName AS '@instanceName',
						D.ClientId AS '@clientId',
						D.ClientDisplayName AS '@displayName',
						D.ClientName AS '@clientName' FOR XML PATH('instance'), TYPE),
					(CASE D.SubClientId
						WHEN 0 THEN ''
						ELSE (SELECT
							D.SubClientId as '@subclientId',
							D.BackupSetId as '@backupsetId',
							D.InstanceId AS '@instanceId',
							D.ClientId AS '@clientId' FOR XML PATH('subclient'), TYPE)
						END),
					D.PlanId AS 'plan/@planId',
					D.PlanName AS 'plan/@planName',
					(
						SELECT environmentType AS 'salesforceAccount/@environmentType',
							sfStats.query('element salesforceStats {Api_SalesforceStats/@*, Api_SalesforceStats/*}')
						FROM #sfProps WHERE instanceId = D.InstanceId
						FOR XML PATH('salesforceProps'), TYPE
					)
			FROM #ClientInstanceDetails AS D for XML PATH('account'), TYPE)
		FOR XML PATH(''), ROOT('Api_CloudAppAccountsResp')
	)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xmlString = (SELECT @@ERROR AS '@errorCode', 'Failed to get database details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'Api_CloudAppAccountsResp'))
END CATCH
IF @o_xmlString IS NULL
	SET @o_xmlString = '<Api_CloudAppAccountsResp/>'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
	DROP TABLE #ClientInstanceDetails
IF OBJECT_ID('tempdb.dbo.#sfProps') IS NOT NULL
		DROP TABLE #sfProps
select @o_xmlString as o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetCloudAppAccounts')
	delete from GxQscripts where name = 'AppGetCloudAppAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetCloudAppAccounts')
	delete from GXDBVersions where aliasname = 'AppGetCloudAppAccounts'
GO

insert into GXDBVersions values(2, 'AppGetCloudAppAccounts',  '00000000000000000000', 'AppGetCloudAppAccounts', '00000000000000000000')
GO

