

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsToBeRetiredDeleted.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientsToBeRetiredDeleted')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientsToBeRetiredDeleted <<<'
	drop procedure AppGetClientsToBeRetiredDeleted
END
IF EXISTS (select * from GxQscripts where name='AppGetClientsToBeRetiredDeleted')
	delete from GxQscripts where name = 'AppGetClientsToBeRetiredDeleted'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsToBeRetiredDeleted')
	delete from GXDBVersions where aliasname = 'AppGetClientsToBeRetiredDeleted'
GO
print '... Creating Procedure: AppGetClientsToBeRetiredDeleted'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientsToBeRetiredDeleted
  @userId INT
AS
  DECLARE @clientId INT
  DECLARE @clientName NVARCHAR(255)
  DECLARE @toRetire INT
  DECLARE @toDelete INT
  DECLARE @companyId INT
  DECLARE @companyName NVARCHAR(255)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- GET ALL THE CLIENTS THAT GIVEN USER HAS VIEW OR AGENT MANAGEMENT OR ADMINISTRATIVE MANAGEMENT PERMISSION ON
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	INSERT INTO #permissionIdTable
	(permissionId)
VALUES (31), (3), (2)
EXEC sec_getObjectsWithPermissionsV2 @userId, 3, 0
	-- QUERY TO GET CLIENTS THAT ARE GOING TO BE DECONFIGURED OR DELETED
	IF object_id('tempdb.dbo.#tempCTBRD') is not null
	BEGIN
		DROP TABLE #tempCTBRD
	END
	CREATE TABLE #tempCTBRD(errorCode INT, errorString NVARCHAR(max), outXml XML)
	insert into #tempCTBRD(errorCode,errorString,outXml)
	EXEC AppProcessEntitiesForAutoDeletion
	IF object_id('tempdb.dbo.#resultCTBRD') is not null
	BEGIN
		DROP TABLE #resultCTBRD
	END
CREATE TABLE #resultCTBRD(clientId INT, clientName NVARCHAR(255), toRetire INT, toDelete INT, companyId INT, companyName NVARCHAR(255));
	DECLARE @xmlToProcess XML = (SELECT outXml from #tempCTBRD)
	INSERT into #resultCTBRD
	(clientId, clientName, toRetire, toDelete, companyId, companyName)
	SELECT   sref.value('@clientId','INT') ,NULL,  1, 0, tref.value('@providerId','INT'), 'Commcell' FROM  @xmlToProcess.nodes('App_ProcessEntitiesForAutoDeletionResponse/offlineClient') R ( ref )
	OUTER APPLY R.ref.nodes('client') S (sref)
	OUTER APPLY R.ref.nodes('ownerCompany') T (tref)
	UNION
	SELECT   sref.value('@clientId','INT') ,NULL, 0, 1, tref.value('@providerId','INT'), 'Commcell' FROM  @xmlToProcess.nodes('App_ProcessEntitiesForAutoDeletionResponse/deconfiguredOfflineClient') R ( ref )
	OUTER APPLY R.ref.nodes('client') S (sref)
	OUTER APPLY R.ref.nodes('ownerCompany') T (tref)
	-- REMOVE CLIENTS THAT GIVEN USER CANNOT VIEW
	DELETE C1
	FROM #resultCTBRD C1
	LEFT JOIN #getObjectsTable C2 ON C1.clientId = C2.entityId
	WHERE C2.entityId IS NULL
	-- GET CLIENT NAME
	UPDATE R
	SET clientName = C.name
	FROM #resultCTBRD R JOIN APP_Client C (NOLOCK) ON R.clientId = C.id
	-- GET COMPANY NAME
	UPDATE R
	SET companyName = P.hostName
	FROM #resultCTBRD R JOIN UMDSProviders P (NOLOCK) ON R.companyId <> 0 AND R.companyId = P.id
	SELECT clientId AS clientId, clientName AS clientName, toRetire AS toRetire, toDelete AS toDelete, companyId AS companyId, companyName AS companyName from #resultCTBRD
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsToBeRetiredDeleted')
	delete from GxQscripts where name = 'AppGetClientsToBeRetiredDeleted'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsToBeRetiredDeleted')
	delete from GXDBVersions where aliasname = 'AppGetClientsToBeRetiredDeleted'
GO

insert into GXDBVersions values(2, 'AppGetClientsToBeRetiredDeleted',  '00000000000000000000', 'AppGetClientsToBeRetiredDeleted', '00000000000000000000')
GO

