

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsOutsideCS.sp] ---------- 

-- ==================================================================================================================
--  Author:         	Kaushal Ghai
--  Create date:        18/03/2012
--  Description:        To provide the Trivial Firewall Details of all the clients which are outside CS Network or may go outside CS Network.
--
--
--  Behaviour :
--
--  Gives details of clients that are either always outside CS Network or may go outside CS Network.
--  If Firewall Conf is enabled for a client group then it gives the list of all the clients too coming under that group.
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetClientsOutsideCS <<<'

IF EXISTS (select * from sysobjects where name='AppGetClientsOutsideCS')
	drop procedure AppGetClientsOutsideCS
IF EXISTS (select * from GxQscripts where name='AppGetClientsOutsideCS')
	delete from GxQscripts where name = 'AppGetClientsOutsideCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsOutsideCS')
	delete from GXDBVersions where aliasname = 'AppGetClientsOutsideCS'
GO
print '... Creating Procedure: AppGetClientsOutsideCS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientsOutsideCS
AS
  DECLARE @clientId integer
  DECLARE @networkWithCS integer
  DECLARE @connectionWithCS integer
  DECLARE @proxyClientIdCS integer
  DECLARE @clientName nvarchar(MAX)
select clientId as 'clientId' ,networkWithCS as 'networkWithCS', connectionWithCS  'connectionWithCS' ,proxyClientIdCS 'proxyClientIdCS' , name as       'clientName' from App_FWTrivialConfig
INNER JOIN APP_Client with (nolock) ON APP_Client.id = clientId and isTrivialConfig = 1
	where networkWithCS IN (2,3) and clientGroupId = 0
union
select APP_ClientGroupAssoc.clientId as 'clientId', networkWithCS as 'networkWithCS', connectionWithCS as 'connectionWithCS',proxyClientIdCS as 	'proxyClientIdCS', name as 'clientName' from APP_ClientGroupAssoc
INNER JOIN App_FWTrivialConfig ON APP_ClientGroupAssoc.clientGroupId = App_FWTrivialConfig.clientGroupId
INNER JOIN APP_Client with (nolock) ON APP_ClientGroupAssoc.clientId = APP_Client.id
	and networkWithCS in (2,3) and App_FWTrivialConfig.clientId = 0 and App_FWTrivialConfig.isTrivialConfig = 1
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsOutsideCS')
	delete from GxQscripts where name = 'AppGetClientsOutsideCS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsOutsideCS')
	delete from GXDBVersions where aliasname = 'AppGetClientsOutsideCS'
GO

insert into GXDBVersions values(2, 'AppGetClientsOutsideCS',  '00000000000000000000', 'AppGetClientsOutsideCS', '00000000000000000000')
GO

