

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsNotOnline.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientsNotOnline.sp,v $ $Id: AppGetClientsNotOnline.sp,v 1.14.40.15 2020/10/20 03:49:47 snandhini Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			SP : "AppGetClientsNotOnline"						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientsNotOnline')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientsNotOnline <<<'
	drop procedure AppGetClientsNotOnline
END
IF EXISTS (select * from GxQscripts where name='AppGetClientsNotOnline')
	delete from GxQscripts where name = 'AppGetClientsNotOnline'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsNotOnline')
	delete from GXDBVersions where aliasname = 'AppGetClientsNotOnline'
GO
print '... Creating Procedure: AppGetClientsNotOnline'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientsNotOnline
  @updateOnlyExistingAlerts int
AS
  DECLARE @o_servEndDate integer;
  DECLARE @o_jobId integer;
  DECLARE @o_subclientCreatedTime integer;
  DECLARE @o_genericEntity nvarchar(MAX);
  DECLARE @o_isConditionCleared integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET ANSI_WARNINGS ON
declare @alertType int
set @alertType = 3
-- First check whether any alert is present with this criteria selected. Else disable.
-- In case there are no active alerts with these criterias selected, then SP returns empty
if not exists(
		select 1 from NTSelCriteria NTSel with (nolock)
		inner join NTNotificationRule  NTRule with (nolock)
		on NTRule.id = NTsel.ruleid
where availCriteriaid=65
and (NTRule.status & (1|2)) = 0
	)
	begin
		return
	end
-- Now we will expand it till subclient level and store it in @Expandedselectedclientids list.
IF object_id('tempdb.dbo.#expandedSelectedEntityIds') is not null
		DROP TABLE #expandedSelectedEntityIds
create table #expandedSelectedEntityIds
(
	clientId int,
	appTypeId int default 0,
	instanceId int default 0,
	backupsetId int default 0,
	subclientId int default 0,
	subclientStatus int,
	createdTime int NULL,
	lastJobTime int NULL,
	lastJobId int,
	ntRuleId int default 0,
	isConditionCleared int default 0
	primary key(clientId, subclientId, ntRuleId)
)
if (@updateOnlyExistingAlerts=0)
begin
	Insert into #expandedSelectedEntityIds(clientId,appTypeId,instanceId,backupsetId,subclientId,subclientStatus,ntRuleId)
exec br_ntGetExpandedEntityListForAlerts 0,65,@alertType
end
else
begin
	-- fill this temp table from alerts DB
	Insert into #expandedSelectedEntityIds(clientId,appTypeId,instanceId,backupsetId,subclientId,ntRuleId)
	select NTDdpDr.clientId, NTDdpDr.appTypeId, NTDdpDr.instanceId, NTDdpDr.backupsetId,NTDdpDr.subclientId,0 from NTDetectedAlerts
	inner join NTDdpDr on NTDdpDr.eventId = NTDetectedAlerts.eventId
where alertType = @alertType AND criteria = 65
	AND ((processStat & 2) <> 0)
	and NTDdpDr.subclientId>0
	-- VM clients would be inserted below
	-- Update subclientStatus from App_application
	Update expandedSelectedEntityIds
	set subclientStatus = App_application.subclientStatus
	from #expandedSelectedEntityIds expandedSelectedEntityIds
	inner join App_application on expandedSelectedEntityIds.subclientId = App_application.id
end
CREATE NONCLUSTERED INDEX #expandedSelectedEntityIds_clientId_Index ON #expandedSelectedEntityIds ([clientId])
-- Delete the physical machines on the cluster CS
delete from #expandedSelectedEntityIds where clientId IN (select APP_VMToPMMap.PMClientId from APP_VMToPMMap where APP_VMToPMMap.VMClientId = 2)
-- MR 106347 'No Backup' alerts are triggered for Oracle command line subclients
delete from #expandedSelectedEntityIds
where (subclientStatus & 16)>0 -- Remove dummy subclients
OR (subclientStatus & 32)>0 -- Remove hidden subclients
OR (subclientStatus & 64)>0 -- Remove command line subclients
OR (subclientStatus & 0x1000)>0 -- Remove log commandline subclients
-- remove dummy backup set from db2
delete ExpandedEntities
from #expandedSelectedEntityIds ExpandedEntities
inner join App_backupsetName
ON ExpandedEntities.backupsetId = app_backupsetname.id
where (appTypeId = 37 OR appTypeId = 62 OR appTypeId = 103) and
app_backupsetname.name=N'defaultDummyBackupSet'
-- remove saphana physicalclient's dummy subclient
delete from #expandedSelectedEntityIds where apptypeid = 136
-- MR 103675 -- Not report on disabled subclients. This is made globalparam based.
declare @checkDisabledSubclients int
select @checkDisabledSubclients = value FROM GXGlobalParam WHERE Name = 'Check Disabled Subclients for No backup alert' and modified=0
if @checkDisabledSubclients is null OR @checkDisabledSubclients>0
begin
	-- Delete from #expandedSelectedEntityIds where isActivityDisabled = 1 now itself.
	delete S
	FROM  #expandedSelectedEntityIds S INNER JOIN JMJobAction J with (nolock)
	ON  J.opType = 4 AND J.action = 1 AND ((J.clientId = S.ClientId AND J.appType IN (S.AppTypeId, 0)) OR J.appId = S.subclientId)
	-- Check at client group level. And disable activity for all clients for disabled client groups
	delete S
	FROM  #expandedSelectedEntityIds S INNER JOIN App_clientGroupAssoc CGA with (nolock)
	on CGA.clientId = S.clientId
	INNER JOIN JMJobAction J with (nolock)
	on J.clientGroupId=CGA.clientGroupId
	where J.opType = 4 AND J.action = 1 AND J.clientId = 1 and J.appType = 0 and J.mediaAgentId = 1
	declare @drSubclientId int
	set @drSubclientId  = ISNULL((select top 1 id from APP_Application
                            where appTypeId= 1000),1) --CV_APPTYPE_COMMSRVMGMT
	 DECLARE @defaultInstanceId   INT = 1
	 SELECT TOP 1 @defaultInstanceId = id
     FROM APP_InstanceName WHERE name = 'DefaultInstanceName'
	 -- check whether activity is disabled at instance level or not.
	delete S
	FROM  #expandedSelectedEntityIds S INNER JOIN JMJobAction J with (nolock)
ON  J.opType = 4 AND J.action = 1 AND J.clientId =  1 AND J.appType=0 and J.InstanceId=S.instanceId and J.mediaAgentID = 1
			AND J.appId = @drSubclientId AND J.clientGroupId = 0 and S.instanceId<>1
	-- for the indexing v2 subclients in #expandedSelectedEntityIds, check the activity control on parent subclient
	-- delete - disabled from subclient/client level
	DELETE VMs
	FROM #expandedSelectedEntityIds VMs
	INNER JOIN App_ClientProp Prop ON VMs.clientId = Prop.componentNameId AND Prop.attrName = 'VSA Discover Subclient ID' and modified = 0
	INNER JOIN App_Application App ON CAST(App.id AS NVARCHAR) = Prop.attrVal
	INNER JOIN JMJobAction J ON J.appId = App.Id OR (J.clientId = App.clientId AND J.apptype in (0, App.appTypeId) )
	WHERE  J.opType = 4 AND J.action = 1
	-- delete - disabled from clientgroup level
	DELETE VMs
	FROM #expandedSelectedEntityIds VMs
	INNER JOIN App_ClientProp Prop ON VMs.clientId = Prop.componentNameId AND Prop.attrName = 'VSA Discover Subclient ID' and modified = 0
	INNER JOIN App_Application App ON CAST(App.id AS NVARCHAR) = Prop.attrVal
	INNER JOIN App_ClientGroupAssoc Assoc ON App.clientid = Assoc.clientId
	INNER JOIN JMJobAction J ON J.clientGroupId = Assoc.clientGroupId
	WHERE J.opType = 4 AND J.action = 1 AND J.clientID = 1 and J.mediaAgentId = 1
	-- In case you have all activity or backup activity disabled at commcell level then remove all entries.
	if exists(select 1 from JMJobAction where
		clientId = 1 AND appType = 0 AND mediaAgentID = 1 AND appId = @drSubclientId AND clientGroupId = 0 AND instanceId=@defaultInstanceId
		and (opType = 1 Or opType=4) and action = 1)
	begin
		delete FROM  #expandedSelectedEntityIds
	end
end
update #expandedSelectedEntityIds
	set createdTime=APP_Application.refTime
	from APP_Application with (nolock)
	where APP_Application.id = subclientId
IF object_id('tempdb.dbo.#SubclientLastJob') is not null
		DROP TABLE #SubclientLastJob
create table #SubclientLastJob
(
	appId	int,
	servEndDate int,
	jobId int,
	primary key(appId)
)
-- For every successful job for all subclients, last successful backup time would be stored in subclient prop table. So refer to that for getting last successful backup time.
-- Refer to JMBkpstats for only the last successfull jobId.
insert into #SubclientLastJob(appId,servEndDate,jobid)
SELECT App_SubclientProp.componentNameID, CONVERT(INT, App_SubclientProp.attrval) as LastBackupTime, 0
	FROM App_SubclientProp WITH (NOLOCK)
	WHERE App_SubclientProp.attrName = N'Last Data Protected Time' --CV_PROP_BACKUP_NOTHING
	AND App_SubclientProp.cs_attrname = CHECKSUM(N'Last Data Protected Time')
	AND App_SubclientProp.modified = 0
	AND IsNumeric(App_SubclientProp.attrval) = 1
-- Update the jobId based on appID and servEndDate
UPDATE ScLastJobTime
SET jobid = JMBkpStats.jobId
FROM #SubclientLastJob ScLastJobTime INNER JOIN JMBkpStats WITH (NOLOCK)
	ON  JMBkpStats.appId = ScLastJobTime.appId
	AND JMBkpStats.status in (1,3,14)	--_JMSUCCESS,_PARTIALSUCCESS,_JMSUCCESSWITHWARNINGS
	AND JMBkpStats.opType!=14		--_Synthetic Full
	AND JMBkpStats.commCellId = 2 -- default commcell Id
	AND JMBkpStats.servEndDate = ScLastJobTime.servEndDate
update #expandedSelectedEntityIds
	set lastJobTime=servEndDate,
	lastJobId = T.jobid
	from #SubclientLastJob T
	where T.appid = subclientId
-- Now do this only when bExcludeVMsForNoBackupAlert is not set.
declare @excludeVMsForNoBackupAlert int
set @excludeVMsForNoBackupAlert = 0
select @excludeVMsForNoBackupAlert = value FROM GXGlobalParam WHERE Name = 'Exclude VMs for No backup alert' and modified=0
if @excludeVMsForNoBackupAlert=0
begin
	-- Now for virtual machines, we compute last backup time based on vmBackupEndtime
	--Insert into #expandedSelectedEntityIds(clientId ,createdTime ,lastJobTime ,lastJobId )
	declare @vmDiscoveredClientList table
	(
		vmClientId int,
		createdTime int,
		lastJobTime int,
		lastJobId int,
		primary key(vmClientId)
	)
	if (@updateOnlyExistingAlerts=0)
	begin
		Insert into @vmDiscoveredClientList(vmClientId,createdTime,lastJobTime,lastJobId)
		select distinct App_clientprop.componentNameId, App_clientprop.created,0,0
		from App_clientprop with (nolock)
		inner join App_vmprop on
		App_clientprop.componentNameId = App_vmprop.vmclientid
		inner join App_client on
		App_clientprop.componentNameId=APP_Client.id
		where App_clientprop.attrname='Virtual Server Discovered Clients'
		and App_clientprop.modified=0
		and (APP_Client.specialClientFlags & 2)>0
	end
	else
	begin
		Insert into @vmDiscoveredClientList(vmClientId,createdTime,lastJobTime,lastJobId)
		select distinct App_clientprop.componentNameId, App_clientprop.created,0,0
		from App_clientprop with (nolock)
		inner join App_vmprop on
		App_clientprop.componentNameId = App_vmprop.vmclientid
		inner join App_client on
		App_clientprop.componentNameId=APP_Client.id
		inner join NTDdpDr on NTDdpDr.clientId = APP_Client.id
		inner join NTDetectedAlerts on NTDdpDr.eventId = NTDetectedAlerts.eventId
and alertType = @alertType AND criteria = 65
		AND ((processStat & 2) <> 0)
		and NTDdpDr.subclientId=0
		and NTDdpDr.clientId>0
		where App_clientprop.attrname='Virtual Server Discovered Clients'
		and App_clientprop.modified=0
		and (APP_Client.specialClientFlags & 2)>0
	end
	-- remove if backup acivity is disabled in VM client
	if @checkDisabledSubclients is null OR @checkDisabledSubclients>0
    begin
        DELETE S
        FROM @vmDiscoveredClientList S
		INNER JOIN JMJobAction J ON  S.vmClientid = J.clientId
		WHERE J.opType = 4 AND J.action = 1 AND J.appType = 0
        -- Check at client group level. And disable activity for all clients for disabled client groups
        DELETE S
        FROM @vmDiscoveredClientList S
		INNER JOIN App_clientGroupAssoc CGA ON CGA.clientId = S.vmclientId
        INNER JOIN JMJobAction J on J.clientGroupId = CGA.clientGroupId
        where J.opType = 4 AND J.action = 1 AND J.clientId = 1 and J.appType = 0 and J.mediaAgentId = 1
    end
	-- VM clients would be inserted below
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#vmSubclientJobInfo'))
         DROP TABLE #vmSubclientJobInfo
    CREATE TABLE #vmSubclientJobInfo (
        scId	                    INT,
        lastJobId					INT,
		ClientId					INT,
		AppTypeId					INT
    )
	CREATE NONCLUSTERED INDEX #vmSubclientJobInfo_ClientId_Index ON #vmSubclientJobInfo ([ClientId])
	if ( (@updateOnlyExistingAlerts=0) OR
		exists(select 1 from @vmDiscoveredClientList)
		)
	begin
		-- We figure out last job for subclient and then check for no backup alert only for vms which are part of some subclient.
		Insert into #vmSubclientJobInfo
		select App_application.Id,Max(JMBkpStats.jobId),App_application.clientId,App_application.appTypeId from App_application
		inner join JMBkpStats on
		App_application.id = JMBkpStats.AppId
		inner join App_vmprop on
		JMBkpStats.jobid = App_vmprop.jobId
		where appType=106 and dbo.IsSubClientValid(App_application.appTypeId,App_application.subclientStatus,0)=1
		group by App_application.id,App_application.clientId,App_application.appTypeId
		-- Now delete subclients whose activity control is disabled.
		if @checkDisabledSubclients is null OR @checkDisabledSubclients>0
		begin
			delete S
			from #vmSubclientJobInfo S INNER JOIN JMJobAction J with (nolock)
			ON  J.opType = 4 AND J.action = 1 AND ((J.clientId = S.ClientId AND J.appType IN (S.AppTypeId, 0)) OR J.appId = S.scId)
			-- Check at client group level. And disable activity for all clients for disabled client groups
			delete S
			from #vmSubclientJobInfo S INNER JOIN App_clientGroupAssoc CGA with (nolock)
			on CGA.clientId = S.clientId
			INNER JOIN JMJobAction J with (nolock)
			on J.clientGroupId=CGA.clientGroupId
			where J.opType = 4 AND J.action = 1 AND J.clientId = 1 and J.appType = 0 and J.mediaAgentId = 1
		end
		Delete VMsContent
		from @vmDiscoveredClientList VMsContent
		left outer join
		(
			select distinct vmClientId from
			App_vmprop inner join #vmSubclientJobInfo VMScInfo
			on VMScInfo.lastJobId = App_vmprop.jobId
		)  t
		on VMsContent.vmClientId = t.vmClientId
		where t.vmClientId is NULL
	end
	Drop table #vmSubclientJobInfo
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMJobInfo'))
         DROP TABLE #VMJobInfo
    CREATE TABLE #VMJobInfo (
        commcellid                  INT,
        clientId                    INT,
        LastSuccessfulBackupJobId   INT,
        LastSuccessfulBackupTime    INT
    )
	 Insert into #VMJobInfo
	 SELECT  distinct JMQ.commCellId,
            JMQ.clientId,
            ISNULL(MAX(CASE  WHEN B.status in ( 1,3,14,16)  THEN(
                        CASE    WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
                            THEN B.jobid
                        WHEN V.attrVal IS  NULL AND JMQ.status IN (1,3)
                            THEN B.jobId
                        ELSE 0
                        END)
                END), 0) as LastSuccessfulBackupJobId,
            0 as LastSuccessfulBackupTime
    FROM JMQinetixUpdateStatus JMQ with (nolock)
        INNER JOIN JMBkpStats B with (nolock)
            ON  B.jobId = JMQ.jobId
            AND B.commCellId = B.commCellId
		Inner join @vmDiscoveredClientList vmDiscoveredClientList on
		vmDiscoveredClientList.vmClientId = JMQ.clientId
        LEFT OUTER JOIN APP_VMProp V with (nolock)
            ON  JMQ.jobId = V.jobId
            AND JMQ.commCellId = V.commCellId
            AND JMQ.clientId = V.VMclientId
            AND V.attrName = 'vmStatus'
    WHERE   B.appType = 106
	and JMQ.commCellId = 2
	and B.opType in (4,59)		--_Synthetic Full
	group by JMQ.clientId, JMQ.commCellId
	UPDATE  #VMJobInfo
    SET     LastSuccessfulBackupTime = CAST(V.attrVal as int)
    FROM    #VMJobInfo VM
    JOIN    APP_VMProp V with (nolock)
    ON VM.LastSuccessfulBackupJobId = V.jobId AND VM.clientId = V.vmclientId
    AND V.attrName = 'vmBackupStartTime'
	UPDATE  #VMJobInfo
    SET     LastSuccessfulBackupTime = B.ServEndDate
    FROM    #VMJobInfo VM
    JOIN    JMBkpStats B with (nolock)
    ON VM.LastSuccessfulBackupJobId = B.jobId
	where LastSuccessfulBackupTime = 0
	Update VMs
	set lastJobId = t.LastSuccessfulBackupJobId,
	lastJobTime = t.LastSuccessfulBackupTime
	from @vmDiscoveredClientList VMs,#VMJobInfo t
	where t.clientId = VMs.vmClientId
	IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#VMJobInfo'))
         DROP TABLE #VMJobInfo
	Insert into #expandedSelectedEntityIds(clientId ,createdTime ,lastJobTime ,lastJobId )
	select vmClientId,createdtime,lastJobTime,lastJobId
	from @vmDiscoveredClientList
end
-- donot alert deleted VMs
DELETE VMs
	FROM #expandedSelectedEntityIds VMs
	INNER JOIN App_ClientProp Prop ON VMs.clientId = Prop.componentNameId AND Prop.attrName = 'Virtual Machine Deletion Time' and Prop.modified = 0 and Prop.attrVal<>'0'
declare @minTimeClientNotBacked int
select @minTimeClientNotBacked = min(value) from NTSelCriteriaParams params inner join NTSelcriteria Selcriteria
	on params. selCriteriaId = Selcriteria.id
and Selcriteria.availCriteriaid=65
	inner join NTNotificationRule NTRule on
	NTRule.id = SelCriteria.Ruleid
where (NTRule.status & (1|2)) = 0
-- this is in no of days. Convert to seconds
set @minTimeClientNotBacked = @minTimeClientNotBacked*3600*24
Declare @currentTime int
set @currentTime = dbo.getunixtime(GetUTCDate())
-- Now we dont need to look at entries whic were backed up before last specified time.
delete from #expandedSelectedEntityIds
where lastJobTime is not NULL and ((@currentTime - lastJobTime)<@minTimeClientNotBacked)
-- Now where lastJobTime is null we look at subclient createdTime
delete from #expandedSelectedEntityIds
where lastJobTime is NULL
and ((@currentTime - createdTime)<@minTimeClientNotBacked)
-- Now here we have all the sublients whose jobs doesnt ran for atleast @minTimeClientNotBacked
   -- Check in alert tables to see if any of already existing alerts condition got cleared or not.
insert into #expandedSelectedEntityIds
SELECT DISTINCT
  NTD.clientId,
  NTD.appTypeId,
  NTD.instanceId,
  NTD.backupSetId,
  NTD.subClientId,
  0 , --  subclientStatus not required
  0 , -- Subclient created time : will update it later
  0 , -- Last job run time : Will set it later from #SubclientLastJob table
  0 , -- previous job Id  : Will set it later from #SubclientLastJob table
  0 , -- ntruleId not required for condition cleared
  1  -- IsConditionCleared = true
FROM NTDetectedAlerts
INNER JOIN NTDdpDr AS NTD
ON NTDetectedAlerts.eventId = NTD.eventId
LEFT OUTER JOIN #expandedSelectedEntityIds  AS ESE
ON
   NTD.clientId = ESE.clientId AND
   NTD.subClientId = ESE.subClientId
WHERE
   NTDetectedAlerts.criteria =  65  AND -- NT_CLIENT_JOB_NOT_RUN
   ( ESE.subclientId IS NULL AND  ESE.clientId  IS NULL ) AND
   NTDetectedAlerts.processStat & 2  = 2 --  Take only pending events
if (@updateOnlyExistingAlerts<>0)
begin
	-- Delete entries from #expandedSelectedEntityIds which are not present in NTDetectedalerts table
	delete expandedSelectedEntityIds
	from #expandedSelectedEntityIds expandedSelectedEntityIds
	left join NTDDpdr on expandedSelectedEntityIds.clientId = NTDDpdr.clientId
	and expandedSelectedEntityIds.subclientId = NTDDpdr.subclientId
	where NTDDpdr.clientId is null
end
update #expandedSelectedEntityIds
	set lastJobTime=servEndDate,
	lastJobId = T.jobid
	from #SubclientLastJob T
	where T.appid = subclientId
update #expandedSelectedEntityIds
	set createdTime= reftime
from APP_Application APP with (nolock )
	where APP.id = subclientId
select lastJobTime,lastJobId,createdTime,
	(select clientid '@clientId',appTypeId '@applicationId',instanceId '@instanceId',
		backupsetId '@backupsetId',subclientId '@subclientId'
	 for xml path('CvEntities_GenericEntity')) , isConditionCleared
from
(
	select distinct lastJobTime,lastJobId,createdTime,clientid,appTypeId,instanceId,
		backupsetId ,subclientId ,isConditionCleared
	from #expandedSelectedEntityIds
) t
IF object_id('tempdb.dbo.#SubclientLastJob') is not null
		DROP TABLE #SubclientLastJob
GO
--dummy check-in becuase one update on build 52 failed to get built correctly Form (52563).

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsNotOnline')
	delete from GxQscripts where name = 'AppGetClientsNotOnline'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsNotOnline')
	delete from GXDBVersions where aliasname = 'AppGetClientsNotOnline'
GO

insert into GXDBVersions values(2, 'AppGetClientsNotOnline',  '00010014004000150000', 'AppGetClientsNotOnline', '00010014004000150000')
GO

