

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsForMAOutsideMA.sp] ---------- 

-- ==================================================================================================================
--  Author:         	Kaushal Ghai
--  Create date:        18/03/2012
--  Description:        To provide the Trivial Firewall Details of all the clients which are associated to a given MA and are either always outside the MA  --			Network or may go outside the MA Network.
--
--
--  Behaviour :
--
--  If Firewall Conf is enabled for a client group then it gives the list of all the clients too coming under that group.
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetClientsForMAOutsideMA <<<'

IF EXISTS (select * from sysobjects where name='AppGetClientsForMAOutsideMA')
	drop procedure AppGetClientsForMAOutsideMA
IF EXISTS (select * from GxQscripts where name='AppGetClientsForMAOutsideMA')
	delete from GxQscripts where name = 'AppGetClientsForMAOutsideMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsForMAOutsideMA')
	delete from GXDBVersions where aliasname = 'AppGetClientsForMAOutsideMA'
GO
print '... Creating Procedure: AppGetClientsForMAOutsideMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientsForMAOutsideMA
  @mediaAgentId integer
AS
  DECLARE @clientId integer
  DECLARE @networkWithMA integer
  DECLARE @connectionWithMA integer
  DECLARE @proxyClientIdMA integer
  DECLARE @clientName nvarchar(MAX)
DECLARE @clientIDsForMA  TABLE( clientId integer)
insert into @clientIDsForMA select distinct clientId from APP_Application where dataArchGrpID in (select archGroupId from archGroupCopy where id in
												 (select CopyId from MMDataPath where HostClientId = 													@mediaAgentId)) or
										logArchGrpID in	 (select archGroupId from archGroupCopy where id in
												 (select CopyId from MMDataPath where HostClientId = 													@mediaAgentId ))
select T.clientId as 'clientId', T.networkWithMA as 'networkWithMA', T.connectionWithMA as 'connectionWithMA', T.proxyClientIdMA as 'proxyClientIdMA', C.name as 'clientName'
from App_FWTrivialConfig T INNER JOIN App_Client C with (nolock) ON T.clientId = C.id AND isTrivialConfig = 1
where networkWithMA IN (2,3) and clientGroupId = 0 and clientId in ( select * from @clientIDsForMA )
union
select A.clientId as 'clientId', T.networkWithMA as 'networkWithMA', T.connectionWithMA as 'connectionWithMA', T.proxyClientIdMA as 'proxyClientIdMA' , C.name as 'clientName'
from App_FWTrivialConfig T INNER JOIN APP_ClientGroupAssoc A with (nolock) ON T.clientGroupId = A.clientGroupId
INNER JOIN APP_Client C with (nolock) ON  A.clientId = C.id
where T.networkWithMA IN (2,3) and T.clientId = 0 and A.clientId in ( select * from @clientIDsForMA ) AND T.isTrivialConfig = 1
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsForMAOutsideMA')
	delete from GxQscripts where name = 'AppGetClientsForMAOutsideMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsForMAOutsideMA')
	delete from GXDBVersions where aliasname = 'AppGetClientsForMAOutsideMA'
GO

insert into GXDBVersions values(2, 'AppGetClientsForMAOutsideMA',  '00000000000000000000', 'AppGetClientsForMAOutsideMA', '00000000000000000000')
GO

