

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsForIP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientsForIP.sp,v $ $Id: AppGetClientsForIP.sp,v 1.1.2.6 2020/08/13 22:57:52 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppGetClientsForIP()
--  |
--  | Description:  Gets clients list based on th list of ip addresses
--  |
--  |       Input: App_GetClientsForIPAddressRequest - list of ip address
--  |      Output: App_GetClientsForIPAddressResponse - list of clients
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientsForIP')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientsForIP <<<'
	drop procedure AppGetClientsForIP
END
IF EXISTS (select * from GxQscripts where name='AppGetClientsForIP')
	delete from GxQscripts where name = 'AppGetClientsForIP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsForIP')
	delete from GXDBVersions where aliasname = 'AppGetClientsForIP'
GO
print '... Creating Procedure: AppGetClientsForIP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientsForIP
  @xmlRequest XML
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT
	(SELECT
		(SELECT client.name as '@clientName', client.id as '@clientId', req.ipAddress.value('@val','NVARCHAR(100)') as '@hostName' FROM
			@xmlRequest.nodes('/App_GetClientsForIPAddressRequest/ipAddress') AS req(ipAddress)
LEFT JOIN APP_ComponentProp cProp ON cProp.propertyTypeId = 2102 AND cProp.modified = 0
				   OUTER APPLY dbo.Split(cProp.stringVal, ',') ip
				   INNER JOIN APP_Client client ON cProp.componentId = client.id AND ((client.status & 6) = 0) -- CV_STATUS_UNINSTALLED | CV_STATUS_DELETED
		WHERE ip.Data = req.ipAddress.value('@val','NVARCHAR(100)')
		FOR XML PATH('clients'), TYPE)
	FOR XML PATH('App_GetClientsForIPAddressResponse'), TYPE) as o_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsForIP')
	delete from GxQscripts where name = 'AppGetClientsForIP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsForIP')
	delete from GXDBVersions where aliasname = 'AppGetClientsForIP'
GO

insert into GXDBVersions values(2, 'AppGetClientsForIP',  '00010001000200060000', 'AppGetClientsForIP', '00010001000200060000')
GO

