

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsApplicableForMigration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientsApplicableForMigration.sp,v $ $Id: AppGetClientsApplicableForMigration.sp,v 1.1.2.13 2020/12/21 15:58:13 nshah Exp $";
--  +===============================================================================+
--  |                  AppGetClientsApplicableForMigration                          |
--  |                                                                               |
--  |  PARAMETERS                                                                   |
--  |    x_xmlData    =     Api_AssociateCompanyReq request xml                     |
--  +===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientsApplicableForMigration')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientsApplicableForMigration <<<'
	drop procedure AppGetClientsApplicableForMigration
END
IF EXISTS (select * from GxQscripts where name='AppGetClientsApplicableForMigration')
	delete from GxQscripts where name = 'AppGetClientsApplicableForMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsApplicableForMigration')
	delete from GXDBVersions where aliasname = 'AppGetClientsApplicableForMigration'
GO
print '... Creating Procedure: AppGetClientsApplicableForMigration'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientsApplicableForMigration
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @x_xmlData XML OUTPUT 
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE @i_companyId    INT = (SELECT ISNULL(ref.value('@providerId', 'INT'), 0) AS name FROM @x_xmlData.nodes('Api_AssociateCompanyReq/company') R ( ref )),
        @i_callerId     INT = ISNULL (( SELECT ref.value('@userId', 'INT') FROM @x_xmlData.nodes ('Api_AssociateCompanyReq/processinginstructioninfo/user') R(ref)), 0),
        @i_localeId     INT = ISNULL (( SELECT ref.value('@localeId', 'INT') FROM @x_xmlData.nodes ('Api_AssociateCompanyReq/processinginstructioninfo/locale') R(ref)), 0),
        @errorCode      INT = 0,
        @errorMsg       NVARCHAR(MAX) = '',
        @isMSPUserComcellAdmin INT = 0
BEGIN TRY
    ----- CHECK SECURITY ----------------------------------------------------------------------------------------------------------------------
    IF @i_companyId < 0
    BEGIN
        SET @errorCode = 1
        SET @errorMsg = 'Please provide valid companyId.'
        GOTO ERROR_EXIT
    END
    --
EXEC sec_checkPermissionOnEntity @i_callerId, 1, @isMSPUserComcellAdmin OUT,1,2
    ----- CHECK SECURITY ----------------------------------------------------------------------------------------------------------------------
--
--
    ----- PARSE THE XML ------------------------------------------------------------------------------------------------------------------------
    CREATE TABLE #EntitiesToAssociate (entityId INT, entityType INT, isVM INT DEFAULT 0, isinValidForMigration INT DEFAULT 0, parentEntity INT DEFAULT 0, oldCompanyId INT DEFAULT 0,
		invalidStatus INT DEFAULT 0 	PRIMARY KEY(entityId, entityType))
    CREATE TABLE #EntityPlanAssoc (entityId INT, planId INT DEFAULT 0)
	IF object_id('tempdb.dbo.#AssociatedClients') is not null
		DROP TABLE #AssociatedClients
	CREATE TABLE #AssociatedClients
	(
		id INT
		PRIMARY KEY(id)
	)
    --
    INSERT INTO #EntitiesToAssociate (entityId, entityType)
        SELECT ref.value('@clientId','INT'),
3
        FROM @x_xmlData.nodes('Api_AssociateCompanyReq/entities') AS R(ref)
WHERE ref.value('@_type_','INT') = 3
		UNION
        SELECT CG.clientId,
3
        FROM @x_xmlData.nodes('Api_AssociateCompanyReq/entities') AS R(ref)
        INNER JOIN App_ClientGroupAssoc AS CG WITH(NOLOCK) ON CG.clientGroupId = ref.value('@clientGroupId','INT')
WHERE ref.value('@_type_','INT') = 28
    --
    ----- PARSE THE XML -----------------------------------------------------------------------------------------------------------------------
--
--
    ----- SECURITY CHECK - NOT MSP ADMIN ON COMMCELL THEN CHECK ADMIN PERMISSION ON EACH ENTITY -----------------------------------------------
    IF @isMSPUserComcellAdmin = 0 /*Not MSP admin*/
    BEGIN
        -- NOT MSP ADMIN ON COMMCELL THEN CHECK CLIENT OWNERSHIP PERMISSION ON EACH ENTITY
        CREATE TABLE #getPermissionsOnEntities_InputTable
        (
            entityId1 INT,
            entityId2 INT DEFAULT 0,
            entityId3 INT DEFAULT 0,
            entityId4 INT DEFAULT 0,
            entityId5 INT DEFAULT 0
        )
        CREATE TABLE #getPermissionsOnEntities_OutputTable
        (
            entityId1 INT,
            entityId2 INT,
            entityId3 INT,
            entityId4 INT,
            entityId5 INT,
            permissionsString VARCHAR(512),
            isChildRow BIT DEFAULT 0
        )
        INSERT into #getPermissionsOnEntities_InputTable (entityId1)
            (SELECT entityId FROM #EntitiesToAssociate)
EXEC sec_getPermissionsOnEntities @i_callerId, 3/*CLIENT_ENTITY*/
        --
        UPDATE E
            SET E.isinValidForMigration = 1, invalidStatus = 2 /*NOT OWNER OF THE CLIENT*/
        FROM #EntitiesToAssociate E
        INNER JOIN #getPermissionsOnEntities_OutputTable ON entityId1 = entityId
WHERE SUBSTRING(permissionsString, 1, 1) != N'1'
    END
    ----- SECURITY CHECK - NOT MSP ADMIN ON COMMCELL THEN CHECK CLIENT OWNERSHIP PERMISSION ON EACH ENTITY ------------------------------------
--
--
	------ Associate all the VM clients of hyperV client as well
	  -------------------------------------------------------------------------------------------------------
	MERGE #EntitiesToAssociate AS TARGET
USING (SELECT componentNameId as entityId, 3 as entityType, E.entityId as parentEntity
	FROM #EntitiesToAssociate E
	INNER JOIN APP_Application Appl WITH(NOLOCK)
On E.entityId = Appl.clientId AND E.entityType = 3
	INNER JOIN APP_ClientProp ACP WITH(NOLOCK)
ON ACP.attrName = 'Last Backup Subclient' AND ACP.attrVal = CAST(Appl.id AS NVARCHAR(10)) AND ACP.modified=0
	WHERE E.isinValidForMigration = 0
	) AS SOURCE ON
	(TARGET.entityId = SOURCE.entityId AND SOURCE.entityType = TARGET.entityType)
	WHEN MATCHED THEN UPDATE SET TARGET.parentEntity = SOURCE.parentEntity
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (entityId, entityType, isVM, isinValidForMigration, parentEntity)
	VALUES (SOURCE.entityId, SOURCE.entityType, 1, 0, SOURCE.parentEntity);
	----- GET OLD COMPANY ID -------------------------------------------------------------------------------------------------------------------------
	UPDATE EA
		SET EA.oldCompanyId = ACE.companyId
	FROM #EntitiesToAssociate EA
		INNER JOIN APP_CompanyEntities ACE (NOLOCK)
			ON EA.entityType = ACE.entityType AND EA.entityId = ACE.entityId
	WHERE
		EA.isinValidForMigration = 0
	----- GET OLD COMPANY ID -------------------------------------------------------------------------------------------------------------------------
	----- Verify subclients, backupsets, instances have either same company as client itself or same company as target company --------------------------------------------------------------------------------------------------------
	-- A.Verify associated clients of given client either have same company as client or same company as target company
	DECLARE @targetCompanyId INT = @i_companyId
	UPDATE E
	SET E.isinValidForMigration = 1, invalidStatus = 3 /*Child/Parent entity associated to another company*/
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.oldCompanyId <> E2.oldCompanyId
		AND E.oldCompanyId <> @targetCompanyId
		AND E2.oldCompanyId <> @targetCompanyId
		AND E.parentEntity = 0 AND E2.parentEntity <> 0 AND E.isinValidForMigration = 0 AND E2.isinValidForMigration = 0
	-- B. Verify subclients, backupsets, instances of given client & it's associated clients either have same company as client or same company as target company
	UPDATE E
	SET isinValidForMigration = 1, invalidStatus = 4 /*Subclient associated to another company*/
	FROM APP_Application Appl WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = Appl.id AND App.entityType = 7
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
	UPDATE E
	SET isinValidForMigration = 1, invalidStatus = 5 /*Backupset associated to another company*/
	FROM APP_BackupSetName Bkp WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = Bkp.id AND App.entityType = 6
	INNER JOIN APP_Application Appl WITH(NOLOCK)
		On Appl.backupSet = Bkp.id
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
	UPDATE E
	SET isinValidForMigration = 1, invalidStatus = 6 /*Instance associated to another company*/
	FROM APP_InstanceName AI WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = AI.id AND App.entityType = 5
	INNER JOIN APP_Application Appl WITH(NOLOCK)
		On Appl.instance = AI.id
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
		AND AI.id <> 1
		AND AI.id NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1')   /*default VM instance*/
	-- C. If client is MA, verify that all the SP/Plan/Pool created using MA are target company entities. Note: SP/Plan/Pool cannot even be MSP entities since those are not migrated along with MA to target company. -----
	UPDATE E
	SET E.isinValidForMigration = 1, invalidStatus = 7 /*Storage policy of the MA associated to another company*/
	FROM #EntitiesToAssociate E
	INNER JOIN MMHost MMH WITH(NOLOCK)
		ON MMH.ClientId = E.entityId
AND E.entityType = 3
	INNER JOIN MMDataPath MMD WITH(NOLOCK)
		ON MMH.ClientId = MMD.HostClientId
	INNER JOIN archGroupCopy AGC WITH(NOLOCK)
		ON AGC.id = MMD.CopyId
	LEFT JOIN App_CompanyEntities ACE WITH(NOLOCK)
		ON ACE.entityId = AGC.archGroupId
AND ACE.entityType = 17
	WHERE (ACE.entityId is NULL
			OR ACE.companyId <> @targetCompanyId)
			AND E.isinValidForMigration = 0
	-- D. Verify that subclients of client either have security association with same company as client or same company as target company
	UPDATE E
	SET E.isinValidForMigration = 1, invalidStatus = 10
	FROM #EntitiesToAssociate E
	INNER JOIN App_Application Appl WITH(NOLOCK)
ON E.entityType = 3
			AND E.entityId = Appl.clientId
	INNER JOIN UMSecurityAssociations UM WITH(NOLOCK)
ON UM.entityType1 = 3
			AND UM.entityId1 = E.entityId
AND UM.entityType5 = 7
			AND UM.entityId5 = Appl.id
	WHERE E.oldCompanyId <> UM.companyId
		AND E.oldCompanyId <> @targetCompanyId
		AND UM.companyId <> @targetCompanyId
		AND E.parentEntity = 0
		AND E.isinValidForMigration = 0
	UPDATE E
	SET E.isinValidForMigration = 1, invalidStatus = E2.invalidStatus
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.parentEntity = 0 AND E2.parentEntity <> 0 AND E2.isinValidForMigration = 1 AND E.isinValidForMigration = 0
	UPDATE E2
	SET E2.isinValidForMigration = 1, invalidStatus = E.invalidStatus
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.parentEntity = 0 AND E2.parentEntity <> 0 AND E2.isinValidForMigration = 0 AND E.isinValidForMigration = 1
    ----- SET VM FLAG FOR THE ENTITIES --------------------------------------------------------------------------------------------------------
    UPDATE E
        SET E.isVM = 1
    FROM #EntitiesToAssociate E
    INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON E.entityId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.modified=0 AND CP.attrVal='1'
--
    ----- GET PLAN ids FOR THE VM -------------------------------------------------------------------------------------------------------------
    INSERT INTO #EntityPlanAssoc
        SELECT E.entityid, CAST(SP.attrVal AS INT)
        FROM #EntitiesToAssociate E
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = E.entityId AND CP.attrName = 'Last Backup Subclient' AND CP.modified=0
INNER JOIN App_SubclientProp SP WITH(NOLOCK) ON SP.componentNameId = CAST(CP.attrVal AS INT) AND SP.attrName = 'Associated Plan' AND SP.modified = 0 AND SP.attrVal<>'0'
            WHERE E.isVM = 1 AND E.isinValidForMigration = 0
    ----- SET VM FLAG FOR THE ENTITIES --------------------------------------------------------------------------------------------------------
--
--
    ----- GET PLAN ids ASSOCIATED THRU CLIENT -------------------------------------------------------------------------------------------------
    INSERT INTO #EntityPlanAssoc
        SELECT E.entityid, CAST(CP.attrVal AS INT)
            FROM #EntitiesToAssociate E
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = E.entityId AND CP.attrName = 'Associated Plan' AND CP.modified=0 AND CP.attrVal<>'0'
        WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
    ----- GET PLAN ids ASSOCIATED THRU BACKUPSET ----------------------------------------------------------------------------------------------
    INSERT INTO #EntityPlanAssoc
        SELECT E.entityid, CAST(BP.attrVal AS INT)
            FROM #EntitiesToAssociate E
            INNER JOIN APP_Application A WITH(NOLOCK) on A.clientId = E.entityId
INNER JOIN APP_BackupSetProp BP WITH(NOLOCK) ON BP.componentNameId = A.backupSet AND BP.attrName = 'Associated Plan' AND BP.modified = 0 AND BP.attrVal<>'0'
        WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
    ----- GET PLAN ids ASSOCIATED THRU SUBCLIENT ----------------------------------------------------------------------------------------------
    INSERT INTO #EntityPlanAssoc
        SELECT E.entityid, CAST(SP.attrVal AS INT)
            FROM #EntitiesToAssociate E
            INNER JOIN APP_Application A WITH(NOLOCK) on A.clientId = E.entityId
INNER JOIN APP_SubClientProp SP WITH(NOLOCK) ON SP.componentNameId = A.id AND SP.cs_attrName = CHECKSUM(N'Associated Plan') AND SP.attrVal<>'0'
AND SP.attrName = 'Associated Plan' AND SP.modified = 0
        WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
    ----- CHECK iF THE TENANT ADMIN HAS PERMISSION ON THE ASSOCIATED PLANS OF EACH CLIENT --------------------------------------------------------
    IF EXISTS (SELECT 1 FROM #EntityPlanAssoc EA INNER JOIN #EntitiesToAssociate E ON E.entityId = EA.entityId WHERE E.isinValidForMigration = 0)
    BEGIN
        ----- GET PLANS OF THE COMPANY -----------------------------------------------------------------------------------------------------
    CREATE TABLE #getPlans (planId INT)
EXEC AppGetCompanyPlanList @i_companyId,159,'#getPlans'
            UPDATE E
                SET E.isinValidForMigration = 1, invalidStatus = 8 /*Tenant Admin has no permission on plan associated w/ the client*/
            FROM #EntitiesToAssociate E
INNER JOIN #EntityPlanAssoc EA ON EA.entityid = E.entityId and E.isinValidForMigration = 0 AND E.entityType = 3
            LEFT OUTER JOIN #getPlans P ON P.planid = EA.planId
            WHERE P.planId IS NULL
    END
    ----- CHECK iF THE TENANT ADMIN HAS PERMISSION ON THE ASSOCIATED PLANS OF EACH CLIENT -----------------------------------------------------
--
--
	----- CHECK LOCKED CLIENTS. THEY SHOULD NOT BE ALLOWED TO MIGRATE FROM COMPANY C1 TO COMPANY C2. ------------------------------------------
	BEGIN
		UPDATE E
			SET E.isinValidForMigration = 1, invalidStatus = 9/*Locked clients*/
		FROM #EntitiesToAssociate E
			INNER JOIN APP_ClientProp CP (NOLOCK)
ON E.entityType = 3 AND CP.componentNameId = E.entityId AND CP.attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND CP.attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' AND CP.modified = 0
		WHERE
			E.isinValidForMigration = 0
	END
	----- CHECK LOCKED CLIENTS. THEY SHOULD NOT BE ALLOWED TO MIGRATE FROM COMPANY C1 TO COMPANY C2. ------------------------------------------
--
--
    ----- CREATE RESPONSE ---------------------------------------------------------------------------------------------------------------------
	SET @x_xmlData = (SELECT
						(SELECT
							C.id AS '@clientId', C.name AS '@clientName', C.displayName AS '@displayName'
						FROM #EntitiesToAssociate E
INNER JOIN App_Client C WITH(NOLOCK) ON E.entityType = 3 AND C.id = E.entityId AND E.isinValidForMigration = 0
						FOR XML PATH('applicableClients'), TYPE),
						(SELECT
							invalidStatus AS '@status',
							(SELECT
								CL.id AS '@clientId', CL.name AS '@clientName', CL.displayName AS '@displayName'
							FROM #EntitiesToAssociate F
INNER JOIN App_Client CL WITH(NOLOCK) ON F.entityType = 3 AND CL.id = F.entityId
							WHERE N.invalidStatus = F.invalidStatus
							FOR XML PATH('clients'), TYPE)
						FROM (SELECT DISTINCT invalidStatus FROM #EntitiesToAssociate WHERE isinValidForMigration = 1) AS N ORDER BY invalidStatus
						FOR XML PATH('notApplicableClients'), TYPE)
					FOR XML PATH(''),TYPE)
    ----- CREATE RESPONSE ---------------------------------------------------------------------------------------------------------------------
--
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT @errorCode = ERROR_NUMBER(), @errorMsg = ERROR_MESSAGE()
END CATCH
--
ERROR_EXIT:
SET @x_xmlData =
    (
        SELECT
            (SELECT
                @errorCode '@errorCode',
                @errorMsg '@errorMessage'
            FOR XML PATH('error'), TYPE),
            (SELECT @x_xmlData
                FOR XML PATH(''), TYPE)
            FOR XML PATH(''), ROOT('Api_GetClientsApplicableForMigrationRespV2')
    )
SELECT @x_xmlData AS x_xmlData
RETURN @errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsApplicableForMigration')
	delete from GxQscripts where name = 'AppGetClientsApplicableForMigration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsApplicableForMigration')
	delete from GXDBVersions where aliasname = 'AppGetClientsApplicableForMigration'
GO

insert into GXDBVersions values(2, 'AppGetClientsApplicableForMigration',  '00010001000200130000', 'AppGetClientsApplicableForMigration', '00010001000200130000')
GO

