

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientsAndArrays.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetClientsAndArrays"
--	|	This Procedure is used to get NAS VServer Clients
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientsAndArrays')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientsAndArrays <<<'
	drop procedure AppGetClientsAndArrays
END
IF EXISTS (select * from GxQscripts where name='AppGetClientsAndArrays')
	delete from GxQscripts where name = 'AppGetClientsAndArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsAndArrays')
	delete from GXDBVersions where aliasname = 'AppGetClientsAndArrays'
GO
print '... Creating Procedure: AppGetClientsAndArrays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientsAndArrays
  @xmlText XML
AS
  DECLARE @o_ClientId INTEGER
  DECLARE @o_clientHostName NVARCHAR(1024)
  DECLARE @o_CtrlHostId INTEGER
  DECLARE @o_arrayId NVARCHAR(1024)
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorStr NVARCHAR(1024)
SET NOCOUNT ON
DECLARE @tblOutput TABLE ( clientId INT,
							clientNetHostName NVARCHAR(1024),
							ctrlHostId INT,
							arrayId NVARCHAR(1024))
DECLARE @ClientList TABLE ( clientId INT,
							clientName NVARCHAR(1024),
							clientNetHostName NVARCHAR(1024) )
DECLARE @hostList TABLE ( ctrlHostId INT,
							arrayId NVARCHAR(1024))
							--clientNetHostName NVARCHAR(1024),
							--simOsId INTEGER,
							--isNAS INTEGER )
DECLARE @errCode INTEGER = 0
DECLARE @errStr NVARCHAR(1024) = N''
-- MM Config Parameter to skip duplicate array alias check.
DECLARE @skipDuplicateAliasCheck INT = 0
SET @skipDuplicateAliasCheck = ISNULL((select Value from MMConfigs (NOLOCK) where name = 'MMS2_CONFIG_SKIP_DUPLICATE_ALIAS_CHECK'), 0)
	-- Find eligible clients
	INSERT	INTO @ClientList
	SELECT	CLIENT.id, CLIENT.name, CLIENT.net_hostname
	FROM	APP_Client CLIENT WITH(NOLOCK)
	WHERE	CLIENT.simOperatingSystemId in (16, 19, 17, 29) -- ManageONTAP NAS/ NAS Filer
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in getting NAS Clients.'
		GOTO ERR_EXIT
	END
	-- Find eligible HOSTS
	INSERT	INTO @hostList
	SELECT	ControlHostId, SMArrayId
FROM	SMControlHost WITH(NOLOCK) WHERE SnapVendorName IN ('NetApp', 'Dell EMC Isilon')
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in getting existing arrays.'
		GOTO ERR_EXIT
	END
	INSERT	INTO @hostList
	SELECT	ControlHostId, SMHostName
FROM	SMControlHost WITH(NOLOCK) WHERE SnapVendorName IN ('Dell EMC Isilon', 'Dell EMC Unity', 'Huawei', 'Hitachi NAS', 'Dell EMC VNX / Celerra')
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in getting existing arrays.'
		GOTO ERR_EXIT
	END
	INSERT	INTO @tblOutput
	SELECT	ClientId, clientNetHostName, 0, '' FROM @ClientList
	INSERT	INTO @tblOutput
	SELECT	0, N'', CtrlHostId, arrayId FROM @hostList
	IF(@skipDuplicateAliasCheck > 0)
	BEGIN
		SELECT 0, N'', 0, N'', @errCode, @errStr
		RETURN
	END
	SELECT ClientId, clientNetHostName, ctrlHostId, arrayId, 0, N'' FROM @tblOutput
	RETURN
ERR_EXIT:
	SELECT 0, N'', 0, N'', @errCode, @errStr
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientsAndArrays')
	delete from GxQscripts where name = 'AppGetClientsAndArrays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientsAndArrays')
	delete from GXDBVersions where aliasname = 'AppGetClientsAndArrays'
GO

insert into GXDBVersions values(2, 'AppGetClientsAndArrays',  '00000000000000000000', 'AppGetClientsAndArrays', '00000000000000000000')
GO

