

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientReadiness.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientReadiness.sp,v $ $Id: AppGetClientReadiness.sp,v 1.10.2.15 2020/06/02 22:58:08 samrutkar Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppGetClientReadiness   - returns Client Readiness
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetClientReadiness')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientReadiness <<<'
	drop procedure AppGetClientReadiness
END
IF EXISTS (select * from GxQscripts where name='AppGetClientReadiness')
	delete from GxQscripts where name = 'AppGetClientReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientReadiness')
	delete from GXDBVersions where aliasname = 'AppGetClientReadiness'
GO
print '... Creating Procedure: AppGetClientReadiness'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetClientReadiness
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @CCRId integer,
  @i_userId integer,
  @i_excludeDisabled integer
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientName NVARCHAR(255);
  DECLARE @o_subClient integer;
  DECLARE @o_appTypeId integer;
  DECLARE @o_subClientName NVARCHAR(255);
  DECLARE @o_appTypeName varchar(255);
  DECLARE @o_backupSetName NVARCHAR(255);
  DECLARE @o_StoragePolicyName NVARCHAR(255);
  DECLARE @o_maname NVARCHAR(255);
  DECLARE @o_CCRStatus integer;
  DECLARE @o_CCRNetworkStatus integer;
  DECLARE @o_CCRResourceStatus integer;
  DECLARE @o_dataPathId integer;
  DECLARE @o_dataPathFlag integer;
  DECLARE @o_numDataPaths integer;
  DECLARE @o_numRows integer;
  DECLARE @o_isNonRealSubClients integer;
  DECLARE @o_softwareCompression integer;
  DECLARE @o_Deduplication integer;
  DECLARE @o_instanceName varchar(255);
--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempReadinessCheck') IS NOT null DROP TABLE #tempReadinessCheck
CREATE TABLE #tempReadinessCheck(
				clientId			integer,
				clientName			NVARCHAR(256),
				subClientId			integer,
				subClientName		NVARCHAR(256),
				backupSetId			integer,
				BackupSetName	NVARCHAR(256),
				appTypeId			integer,
				appName			NVARCHAR(256),
				archGrpId			integer,
				spName			NVARCHAR(256),
				archCopyId			integer,
				archCopyName		varchar(256),
				dataPathId			integer,
				DataPathFlag		integer,
				mediaAgentId		integer,
				mediaAgentName		varchar(256),
				CCRResultFlag		integer,
				CCRNetworkReadinessFlag		integer,
				CCRResourceReadinessFlag		integer,
				numDataPaths		integer,
				numRows				integer,
				isNonRealSubClients	integer,
				softwareCompression integer,
				Deduplication		integer,
				associatedsubclientPolicyId 	integer,
				instanceName        varchar(256) default ''
)
-- get the id's from CCRToSubClient Table
INSERT INTO #tempReadinessCheck(clientId,subClientId,backupSetId,dataPathId,CCRResultFlag,CCRNetworkReadinessFlag,CCRResourceReadinessFlag,appTypeId,mediaAgentId,DataPathFlag,archGrpId,archCopyId)
SELECT CCRS.clientId,CCRS.subClientId,APP.backupSet,CCRS.dataPathId,CCRS.CCRResultFlag,CCRS.CCRNetworkReadinessFlag,CCRS.CCRResourceReadinessFlag,CCRS.appTypeId,MD.HostClientId,MD.readinessFlag,AGC.archGroupId,MD.copyId
FROM CCRToSubClient CCRS (NOLOCK)
INNER JOIN MMDataPath MD (NOLOCK)  ON  CCRS.ccrId = @CCRId AND CCRS.dataPathId = MD.dataPathId AND (CCRS.CCRResultFlag!=64  OR 0=@i_excludeDisabled)
INNER JOIN archGroupCopy AGC (NOLOCK)  ON   MD.copyId = AGC.Id  AND AGC.type<>5
INNER JOIN APP_Application APP (NOLOCK)  ON  CCRS.subClientId = APP.id
IF @i_userId > 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 2013, 0, '#rptUserObjects'  --SUB_CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR commcellID <> 2
	delete  t
	from #tempReadinessCheck t, APP_Application A WITH (READUNCOMMITTED)
	WHERE SubClientId=id AND
	 0 = (	select	count(*) from #rptUserObjects  u
			where	u.clientId in (0, t.clientId) AND
					u.appTypeId IN (0,t.appTypeId) AND
					u.instanceId IN (0,a.instance) AND
					u.backupsetId IN (0,t.backupSetId) AND
					u.subClientId IN (0,t.subClientId))
	DROP TABLE #rptUserObjects
END
--update the clientname
UPDATE #tempReadinessCheck
SET clientName = (case when AC.id > 1 then AC.displayname else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_Client AC (NOLOCK) ON tmp.clientid = AC.id
-- update the media agent name
UPDATE #tempReadinessCheck
SET mediaAgentName = (case when AC.id > 1 then AC.displayname else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_Client AC (NOLOCK) ON tmp.mediaAgentId = AC.id
--update subClientName
UPDATE #tempReadinessCheck
SET subClientName = (case when subClientId > 0  then APP.subClientName else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_Application APP (NOLOCK) ON tmp.subClientId = APP.id
--update BackupSetName
UPDATE #tempReadinessCheck
SET backupSetName = (case when BS.Id > 0  then BS.name else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_BackupSetName BS (NOLOCK) ON  tmp.backupSetId = BS.id
--update associated PolicyId for subclient policy case
IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
CREATE TABLE #tempSubclientProp(
subClientId					integer,
associatedsubclientPolicyId 	integer,
Deduplication				integer
)
INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
SELECT tmp.subClientId,prop.attrVal, ISNULL(SProp.attrVal,1) FROM #tempReadinessCheck tmp
INNER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = tmp.subClientId AND prop.attrName = 'Associated subclient Policy' AND prop.modified = 0
LEFT OUTER JOIN APP_SubclientProp SProp WITH (NOLOCK) ON  SProp.componentNameId =  prop.attrVal AND SProp.attrName = 'Single Instancing Option'  AND SProp.modified = 0
INSERT INTO #tempSubclientProp (subClientId,associatedsubclientPolicyId,Deduplication)
SELECT tmp.subClientId,0, ISNULL(prop.attrVal,1) FROM #tempReadinessCheck tmp
LEFT OUTER JOIN APP_SubclientProp prop WITH (NOLOCK) ON  prop.componentNameId = tmp.subClientId AND prop.attrName = 'Single Instancing Option' AND prop.modified = 0
LEFT OUTER JOIN #tempSubclientProp SProp WITH (NOLOCK) ON  SProp.subClientId = tmp.subClientId
WHERE SProp.subClientId is NULL
UPDATE tmp
SET associatedsubclientPolicyId = prop.associatedsubclientPolicyId
FROM #tempReadinessCheck tmp
LEFT OUTER JOIN #tempSubclientProp prop ON
prop.subClientId = tmp.subClientId
-- update instanceName  for Oracle Database , SAP for Oracle, DB2
UPDATE #tempReadinessCheck
SET instanceName = (case when subClientId > 0  then instance.name else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_Application APP (NOLOCK) ON tmp.subClientId = APP.id
INNER JOIN APP_InstanceName instance (NOLOCK) ON APP.instance = instance.id
--update Application Name
UPDATE #tempReadinessCheck
SET appName = (case when apptypeId > 0  then IDA.name else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN APP_IDAType IDA (NOLOCK) ON tmp.appTypeId = IDA.type
-- Update SP Name
update #tempReadinessCheck
SET spName= (case when AG.id > 1 then AG.name+'('+AGC.name+')' else 'N/A' end)
FROM #tempReadinessCheck tmp
INNER JOIN archGroup AG (NOLOCK) ON  tmp.archGrpId = AG.id
INNER JOIN archGroupCopy AGC (NOLOCK) ON  tmp.archCopyId = AGC.id
--update The num data paths for each archive GroupId
update R
SET numDataPaths = (select count(*) from #tempReadinessCheck T where T.subClientId = R.subClientId and T.archGrpId = R.archGrpId   group by subClientId,archGrpId)
FROM #tempReadinessCheck R
--update The num of rows
update R
SET numRows = (select count(*) from #tempReadinessCheck T where T.subClientId = R.subClientId and T.archGrpId = R.archGrpId  group by archGrpId,subClientId)
FROM #tempReadinessCheck R
--set 1 for client having non real subclients
update R
SET isNonRealSubClients = (case when (select COUNT(clientId) from APP_Application
									where clientId = R.clientId AND (subclientstatus =0
									OR ((subclientstatus & 8) >0) AND  ((subclientstatus & 48) = 0  )
									OR ((subclientstatus &256) >0 AND  ((subclientstatus & 48) = 0 )))) > 0 then 0 else 1 end)
FROM #tempReadinessCheck R
--update The num data paths for each archive GroupId
update R
SET softwareCompression = (SELECT TOP 1 compressWhere FROM archPipeConfig WITH (NOLOCK) WHERE appNumber = R.subClientId),
Deduplication = prop.Deduplication
FROM #tempReadinessCheck R
INNER JOIN #tempSubclientProp prop
ON R.subClientId  = prop.subClientId
IF object_id('tempdb.dbo.#tempSubclientProp') IS NOT null DROP TABLE #tempSubclientProp
update R
SET softwareCompression = CASE WHEN  softwareCompression< 1 OR softwareCompression IS NULL THEN 0 ELSE softwareCompression END,
Deduplication = CASE WHEN  Deduplication< 1 OR Deduplication IS NULL THEN 0 ELSE Deduplication END
FROM #tempReadinessCheck R
IF object_id('tempdb.dbo.#tempCompresswhere') IS NOT null DROP TABLE #tempCompresswhere
CREATE TABLE #tempCompresswhere(
				clientId				INTEGER,
				subClientId				INTEGER,
				archGrpId				INTEGER,
				archCopyId				INTEGER,
				SIDBStoreId				INTEGER,
				SIDBFlags				INTEGER,
				dedupeFlags				INTEGER,
				copyExtendedFlags		INTEGER,
				SignatureModuleWhere	INTEGER,
				DedupEnabledOnClient	INTEGER,
				compressWhere			INTEGER
				)
INSERT INTO #tempCompresswhere(clientId ,subClientId, archGrpId, archCopyId,SIDBStoreId,dedupeFlags,copyExtendedFlags,DedupEnabledOnClient)
SELECT rcheck.clientId,rcheck.subClientId,rcheck.archGrpId,rcheck.archCopyId,ISNULL(CSD.SIDBStoreId, 0),AGC.dedupeFlags,AGC.extendedFlags,0
FROM #tempReadinessCheck rcheck INNER JOIN archGroupCopy AGC WITH (NOLOCK)
ON rcheck.archCopyId = AGC.ID
LEFT OUTER JOIN archSubclientCopyDDBMap CSD WITH (READUNCOMMITTED) ON CSD.copyID = AGC.id AND CSD.appId = rcheck.subClientId
UPDATE compress
SET SIDBFlags = isnull((select  Flags
	FROM	idxSIDBStore sidb WITH (NOLOCK)
	WHERE	sidb.SIDBStoreId =compress.SIDBStoreId),0)
FROM #tempCompresswhere compress
UPDATE compress
SET DedupEnabledOnClient = CASE
WHEN (dedupeFlags & 262144) <> 0
AND (dedupeFlags & 1048576) = 0
							then isnull((select  CONVERT(int, attrVal)
			FROM	APP_ClientProp WITH (NOLOCK)
		WHERE	ComponentNameId = compress.clientId AND modified = 0
			AND attrName =N'Enable DeDuplication'),DedupEnabledOnClient)
			else 0 end
FROM #tempCompresswhere compress
UPDATE compress
SET SignatureModuleWhere =   CASE
WHEN (dedupeFlags & 262144) <> 0
AND (dedupeFlags & 1048576) = 0
										 AND DedupEnabledOnClient =1
									THEN 3
WHEN (dedupeFlags & 262144) <> 0
AND (dedupeFlags & 1048576) = 0
									THEN isnull(Deduplication,SignatureModuleWhere)
									ELSE 0
								END
FROM #tempCompresswhere compress
INNER JOIN #tempReadinessCheck R ON R.clientId   =compress.clientId	AND  R.subClientId = compress.subclientid
UPDATE compress
SET SignatureModuleWhere =   CASE
									WHEN SignatureModuleWhere > 0
AND (dedupeFlags & 524288) <> 0 AND DedupEnabledOnClient = 0
									THEN 3
								else SignatureModuleWhere
								END
FROM #tempCompresswhere compress
UPDATE compress
SET compressWhere =  isnull((select  config.compressWhere
			FROM	archPipeConfig config WITH (NOLOCK)
WHERE	config.appNumber = compress.subClientId),compressWhere)
FROM #tempCompresswhere compress
UPDATE compress
SET compressWhere =  4
FROM #tempCompresswhere compress
WHERE compress.compressWhere IS NULL
UPDATE compress
SET compressWhere = CASE
						WHEN compressWhere = 1 AND SignatureModuleWhere IN (1, 3)
						THEN 0
WHEN compressWhere = 2 AND ((dedupeFlags & 262144) = 0)
AND ((copyExtendedFlags & 16) > 0)
						THEN 0
					else compressWhere
					END
FROM #tempCompresswhere compress
UPDATE compress
SET compressWhere = CASE
						WHEN compressWhere = 4
						THEN 2
WHEN (dedupeFlags & 262144 & ~(1048576))>0 AND compressWhere = 2 	AND ((SIDBFlags & 2) > 0)
						THEN 0
					else compressWhere
					END
FROM #tempCompresswhere compress
UPDATE rcheck
SET rcheck.softwareCompression = compress.compressWhere
FROM #tempReadinessCheck rcheck,#tempCompresswhere compress
WHERE rcheck.subClientId = compress.subClientId and  rcheck.archCopyId = compress.archCopyId
SELECT clientId,clientName,subclientid, appTypeId, subclientname,appName,backupSetName,spName,mediaAgentName,CCRResultFlag,CCRNetworkReadinessFlag,CCRResourceReadinessFlag,dataPathId,DataPathFlag,numDataPaths,numRows, isNonRealSubClients,softwareCompression,Deduplication,instanceName
FROM #tempReadinessCheck
ORDER BY archGrpId,subclientid
drop table #tempReadinessCheck
drop table #tempCompresswhere
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientReadiness')
	delete from GxQscripts where name = 'AppGetClientReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientReadiness')
	delete from GXDBVersions where aliasname = 'AppGetClientReadiness'
GO

insert into GXDBVersions values(2, 'AppGetClientReadiness',  '00010010000200150000', 'AppGetClientReadiness', '00010010000200150000')
GO

