

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientProperties.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientProperties.sp,v $ $Id: AppGetClientProperties.sp,v 1.147.2.151.4.1 2021/01/13 05:55:07 pankajkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetClientProperties"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetClientProperties <<<'
	drop procedure AppGetClientProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetClientProperties')
	delete from GxQscripts where name = 'AppGetClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetClientProperties'
GO
print '... Creating Procedure: AppGetClientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetClientProperties
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @i_clientId INTEGER
DECLARE @ClientList TABLE ( client INT )
DECLARE @AllClient INT
DECLARE @FinalDataInterfacePair TABLE ( clientid INT,
							srcClientID INT,
							srcInterface NVARCHAR(255),
							destClientID INT,
							destInterface NVARCHAR(255),
							isActive INT)
DECLARE @FinalLicenseEntity TABLE ( clientid INT,
							LicenseID INT,
							LicenseName NVARCHAR(255))
DECLARE @FinalActivePhyNode TABLE ( clientid INT,
							ActPhyNodeclientID INT,
							ActPhyNodeclientName NVARCHAR(255),
							ActPhyNodeclientHostName NVARCHAR(255))
DECLARE @FinalVM_PM TABLE ( clientid INT,
							VMPMClientID INT,
							VMPMClientName NVARCHAR(255))
DECLARE @FinalUpdateAgentList TABLE ( clientid INT,
							UpdateAgentID INT,
							UpdateAgentName NVARCHAR(255))
DECLARE @ProxyClients TABLE ( clientid INT,
							   clientName NVARCHAR(255),
							   hostName NVARCHAR(255))
DECLARE @DAGClient TABLE ( physical_clientid INT DEFAULT 0,
							pseudo_clientid INT DEFAULT 0,
							pseudo_clientName NVARCHAR(255) DEFAULT '',
							physical_hostname NVARCHAR(255) DEFAULT '')
DECLARE @DLPContentTbl TABLE ( clientid INT,
								dlpContents NVARCHAR(MAX)
								)
DECLARE @PseudoClientComponentTbl TABLE ( propertyTypeId INT,
								stringVal NVARCHAR(MAX)
								)
DECLARE @DLPFilterTbl TABLE ( clientid INT,
								dlpFilters NVARCHAR(MAX)
								)
DECLARE @DLPRMContentTbl TABLE ( clientid INT,
								dlpRmContents NVARCHAR(MAX)
								)
DECLARE @DLPRMFilterTbl TABLE ( clientid INT,
								dlpRmFilters NVARCHAR(MAX)
								)
DECLARE	@clientPackages	TABLE ( clientId int,
								t_packageId int,
								t_packageName varchar(256),
								t_bInstalled int,
								t_releaseId int,
								t_flag int,
								t_osType varchar(64))
DECLARE	@clientComponents	TABLE ( clientId int,
								t_packageId int,
								t_packageName varchar(256),
								t_bInstalled int,
								t_releaseId int,
								t_flag int,
								t_osType varchar(64))
DECLARE @clientAgents TABLE ( clientId int,
								t_type int,
								t_displayname
								varchar(256))
DECLARE @storagePolicyTbl TABLE( clientId INT,
								 storagePolicyId INT,
								 storagePolicyName NVARCHAR(288))
DECLARE @DesktopGuiProperties TABLE(   clientId INT,
									   allowBackupControl INT,
									   successiveBackupJobsFailed INT,
									   isRecoveryPageDisplayed INT,
									   isSchedulingPageDisplayed INT,
									   bandwidthBeforeBackupAttempted INT,
									   journalChunkSize INT,
									   allowContentManagement INT,
									   allowCompareDataBeforeBackup INT,
									   allowToGenerateDataVerificationReport INT,
									   allowToRunDataVerificationJobs INT,
									   allowToChangeSmartSchedulingParameters INT,
									   isChainingEnabled INT)
DECLARE @PseudoClients TABLE ( clientid INT,
							proxyClientName NVARCHAR(255))
DECLARE @clientClusterInfoTbl TABLE ( 	clientid INT,
					clusterType INT,
					defaultInstanceIdForClusterClient INT)
DECLARE @FinalClientList TABLE ( clientid INT,
				ClientName NVARCHAR(255),
				ClientHostName NVARCHAR(255),
				ClientCSHostName NVARCHAR(255),
				IsCommServer INT,
				IsMA INT,
				-- Pseudo Client Flags
				IsDeletedClient	NVARCHAR(10),
				IsPseudoRAC	NVARCHAR(10),
				IsPseudoSAPHANA	NVARCHAR(10),
				IsPseudoMDM	NVARCHAR(10),
				IsDCInstalled NVARCHAR(10),
				IsPseudoDPF	NVARCHAR(10),
				--IsWorkStationBackup	NVARCHAR(10),
				IsPseudoSRM NVARCHAR(10), -- this is for SRM PseudoClient
				IsPseudoDAG	NVARCHAR(10),
				IsDummyClientForFirewallSetup NVARCHAR(10),
				IsDAGAssociatedClient NVARCHAR(10),--
				IsObjectServer NVARCHAR(10),
				IsCCpHold  NVARCHAR(10),
				IsCCP  NVARCHAR(10),
				IsSQLAlwaysON	NVARCHAR(10),
				--Special Client Flags
				IsClientHiddenInGUI NVARCHAR(10),
				IsCommCellPackageAbsent  NVARCHAR(10),
				IsClientCountedOnScaleLimits  NVARCHAR(10),
				ClientRequiresLicense NVARCHAR(10),
				grcMigratedClient NVARCHAR(10),
				grcDeconfigureInSourceClient  NVARCHAR(10),
				-- Client Flags
				IsFastCIEnabled	NVARCHAR(10),
				IscxbfInstalled INT,
				IswebSearchServerInstalled INT,
				IsMergedExchangePackageInstalled INT,
				IswebSearchClientInstalled INT,
				IsPersonalWorkstation NVARCHAR(10),
				NoValidIdaPresent NVARCHAR(255),
				ContentIndexEngineInstalled NVARCHAR(255),
				FastServerInstalled NVARCHAR(255),
				DesktopServerInstalled NVARCHAR(255),
				IsPreConfigured NVARCHAR(255),
				IsVirtualClient NVARCHAR(255),
				IsQsnapUNIX NVARCHAR(255),
				IsVirtualServerDiscoveredClient NVARCHAR(10),
				vmStatusInfoXML	XML,
				IsEdcDiscoveredClient NVARCHAR(10),
				IsMiniSRMClient NVARCHAR(10),
				IsAddInClient NVARCHAR(10),
				OSId NVARCHAR(255),
				OSName NVARCHAR(255),
				PlatformId NVARCHAR(255),
				PlatformName NVARCHAR(255),
				TimeZone NVARCHAR(255),
				ClockSkewInSeconds NVARCHAR(255),
				ClockSkewInHours NVARCHAR(255),
				ClockSkewInMin NVARCHAR(255),
				ClockSkewInSec NVARCHAR(255),
				ClientDescription NVARCHAR(MAX),
				InstallDirectory NVARCHAR(255),
				VersionId NVARCHAR(255),
				EnableDataManagement NVARCHAR(255),
				EnableDataRecovery NVARCHAR(255),
				EnableOnlineContentIndex NVARCHAR(255),
				JobPriority NVARCHAR(255),
				JobResultsRetentionDays NVARCHAR(255),
				JobResultsDiskCapThreshold NVARCHAR(255),
				JobResultsImpersonateUser NVARCHAR(255),
				JobResultsDirectory NVARCHAR(255),
				JobResultsThresholdMB NVARCHAR(255),
				--EnableEncryption NVARCHAR(255),
				--RestoreAccessPubKey NVARCHAR(255),
				--RestoreAccessSynFull NVARCHAR(255),
				CipherType NVARCHAR(255),
				EncryptKeyLength NVARCHAR(255),
				RestoreAccessFlag NVARCHAR(255),
				DirectMediaAccessFlag NVARCHAR(255),
				ClientNoPhysicalMachine NVARCHAR(255),
				CDRLogFileLocation NVARCHAR(255),
				AltCachePartitionForQSnap NVARCHAR(255),
				EnableContentIndexing NVARCHAR(255),
				EnableSnapBackups NVARCHAR(255),
				SnapBackupMAInstalled NVARCHAR(255),
				OptimizeDataForSearch NVARCHAR(255),
				EnableRetryOnNetError NVARCHAR(255),
				RetryFrequencyInSecOnNetError NVARCHAR(255),
				RetryCountOnNetError NVARCHAR(255),
				ComplianceUrl NVARCHAR(255),
				EndUserUrl NVARCHAR(255),
				AdminUrl NVARCHAR(255),
				WebURL NVARCHAR(255),
				PathToExchangeMiningTool NVARCHAR(255),
				AutoPatchUpdateLocation NVARCHAR(255),
				StorePatchLocally NVARCHAR(255),
				CenteraResourceFilename NVARCHAR(255),
				EnableCollectDelegateInfo int,
				ClientInterface NVARCHAR(255),
				PortForCVD NVARCHAR(255),
				PortForEvMgrC NVARCHAR(255),
				ActivePhysicalNode INT,
				WebServer INT,
				ProxyHostForContentSearch INT,
				ProxyHostForFileSystem INT,
				UpdateCacheAgent INT,
				ProxyHostForExchange INT,
				VersionInfo XML,
				UpdateAgentId INT,
				UpdateAgentName NVARCHAR(255),
				CPUCount INT,
				BinarySetID INT,
				ByteOrder NVARCHAR(255),
				CacheSource INT,
				FixMe NVARCHAR(255),
				fileLevelAnalyticsLicense NVARCHAR(255),
				GlobalZoneHost  INT,
				SMTPAddressOfTheRMSSuperUser NVARCHAR(255),
				rmsCredentailsUser NVARCHAR(255),
				rmsCredentailsPassword NVARCHAR(255),
				decryptRMSDocumentDuringContentIndexing INT,
				performClientSideDeduplication	INT,
				enableHighLatencyOptimization	INT,
				cacheBufferSize INT,
				enableClientSideDiskCache INT,
				maxCacheDb INT,
				enableVariableContentAlignment INT,
				deskTopGuiProperties NVARCHAR(1024),
				overrideGlobalDesktopGuiProperties INT	,
				IsRemoteCacheEnabled	INT	,
				sharePointWebServerUrl NVARCHAR(255),
				sharePointWebServerUserName NVARCHAR(255),
				sharePointWebServerPassword NVARCHAR(255),
				enableOnlineSearch INT,
				enableAccessControlCollection INT,
				configureClusterClient	INT,
				showAllAgents	INT,
				baseInstallFolder NVARCHAR(1024),
				openVMSProxyClientId INT,
				openVMSUserName NVARCHAR(255),
				openVMSUserPassword NVARCHAR(255),
				webserverClientId INT,
				webserverClientName NVARCHAR(255),
				webServiceWebSitePortNumber NVARCHAR(32),
				webServiceSearchWebAlias NVARCHAR(1024),
				webSearchServerForRecallClientId INT,
				isWebServerInstalled NVARCHAR(10),
				webSearchServerForSuperSearch INT,
				recallService NVARCHAR(MAX),
				IsWebConsoleInstalled INT,
				enableDLP INT,
				dlpStolen INT,
				dlpEnableClientKeys INT,
				dlpScanIntervalMins INT,
				dlpMinFileAgeMins INT,
				enableRmDLP INT,
				dlpRmOfflineDays INT,
				dlpRmNow INT,
				billableEntityId INT,
				pseudoClientType INT,
				nasClusterClientPropertiesXML XML,
				displayName nvarchar(255),
				-- Reading datasecurity enabled as varchar because its an encrypted hash value
				dataSecurityEnabled nvarchar(255),
				dlpEnableAutomaticDecryption INT,
				dlpUnlockMethod INT,
				enableEmailWebApp INT,
				ExchangeAdminUserName NVARCHAR(255),
				ExchangeAdminSmtpAddress NVARCHAR(MAX),
				vmTotalCount				BIGINT,
				vmProtectedCount			BIGINT,
				vmNotProtectedCount			BIGINT,
				vmPendingCount				BIGINT,
				vmBackedUpWithErrorCount	BIGINT,
				vmNeverBackedUpCount		BIGINT,
				awsAccessKey	NVARCHAR(255),
				azureSubscriptionId 	NVARCHAR(255),
				azureTenantId	NVARCHAR(255),
				azureAppId	NVARCHAR(255),
				cloudHyperVisorType	INT,
				excludeFromSLA INT,
				slaCopyRedundancy INT,
				slaCopyFallenBehindDays INT,
				rpoMinutes INT,
				rtoMinutes INT,
				sharePointPseudoClientProps XML,
				edgeSystemDriveType INT,
				isIndexingV2 INT,
				isQsnapInstalled INT,
				edgeDriveClientAssoc	XML,
				isJobThrottleEnabled INT,
				excludeImmidiateJobs INT,
				dataJobThrottle INT,
				logJobThrottle INT,
				isDescriptionInHTMLFormat INT,
				isDisableEdgeDriveVersions INT,
				isEdgeDriveAuditEnabled INT,
				isEdgeDrivePushNotificationEnabled INT,
				edgeDriveStagingMachine INT,
				edgeDriveStagingDir NVARCHAR(MAX),
				encryptionSettings INT,
				IsExchangeOnePassClient NVARCHAR(55),
				sharePointFarmClient INT,
				mailServerRole INT,
				impersonateUserName	NVARCHAR(MAX),
				isExchangePseudoClient INT,
				isIndexingV2NAS INT,
				timezoneSetByUser INT,
				BlockLevelCacheDir NVARCHAR(MAX),
				timezoneId INT,
				is1TouchClient INT,
				queueJobsIfOtherConflictingJobsAreActive NVARCHAR(255),
				IBMiUserProfile NVARCHAR(100),
				SubsystemDesc	NVARCHAR(MAX),
				JobQueue		NVARCHAR(MAX),
				IsCreateJobQueue	INT,
				IBMiDataFolder	NVARCHAR(MAX),
				IBMIJobPriority		INT,
				RunPriority		INT,
				dm2CacheRetentionDays NVARCHAR(255),
				dm2CacheDiskCapThreshold NVARCHAR(255),
				dm2CacheImpersonateUser NVARCHAR(255),
				dm2CacheDirectory NVARCHAR(255),
				dm2CacheThresholdMB NVARCHAR(255),
				clientGuid uniqueidentifier,
				copyMgmtLicense INT,
				devsnapInitiatorIQN NVARCHAR(255),
				devsnapTargetPort NVARCHAR(16),
				devsnapServerType NVARCHAR(255),
				openVMSProxyClientList XML,
				isFarmClient INT,
				maxStreams INT,
				forceClientSideDownload INT,
				overrideGlobalEncryptionSettings INT,
				iSCSIPort INT,
				dbThinClientProxyClientList XML,
				regionId varchar(20),
				geoLocation nvarchar(max),
				clientAppType INT,
				nutanixFileServerId INT,
				fileServerCredential XML,
				jobStartTime INT,
				SLAStatus INT DEFAULT 4, --Yet to be protected by default. For new clients we may not have an entry in RptSlaClient table.
				isClientBasePackageInstalled INT,
				isIndexingV2VSA INT,
				companyId VARCHAR(20),
				IsAdvancedFSPackageInstalled NVARCHAR(10),
				isUserCentricClient INT,
				SLACategory INT DEFAULT(0),
				SLACategoryDescription	NVARCHAR(255) DEFAULT '',
				slaMissReasonList XML,
				nwReadiness	INT DEFAULT(0),
				nwReadinessUpdatedTime	BIGINT,
				lastOnlineTime	BIGINT,
				lastOfflineTime	BIGINT,
				memberServers	NVARCHAR(MAX),  --Agent level properties for SQL Cloud Clients
				azureStorageConnectionString NVARCHAR(MAX),
				azureSQLUsername	NVARCHAR(MAX),
				s3BucketName NVARCHAR(MAX),
				awsSqlInstanceUsername  NVARCHAR(MAX),
				sqlUseLocalSystem INT,
				sqlOverride INT,
				sqlUsername NVARCHAR(MAX),
				sqlPassword NVARCHAR(MAX),
				retireClientPhase INT DEFAULT(0),
				NasVendorType INT,
				virtualServerCredId 	INT,
				virtualServerCredName 	NVARCHAR(255),
				indexingV2EnabledMask 	BIGINT DEFAULT(0),
				migrationServerXML XML,
				IsInfrastructureMachine		INT DEFAULT(0),
				InfrastructureMachineType		INT DEFAULT(0)
				)
DECLARE @FinalXMLList TABLE
	(
		clientId INT,
		securityXML XML,
		entitySecurityAssociation XML,
		networkthrottlingXML XML,
		firewallXML XML,
		activityControlXML XML
	)
IF OBJECT_ID('tempdb.dbo.#indexServer') IS NOT NULL DROP TABLE #indexServer
	CREATE TABLE #indexServer (
			clusterType INT,
			cloudServerType INT,
			cloudId INT,
			cloudStatus INT,
			cloudName NVARCHAR(256),
			cloudDisplayName NVARCHAR(256),
			indexDirectory NVARCHAR(256),
			analyticsEnabled VARCHAR(10),
			zkCloudId INT,
			zkCloudName NVARCHAR(1024),
			indexServerPoolId INT,
			indexServerPoolName NVARCHAR(256),
			replicationFactor INT,
			indexServerLanguage INT,
            indexServerClientId INT,
			planId	INT,
			planName NVARCHAR(256),
			storagePolicyId INT,
			storagePolicyName NVARCHAR(256)
		)
IF OBJECT_ID('tempdb.dbo.#nodeProperties') IS NOT NULL DROP TABLE #nodeProperties
CREATE TABLE #nodeProperties (
			clientId INT,
			clientName NVARCHAR(256),
			clientDisplayName NVARCHAR(256),
			indexDirectory NVARCHAR(256),
			javaMaxMem INT,
			portNo INT,
			analyticsEnabled VARCHAR(10),
			isWebserver VARCHAR(10),
			nodeStatus	 INT,
			URL NVARCHAR(1024)
		)
IF OBJECT_ID('tempdb.dbo.#rolesList') IS NOT NULL DROP TABLE #rolesList
CREATE TABLE #rolesList (
			roleId INT,
			roleName NVARCHAR(255),
			roleStatus INT DEFAULT 0,
			isEnabled VARCHAR(10) DEFAULT 'false',
			isCloudSupported VARCHAR(10) DEFAULT 'false',
			isAssocToEdgeClient VARCHAR(10) DEFAULT 'false'
		)
IF OBJECT_ID('tempdb.dbo.#zkNodes') IS NOT NULL DROP TABLE #zkNodes
CREATE TABLE #zkNodes (
		clientId INT,
        zkClientName NVARCHAR(1024),
		zkDisplayName NVARCHAR(1024),
        zkListenerPort INT ,
        zkDataPort    INT ,
        zkElectionPort INT ,
        zkServerID    INT,
        zkNodeStatus INT,
		zkDataDir NVARCHAR(1024),
		t_metaXML XML)
IF OBJECT_ID('tempdb.dbo.#contentAnalyzerTbl') IS NOT NULL DROP TABLE #contentAnalyzerTbl
    CREATE TABLE #contentAnalyzerTbl
							(	t_clientId INT,
								t_clientName VARCHAR(255),
								t_hostName VARCHAR(255),
								t_clientType INT,
								t_nodeStatus INT DEFAULT 0,
								t_isCAEnabled VARCHAR(32) DEFAULT 'false',
								t_jvmMax VARCHAR(32) DEFAULT '4096',
								t_caPortNo VARCHAR(32) DEFAULT '22000' ,
								t_caURL VARCHAR(255) DEFAULT '',
								t_indexLocation VARCHAR(1024) DEFAULT '',
								t_clientDisplayName NVARCHAR(512) DEFAULT '',
								t_cloudId	INT,
								t_pseudoClientId INT DEFAULT 0,
								t_cloudStatus INT DEFAULT 0)
IF OBJECT_ID('tempdb.dbo.#selectiveSyncContent') IS NOT NULL DROP TABLE #selectiveSyncContent
CREATE TABLE #selectiveSyncContent (
			itemPath NVARCHAR(MAX)
		)
------------------
DECLARE @Clientprop INT
DECLARE @userId INT
DECLARE @localeId INT
DECLARE @r_capabilityId INT
DECLARE @idoc int
DECLARE @errorXML XML
DECLARE @outvar nvarchar(MAX)
DECLARE @doc varchar(1024)
DECLARE @nasClusterProperties XML
DECLARE	@vmStatusInfoXML XML
DECLARE @associationEntity XML
DECLARE @securityCheckError NVARCHAR(MAX)
-- PROPERTY FLAGS FLAT
DECLARE @getAssociatedCGProperty INT=0
DECLARE @getSecurityProperty INT=0
DECLARE @getActivityControlProperty INT=0
DECLARE @getRegistryProperty INT=0
DECLARE @getFirewallProperty INT=0
DECLARE @getNetworkThrottleProperty INT=0
DECLARE @getVersionInfoProperty INT = 0
DECLARE @getOsInfoProperty INT = 0
DECLARE @getidaList INT = 0
DECLARE @getAllProperties INT=0
DECLARE @getStoragePolicyProperty INT = 0    -- get storage policy of default Subclient of default BackupSet
DECLARE @getPseudoClients INT = 0
DECLARE @ErrorTable TABLE ( clientid INT,
							   clientName NVARCHAR(255),
							   errorCode INT,
							   errorString NVARCHAR(255))
DECLARE @clientGroupList TABLE
    (
      [c_id] INT NOT null,
	  [c_name] NVARCHAR(255),
      [c_flag] INT NOT null
    )
DECLARE @capabilityReqd bigint = 0
DECLARE @hideMask int = 0
SET @Clientprop =  @xmlText.exist('/App_GetClientPropertiesRequest')
IF @Clientprop <> 1
	SET @Clientprop =  @xmlText.exist('/App_Associations')
IF @Clientprop = 1
BEGIN
       SET @AllClient = (SELECT  ref.value('@allEntities', 'int') AS client
                    FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref ))
    SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
    SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetClientPropertiesRequest/processinginstructioninfo/locale') R ( ref )),0)
	SET @r_capabilityId = ISNULL((SELECT  ref.value('@capabilityFlags', 'int') AS Agent
                         FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions') R ( ref )),0)
	if @r_capabilityId=6
	begin
		set @r_capabilityId = 2
	end
	--PROPERTY FLAGS
	SET @getAssociatedCGProperty = ISNULL((SELECT  ref.value('@associatedClientGroups', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getSecurityProperty = ISNULL((SELECT  ref.value('@security', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getActivityControlProperty = ISNULL((SELECT  ref.value('@activityControl', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getRegistryProperty = ISNULL((SELECT  ref.value('@registry', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getFirewallProperty = ISNULL((SELECT  ref.value('@firewallConfiguration', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getNetworkThrottleProperty = ISNULL((SELECT  ref.value('@networkThrottle', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getVersionInfoProperty = ISNULL((SELECT  ref.value('@versionInfo', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
    SET @getOsInfoProperty = ISNULL((SELECT  ref.value('@osInfo', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
    SET @getidaList = ISNULL((SELECT  ref.value('@idaList', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getStoragePolicyProperty = ISNULL((SELECT  ref.value('@storagePolicy', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getAllProperties = ISNULL((SELECT  ref.value('@all', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	SET @getPseudoClients = ISNULL((SELECT  ref.value('@pseudoClients', 'int') AS client  FROM    @xmlText.nodes('App_GetClientPropertiesRequest/extendedFilter/propertiesFilter') R ( ref )),0)
	DECLARE @getSpecificAgentClients INT =0
       -- create the ida list temporary table
	IF object_id('tempdb.dbo.#idaGroupListTbl') IS NOT null DROP TABLE #idaGroupListTbl
	CREATE TABLE #idaGroupListTbl
	(
		[r_groupAppId] INT
	)
		   IF object_id('tempdb.dbo.#idaLstTbl') IS NOT null DROP TABLE #idaLstTbl
	CREATE TABLE #idaLstTbl
	(
		[r_appId] INT
	)
	IF object_id('tempdb.dbo.#idaInfoTbl') IS NOT null DROP TABLE #idaInfoTbl
	CREATE TABLE #idaInfoTbl
	(
		[r_clientId] INT DEFAULT(0),
		[r_appId]               INT DEFAULT(0),
		[r_appName] nvarchar(MAX) DEFAULT(NULL),
		[r_slaStatus] INT DEFAULT(4),
		[r_slaDescription] varchar(MAX)	,
		[r_slaMissReasonList]	XML
	)
		INSERT INTO #idaGroupListTbl
		SELECT  ref.value('@appGroupId', 'int') AS Agent
		FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )
		DELETE #idaGroupListTbl WHERE r_groupAppId IS NULL
		IF EXISTS(SELECT * FROM #idaGroupListTbl)
		BEGIN
			INSERT INTO #idaLstTbl
			SELECT appTypeId from APP_AppTypeGroupAssoc where
			appGroupId in (select [r_groupAppId] from #idaGroupListTbl) and typeOfGroup=0
		END
		INSERT INTO #idaLstTbl
		SELECT  ref.value('@applicationId', 'int') AS Agent
		FROM    @xmlText.nodes('App_GetClientPropertiesRequest/filterOptions/ChildrenEntity') R ( ref )
		DELETE #idaLstTbl WHERE r_appId IS NULL
		IF EXISTS (SELECT * FROM #idaLstTbl)
			SET @getSpecificAgentClients = 1
	-- OLD BACKWARD COMPABILITY> IF NONE OF PROPS SET THEN GET ALL
	IF @getAllProperties = 0 AND @getAssociatedCGProperty=0 AND @getSecurityProperty=0 AND @getActivityControlProperty=0
	   AND @getRegistryProperty=0 AND @getFirewallProperty=0 AND @getNetworkThrottleProperty=0 AND @getVersionInfoProperty=0 AND @getOsInfoProperty=0 AND @getidaList=0 AND @getStoragePolicyProperty=0 AND @getPseudoClients=0
	   SET @getAllProperties = 1
	IF @getAllProperties = 1
	BEGIN
		SET @getAssociatedCGProperty = 1
		SET @getSecurityProperty = 1
		SET @getActivityControlProperty = 1
		SET @getRegistryProperty = 1
		SET @getFirewallProperty = 1
		SET @getNetworkThrottleProperty =1
		SET @getVersionInfoProperty = 1
        SET @getOsInfoProperty =1
        SET @getidaList=1
		SET @getPseudoClients=1
	END
END
ELSE
	SET @AllClient = (SELECT  ref.value('@allclients', 'int') AS client
                    FROM    @xmlText.nodes('App_ClientListReq') R ( ref ))
------ Get accessible client group list ------------
IF @userId IS NULL
	SET @userId = 0
IF @userId = 0
BEGIN
	INSERT INTO  @clientGroupList
	SELECT
	[c_id] = CLG.id,
	[c_name] = CLG.[name],
	[c_flag] = CLG.[flag]
	FROM [APP_ClientGroup] CLG
	WHERE
	status & 2 <> 2
	and CLG.[flag] & @hideMask = 0
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#sec_clientGroupList') IS NOT NULL
		DROP TABLE #sec_clientGroupList
	CREATE TABLE #sec_clientGRoupList (entityID INT)
	EXEC sec_getNonIdaObjectsForThisUser @userId,
28,
										0,
										'#sec_clientGroupList'
	INSERT INTO  @clientGroupList
	SELECT distinct
	[c_id] = CLG.id,
	[c_name] = CLG.[name],
	[c_flag] = CLG.[flag]
	FROM [APP_ClientGroup] CLG
	INNER JOIN    #sec_clientGroupList sec ON
		CLG.id = sec.entityID
	WHERE
	status & 2 <> 2
	and CLG.[flag] & @hideMask = 0
	DROP TABLE #sec_clientGroupList
END
-----------------------------------------------------
IF @AllClient = 1
       BEGIN
                    -- Do the security check here. We will not be doing it later within loop for client List table.
					IF OBJECT_ID('tempdb.dbo.#getClientProperties_getIdaObjectsForUser') IS NOT NULL
						DROP TABLE #getClientProperties_getIdaObjectsForUser
					CREATE TABLE #getClientProperties_getIdaObjectsForUser
					(
						clientId INT,
						appTypeId INT,
						instanceID INT,
						backupsetId INT,
						subclientId INT
					)
					EXEC sec_getIdaObjectsForUser @userId,								-- userId
3,						-- entityTypeReq
												0,										-- permissionId (any permission)
												1,										-- inheritFromChildren
												'#getClientProperties_getIdaObjectsForUser'		-- tableOutput
					 INSERT  INTO @ClientList
                     SELECT distinct c.id from [dbo].[APP_Client] c, simInstalledPackages SIP WITH(NOLOCK), simPackageMap SP WITH(NOLOCK), #getClientProperties_getIdaObjectsForUser Sec
                     where  (Sec.clientID = C.id)
					 AND (@getSpecificAgentClients<>1 OR  SP.apptype IN (SELECT r_appId FROM #idaLstTbl)
                    AND SIP.simPackageID = SP.simPackageId
                    AND SIP.ClientId = C.id)
       END
ELSE
BEGIN
	IF @Clientprop = 1
	BEGIN
		INSERT  INTO @ClientList
							SELECT DISTINCT ref.value('@clientId', 'int') AS client					-- For GAT input request contains same client twice. So load only once.
							FROM    @xmlText.nodes('App_Associations/entity') R ( ref )
		INSERT  INTO @ClientList
							SELECT DISTINCT ref.value('@clientId', 'int') AS client
							FROM    @xmlText.nodes('App_GetClientPropertiesRequest/association/entity') R ( ref )
		INSERT  INTO @ClientList
							SELECT DISTINCT clientId from [dbo].[APP_ClientGroupAssoc]
							WHERE clientGroupId IN
								(SELECT  ref.value('@clientGroupId', 'int') AS client
								FROM    @xmlText.nodes('App_Associations/entity') R ( ref ))
		IF (SELECT COUNT(client) FROM @ClientList) = 1
		BEGIN
			SET @i_clientId = (SELECT client FROM @ClientList)
			SET @associationEntity = (SELECT @i_clientId AS '@clientId'
										FOR XML PATH('entity'))
IF (@i_clientId = -32001)
			BEGIN
				INSERT INTO @ErrorTable
SELECT @i_clientId,'', (4599 | (CAST(POWER(2, 24) AS BIGINT) * 35)),  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4599 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO ALL_DONE
			END
IF(@i_clientId = -32000)  OR NOT EXISTS(SELECT ID FROM app_client where id = @i_clientId)
			BEGIN
				INSERT INTO @ErrorTable
SELECT @i_clientId, '',(4598 | (CAST(POWER(2, 24) AS BIGINT) * 35)),  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4598 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO ALL_DONE
			END
			SET @securityCheckError = ''
			EXEC [dbo].[Sec_DoesUserHaveRightsOnEntity] @associationEntity,@userId,@r_capabilityId,0,@localeId,@securityCheckError OUTPUT
			IF (len(@securityCheckError)>0)
			BEGIN
				INSERT INTO @ErrorTable
				SELECT C.id,C.name,1,@securityCheckError
				FROM app_Client C
				WHERE C.id = @i_clientId
     			GOTO ALL_DONE
     		END
		END
		ELSE
		BEGIN
		DECLARE @associatedEntitiesRequest xml
		DECLARE @associatedEntitiesResponse xml
		DECLARE @processinginstructioninfoXML XML
		DECLARE @associatedEntitiesTable TABLE
			(
				xmlval xml
			)
		set @processinginstructioninfoXML = @xmlText.query('App_GetClientPropertiesRequest/processinginstructioninfo')
		SELECT @associatedEntitiesRequest =ISNULL(@xmlText.query('App_GetClientPropertiesRequest/association/entity'),'')
		SET @associatedEntitiesRequest = ( SELECT 3 '@expandLevel',@processinginstructioninfoXML, @associatedEntitiesRequest	FOR XML PATH('App_GetAssociatedEntities'))
		INSERT INTO @associatedEntitiesTable
		EXEC dbo.GetAssociatedEntities @associatedEntitiesRequest
		SET @associatedEntitiesResponse = ISNULL((select top 1 xmlval from @associatedEntitiesTable),'<App_GenericResponse/>')
		DECLARE @inTable table
		(
			clientId integer ,
			clientName nvarchar(max),
			errorString nvarchar(max),
			errorCode integer,
			guid varchar(40)
		)
		INSERT INTO @inTable
		SELECT
		ISNULL(s.ref.value('@clientId', 'int'),0),
		ISNULL(s.ref.value('@clientName', 'nvarchar(max)'),''),
		ISNULL(Tbl.Col.value('@errorString', 'nvarchar(max)'),''),
		ISNULL(Tbl.Col.value('@errorCode', 'int'),0),
		ISNULL(Tbl.Col.value('@clientGUID', 'varchar(40)'),'')
		FROM @associatedEntitiesResponse.nodes('/App_GenericResponse/response')  Tbl(Col)
		  OUTER APPLY Col.nodes('entity') S(ref)
		INSERT  INTO @ErrorTable
		SELECT clientId, clientName, errorCode, errorString from @inTable
		where errorCode <> 0
		DELETE FROM @clientList			-- This table now might be containing wrong client Ids (on which user do not have rights) and client groups not expanded.
										-- Drop the entries and insert freshly from getAssociatedEntities output.
		INSERT  INTO @ClientList
		SELECT clientId from @inTable
		where errorCode = 0
		END
	END
	ELSE
	BEGIN
		INSERT  INTO @ClientList
						SELECT  ref.value('@clientId', 'int') AS client
						FROM    @xmlText.nodes('App_ClientListReq/clients') R ( ref )
		INSERT  INTO @ClientList
						SELECT clientId from [dbo].[APP_ClientGroupAssoc]
						WHERE clientGroupId IN
							(SELECT  ref.value('@clientGroupId', 'int') AS client
							FROM    @xmlText.nodes('App_ClientListReq/clientgroups') R ( ref ))
		IF (SELECT COUNT(client) FROM @ClientList) = 1
		BEGIN
			SET @i_clientId = (SELECT client FROM @ClientList)
			SET @associationEntity = (SELECT @i_clientId AS '@clientId'
										FOR XML PATH('entity'))
			SET @securityCheckError = ''
			EXEC [dbo].[Sec_DoesUserHaveRightsOnEntity] @associationEntity,@userId,@r_capabilityId,0,@localeId,@securityCheckError OUTPUT
			IF (len(@securityCheckError)>0)
			BEGIN
				INSERT INTO @ErrorTable
				SELECT C.id,C.name,1,@securityCheckError
				FROM app_Client C
				WHERE C.id = @i_clientId
     			GOTO ALL_DONE
     		END
		END
	END
END
-- Need this list for VM's. Instead of gettingfor all clients, lets get it only 1 time and keep it.
IF OBJECT_ID('tempdb.dbo.#idaClientList') IS NOT NULL DROP TABLE #idaClientList
CREATE TABLE #idaClientList
(
t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaClientList'
DECLARE @clientcur CURSOR
DECLARE @cliID INT
SET @clientcur = CURSOR
FOR	SELECT DISTINCT client FROM @ClientList
	OPEN @clientcur
		FETCH NEXT FROM @clientcur INTO @cliID
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @i_clientId = @cliID
			IF @i_clientId != 1
				BEGIN
									IF @Clientprop = 1						-- When multiple clients are passed, association entity is not yet filled.
									BEGIN									-- Bringing back old code to fill it, so security, firewall, activity control, etc. gets populated correct
										SET @associationEntity = (select @i_clientId as '@clientId'
																	for xml path('entity'))
									END
									DECLARE  @r_releaseId				INTEGER
									DECLARE  @r_status					INTEGER
									DECLARE  @r_specialClientFlags		INTEGER
									DECLARE  @r_OSId					INTEGER
									DECLARE  @r_OSName					NVARCHAR(255)
									DECLARE  @r_hwId					INTEGER
									DECLARE  @r_hwName					NVARCHAR(255)
									DECLARE  @r_licenses				INTEGER
									DECLARE  @r_CIEngineInstalled		INTEGER
									DECLARE  @r_isCommServer			INTEGER
									DECLARE  @r_isMA					INTEGER
									DECLARE  @r_QinetixInstallDir		NVARCHAR(255)
									DECLARE  @r_snapBackupsMAInstalled	INTEGER
									IF	object_id('tempdb.dbo.#TEMP_APP_CLIENT') is not null DROP TABLE #TEMP_APP_CLIENT
									IF	object_id('tempdb.dbo.#TEMP_APP_CLIENTPROP') is not null DROP TABLE #TEMP_APP_CLIENTPROP
									-- Get data from App_Client table
									SELECT	id														AS clientId,
											name													AS clientName,
											net_hostname											AS netHostName,
											csHostName												AS csHostName,
											jobResultDir											AS jobResultDir,
											clientDescription										AS description,
											simOperatingSystemId											AS simOperatingSystemId,
											clientSkewTime											AS clientSkewTime,
											cvdPort													AS cvdPort,
											evmgrcPort												AS evmgrcPort,
											releaseId												AS releaseId,
											status													AS status,
											specialClientFlags										AS specialClientFlags,
											displayName												AS displayName,
											GUID													AS clientGuid
									INTO	#TEMP_APP_CLIENT
									FROM	APP_CLIENT
									WHERE	id = @i_clientId
									INSERT INTO @DAGClient (physical_clientid, pseudo_clientid, pseudo_clientName, physical_hostname)
									SELECT @i_clientId, AA.id, AA.net_hostname, AA.attrName
									FROM
									(
										SELECT TOP 1 AC.id, AC.net_hostname, AP.attrName FROM #TEMP_APP_CLIENT TC
										INNER JOIN APP_ClientProp AP (NOLOCK)  ON AP.attrName = TC.netHostName AND AP.attrType = 125 AND AP.modified = 0
										INNER JOIN APP_Client AC (NOLOCK) ON AC.id = AP.componentNameId
										WHERE TC.clientId = @i_clientId
									)AA
									IF(@getStoragePolicyProperty = 1)
									BEGIN
										INSERT INTO @storagePolicyTbl (clientId, storagePolicyId, storagePolicyName)
										SELECT subclient.clientId, ag.id, ag.name FROM APP_Application subclient WITH(NOLOCK)
										INNER JOIN APP_BackupSetName BkpSet WITH(NOLOCK) ON subclient.backupSet = BkpSet.id
										INNER JOIN archgroup ag WITH(NOLOCK) ON subclient.dataArchGrpID = ag.id
										INNER JOIN APP_AppTypeGroupAssoc ATGA ON subclient.appTypeId = ATGA.appTypeId
										WHERE ATGA.appGroupId = 35 -- APPGRP_FileSystemIDA
										AND (subclient.dataArchGrpID > 1) -- 1 is for storagePolicy CV_DEFAULT
AND subclient.clientId = @i_clientId AND ((subclient.subclientStatus & 0x00008) = 0x00008) AND ((BkpSet.STATUS & 0x00008) = 0x00008)
									END
									INSERT INTO @FinalClientList(clientid) VALUES (@i_clientId)
									UPDATE @FinalClientList
									SET ClientCSHostName = (SELECT csHostName from #TEMP_APP_CLIENT),
									ClientName = (SELECT clientName from #TEMP_APP_CLIENT),
									ClientHostName = (SELECT netHostName from #TEMP_APP_CLIENT),
									clientGuid = (SELECT clientGuid from #TEMP_APP_CLIENT)
									WHERE clientid = @i_clientId
									SET @r_status = (SELECT STATUS FROM #TEMP_APP_CLIENT)
									SET @r_specialClientFlags = (SELECT specialClientFlags FROM #TEMP_APP_CLIENT)
									IF  @getAllProperties = 1
									BEGIN
									-- Get data from App_ClientProp table
									SELECT
											ISNULL([Encrypt: rsaPubKey], N'')						AS rsaPubKey,
											ISNULL([Encrypt: rsaPriKeySF], N'')						AS rsaPriKeySF,
											ISNULL([Encrypt: restoreAccess], 0)						AS restoreAccess,
											ISNULL([Encrypt: drToolAccess], 0)						AS drtoolAccess,
											ISNULL([Encrypt: Type], 2)								AS cipher,
											ISNULL([Encrypt: Key Length], 128)						AS keylen,
											ISNULL([URL for Compliance Search], N'')				AS complianceSearchURL,
											ISNULL([URL for End-User Search], N'')					AS endUserSearchURL,
											ISNULL([URL for Administrator], N'')					AS AdminURL,
											ISNULL([WebURL], N'')									AS WebURL,
											ISNULL([Web Server for Search], 0)						AS webServerForSearch,
											ISNULL([NW Err Retry Flag], 1)							AS nwErrRetryFlag,
											ISNULL([NW Err Retry Frequency], 30)					AS nwErrRetryFreq,
											ISNULL([NW Err Retry Count], 40)						AS nwErrRetryCount,
											ISNULL([Patch Local Location], N'')						AS patchLoc,
											ISNULL([Patch Location flag], 1)						AS patchLocFlag,
											ISNULL([Snap Shot Engine], 0)							AS snapShotEngine,
											ISNULL([Snap Backups Enabled], 0)						AS snapBackupsEnabled,
											ISNULL([JobResultsThresholdMB], 500)						AS jobResultsThresholdMB,
											ISNULL([Job Results Dir Username], N'')					AS JRusername,
											ISNULL([DataPipeInterface], N'')						AS interface,
											ISNULL([DiskFullPercent], 90)							AS diskfull,
											ISNULL([AgingDays], 7)									AS cacheAging,
											ISNULL([Proxy Content Indexing], 0)						AS contentProxy,
											ISNULL([timezone], N'')									AS timezone,
											ISNULL([Alt Cache Partition], N'')						AS AltCachePrt,
											ISNULL([Centera Resource File], N'')					AS resourceFileName,
											ISNULL([Content Indexing Enabled], 0)					AS contentIndexingEnabled,
											ISNULL([FLR Log Filepath], N'')							AS CDRLogLocation,
											ISNULL([Virtual Client], 0)								AS isVirtualClient,
											ISNULL([Active Physical Node], 0)						AS physClientId,
											ISNULL([Proxy for Exchange], 0)							AS proxyForExchange,
											ISNULL([UPDATE CACHE AGENT ID], 0)						AS updateCacheAgentId,
											ISNULL([Collect Delegate Information], 0)				AS collectDelegateInfo,
											ISNULL([Do not Single Instance Email Messages], 0)		AS donotSingleInstance,
											ISNULL([Proxy Filesystem Client Id], 0)					AS proxyFSClientId,
											ISNULL([platformdeleted 4], 0)							AS deleted,
											ISNULL([JMPriority], 6)									AS priority,
											ISNULL([Content Indexing Engine], N'')					AS CIEngineName,
											ISNULL([Sim OS Info], N'')								AS OSInfo,
											ISNULL([Exchange Mining Tool Path], N'')				AS exchangeMiningToolPath,
											ISNULL([Data Classification Installed on Client], 0)	AS DCinstalled,
											ISNULL([HotSpot], 0)									AS isQSnapUNIX,
											ISNULL([NoPhysicalMachinePresent], 0)					AS noPhysMachPresent,
											ISNULL([File Level Analytics License],0)				AS fileLevelAnalLic,
											ISNULL([Global Zone Host],0)							AS globalZoneHostId,
											ISNULL([RMS SMTP Address],N'')							AS SMTPAddressOfTheRMSSuperUser,
											ISNULL([Decrypt RMS document User name],N'')			AS rmsCredentailsUser,
											ISNULL([Decrypt RMS document Pass word],N'')			AS rmsCredentailsPassword,
											ISNULL([Decrypt RMS document during CI],0)				AS decryptRMSDocumentDuringContentIndexing,
											ISNULL([Enable DeDuplication],0)						AS performClientSideDeduplication,
											ISNULL([Optimize for High Latency Networks],0)			AS enableHighLatencyOptimization,
											ISNULL([Maximum Cache Buffer Size],1024)					AS cacheBufferSize,
											ISNULL([Enable Client Signature Cache],0)			AS enableClientSideDiskCache,
											ISNULL([Client Max DB Cache Size],4096)					AS maxCacheDb,
											ISNULL([Enable Intelligent Block Alignment],0)				AS enableVariableContentAlignment,
											ISNULL([WBA Configuration Parameters],0)				AS deskTopGuiProperties,
											ISNULL([WBA Override Global settings],0)				AS overrideGlobalDesktopGuiProperties,
											ISNULL([Mini SRM Agent],0)								AS IsMiniSRMClient,
											ISNULL([Virtual Server Discovered Clients],0)			AS isVirtualServerDiscoveredClient,
											ISNULL([Outlook Addin Client],0)						AS isAddInClient,
											ISNULL([SharePoint WebService URL],N'')					AS sharePointWebServerUrl,
											ISNULL([SharePoint WebService User name],N'')			AS sharePointWebServerUserName,
											ISNULL([SharePoint WebService User password],N'')		AS sharePointWebServerPassword,
											ISNULL([SharePoint Online Content Indexing],0)			AS enableOnlineSearch,
											ISNULL([Access Control Collection],1)					AS enableAccessControlCollection,
											ISNULL([Configure Cluster Client],0)					AS configureClusterClient,
											ISNULL([All Agents],0)									AS showAllAgents,
											ISNULL([Base Install Folder],N'')						AS baseInstallFolder,
											ISNULL([Open VMS proxy client],0)						AS openVMSProxyClientId,
											ISNULL([Open VMS proxy client list], N'')				AS openVMSProxyClientList,
											ISNULL([Open VMS User Name],N'')						AS openVMSUserName,
											ISNULL([Open VMS User Password],N'')					AS openVMSUserPassword,
											ISNULL([WebSearchClient Web Server Client],0)						AS webSearchClientId,
											ISNULL([DM2WebService Web Site Port],N'')							AS webServiceWebSitePortNumber,
											ISNULL([DM2WebService Search Web Alias],N'')					AS webServiceSearchWebAlias,
											ISNULL([Web Search Server for Recall], 0)						AS webSearchServerForRecallClientId,
											ISNULL([Web Search Server for Super Search], 0)					AS webSearchServerForSuperSearch,
											ISNULL([Recall Service], N'')									AS recallService,
											ISNULL([enableDLP], 0)											AS enableDLP,
											ISNULL([dlpStolen], 0)											AS dlpStolen,
											ISNULL([dlpEnableClientKeys], 0)								AS dlpEnableClientKeys,
											ISNULL([dlpScanIntervalMins], 15)								AS dlpScanIntervalMins,
											ISNULL([dlpMinFileAgeMins], 5)								AS dlpMinFileAgeMins,
											ISNULL([enableRmDLP], 0)									AS enableRmDLP,
											ISNULL([dlpRmOfflineDays], 30)								AS dlpRmOfflineDays,
											ISNULL([dlpRmNow], 0)										AS dlpRmNow,
											-- Reading from the new column name instead 'Enable Data Security'
											ISNULL([7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],0)							AS dataSecurityEnabled,
											ISNULL([dlpEnableAutomaticDecryption], 0)					AS dlpEnableAutomaticDecryption,
											ISNULL([dlpUnlockMethod], 0)								AS dlpUnlockMethod,
											ISNULL([Enable Email Web App],0)						AS 	enableEmailWebApp,
											ISNULL([Exchange Administrator User name],N'')			AS ExchangeAdminUserName,
											ISNULL([Exchange Administrator Smtp Address],N'')		AS ExchangeAdminSmtpAddress,
											ISNULL([Exclude From SLA],0)						AS 	excludeFromSLA,
											ISNULL([SLA Copy Redundancy],0)						AS 	slaCopyRedundancy,
											ISNULL([SLA Copy Fallen Behind Days],0)				AS 	slaCopyFallenBehindDays,
											ISNULL([RPO Minutes],0)								AS 	rpoMinutes,
											ISNULL([RTO Minutes],0)								AS 	rtoMinutes,
											ISNULL([System Drive Type],0)						AS edgeSystemDriveType,
											ISNULL([IndexingV2], 0)								AS isIndexingV2,
											ISNULL([Qsnap installed],0)							AS isQsnapInstalled,
											ISNULL([Throttle Jobs Enabled],0)					AS isJobThrottleEnabled,
											ISNULL([Throttle Jobs - Data Threshold],1)			AS dataJobThrottle,
											ISNULL([Throttle Jobs - Log Threshold],1)			AS logJobThrottle,
											ISNULL([Is Client Description in HTML Format],0)	AS isDescriptionInHTMLFormat,
											[Edge Drive Disable Versions]						AS isDisableEdgeDriveVersions ,
											[Edge Drive Enable Audit]							AS isEdgeDriveAuditEnabled ,
											[Edge Drive Enable Push Notification]				AS isEdgeDrivePushNotificationEnabled ,
											[Edge Drive Staging Machine]						AS edgeDriveStagingMachine,
											[Edge Drive Staging Directory]						AS edgeDriveStagingDir,
											[Encryption Settings]								AS encryptionSettings,
											ISNULL([Exchange OnePass Client], 0)				AS IsExchangeOnePassClient,
											ISNULL([SharePoint Farm Client], 0)					AS sharePointFarmClient,
											ISNULL([Content Store Mail Server Role], 0)			AS mailServerRole,
											[UNCPath user name]									AS impersonateUserName,
											ISNULL([Exchange Pseudo Client], 0)					AS isExchangePseudoClient,
											ISNULL([IndexingV2_NAS], 0)							AS isIndexingV2NAS,
											ISNULL([Timezone set by User], 0)					AS timezoneSetByUser,
											ISNULL([Block level cache Directory],N'')			AS BlockLevelCacheDir,
											ISNULL([1-Touch Client],0)							AS is1TouchClient,
											ISNULL([Queue Jobs If Conflicting Jobs Are Active], 0)	AS queueJobsIfOtherConflictingJobsAreActive,
											ISNULL([IBMi User Name], '')							AS IBMiUserProfile,
											ISNULL([IBMi System Description],'')					AS SubsystemDesc,
											ISNULL([IBMi Job Queue],'')								AS JobQueue,
											ISNULL([IBMi Create Job Queue], 0)						AS IsCreateJobQueue,
											ISNULL([IBMi Data Folder],'')							AS IBMiDataFolder,
											ISNULL([IBMi Job Priority], 0)							AS IBMIJobPriority,
											ISNULL([IBMi Run Priority], 0)							AS RunPriority,
											ISNULL([DM2Cache ThresholdMB], 500)						AS DM2CacheThresholdMB,
											ISNULL([DM2Cache Directory], N'')						AS DM2CacheDirectory,
											ISNULL([DM2Cache Dir Username], N'')					AS DM2CacheUserName,
											ISNULL([DM2Cache Disk Full Percent], 90)				AS DM2CacheDiskfull,
											ISNULL([DM2Cache Aging Days], 7)						AS DM2CacheAging,
											ISNULL([Copy Management License], 0)					AS CopyMgmtLicense,
											ISNULL([Dev Snap Initiator IQN], N'')					AS DevSnapInitiatorIQN,
											ISNULL([Dev Snap Target Port], 3260)					AS DevSnapTargetPort,
											ISNULL([Dev Snap Server Type], N'')						AS DevSnapServerType,
											ISNULL([Azure Subscription Id], '')						AS azureSubscriptionId,
											ISNULL([Azure Tenant Id], '')							AS azureTenantId,
											ISNULL([maxStreams], '')								AS maxStreams,
											ISNULL([Force Client Side Download], 2)					AS forceClientSideDownload,
											ISNULL([Override Global Encryption Settings],3)			AS overrideGlobalEncryptionSettings,
											[iSCSI Port Number]										AS iSCSIPort,
											ISNULL([DB Thin Client Proxy Client List], N'')			AS dbThinClientProxyClientList,
											[Client Geo Location]									AS geoLocation,
											[Client App Type] 										AS clientAppType,
											[Nutanix AFS Snap Control Host ID]						AS nutanixFileServerId,
											[File Server Credentials]                               AS fileServerCredential,
											[JobStartTime]											AS jobStartTime,
											4														AS SLAStatus,
											ISNULL([IndexingV2_VSA], 0)								AS isIndexingV2VSA,
											(CASE
												WHEN [Installation Company ID] IS NULL THEN
													(SELECT TOP 1 ISNULL(componentNameId, '')
														FROM App_companyProp
WHERE attrName = 'Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group')
														AND attrValInt IN (SELECT c_id FROM @clientGroupList))
												ELSE
													[Installation Company ID]
											END) AS companyId,
											ISNULL([User Centric Client], 0)                       AS isUserCentricClient,
											0													   AS SLACategory,
											CAST('' AS NVARCHAR(255))	  						   AS SLACategoryDescription,
											CAST(NULL AS XML)			  						   AS slaMissReasonList,
											0													   AS nwReadiness,
											[NAS OS Type]  								   AS NasVendorType,
											ISNULL([IndexingV2_EnabledMask], 0)					   AS indexingV2EnabledMask,
											[IsInfrastructureMachine] AS IsInfrastructureMachine,
											[InfrastructureMachineType] AS InfrastructureMachineType
									INTO	#TEMP_APP_CLIENTPROP
									FROM
									(
										SELECT	componentNameId, attrName, attrVal
										FROM	App_ClientProp
										WHERE	componentNameId = @i_clientId
										AND		modified = 0
									) AS clients
									PIVOT
									(
										MAX(attrVal)
										FOR attrName IN
										(
											[Encrypt: rsaPubKey],
											[Encrypt: rsaPriKeySF],
											[Encrypt: restoreAccess],
											[Encrypt: drToolAccess],
											[Encrypt: Type],
											[Encrypt: Key Length],
											[URL for Compliance Search],
											[URL for End-User Search],
											[URL for Administrator],
											[WebURL],
											[Web Server for Search],
											[NW Err Retry Flag],
											[NW Err Retry Frequency],
											[NW Err Retry Count],
											[Patch Local Location],
											[Patch Location flag],
											[Snap Shot Engine],
											[Snap Backups Enabled],
											[JobResultsThresholdMB],
											[Job Results Dir Username],
											[DataPipeInterface],
											[DiskFullPercent],
											[AgingDays],
											[Proxy Content Indexing],
											[timezone],
											[Alt Cache Partition],
											[Centera Resource File],
											[Content Indexing Enabled],
											[FLR Log Filepath],
											[Virtual Client],
											[Active Physical Node],
											[Proxy for Exchange],
											[UPDATE CACHE AGENT ID],
											[Collect Delegate Information],
											[Do not Single Instance Email Messages],
											[Proxy Filesystem Client Id],
											[platformdeleted 4],
											[JMPriority],
											[Content Indexing Engine],
											[Sim OS Info],
											[Exchange Mining Tool Path],
											[Data Classification Installed on Client],
											[HotSpot],
											[NoPhysicalMachinePresent],
											[File Level Analytics License],
											[Global Zone Host],
											[RMS SMTP Address],
											[Decrypt RMS document User name],
											[Decrypt RMS document Pass word],
											[Decrypt RMS document during CI],
											[Enable DeDuplication],
											[Optimize for High Latency Networks],
											[Maximum Cache Buffer Size],
											[Enable Intelligent Block Alignment],
											[Client Max DB Cache Size],
											[Enable Client Signature Cache]	,
											[WBA Configuration Parameters],
											[WBA Override Global settings],
											[Mini SRM Agent],
											[Virtual Server Discovered Clients],
											[Outlook Addin Client],
											[SharePoint WebService URL],
											[SharePoint WebService User name],
											[SharePoint WebService User password],
											[SharePoint Online Content Indexing],
											[Access Control Collection],
											[Configure Cluster Client],
											[All Agents],
											[Vs Member Servers],
											[Base Install Folder],
											[Open VMS proxy client],
											[Open VMS proxy client list],
											[Open VMS User Name],
											[Open VMS User Password],
											[WebSearchClient Web Server Client],
											[DM2WebService Web Site Port],
											[DM2WebService Search Web Alias],
											[Web Search Server for Recall],
											[Web Search Server for Super Search],
											[Recall Service],
											[enableDLP],
											[dlpStolen],
											[dlpEnableClientKeys],
											[dlpScanIntervalMins],
											[dlpMinFileAgeMins],
											[enableRmDLP],
											[dlpRmOfflineDays],
											[dlpRmNow],
											--Reading from new column name instead of 'Enable Data Security'
											[7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807],
											[dlpEnableAutomaticDecryption],
											[dlpUnlockMethod],
											[Enable Email Web App],
											[Exchange Administrator User name],
											[Exchange Administrator Smtp Address],
											[Exclude From SLA],
											[SLA Copy Redundancy],
											[SLA Copy Fallen Behind Days],
											[RPO Minutes],
											[RTO Minutes],
											[System Drive Type],
											[IndexingV2],
											[Qsnap installed],
											[Throttle Jobs Enabled],
											[Throttle Jobs - Data Threshold],
											[Throttle Jobs - Log Threshold],
											[Is Client Description in HTML Format],
											[Edge Drive Disable Versions],
											[Edge Drive Enable Audit],
											[Edge Drive Enable Push Notification],
											[Edge Drive Staging Machine],
											[Edge Drive Staging Directory],
											[Encryption Settings],
											[Exchange OnePass Client],
											[SharePoint Farm Client],
											[Content Store Mail Server Role],
											[UNCPath user name],
											[Exchange Pseudo Client],
											[IndexingV2_NAS],
											[Timezone set by User],
											[Block level cache Directory],
											[1-Touch Client],
											[Queue Jobs If Conflicting Jobs Are Active],
											[IBMi User Name],
											[IBMi System Description],
											[IBMi Job Queue],
											[IBMi Create Job Queue],
											[IBMi Data Folder],
											[IBMi Job Priority],
											[IBMi Run Priority],
											[DM2Cache ThresholdMB],
											[DM2Cache Directory],
											[DM2Cache Dir Username],
											[DM2Cache Disk Full Percent],
											[DM2Cache Aging Days],
											[Copy Management License],
											[Dev Snap Initiator IQN],
											[Dev Snap Target Port],
											[Dev Snap Server Type],
											[Azure Subscription Id],
											[Azure Tenant Id],
											[maxStreams],
											[Force Client Side Download],
											[Override Global Encryption Settings],
											[iSCSI Port Number],
											[DB Thin Client Proxy Client List],
											[Client Geo Location],
											[Client App Type],
											[Nutanix AFS Snap Control Host ID],
											[File Server Credentials],
											[JobStartTime],
											[IndexingV2_VSA],
											[Installation Company ID],
											[User Centric Client],
											[NAS OS Type],
											[IndexingV2_EnabledMask],
											[IsInfrastructureMachine],
											[InfrastructureMachineType]
										)
									) AS pvt
									UPDATE #TEMP_APP_CLIENTPROP
									SET updateCacheAgentId = ISNULL((SELECT TOP 1 UA.id FROM APP_ComponentProp CP, PatchUpdateAgentInfo UA
WHERE	UA.id = longVal AND propertyTypeId = 1300 AND longval > 0 AND UA.isEnabled =1 AND UA.isDeleted = 0 AND
									componentId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @i_clientId)), 0)
									WHERE updateCacheAgentId = 0
									-- Sets the SLA status. 1 - Met, 2 - Missed, 3 - Exclude
									UPDATE T
									SET T.SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
										T.SLACategory = SLA.Category,
										T.SLACategoryDescription = dbo.WR_GetSLACategoryString(@localeId,SLA.Category)
									FROM #TEMP_APP_CLIENTPROP T
									INNER JOIN RptSLAClient SLA ON SLA.clientId = @i_clientId AND SLA.fullJobsOnly = 0
									UPDATE T
									SET T.SLAStatus = 5,/*MIGHT_MISS_SLA*/
										T.SLACategoryDescription = '',
										T.slaMissReasonList = CAST(stringVal AS XML)
									FROM #TEMP_APP_CLIENTPROP T
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = @i_clientId AND Prop.componentType =  3 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
									UPDATE T
									SET T.SLAStatus = 3/*EXCLUDED_SLA*/,
										T.SLACategoryDescription = ''
									FROM #TEMP_APP_CLIENTPROP T
									INNER JOIN RPTSlaExclusion EX
									ON @i_clientId = EX.clientId AND EX.appTypeId = 0
									UPDATE #TEMP_APP_CLIENTPROP
									SET physClientId = ISNULL((select attrVal from app_clientprop where componentNameId = 2 and attrName = 'CS Active Physical Node' ),0)
									where @i_clientId = 2 and isVirtualClient = 1
									-- Get data from JMJobAction table
									SELECT	ISNULL([4], 0)			AS bkpEnabled,
											ISNULL([5], 0)			AS rstEnabled,
											ISNULL([57], 1)			AS onlineCIEnabled
									INTO	#TEMP_JMJOBCONTROL
									FROM
									(
											SELECT	clientId, optype, action
											FROM	JMJobAction
											WHERE	clientId = @i_clientId
											AND		appType = 0
											AND		mediaAgentId = 1
									) AS activity
									PIVOT
									(
											MAX(action)
											FOR optype IN ([4], [5], [57])
									) AS pvt
									-- Get SIM OS info
									DECLARE @t_hwName		NVARCHAR(1024)
									DECLARE @t_OSInfo		NVARCHAR(1024)
									DECLARE @t_OSRel		NVARCHAR(1024)
									DECLARE @t_hwInfoPos	INTEGER
									DECLARE @t_clientId	INTEGER
									DECLARE @isNas INTEGER=0
									SELECT	@r_OSId = simOperatingSystemId,
											@r_hwId = 0,
											@t_clientId = clientId,
											@r_releaseId= releaseId
									FROM	#TEMP_APP_CLIENT
									SELECT	@t_OSInfo = OSInfo FROM #TEMP_APP_CLIENTPROP
								    SELECT	@r_OSName = dbo.GetClientOSName(@t_clientId, @t_OSInfo),
											@t_OSRel = dbo.GetClientOSRelease(@t_clientId, @t_OSInfo),
											@t_hwName = dbo.GetClientHardwareName(@t_clientId, @t_OSInfo),
											@t_hwInfoPos = CHARINDEX('-:', REVERSE(@t_OSInfo))-1
									IF @r_OSName = ''
										SET @r_OSName = (SELECT name FROM simOperatingSystem S WHERE @t_hwInfoPos <= 0 AND @r_OSId = S.id)
IF(@r_status & 0x0080) = 0x0080
										SET @isNas = 1
									IF @isNas <> 0
									BEGIN
										SET @t_OSInfo =  ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo where ClientId = @t_clientId),'')
										IF @t_OSInfo <> '' AND CHARINDEX(@t_OSInfo, @r_OSName) = 0
											SET @r_OSName = @r_OSName + ' ' +@t_OSInfo
										EXEC [dbo].[AppGetNasClusterProperties]
												@i_clientId,
												@xmlText = @nasClusterProperties OUTPUT
										UPDATE @FinalClientList
										SET nasClusterClientPropertiesXML = @nasClusterProperties
										WHERE clientId = @i_clientId
									END
									-- Migration Server details. Fill for both NAS / non-NDMP clients.
IF (@isNas <> 0) OR (@r_status & CAST(0x8000000 AS INT) <> 0)
									BEGIN
										DECLARE @cutOverApprovers NVARCHAR(MAX) = ''
										DECLARE @dateAndTime NVARCHAR(MAX) = ''
										DECLARE @sourceServer NVARCHAR(MAX) = ''
										DECLARE @excludedBackupContent NVARCHAR(MAX) = ''
										DECLARE @includedBackupContent NVARCHAR(MAX) = ''
										DECLARE @backupThreshold INT
										SELECT @cutOverApprovers = @cutOverApprovers + attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'Cutover approvers' AND modified = 0
										--SELECT @cutOverApprovers
										SELECT @dateAndTime = @dateAndTime + attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'CutOver date and time' AND modified = 0
										--SELECT @dateAndTime
										SELECT @sourceServer = @sourceServer + attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'Source server' AND modified = 0
										--SELECT @sourceServer
										SELECT @excludedBackupContent = @excludedBackupContent + attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'Filer migration excluded backup content' AND modified = 0
										--SELECT @excludedBackupContent
										SELECT @includedBackupContent = @includedBackupContent + attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'Filer migration included backup content' AND modified = 0
										--SELECT @includedBackupContent
										SELECT @backupThreshold = attrVal
										FROM APP_ClientProp
WHERE componentNameId = @i_clientId AND attrName = 'Backup threshold for filer migration' AND modified = 0
										--SELECT @backupThreshold
										IF (@sourceServer IS NOT NULL) AND (LEN(@sourceServer) > 0)
										BEGIN
											DECLARE @migrateServerXML XML
											SET @migrateServerXML =
											(SELECT @backupThreshold AS '@backupThreshold',
												CAST(@cutOverApprovers AS XML),
												CAST(@dateAndTime AS XML),
												CAST(@sourceServer AS XML),
												CAST(@excludedBackupContent AS XML),
												CAST(@includedBackupContent AS XML)
											FOR XML PATH ('migrateServerDetails'))
											UPDATE @FinalClientList
											SET migrationServerXML = @migrateServerXML
											WHERE clientId = @i_clientId
										END
									END
									DECLARE @isVirtualServerDiscoveredClient INT
									SELECT  @isVirtualServerDiscoveredClient = CAST(isVirtualServerDiscoveredClient AS INT) FROM #TEMP_APP_CLIENTPROP
									--Set VM properties for discovered VM client
									IF @isVirtualServerDiscoveredClient <> 0
									BEGIN
										EXEC [dbo].[AppGetVMStatusInfoForClient]
												@i_clientId,
												@o_xmlVMStatusInfoResp = @vmStatusInfoXML OUTPUT
										UPDATE @FinalClientList
										SET vmStatusInfoXML = @vmStatusInfoXML
										WHERE clientId = @i_clientId
									END
									-- Check if any SQL server agent is found at the client level.
									DECLARE @isSqlAgentFound INT = 0
									SET @isSqlAgentFound = (SELECT 1 FROM APP_IDAName WHERE clientId = @i_clientId AND appTypeId = 81 AND status = 0)
									IF @isSqlAgentFound <> 0
									BEGIN
										IF OBJECT_ID('tempdb..#SqliDAProp') IS NOT NULL DROP TABLE #SqliDAProp
										-- Only one row should be found for each client.
										-- i.e., only one iDA can be configured for the client.
										SELECT	pvt.clientId,
												pvt.ida,
												pvt.[MSSQL Override Global Authentication],
												pvt.[MSSQL Use Windows Authentication],
												pvt.[MSSQL username],
												dbo.pswConvertV5ToV3(pvt.[MSSQL password]) [MSSQL password]
										INTO #SqliDAProp
										FROM
										(
											SELECT	@i_clientId clientId,
													DP.componentNameId ida,
													DP.attrName,
													DP.attrVal
												FROM APP_IDAProp DP
													JOIN APP_IDAName AN
														ON DP.componentNameId = AN.id
															AND AN.appTypeId = 81
															AND AN.clientId = @i_clientId
												WHERE DP.modified = 0
										) AS SQLIDA
										PIVOT
										(
											MAX(attrVal)
											FOR attrName IN
											(
												[MSSQL Override Global Authentication],
												[MSSQL Use Windows Authentication],
												[MSSQL username],
												[MSSQL password]
											)
										) AS pvt
										UPDATE @FinalClientList SET
											sqlOverride = (SELECT SP.[MSSQL Override Global Authentication]
																FROM #SqliDAProp SP WHERE SP.clientId = @i_clientId),
											sqlUseLocalSystem = (SELECT
																	CASE SP.[MSSQL Use Windows Authentication]
																		WHEN '1' THEN 1
																		WHEN '0' THEN 0
																		ELSE NULL END
																	FROM #SqliDAProp SP WHERE SP.clientId = @i_clientId),
											sqlUsername = (SELECT SP.[MSSQL username]
																FROM #SqliDAProp SP WHERE SP.clientId = @i_clientId),
											sqlPassword = (SELECT SP.[MSSQL password]
																FROM #SqliDAProp SP WHERE SP.clientId = @i_clientId)
										WHERE clientId = @i_clientId
									END
									-- set Credential Manager Entity for Amazon, Alibaba and Azure Cloud Psuedo Clients
									DECLARE @isCloudPseudoClient INT
									SET @isCloudPseudoClient = ( SELECT TOP 1 id FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'Cloud Hypervisor Type'  AND attrVal in (301, 1401, 402))
									IF @isCloudPseudoClient <> 0
									BEGIN
										DECLARE @virtualServerCredAssocId INT
										DECLARE @virtualServerCredId INT
										DECLARE @virtualserverCredName NVARCHAR(MAX)
										SET @virtualServerCredAssocId = ISNULL((SELECT attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE modified = 0 AND componentNameId = @i_clientId AND attrName = 'Virtual Server Credential Assoc Id'), 0)
										IF @virtualServerCredAssocId <> 0
										BEGIN
											SET @virtualServerCredId = ISNULL((SELECT credentialId FROM APP_CredentialAssoc WITH (NOLOCK) WHERE entityId = @i_clientId AND assocId = @virtualServerCredAssocId), 0)
											SET @virtualServerCredName = ISNULL((SELECT credentialName FROM APP_Credentials WITH (NOLOCK) WHERE credentialId = @virtualServerCredId), '')
											UPDATE @FinalClientList
											SET
											virtualServerCredId = @virtualServerCredId,
											virtualServerCredName = @virtualserverCredName
											WHERE clientId = @i_clientId
										END
									END
									-- set Amazon/Azure SQL pseudo client properties
									DECLARE @isVsMssqlPseudoClient INT
									SET @isVsMssqlPseudoClient = ( SELECT TOP 1 id FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'Cloud Hypervisor Type'  AND attrVal in (301, 401, 402))
									IF @isVsMssqlPseudoClient <> 0
									BEGIN
										DECLARE	@cloudHyperVisorType			INT
										DECLARE @cloudUserId	NVARCHAR(255)
										SET @cloudHyperVisorType = ISNULL((SELECT attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE modified = 0 AND componentNameId = @i_clientId AND attrName = 'Cloud Hypervisor Type'), 0)
										SET @cloudUserId = ISNULL((SELECT attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE modified = 0 AND componentNameId = @i_clientId AND attrName = 'Cloud User ID'), '')
										-- set Agent level properties for SQL Cloud Pseudo Clients since Agent related screens are gone from Command Center
										DECLARE @memberServers NVARCHAR(MAX)
										DECLARE @azureStorageConnectionString NVARCHAR(MAX)
										DECLARE @azureSQLUsername NVARCHAR(MAX)
										DECLARE @s3BucketName NVARCHAR(MAX)
										DECLARE @awsSqlInstanceUsername NVARCHAR(MAX)
										-- List of Proxies Server for both Amazon and Azure
										-- Eventually we want to phase out storing Proxy from Agent Level and keep it at Client and Instance level only
										-- Accordingly, we are fetching it first from Client Level and if not found then from Agent Level
										SET @memberServers = ISNULL((SELECT CP.attrVal FROM APP_ClientProp CP WHERE CP.componentNameId = @i_clientId AND CP.modified = 0 AND CP.attrName = 'Vs Member Servers'), '')
										IF @memberServers = N''
										BEGIN
											SET @memberServers = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'Cloud Proxy Servers' AND iDAN.clientid=@i_clientId), '')
										END
										IF @cloudHyperVisorType = 301 --Amazon
										BEGIN
											SET @s3BucketName = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'S3 Bucket Name' AND iDAN.clientid=@i_clientId), '')
											SET @awsSqlInstanceUsername = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'Aws SQL Instance Username' AND iDAN.clientid=@i_clientId), '')
										END
										ELSE -- Azure
										BEGIN
											SET @azureStorageConnectionString = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'Azure Storage Connection String' AND iDAN.clientid=@i_clientId), '')
											SET @azureSQLUsername = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'Azure SQL Instance Username' AND iDAN.clientid=@i_clientId), '')
											IF (@azureSQLUsername = N'') -- If SQL Authentication Credentials are missing, get it from AD Authentication
											BEGIN
												SET @azureSQLUsername = ISNULL((SELECT iDAP.attrVal FROM APP_IDAProp iDAP JOIN APP_IDAName iDAN ON iDAP.componentnameid = iDAN.id WHERE iDAP.modified = 0 AND iDAP.attrName = 'MSSQL username' AND iDAN.clientid=@i_clientId), '')
											END
										END
										UPDATE @FinalClientList
										SET awsAccessKey = (case when @cloudHyperVisorType = 301 then @cloudUserId else null end),
										azureSubscriptionId = (case when @cloudHyperVisorType = 401 then @cloudUserId when @cloudHyperVisorType = 402 then (SELECT azureSubscriptionId from #TEMP_APP_CLIENTPROP WHERE clientId = @i_clientId) else null end),
										azureAppId = (case when @cloudHyperVisorType = 402 then @cloudUserId else null end),
										cloudHyperVisorType = (case when @cloudHyperVisorType = 301 then 4
														when @cloudHyperVisorType = 401 then 5
														when @cloudHyperVisorType = 402 then 7
														end),
										memberServers = @memberServers,
										azureStorageConnectionString = @azureStorageConnectionString,
										azureSQLUsername = @azureSQLUsername,
										s3BucketName = @s3BucketName,
										awsSqlInstanceUsername = @awsSqlInstanceUsername
										WHERE clientId = @i_clientId
									END -- set Amazon/Azure SQL pseudo client properties
									-- set vm counts for VirtualPseudoClient
									DECLARE @isVirtualPseudoClient INT
									SET @isVirtualPseudoClient = ( SELECT COUNT(*) FROM APP_Application WHERE clientId = @i_clientId AND appTypeId = 106)
									IF @isVirtualPseudoClient <> 0
									BEGIN
										-- Give VM counts only if you have direct View rights on the client
										IF NOT EXISTS (SELECT 1 FROM #idaClientList WHERE t_clientId=@i_clientId)
										BEGIN
											-- User don't have direct view rights
											-- Just set all these vm's count as 0
											UPDATE @FinalClientList
												SET vmTotalCount = 0,
												vmProtectedCount = 0,
												vmNotProtectedCount = 0,
												vmPendingCount = 0,
												vmBackedUpWithErrorCount = 0,
												vmNeverBackedUpCount = 0
												WHERE clientId = @i_clientId
     									END
										ELSE
										BEGIN
											IF object_id('tempdb.dbo.#VMClientInfoTbl') is not null DROP TABLE #VMClientInfoTbl
											CREATE TABLE #VMClientInfoTbl (
												clientId INT,
												status INT
											)
											-- Get List of All VM's for there last job
											-- Table Varible is fine here as we won't be looking at too large data set here
											DECLARE @clientListTbl Table
											(
												clientId			INT,
												subclientID			INT,
												jobId               INT
											)
											INSERT INTO @clientListTbl
											SELECT ACP.componentNameId , CAST(ACP2.attrVal AS INT), CAST(ACP.attrVal AS INT) FROM APP_ClientProp ACP WITH (NOLOCK)
											INNER JOIN APP_ClientProp ACP2
ON ACP2.componentNameId=ACP.componentNameId AND ACP2.attrName='Last Backup Subclient' AND ACP2.modified=0
											WHERE ACP.attrName='Last Backup JobID' AND ACP.modified=0
											INSERT INTO #VMClientInfoTbl (clientId, status)
											SELECT DISTINCT AVP.VMclientId, CAST(AVP.attrVal AS INT) FROM @clientListTbl CLT
												INNER JOIN APP_VMProp AVP WITH (NOLOCK)
													ON AVP.jobId=CLT.jobId AND AVP.attrName = 'vmStatus' AND CLT.clientId=AVP.VMclientId
												INNER JOIN APP_Application AAP WITH (NOLOCK)
														ON AAP.id= CLT.subclientID AND AAP.clientId = @i_clientId
											DECLARE @vmTotalCount				BIGINT
											DECLARE @vmProtectedCount			BIGINT
											DECLARE @vmNotProtectedCount		BIGINT
											DECLARE @vmPendingCount				BIGINT
											DECLARE @vmBackedUpWithErrorCount	BIGINT
											DECLARE @vmNeverBackedUpCount		BIGINT
											-- check if total vm count populated by admin thred
											SET @vmTotalCount = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'vmTotalCount'),0)
											IF @vmTotalCount = 0
											BEGIN
												-- count total vms during last job for that subclient
												DECLARE @vmContentStr VARCHAR(MAX)
												DECLARE @vmContent XML
												SET @vmContentStr = (SELECT TOP 1 attrVal FROM APP_ExtendedProperties WITH(NOLOCK) WHERE attrName = 'Virtual Server Content' AND clientId = @i_clientId)
												SET @vmContent = @vmContentStr
												SET @vmTotalCount = (SELECT COUNT(*) FROM
														(
															SELECT ref.value('@guid', 'nvarchar(max)') AS vmGUID, ref.value('@name', 'nvarchar(max)') AS vmName
																FROM   @vmContent.nodes('EVGui_ManualDiscoverResp/guestHosts2') R ( ref )
															UNION
															SELECT C.attrVal AS vmGUID, CL.displayName AS vmName
																FROM APP_VMProp Vp WITH (NOLOCK)
															INNER JOIN APP_Application APP WITH (NOLOCK)
																ON  APP.clientId = @i_clientId
															inner join JMBkpStats JM WITH (NOLOCK)
																on JM.appId = APP.id AND JM.status in (1,3,14,16) AND VP.jobId=JM.jobId
															INNER JOIN APP_ClientProp C WITH (NOLOCK)
																ON Vp.VMclientId = C.componentNameId AND C.attrName = 'Virtual Machine Instance UUID' AND C.modified=0
															INNER JOIN APP_Client CL WITH (NOLOCK)
																ON CL.id = C.componentNameId
															where Vp.attrName = 'vmstatus' and Vp.attrVal in ('0', '3')
																group by C.attrVal, CL.displayName
															) T
														)
											END
									        DECLARE @deletedVMCount int
											select @deletedVMCount=isnull(count(componentNameId),0) from app_clientprop
											inner join #VMClientinfoTbl VM
											on VM.clientId = componentNameId
											and  attrName='Virtual Machine Deletion Time' AND modified=0 and isnull(attrval, 0) !=0
											SELECT
												@vmProtectedCount = isnull(SUM(CASE WHEN status = 0 THEN 1 ELSE 0 END),0),  -- count successfully backed up vms during last job for that subclient
												@vmBackedUpWithErrorCount = isnull(SUM(CASE WHEN status = 3 THEN 1 ELSE 0 END),0), -- count backed up with errors vms during last job for that subclient
												@vmPendingCount = isnull(SUM(CASE WHEN (status = 2 OR status=4) THEN 1 ELSE 0 END),0)  -- count pending vms during last job for that subclient
											FROM #VMClientInfoTbl
											SET @vmNeverBackedUpCount = 0
											IF @vmTotalCount > 0
											BEGIN
												-- count failed to backed up vms during last job for that subclient
												SET @vmNotProtectedCount = @vmTotalCount - (@vmProtectedCount- @deletedVMCount) - @vmPendingCount - @vmBackedUpWithErrorCount
											END
											UPDATE @FinalClientList
											SET vmTotalCount = @vmTotalCount,
											vmProtectedCount = @vmProtectedCount,
											vmNotProtectedCount = case when @vmNotProtectedCount >0 then @vmNotProtectedCount else 0 end ,
											vmPendingCount = @vmPendingCount,
											vmBackedUpWithErrorCount = @vmBackedUpWithErrorCount,
											vmNeverBackedUpCount = @vmNeverBackedUpCount
											WHERE clientId = @i_clientId
										END
									END -- set vm counts for VirtualPseudoClient
									SET @r_hwName = @t_hwName
									-- get license info
									SELECT	cid	AS t_clientId,
											SUM(CASE licType	WHEN 110	THEN POWER(2,0)
													WHEN 102	THEN POWER(2,1)
													WHEN 80		THEN POWER(2,2)
													WHEN 60		THEN POWER(2,4)
													WHEN 70		THEN POWER(2,5)
													WHEN 96		THEN POWER(2,6)
													WHEN 101	THEN POWER(2,7)
													WHEN 136	THEN POWER(2,8)
													WHEN 137	THEN POWER(2,9)
													ELSE 0 END)	AS t_licenses,
											SUM(CASE WHEN appType < 1000 THEN 1 ELSE 0 END)	AS t_agents
									INTO	#TEMP_CLIENT_LICENSES
									FROM	licUsage
									WHERE	optype = 'Install'
											AND InstallFlag = 0
											AND cId = @i_clientId
									GROUP BY Cid
									-- Set bit flag: UNLICENSED_IDAS_PRESENT
									UPDATE	#TEMP_CLIENT_LICENSES
									SET		t_licenses = t_licenses | 8
									WHERE	t_agents = 0
									SET @r_licenses = (SELECT t_licenses FROM #TEMP_CLIENT_LICENSES)
									SET @r_CIEngineInstalled = ISNULL((SELECT 1 FROM #TEMP_APP_CLIENTPROP WHERE CIEngineName <> N''), 0)
									SET @r_isCommServer	= ISNULL((select platformType FROM APP_Platform WHERE clientId = @i_clientId and platformType=1), N'')
									SET @r_isMA	= ISNULL((select
									(case platformType
									 When N'2' then N'1'
									 else NULL
									 end)
									 FROM APP_Platform WHERE clientId = @i_clientId and platformType=2), N'')
									SET @r_QinetixInstallDir = ISNULL((SELECT (case install_dir
																		 when 'N/A' Then N''
																		 Else install_dir
																		 End)
																		 FROM APP_Platform WHERE clientId = @i_clientId AND platformType = 4), N'')
									SET @r_snapBackupsMAInstalled = ISNULL((SELECT 1 FROM APP_Platform WHERE platformType = 2 AND clientId = @i_clientId AND (clientId IN (SELECT clientId FROM simInstalledPackages WHERE simPackageID = 453) OR
										clientId IN (SELECT clientId FROM APP_Client WHERE simOperatingSystemId IN (SELECT id FROM simOperatingSystem WHERE type <> 'Windows')))
										AND clientId IN (SELECT id FROM APP_Client WHERE releaseId >= 13)), 0)
									UPDATE @FinalClientList
									SET IsCommServer = 	@r_isCommServer,
									IsMA = @r_isMA,
									OSId =	@r_OSId,
									OSName = @r_OSName,
									PlatformId = @r_hwId,
									PlatformName = @r_hwName,
									TimeZone = (SELECT timezone from #TEMP_APP_CLIENTPROP),
									ClockSkewInSeconds = (SELECT clientSkewTime  from #TEMP_APP_CLIENT),
									ClockSkewInHours=(SELECT clientSkewTime  from #TEMP_APP_CLIENT)/3600,
									ClockSkewInMin=((SELECT clientSkewTime  from #TEMP_APP_CLIENT)%3600)/60,
									ClockSkewInSec=(ClockSkewInMin%3600)%60,
									ClientDescription =	(SELECT description  from #TEMP_APP_CLIENT),
									displayName =	(SELECT displayName  from #TEMP_APP_CLIENT),
									InstallDirectory =	@r_QinetixInstallDir,
									VersionId =	(SELECT releaseId  from #TEMP_APP_CLIENT),
									EnableDataManagement= (case
											WHEN (SELECT bkpEnabled from #TEMP_JMJOBCONTROL) = 2 THEN 'true'
											ELSE 'false' END),
									EnableDataRecovery = (case
											WHEN (SELECT rstEnabled from #TEMP_JMJOBCONTROL) = 2 THEN 'true'
											ELSE 'false' END),
									EnableOnlineContentIndex = (case
											WHEN (SELECT onlineCIEnabled from #TEMP_JMJOBCONTROL) = 2 THEN 'true'
											ELSE 'false' END),
									JobPriority = (SELECT priority from #TEMP_APP_CLIENTPROP),
									JobResultsRetentionDays = (SELECT cacheAging from #TEMP_APP_CLIENTPROP),
									JobResultsDiskCapThreshold = (SELECT diskfull from #TEMP_APP_CLIENTPROP),
									JobResultsImpersonateUser =	(SELECT JRusername from #TEMP_APP_CLIENTPROP),
									JobResultsDirectory = (SELECT jobResultDir  from #TEMP_APP_CLIENT),
									JobResultsThresholdMB =	(SELECT jobResultsThresholdMB from #TEMP_APP_CLIENTPROP),
									-- we dont use this field any more in 11.0
									--EnableEncryption = (case
											--WHEN (SELECT encryptionSettings from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											--ELSE 'false' END),
									--RestoreAccessPubKey = (case
									--WHEN (SELECT len(rsaPubKey) from #TEMP_APP_CLIENTPROP) < 1 then 'false'
									--ELSE 'true'
									--end),
									--RestoreAccessSynFull = (case
									--WHEN (SELECT len(rsaPriKeySF) from #TEMP_APP_CLIENTPROP) < 1 then 'false'
									--ELSE 'true'
									--end),
									CipherType = (SELECT cipher from #TEMP_APP_CLIENTPROP),
									EncryptKeyLength = (SELECT keylen from #TEMP_APP_CLIENTPROP),
									RestoreAccessFlag = (SELECT restoreAccess from #TEMP_APP_CLIENTPROP),
									DirectMediaAccessFlag = (SELECT drtoolAccess from #TEMP_APP_CLIENTPROP),
									ClientNoPhysicalMachine = (SELECT noPhysMachPresent from #TEMP_APP_CLIENTPROP),
									CDRLogFileLocation = (SELECT CDRLogLocation from #TEMP_APP_CLIENTPROP),
									AltCachePartitionForQSnap = (SELECT AltCachePrt from #TEMP_APP_CLIENTPROP),
									EnableContentIndexing = (case
											WHEN (SELECT contentIndexingEnabled from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											ELSE 'false' END),
									EnableSnapBackups = (case
											WHEN (SELECT snapBackupsEnabled from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											ELSE 'false' END),
									SnapBackupMAInstalled = @r_snapBackupsMAInstalled,
									OptimizeDataForSearch = (case
											WHEN (SELECT donotSingleInstance from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											ELSE 'false' END),
									fileLevelAnalyticsLicense = (case
											WHEN (SELECT fileLevelAnalLic from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											ELSE 'false' END),
									EnableRetryOnNetError = (case
											WHEN (SELECT nwErrRetryFlag from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
											ELSE 'false' END),
									RetryFrequencyInSecOnNetError = (SELECT nwErrRetryFreq from #TEMP_APP_CLIENTPROP),
									RetryCountOnNetError = (SELECT nwErrRetryCount from #TEMP_APP_CLIENTPROP),
									ComplianceUrl = (SELECT complianceSearchURL from #TEMP_APP_CLIENTPROP),
									EndUserUrl = (SELECT endUserSearchURL from #TEMP_APP_CLIENTPROP),
									WebURL = (SELECT WebURL from #TEMP_APP_CLIENTPROP),
									AdminUrl = (SELECT AdminURL from #TEMP_APP_CLIENTPROP),
									PathToExchangeMiningTool = (SELECT exchangeMiningToolPath from #TEMP_APP_CLIENTPROP),
									AutoPatchUpdateLocation = (SELECT (case patchLoc
																when 'N/A' then N''
																Else patchLoc
																End)
																from #TEMP_APP_CLIENTPROP),
									StorePatchLocally = (SELECT patchLocFlag from #TEMP_APP_CLIENTPROP),
									CenteraResourceFilename = (SELECT resourceFileName from #TEMP_APP_CLIENTPROP),
									EnableCollectDelegateInfo = (SELECT (CASE collectDelegateInfo
																		WHEN 0 THEN NULL
																		ELSE  collectDelegateInfo
																		END) from #TEMP_APP_CLIENTPROP),
									ClientInterface = (SELECT interface from #TEMP_APP_CLIENTPROP),
									PortForCVD = (SELECT cvdPort  from #TEMP_APP_CLIENT),
									PortForEvMgrC = (SELECT evmgrcPort  from #TEMP_APP_CLIENT),
									ActivePhysicalNode = (SELECT physClientId from #TEMP_APP_CLIENTPROP),
									WebServer = (SELECT webServerForSearch from #TEMP_APP_CLIENTPROP),
									ProxyHostForContentSearch = (SELECT contentProxy from #TEMP_APP_CLIENTPROP),
									ProxyHostForFileSystem = (SELECT (CASE proxyFSClientId
																		WHEN 0 THEN NULL
																		ELSE  proxyFSClientId
																		END)
															  from #TEMP_APP_CLIENTPROP),
									GlobalZoneHost = (SELECT (CASE globalZoneHostId
																		WHEN 0 THEN NULL
																		ELSE  globalZoneHostId
																		END) from #TEMP_APP_CLIENTPROP),
									UpdateCacheAgent = (SELECT (CASE updateCacheAgentId
																		WHEN 0 THEN NULL
																		ELSE  updateCacheAgentId
																		END) from #TEMP_APP_CLIENTPROP),
									CacheSource = (SELECT (CASE updateCacheAgentId
																		WHEN 0 THEN 0
																		ELSE  1
																		END) from #TEMP_APP_CLIENTPROP),
									ProxyHostForExchange = (SELECT (CASE proxyForExchange
																		WHEN 0 THEN NULL
																		ELSE  proxyForExchange
																		END) from #TEMP_APP_CLIENTPROP),
									CPUCount = (SELECT attrVal from APP_ClientProp where attrName like '%CPU count%' AND componentNameId = @i_clientId),
									BinarySetID = (SELECT attrVal from APP_ClientProp where RTRIM(LTRIM(attrName)) = 'Binary Set ID' AND componentNameId = @i_clientId),
									ByteOrder = (SELECT attrVal from APP_ClientProp where attrName like '%Byte Order%' AND componentNameId = @i_clientId),
									SMTPAddressOfTheRMSSuperUser = (SELECT SMTPAddressOfTheRMSSuperUser FROM #TEMP_APP_CLIENTPROP),
									rmsCredentailsUser = (SELECT rmsCredentailsUser FROM #TEMP_APP_CLIENTPROP),
									rmsCredentailsPassword = (SELECT rmsCredentailsPassword FROM #TEMP_APP_CLIENTPROP),
									decryptRMSDocumentDuringContentIndexing = (SELECT decryptRMSDocumentDuringContentIndexing FROM #TEMP_APP_CLIENTPROP),
									performClientSideDeduplication = (SELECT performClientSideDeduplication FROM #TEMP_APP_CLIENTPROP),
									enableHighLatencyOptimization = (SELECT enableHighLatencyOptimization FROM #TEMP_APP_CLIENTPROP),
									cacheBufferSize = (SELECT cacheBufferSize FROM #TEMP_APP_CLIENTPROP),
									enableClientSideDiskCache = (SELECT enableClientSideDiskCache FROM #TEMP_APP_CLIENTPROP),
									maxCacheDb = (SELECT maxCacheDb FROM #TEMP_APP_CLIENTPROP),
									enableVariableContentAlignment = (SELECT enableVariableContentAlignment FROM #TEMP_APP_CLIENTPROP),
									deskTopGuiProperties = (SELECT deskTopGuiProperties FROM #TEMP_APP_CLIENTPROP),
									overrideGlobalDesktopGuiProperties = (SELECT overrideGlobalDesktopGuiProperties FROM #TEMP_APP_CLIENTPROP),
									sharePointWebServerUrl = (SELECT sharePointWebServerUrl FROM #TEMP_APP_CLIENTPROP),
									sharePointWebServerUserName = (SELECT sharePointWebServerUserName FROM #TEMP_APP_CLIENTPROP),
									sharePointWebServerPassword = (SELECT sharePointWebServerPassword FROM #TEMP_APP_CLIENTPROP),
									enableOnlineSearch = ISNULL((SELECT enableOnlineSearch FROM #TEMP_APP_CLIENTPROP),0),
									enableAccessControlCollection = ISNULL((SELECT enableAccessControlCollection FROM #TEMP_APP_CLIENTPROP),1),
									configureClusterClient = ISNULL((SELECT configureClusterClient FROM #TEMP_APP_CLIENTPROP),0),
									showAllAgents = ISNULL((SELECT showAllAgents FROM #TEMP_APP_CLIENTPROP),0),
									baseInstallFolder = (SELECT baseInstallFolder FROM #TEMP_APP_CLIENTPROP),
									openVMSProxyClientId = (SELECT openVMSProxyClientId FROM #TEMP_APP_CLIENTPROP),
									openVMSProxyClientList = (SELECT openVMSProxyClientList FROM #TEMP_APP_CLIENTPROP),
									openVMSUserName = (SELECT openVMSUserName FROM #TEMP_APP_CLIENTPROP),
									openVMSUserPassword = (SELECT openVMSUserPassword FROM #TEMP_APP_CLIENTPROP),
									webserverClientId = (SELECT webSearchClientId FROM #TEMP_APP_CLIENTPROP),
									webServiceWebSitePortNumber = (SELECT webServiceWebSitePortNumber FROM #TEMP_APP_CLIENTPROP),
									webServiceSearchWebAlias = (SELECT webServiceSearchWebAlias FROM #TEMP_APP_CLIENTPROP),
									webSearchServerForRecallClientId = (SELECT webSearchServerForRecallClientId FROM #TEMP_APP_CLIENTPROP),
									webSearchServerForSuperSearch = (SELECT webSearchServerForSuperSearch FROM #TEMP_APP_CLIENTPROP),
									recallService = (SELECT recallService from #TEMP_APP_CLIENTPROP),
									enableDLP = (SELECT enableDLP from #TEMP_APP_CLIENTPROP),
									dlpStolen = (SELECT dlpStolen from #TEMP_APP_CLIENTPROP),
									dlpEnableClientKeys = (SELECT dlpEnableClientKeys from #TEMP_APP_CLIENTPROP),
									dlpScanIntervalMins = (SELECT dlpScanIntervalMins from #TEMP_APP_CLIENTPROP),
									dlpMinFileAgeMins = (SELECT dlpMinFileAgeMins from #TEMP_APP_CLIENTPROP),
									enableRmDLP = (SELECT enableRmDLP from #TEMP_APP_CLIENTPROP),
									dlpRmOfflineDays = (SELECT dlpRmOfflineDays from #TEMP_APP_CLIENTPROP),
									dlpRmNow = (SELECT dlpRmNow from #TEMP_APP_CLIENTPROP),
									dataSecurityEnabled = (SELECT dataSecurityEnabled from #TEMP_APP_CLIENTPROP),
									dlpEnableAutomaticDecryption = (SELECT dlpEnableAutomaticDecryption from #TEMP_APP_CLIENTPROP),
									dlpUnlockMethod = (SELECT dlpUnlockMethod from #TEMP_APP_CLIENTPROP),
									enableEmailWebApp = (SELECT enableEmailWebApp FROM #TEMP_APP_CLIENTPROP),
									ExchangeAdminUserName = (SELECT ExchangeAdminUserName FROM #TEMP_APP_CLIENTPROP),
									ExchangeAdminSmtpAddress = (SELECT ExchangeAdminSmtpAddress FROM #TEMP_APP_CLIENTPROP),
									excludeFromSLA = (SELECT excludeFromSLA FROM #TEMP_APP_CLIENTPROP),
									slaCopyRedundancy = (SELECT slaCopyRedundancy FROM #TEMP_APP_CLIENTPROP),
									slaCopyFallenBehindDays = (SELECT slaCopyFallenBehindDays FROM #TEMP_APP_CLIENTPROP),
									rpoMinutes = (SELECT rpoMinutes FROM #TEMP_APP_CLIENTPROP),
									rtoMinutes = (SELECT rtoMinutes FROM #TEMP_APP_CLIENTPROP),
									edgeSystemDriveType = (SELECT edgeSystemDriveType FROM #TEMP_APP_CLIENTPROP),
									isIndexingV2 = (SELECT isIndexingV2 FROM #TEMP_APP_CLIENTPROP),
									isQsnapInstalled = (select isQsnapInstalled FROM #TEMP_APP_CLIENTPROP),
									isJobThrottleEnabled = (select (CAST(isJobThrottleEnabled as INT) & 0x1) FROM #TEMP_APP_CLIENTPROP),
									is1TouchClient = (select is1TouchClient FROM #TEMP_APP_CLIENTPROP),
									excludeImmidiateJobs = (select (CASE WHEN ((CAST(isJobThrottleEnabled as INT) & 0x2) <> 0) THEN 1 ELSE 0 END) FROM #TEMP_APP_CLIENTPROP),
									dataJobThrottle = (select dataJobThrottle FROM #TEMP_APP_CLIENTPROP),
									logJobThrottle = (select logJobThrottle FROM #TEMP_APP_CLIENTPROP),
									isDescriptionInHTMLFormat = (select isDescriptionInHTMLFormat FROM #TEMP_APP_CLIENTPROP),
									isDisableEdgeDriveVersions = (select isDisableEdgeDriveVersions FROM #TEMP_APP_CLIENTPROP),
									isEdgeDriveAuditEnabled = (select isEdgeDriveAuditEnabled FROM #TEMP_APP_CLIENTPROP),
									isEdgeDrivePushNotificationEnabled = (select isEdgeDrivePushNotificationEnabled FROM #TEMP_APP_CLIENTPROP),
									edgeDriveStagingMachine = (select edgeDriveStagingMachine FROM #TEMP_APP_CLIENTPROP),
									IsExchangeOnePassClient = (SELECT IsExchangeOnePassClient FROM #TEMP_APP_CLIENTPROP),
									edgeDriveStagingDir = (select edgeDriveStagingDir FROM #TEMP_APP_CLIENTPROP),
									encryptionSettings = (select ISNULL(encryptionSettings,0) FROM #TEMP_APP_CLIENTPROP),
									mailServerRole = (select mailServerRole FROM #TEMP_APP_CLIENTPROP),
									impersonateUserName = (select impersonateUserName FROM #TEMP_APP_CLIENTPROP),
									isExchangePseudoClient = (select isExchangePseudoClient FROM #TEMP_APP_CLIENTPROP),
									isIndexingV2NAS = (SELECT isIndexingV2NAS FROM #TEMP_APP_CLIENTPROP),
									timezoneSetByUser = (select timezoneSetByUser FROM #TEMP_APP_CLIENTPROP),
									BlockLevelCacheDir = (SELECT BlockLevelCacheDir FROM #TEMP_APP_CLIENTPROP),
									queueJobsIfOtherConflictingJobsAreActive = (case
										WHEN(SELECT queueJobsIfOtherConflictingJobsAreActive from #TEMP_APP_CLIENTPROP) = 1 THEN 'true'
                                        ELSE 'false' END),
									IBMiUserProfile = (SELECT IBMiUserProfile FROM #TEMP_APP_CLIENTPROP),
									SubsystemDesc	= (SELECT SubsystemDesc FROM #TEMP_APP_CLIENTPROP),
									JobQueue		= (SELECT JobQueue FROM #TEMP_APP_CLIENTPROP),
									IsCreateJobQueue= (SELECT IsCreateJobQueue FROM #TEMP_APP_CLIENTPROP),
									IBMiDataFolder	= (SELECT IBMiDataFolder FROM #TEMP_APP_CLIENTPROP),
									IBMIJobPriority		= (SELECT IBMIJobPriority FROM #TEMP_APP_CLIENTPROP),
									RunPriority		= (SELECT RunPriority FROM #TEMP_APP_CLIENTPROP),
									dm2CacheRetentionDays = (SELECT DM2CacheAging from #TEMP_APP_CLIENTPROP),
									dm2CacheDiskCapThreshold = (SELECT DM2CacheDiskfull  from #TEMP_APP_CLIENTPROP),
									dm2CacheImpersonateUser =	(SELECT DM2CacheUserName  from #TEMP_APP_CLIENTPROP),
									dm2CacheDirectory = (SELECT DM2CacheDirectory   from #TEMP_APP_CLIENTPROP),
									dm2CacheThresholdMB =	(SELECT DM2CacheThresholdMB  from #TEMP_APP_CLIENTPROP),
									copyMgmtLicense = (SELECT CopyMgmtLicense from #TEMP_APP_CLIENTPROP),
									devsnapInitiatorIQN =	(SELECT DevSnapInitiatorIQN  from #TEMP_APP_CLIENTPROP),
									devsnapTargetPort =	(SELECT DevSnapTargetPort  from #TEMP_APP_CLIENTPROP),
									devsnapServerType =	(SELECT DevSnapServerType  from #TEMP_APP_CLIENTPROP),
									azureTenantId = (SELECT azureTenantId from #TEMP_APP_CLIENTPROP),
									IsFarmClient = (SELECT sharePointFarmClient from #TEMP_APP_CLIENTPROP),
									maxStreams = (SELECT maxStreams from #TEMP_APP_CLIENTPROP),
									forceClientSideDownload = (SELECT forceClientSideDownload from #TEMP_APP_CLIENTPROP),
									overrideGlobalEncryptionSettings = (SELECT overrideGlobalEncryptionSettings from #TEMP_APP_CLIENTPROP),
									iSCSIPort = (SELECT iSCSIPort from #TEMP_APP_CLIENTPROP),
									dbThinClientProxyClientList = (SELECT dbThinClientProxyClientList from #TEMP_APP_CLIENTPROP),
									geoLocation = (SELECT geoLocation from #TEMP_APP_CLIENTPROP),
									clientAppType = (SELECT clientAppType from #TEMP_APP_CLIENTPROP),
									nutanixFileServerId = (SELECT nutanixFileServerId FROM #TEMP_APP_CLIENTPROP),
									fileServerCredential = (SELECT fileServerCredential FROM #TEMP_APP_CLIENTPROP),
									jobStartTime = (SELECT jobStartTime FROM #TEMP_APP_CLIENTPROP),
									SLAStatus = (select SLAStatus FROM #TEMP_APP_CLIENTPROP),
									isIndexingV2VSA = (SELECT isIndexingV2VSA FROM #TEMP_APP_CLIENTPROP),
									isUserCentricClient = (SELECT isUserCentricClient FROM #TEMP_APP_CLIENTPROP),
									SLACategory = (select SLACategory FROM #TEMP_APP_CLIENTPROP),
									SLACategoryDescription = (select SLACategoryDescription FROM #TEMP_APP_CLIENTPROP),
									slaMissReasonList = (select CAST(slaMissReasonList AS XML) FROM #TEMP_APP_CLIENTPROP),
									nwReadiness = (select nwReadiness FROM #TEMP_APP_CLIENTPROP),
									NasVendorType = (select NasVendorType FROM #TEMP_APP_CLIENTPROP),
									indexingV2EnabledMask = (select indexingV2EnabledMask FROM #TEMP_APP_CLIENTPROP),
									IsInfrastructureMachine = (SELECT IsInfrastructureMachine FROM #TEMP_APP_CLIENTPROP),
									InfrastructureMachineType = (SELECT InfrastructureMachineType FROM #TEMP_APP_CLIENTPROP)
									WHERE clientid = @i_clientId
									--set region
									UPDATE fc set regionId= aas.value
									FROM  @FinalClientList fc
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=fc.clientid AND aas.entityType=3 and aas.keyName='Region Id' AND aas.enabled=1 AND aas.deleted=0
									WHERE clientid = @i_clientId
									--Set retire client phase. (1) implies uninstall job is in progress
									IF EXISTS(SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
												INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
												AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
												AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */ WHERE JUPDATE.clientId = @i_clientId)
									BEGIN
										UPDATE @FinalClientList SET retireClientPhase = 1 WHERE clientid = @i_clientId
									END
									IF @i_clientId = 2
										UPDATE @FinalClientList
												SET IsRemoteCacheEnabled = 1
												WHERE clientid = @i_clientId
									ELSE
										UPDATE @FinalClientList
										SET IsRemoteCacheEnabled = ISNULL((select  isEnabled from PatchUpdateAgentInfo P where (P.isDeleted <>1 AND P.clientId<>2 AND P.clientId=@i_clientId)),0)
										WHERE clientid = @i_clientId
									IF ( (SELECT TimeZone from @FinalClientList where clientid = @i_clientId) <> '')
									BEGIN
										DECLARE @TZ NVARCHAR(64)
										SET @TZ=(SELECT TimeZone from @FinalClientList where clientid = @i_clientId)
										SET @TZ = right(@TZ,len(@TZ) - CHARINDEX(':', @TZ, (CHARINDEX(':', @TZ)+1)))
										UPDATE @FinalClientList
												SET TimeZone = T.TimeZoneName, timezoneId = T.TimeZoneID
												FROM
												(
													SELECT TimeZoneName, TimeZoneID FROM SchedTimeZone WHERE(TimeZoneStdName LIKE @TZ)
												) T
												WHERE clientid = @i_clientId
									END
									DECLARE @pseudoClientType int
									/*
										@Text(text="Windows")
												WINDOWS = 0,
										@Text(text="Unix")
												UNIX = 1,
										@Text(text="NAS")
												NAS = 2,
										@Text(text="RAC")
												RAC = 3,
										@Text(text="DB2 DPF")
												DB2_DPF = 4,
										@Text(text="SRM NetWare Server")
												SRM_NETWARE_SERVER = 5,
										@Text(text="SRM Oracle Database")
												SRM_ORACLE_SERVER = 6,
										@Text(text="SRM NAS Filer")
												SRM_NAS_SERVER = 7,
										@Text(text="Exchange 2010 DAG")
												EXCHANGE_2010_DAG_CLIENT = 8,
										@Text(text="Content Store")
												CONTENT_STORE_CLIENT = 9,
										@Text(text="Windows Cluster")
										WINDOWS_CLUSTER_CLIENT = 10,
										@Text(text="Unix Cluster")
										UNIX_CLUSTER_CLIENT = 11,
										@Text(text="Virtualization")
										VIRTUAL_SERVER_CLIENT=12,
										@Text(text="Open VMS")
										OPEN_VMS_CLIENT=13,
										@Text(text="ReferenceCopy Client")
										REFERENCE_COPY_CLIENT=14
									*/
IF (@r_status & 0x0040) = 0x0040
									BEGIN
										SET @pseudoClientType = 3
									END
ELSE IF (@r_status & 0x0200) = 0x0200
									BEGIN
										SET @pseudoClientType = 4
									END
ELSE IF (@r_status & 0x0080) = 0x0080
									BEGIN
										SET @pseudoClientType = 2
									END
ELSE IF (@r_status & 0x200000) = 0x200000
									BEGIN
										SET @pseudoClientType = 8
									END
ELSE IF (@r_status & 0x400000) = 0x400000
									BEGIN
										SET @pseudoClientType = 9
									END
ELSE IF (@r_status & 0x4000000 ) = 0x4000000
									BEGIN
										SET @pseudoClientType = 14
									END
ELSE IF (@r_status & 0x800000 ) = 0x800000
									BEGIN
										SET @pseudoClientType = 15
									END
ELSE IF (@r_status & 0x8000000 ) = 0x8000000
									BEGIN
										SET @pseudoClientType = 18
									END
ELSE IF (@r_status & 0x10000000 ) = 0x10000000
									BEGIN
										SET @pseudoClientType = 19
									END
ELSE IF (@r_status & 0x20000000 ) = 0x20000000
									BEGIN
										SET @pseudoClientType = 20
									END
									ELSE IF (SELECT sharePointFarmClient from #TEMP_APP_CLIENTPROP) = 1
									BEGIN
										SET @pseudoClientType = 27
									END
									ELSE IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'Distributed iDA Client' AND modified = 0 AND attrVal = '1')
									BEGIN
										SET @pseudoClientType = 29
										DECLARE @caClientId INT
										--Get compute server, index server or index server pool
										EXEC AppGetDM2CloudServers	@i_clientId, @caClientId OUTPUT
										--Get all roles
										IF EXISTS (SELECT 1 FROM #indexServer WHERE  cloudServerType IN (1,4,5))
											EXEC AppGetAnalyticsRoleDetails	@i_clientId, 0
									END
ELSE IF EXISTS(SELECT TOP 1 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE clientId = @i_clientId AND cloudType IN (1, 5))
									BEGIN
										--if given client is a part of index server then fetch all associated index servers
										EXEC AppGetAssociatedIndexServers	@i_clientId
									END
									ELSE IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'DB Thin Client' AND modified = 0 AND attrVal = '1')
									BEGIN
										SET @pseudoClientType = 35
									END
									ELSE
										SET @pseudoClientType = NULL
									IF EXISTS (SELECT 1 FROM @FinalClientList WHERE IsExchangeOnePassClient = 1)
										SET @pseudoClientType = 25
									IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'Case Manager Pseudo Client' AND modified = 0 AND attrVal = '1')
									BEGIN
										SET @pseudoClientType = 36
									END
									ELSE IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId = @i_clientId AND attrName = 'IndexingV2_SharePoint' AND modified = 0 AND attrVal = '1')
									BEGIN
										SET @pseudoClientType = 37
									END
									-- Check if client has only one agent and that agent should be MSSQL.
									ELSE IF	((SELECT count(appTypeId) FROM APP_IDAName WITH(NOLOCK) WHERE clientId = @i_clientId) = 1)
AND EXISTS(SELECT 1 FROM APP_IDAName WITH(NOLOCK) WHERE appTypeId = 81 AND clientId = @i_clientId)
									BEGIN
										-- If clients vsinstanceType is VSVendor_AZURE(401) or VSVendor_AZURE_V2(402), then we set clientType as AZURE_SQL_CLIENT(40)
										IF EXISTS(SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'Cloud Hypervisor Type' AND modified = 0 AND attrVal IN ('401','402'))
										BEGIN
											SET @pseudoClientType = 40
										END
										-- If clients vsinstanceType is VSVendor_AMAZON(301) then we set clientType as AMAZON_SQL_CLIENT(41)
										ELSE IF EXISTS(SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @i_clientId AND attrName = 'Cloud Hypervisor Type' AND modified = 0 AND attrVal = '301')
										BEGIN
											SET @pseudoClientType = 41
										END
									END
									UPDATE @FINALCLIENTLIST
									SET
										 IsDeletedClient	= (SELECT deleted from #TEMP_APP_CLIENTPROP),
										 companyId = (SELECT companyId FROM #TEMP_APP_CLIENTPROP),
IsPseudoSAPHANA = (CASE (@r_status & 0x2000000)
WHEN 0x2000000 THEN 'true'
															ELSE NULL
															END),
IsPseudoMDM = (CASE (@r_status & 0x80000000)
WHEN 0x80000000 THEN 'true'
															ELSE NULL
															END),
IsPseudoRAC = (CASE (@r_status & 0x0040)
WHEN 0x0040 THEN 'true'
															ELSE NULL
															END),
										 IsDCInstalled = (SELECT DCinstalled from #TEMP_APP_CLIENTPROP),
IsPseudoDPF = (CASE (@r_status & 0x0200)
WHEN 0x0200 THEN 'true'
															  ELSE NULL
															  END),
isPseudoSRM = (CASE (@r_status & 0x0400)
WHEN 0x0400 THEN 'true'
													ELSE NULL
													END),
IsPseudoDAG = (CASE (@r_status & 0x200000)
WHEN 0x200000 THEN 'true'
															ELSE NULL
															END),
IsDummyClientForFirewallSetup = (CASE (@r_status & 0x100000)
WHEN 0x100000 THEN 'true'
															  ELSE NULL
															  END),
IsDAGAssociatedClient = (CASE (@r_status & 0x1000000)
WHEN 0x1000000 THEN 'true'
														ELSE NULL
														END),
IsObjectServer = (CASE (@r_status & 0x400000)
WHEN 0x400000 THEN 'true'
													ELSE NULL
													END),
IsSQLAlwaysON=	(CASE (@r_status & 0x20000000)
WHEN 0x20000000 THEN 'true'
													ELSE NULL
													END),
										  -- CLIENT FLAGS
										 IsVirtualClient = (SELECT isVirtualClient from #TEMP_APP_CLIENTPROP),
FastServerInstalled = (CASE (@r_status & 0x0100)
WHEN 0x0100 THEN 'true'
															ELSE NULL
															END),
										 DesktopServerInstalled = (CASE (@r_licenses & 512) --DESKTOP_SEARCH_SNAPVAULT
WHEN 0x0100 THEN 'true'
															ELSE NULL
															END),
IsPreConfigured = (CASE (@r_status & 0x04000)
WHEN 0x04000 THEN 'true'
															ELSE NULL
															END),
										 ContentIndexEngineInstalled = @r_CIEngineInstalled,
										 IsQsnapUNIX = (SELECT isQSnapUNIX from #TEMP_APP_CLIENTPROP),
IsCCpHold = (CASE (@r_status & 0x10000)
WHEN 0x10000 THEN 'true'
															ELSE NULL
															END),
IsCCP = (CASE (@r_status & 0x20000)
WHEN 0x20000 THEN 'true'
															ELSE NULL
															END),
IsPersonalWorkstation = (CASE (@r_status & 0x1000)
WHEN 0x1000 THEN 'true'
															ELSE 'false'
															END),
										 IsAdvancedFSPackageInstalled = (CASE WHEN (SELECT 1 FROM simInstalledPackages
WHERE simPackageID IN (702, 1101)
															AND clientId = @i_clientId) = 1 THEN 'true'
															ELSE 'false'
															END),
										  NoValidIdaPresent = (CASE (@r_licenses & 8)  --UNLICENSED_IDAS_PRESENT
															WHEN 8 THEN 'true'
															ELSE NULL
															END),
										  IsClientHiddenInGUI = (CASE (@r_specialClientFlags & 0x1)  --//HIDE_IN_GUI_CLIENT_LIST = 0x1
																	WHEN 0x1 THEN 'true'
																	ELSE NULL
																	END),
										  IsCommCellPackageAbsent = (CASE (@r_specialClientFlags & 0x2)  --SAME_COMMCELL_GALAXY_PACKAGES_ABSENT = 0x2
																	WHEN 0x2 THEN 'true'
																	ELSE NULL
																	END),
										  IsClientCountedOnScaleLimits = (CASE (@r_specialClientFlags & 0x8)  --/NO_COUNT_IN_SCALE_LIMITS = 0x8
																	WHEN 0x8 THEN 'true'
																	ELSE NULL
																	END),
										  ClientRequiresLicense = (CASE (@r_specialClientFlags & 0x10) --DO_NOT_TAKE_LICENSE = 0x10
															 WHEN 0x10 THEN 'true'
																				ELSE NULL
																				END),
										  grcMigratedClient = (CASE (@r_specialClientFlags & 0x20) --GRC_MIGRATED_CLIENT = 0x20
															 WHEN 0x20 THEN 'true'
																				ELSE NULL
																				END),
										  grcDeconfigureInSourceClient = (CASE (@r_specialClientFlags & 0x40) --GRC_CLIENT_DECONFIGURED_IN_SOURCE = 0x40
															 WHEN 0x40 THEN 'true'
																				ELSE NULL
																				END),
										  IsFastCIEnabled = (case (@r_CIEngineInstalled)
																WHEN 0 THEN 'false'
																ELSE 'true'
																END),
										  pseudoClientType = @pseudoClientType
									where clientid = @i_clientId
									-- Ask Bhavyan why in getclientlistAndInitialProps.sp it is only for NBU.
									UPDATE @FINALCLIENTLIST
									SET IsEdcDiscoveredClient = 1
									WHERE @i_clientId in
									(SELECT CGA.clientId
										  FROM app_clientgroup CG INNER JOIN app_clientGroupAssoc CGA
										  ON CG.id = CGA.clientGroupId
											  WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
									)
									INSERT INTO @FinalLicenseEntity
									SELECT     @i_clientId, id, short_name
									FROM         simLicAppTypeV2
									WHERE     (id IN
															  (SELECT     LicType
																FROM          LicUsage
																WHERE      (CId = @i_clientId) AND (OpType LIKE '%Install%')))
									IF @i_clientId <> 2
									BEGIN
										INSERT INTO @FinalActivePhyNode
										SELECT		@i_clientId, APP_Client.id, APP_Client.name, APP_Client.net_hostname
										FROM         APP_Client
										WHERE     (id =
																  (SELECT     attrVal
																	FROM          APP_ClientProp
																	WHERE      (componentNameId = @i_clientId) AND (attrName = 'Active Physical Node')))
									END
									ELSE
									BEGIN
										INSERT INTO @FinalActivePhyNode
										SELECT		@i_clientId, APP_Client.id, APP_Client.name, APP_Client.net_hostname
										FROM         APP_Client
										WHERE     (id =
																  (SELECT     attrVal
																	FROM          APP_ClientProp
																	WHERE      (componentNameId = @i_clientId) AND (attrName = 'CS Active Physical Node')))
									END
									IF @i_clientId <> 2
									BEGIN
									INSERT INTO @FinalUpdateAgentList
									SELECT     @i_clientId, APP_Client.id, APP_Client.name
									FROM         APP_Client
									WHERE     (id IN
															  (SELECT     clientId
																FROM          PatchUpdateAgentInfo
																WHERE      (isDeleted = 0 and clientId <> 2))
											   and releaseId >= @r_releaseId
											  )  AND id = @i_clientId
									-- visibility check
									if (@userId <> 0)
									BEGIN
										IF OBJECT_ID('tempdb.dbo.#sec_getClientList') IS NOT NULL
											DROP TABLE #sec_getClientList
										CREATE TABLE #sec_getClientList  (clientID INT, appTypeId INT, instanceID INT, backupsetID INT, subclientID INT)
										EXEC sec_getIdaObjectsForUser @userId,
3,
																	  0,
																	  0,
																	  '#sec_getClientList'
										delete @FinalUpdateAgentList WHERE NOT EXISTS (SELECT 1 FROM #sec_getClientList WHERE clientId = UpdateAgentID)
										DROP TABLE #sec_getClientList
									END
									END
									INSERT INTO @FinalDataInterfacePair
									SELECT		@i_clientId, archPipeline.srcClientId, archPipeline.srcInterface, archPipeline.destClientId, archPipeline.destInterface, archPipeline.isActive
									FROM		archPipeline
									WHERE archPipeline.srcClientId = @i_clientId OR archPipeline.destClientId = @i_clientId
									INSERT INTO @ProxyClients
									SELECT C.id,C.name,C.net_hostname
										   from @FinalClientList as CL, APP_Client as C
										   where C.id = openVMSProxyClientId
									DECLARE @dlpContent NVARCHAR(MAX) = ''
									SET @dlpContent = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'dlpContents' and componentNameId = @i_clientId and modified = 0), '')
									INSERT INTO @DLPContentTbl
									SELECT @i_clientId, _ID FROM dbo.SplitStringByDelimiter(@dlpContent, ';')
									INSERT INTO @PseudoClientComponentTbl
									SELECT propertyTypeId, stringVal FROM APP_ComponentProp
WHERE dataType = 1 AND componentId = @i_clientId AND modified = 0 AND componentType = 3
AND propertyTypeId >= 3000 AND propertyTypeId <= 3199
									DECLARE @dlpFilter NVARCHAR(MAX) = ''
									SET @dlpFilter = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'dlpFilters' and componentNameId = @i_clientId and modified = 0), '')
									INSERT INTO @DLPFilterTbl
									SELECT @i_clientId, _ID FROM dbo.SplitStringByDelimiter(@dlpFilter, ';')
									DECLARE @dlpRmContent NVARCHAR(MAX) = ''
									SET @dlpRmContent = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'dlpRmContents' and componentNameId = @i_clientId and modified = 0), '')
									INSERT INTO @DLPRMContentTbl
									SELECT @i_clientId, _ID FROM dbo.SplitStringByDelimiter(@dlpRmContent, ';')
									DECLARE @dlpRmFilter NVARCHAR(MAX) = ''
									SET @dlpRmFilter = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'dlpRmFilters' and componentNameId = @i_clientId and modified = 0), '')
									INSERT INTO @DLPRMFilterTbl
									SELECT @i_clientId, _ID FROM dbo.SplitStringByDelimiter(@dlpRmFilter, ';')
									SET @doc = CAST((select desktopGuiProperties from @FinalClientList where clientid = @i_clientId )as varchar(1024))
									IF @doc <> '0'
									BEGIN
										EXEC sp_xml_preparedocument @idoc OUTPUT, @doc
										INSERT INTO @DesktopGuiProperties
										SELECT    @i_clientId,
												   allowBackupControl,
												   successiveBackupJobsFailed,
												   isRecoveryPageDisplayed ,
												   isSchedulingPageDisplayed ,
												   bandwidthBeforeBackupAttempted ,
												   journalChunkSize ,
												   allowContentManagement ,
												   allowCompareDataBeforeBackup ,
												   allowToGenerateDataVerificationReport ,
												   allowToRunDataVerificationJobs ,
												   allowToChangeSmartSchedulingParameters ,
												   isChainingEnabled
													FROM   OPENXML (@idoc, '/EVGui_DesktopGuiProperties',0)
											 WITH (allowBackupControl     int         '@allowBackupControl',
												   successiveBackupJobsFailed  int '@successiveBackupJobsFailed',
												   isRecoveryPageDisplayed int '@isRecoveryPageDisplayed',
												   isSchedulingPageDisplayed int '@isSchedulingPageDisplayed',
												   bandwidthBeforeBackupAttempted int '@bandwidthBeforeBackupAttempted',
												   journalChunkSize int '@journalChunkSize',
												   allowContentManagement int '@allowContentManagement',
												   allowCompareDataBeforeBackup int '@allowCompareDataBeforeBackup',
												   allowToGenerateDataVerificationReport int '@allowToGenerateDataVerificationReport',
												   allowToRunDataVerificationJobs int '@allowToRunDataVerificationJobs',
												   allowToChangeSmartSchedulingParameters int '@allowToChangeSmartSchedulingParameters',
												   isChainingEnabled int '@isChainingEnabled')
											EXEC sp_xml_removedocument @idoc
									END
									DECLARE @isVirtualCli INT
									DECLARE @tempId INT
									SET @isVirtualCli = (SELECT isVirtualClient from #TEMP_APP_CLIENTPROP)
									IF (@isVirtualCli = 1)
									BEGIN
										INSERT INTO @FinalVM_PM
										SELECT @i_clientId, id, name FROM App_Client WHERE id IN
										(SELECT PMClientId FROM APP_VMToPMMap WHERE
										-- simVMToPMMap WHERE (appType = 1001 OR appType = 1002 OR appType = 1045) AND
										VMClientId = @i_clientId)
									END
									IF((SELECT COUNT(*) FROM @FInalVM_PM) > 0)
									BEGIN
										DECLARE @clientPackages_tmp TABLE (t_packageId int, t_packageName varchar(256),t_bInstalled int, t_releaseId int, t_flag int, t_osType varchar(64))
										INSERT INTO @clientPackages_tmp
										EXEC simGetInstalledPackages @i_clientId
										INSERT INTO @clientPackages
SELECT @i_clientId, t_packageId , t_packageName ,(CASE (t_bInstalled & 2) WHEN 0 THEN 0 ELSE 1 END), t_releaseId , t_flag , t_osType
										FROM @clientPackages_tmp
										DELETE FROM @clientPackages_tmp
									END
									IF @isVirtualCli = 1
									BEGIN
									 SET @tempId = (SELECT physClientId from #TEMP_APP_CLIENTPROP)
									END
									ELSE
										SET @tempId = @i_clientId
									END
									UPDATE @FINALCLIENTLIST
									SET
										  --isWebServerInstalled flag is same as IswebSearchServerInstalled.. see below
										  IscxbfInstalled = (SELECT 1 WHERE @tempId in (SELECT sim.clientId from simInstalledPackages sim where sim.simPackageID = 1401)),
IswebSearchServerInstalled = (SELECT 1 WHERE @tempId in (SELECT sim.clientId from simInstalledPackages sim where sim.simPackageID IN (252,852))), -- webserver
IsWebConsoleInstalled = (SELECT 1 WHERE @tempId in (SELECT sim.clientId from simInstalledPackages sim where sim.simPackageID in (726,1135))), -- webconsole
IswebSearchClientInstalled = (SELECT 1 WHERE @tempId in (SELECT sim.clientId from simInstalledPackages sim where sim.simPackageID = 255)), -- webclient
isClientBasePackageInstalled = (SELECT 1 WHERE @tempId in (SELECT sim.clientId from simInstalledPackages sim where sim.simPackageID IN (1, 1002)))
									WHERE clientid = @i_clientId
									UPDATE @FINALCLIENTLIST
									SET IsWebServerInstalled = IswebSearchServerInstalled -- ideally there shouldn't have been two flags but to prevent developers to have issues, maintain same value
									-- WHEN WEB SERVER IS ALONE INSTALLED THE PROPERTY WEB SERACH SERVER CLIENT ID IS NOT SET IN DB.
									-- PICK SELF ID IN THAT CASE FOR DISPLAY AS ITS READ ONLY
									UPDATE @FinalClientList
									SET webserverClientId = @i_clientId
									WHERE IswebSearchServerInstalled = 1 and webserverClientId =0 and clientid = @i_clientId
									UPDATE @FinalClientList
									SET webserverClientName = (SELECT C.net_hostname from App_Client C where C.id = webserverClientId)
									WHERE clientid = @i_clientId
									UPDATE @FinalClientList
									SET IsMergedExchangePackageInstalled = ISNULL((select CASE WHEN sim.clientId > 1 THEN 1 ELSE 0 END  from simInstalledPackages sim, PatchSPVersion psp where sim.simPackageID = 151 AND sim.ClientId = @i_clientId AND sim.SPVersionID = psp.id AND psp.Release >= 16 AND psp.SPMajor >= 12), 0)
									WHERE clientid = @i_clientId
									IF EXISTS (select 1 from  @FinalClientList where IsMergedExchangePackageInstalled =1 and clientid = @i_clientId )
									BEGIN
										DECLARE @clientAgents_tmp TABLE( clientId int, t_type int, t_displayname varchar(256))
										INSERT INTO @clientAgents_tmp
										SELECT  @i_clientId,  itype.type, itype.displayName
										FROM @FinalClientList	fcl
										INNER JOIN APP_IDAName idaname on idaname.clientId=fcl.clientid
										INNER JOIN  APP_iDAType itype on itype.type=idaname.appTypeId
										WHERE idaname.clientId = @i_clientId AND fcl.IsMergedExchangePackageInstalled = 1
										INSERT INTO  @clientAgents
										SELECT  DISTINCT * FROM @clientAgents_tmp where clientId = @i_clientId
										DELETE FROM @clientAgents_tmp
										DECLARE @clientPkgs_tmp TABLE (t_packageId int, t_packageName varchar(256),t_bInstalled int, t_releaseId int, t_flag int, t_osType varchar(64))
										INSERT INTO @clientPkgs_tmp
										EXEC simGetInstalledPackages @i_clientId
										INSERT INTO @clientComponents
										SELECT @i_clientId, t_packageId , t_packageName ,t_bInstalled , t_releaseId , t_flag , t_osType
										FROM @clientPkgs_tmp
										DELETE FROM @clientPkgs_tmp
									END
	END  -- END OF @getAllClientPRopeties
									IF(@getVersionInfoProperty=1)
									BEGIN
										DECLARE @VersionInfoReturn XML
										EXEC	[dbo].[AppGetVersionInfo]
													@cliID = @i_clientId,
													@physClID = @tempId,
													@getCachedUpdatesOnly = 0,
													@xmlText = @VersionInfoReturn OUTPUT
										UPDATE @FinalClientList
										SET VersionInfo = @VersionInfoReturn
										WHERE clientid = @i_clientId
									END
									INSERT INTO @FinalXMLList(clientId)
										VALUES(@i_clientId)
									DECLARE @ClientActivityControl XML
									DECLARE @ClientSecurity XML
									DECLARE @entitySecurityAssociation XML
									DECLARE @ClientFirewall XML
									DECLARE @ClientNetworkThrottling XML
									DECLARE @associationEntityPasskey XML
									IF @getActivityControlProperty  = 1
									BEGIN
										SET @ClientActivityControl = @associationEntity
										--'<entity clientId="' + STR(@i_clientId) + '"/>'
										EXEC [dbo].[APPGetActivityControlXML]
												@xmlText = @ClientActivityControl OUTPUT
										UPDATE @FinalXMLList
										SET activityControlXML = @clientActivityControl
										WHERE clientId = @i_clientId
									END
									IF @getSecurityProperty = 1
									BEGIN
										SET @associationEntityPasskey = (select @i_clientId as '@clientId',@userId as '@userId' for xml path('entity'))
										SET @ClientSecurity = @associationEntityPasskey
										-- '<entity clientId="' + STR(@i_clientId) + '"/>'
										EXEC [dbo].[APPGetEntitySecurityXML]
													@xmlText = @ClientSecurity OUTPUT
										UPDATE @FinalXMLList
										SET securityXML = @clientSecurity
										WHERE clientId = @i_clientId
										EXEC [dbo].[sec_getSecurityForEntity]
												@userId,
												@entitySecurityAssociation OUTPUT,
												3,
												@i_clientId
										UPDATE @FinalXMLList
										SET entitySecurityAssociation = @entitySecurityAssociation
										WHERE clientId = @i_clientId
									END
									-- Write a new SP for Firewall and Network Throttling.
									IF @getFirewallProperty  = 1
									BEGIN
										SET @ClientFirewall = @associationEntity
										EXEC [dbo].[APPGetEntityFirewallXML] @userId,
													@entityInfo = @ClientFirewall OUTPUT
										UPDATE @FinalXMLList
										SET firewallXML = @ClientFirewall
										WHERE clientId = @i_clientId
									END
									-- Write a new SP for Firewall and Network Throttling.
									IF @getNetworkThrottleProperty  = 1
									BEGIN
										SET @ClientNetworkThrottling = @associationEntity
										EXEC [dbo].[APPGetEntityNetworkThrottleXML]
												@entityInfo = @ClientNetworkThrottling OUTPUT
										UPDATE @FinalXMLList
										SET networkthrottlingXML = @ClientNetworkThrottling
										WHERE clientId = @i_clientId
									END
									IF	object_id('tempdb.dbo.#TEMP_APP_CLIENT') is not null DROP TABLE #TEMP_APP_CLIENT
									IF	object_id('tempdb.dbo.#TEMP_APP_CLIENTPROP') is not null DROP TABLE #TEMP_APP_CLIENTPROP
									IF	object_id('tempdb.dbo.#TEMP_JMJOBCONTROL') is not null DROP TABLE #TEMP_JMJOBCONTROL
									IF	object_id('tempdb.dbo.#TEMP_CLIENT_LICENSES') is not null DROP TABLE #TEMP_CLIENT_LICENSES
									IF @pseudoClientType = 27
									BEGIN
										DECLARE @sharePointPseudoClientProps table( data xml)
										INSERT INTO @sharePointPseudoClientProps
										EXEC [dbo].[AppGetSharePointMemberServers]	@associationEntity
										UPDATE @FinalClientList
										SET sharePointPseudoClientProps = data
										FROM @sharePointPseudoClientProps
										WHERE clientId = @i_clientId
									END
									ELSE IF @pseudoClientType = 37 -- Office 365
									BEGIN
										INSERT INTO @sharePointPseudoClientProps
										EXEC [dbo].[GetOffice365SPV2MemberServer]	@associationEntity, @userId
										UPDATE @FinalClientList
										SET sharePointPseudoClientProps = data
										FROM @sharePointPseudoClientProps
										WHERE clientId = @i_clientId
									END
									if @pseudoClientType = 19 			--Edge Drive
									begin
										--We need to call Stored Proc AppGetEdgeDriveAssoc to get corresponding edge drive associations for our client
										declare @edgeDriveClientPropsTbl	table(assocData	xml)
										insert into @edgeDriveClientPropsTbl
										exec [dbo].[AppGetEdgeDriveClientAssoc] @associationEntity
										update 	@FinalClientList
										set		edgeDriveClientAssoc = assocData
										from 	@edgeDriveClientPropsTbl
										where	clientId = @i_clientId
										-- Get the selective sync content to show in client advanced properties
										INSERT INTO #selectiveSyncContent
										SELECT SF.fileName
										FROM App_EdgeDriveAssociation AED
INNER JOIN APP_Application APP ON APP.backupSet = AED.entityId AND APP.subclientStatus & 0x00008 = 0x00008 -- Default subclient
										INNER JOIN APP_ScFilterFile SF ON SF.componentNameId = APP.id
										WHERE AED.clientId = @i_clientId AND AED.entityType = 65 --SUBCLIENT_POLICY_ENTITY = 65
										AND SF.type = 24 AND SF.modified = 0 -- CV_EDGE_SELECTIVE_SYNC_FILTERS = 24
									end
	CONTINUE_NEXT_CLIENT:
	--FILL THE ERROR RESPONSE XML HERE
	FETCH NEXT FROM @clientcur INTO @cliID
	END
DEALLOCATE @clientcur
--- Get pseudo clients
IF(@getPseudoClients =1)
BEGIN
	IF object_id('tempdb.dbo.#tmpClient') IS NOT NULL drop table #tmpClient
	create table #tmpClient
		(   ClientId        integer,
			subclientId     integer,
			INSTANCE        integer,
			appTypeId       integer
		)
	IF exists (select * from #idaClientList)
		INSERT INTO #tmpClient SELECT DISTINCT t_clientId ,0,0,0 FROM #idaClientList
	IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
	create table #tmpClientProxyPairs(ClientId  integer,
							instanceId          integer,
							proxyClientId       integer,
							ClientAppType               integer,
							isIndexServer               integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
							iscloudindexServer  integer DEFAULT 0,    -- 1 meaning cloud index server
							cloudindexServer    integer DEFAULT 0,
							isproxyclientGroup  integer DEFAULT 0 , -- 1 meaning client Group
							clientGroup         integer DEFAULT 0,
							subclientId         integer DEFAULT 0
							)
	IF exists (select * from #tmpClient)
		EXEC APPGetProxyClientInfo '#tmpClient','#tmpClientProxyPairs',1
	--Get pseudo clients for Proxy client
	INSERT INTO @PseudoClients(clientid)
	select DISTINCT PP.ClientId FROM #tmpClientProxyPairs PP
	WHERE PP.proxyClientId = @i_clientId AND PP.proxyClientId IS NOT NULL
	--Get Proxt Clients for Pseudo Client
	INSERT INTO @PseudoClients(clientid)
	select DISTINCT PP.proxyClientId FROM #tmpClientProxyPairs PP
	WHERE PP.ClientId = @i_clientId AND PP.proxyClientId IS NOT NULL
	UPDATE PF
	SET PF.proxyClientName = CC.name FROM
	@PseudoClients PF INNER JOIN app_client CC
	ON PF.ClientId = CC.id
END
DELETE FROM @ClientList
--Fill in IDA info
IF (@getidaList= 1)
BEGIN
       INSERT INTO #idaInfoTbl
       SELECT  ctemp.clientid ,itype.type, itype.displayName, 4 /*YET_TO_BE_PROTECTED*/,'',NULL
       FROM @FinalClientList ctemp
       INNER JOIN APP_IDAName idaname on idaname.clientId=ctemp.clientid
       INNER JOIN  APP_iDAType itype on itype.type=idaname.appTypeId
       WHERE ( @getSpecificAgentClients = 1 and type IN (SELECT r_appId FROM #idaLstTbl) ) or @getSpecificAgentClients = 0
	   IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
		CREATE TABLE #SLA_EntityInfo (
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
		status INT, category INT, slaDays INT)
		insert into #SLA_EntityInfo(clientId, appTypeId)
		SELECT  r_clientId, r_appId
		FROM #idaInfoTbl
		exec RptGetSLAOfEntities 2
		UPDATE IDA
		SET r_slaStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
			r_slaDescription = dbo.WR_GetSLACategoryString(@localeId,SLA.Category)
		FROM #idaInfoTbl IDA
			INNER JOIN #SLA_EntityInfo SLA
				ON IDA.r_clientId = SLA.clientId and IDA.r_appId = SLA.appTypeId
	   UPDATE IDA
	   SET IDA.r_SLAStatus = 5, /*MIGHT_MISS_SLA*/
		   IDA.r_SLADescription = '',
		   IDA.r_slaMissReasonList = CAST(stringVal AS XML)
	   FROM #idaInfoTbl IDA
	   INNER JOIN APP_idaName IDN ON IDN.apptypeId = IDA.r_appId AND IDN.clientId = r_clientId
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = IDN.id AND Prop.componentType =  4 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
END
DECLARE @xmlQuery XML
-- Fill network readiness info
;WITH nwReadniess(clientId, latestUpdateTime)
AS
(
	SELECT ToClientId, MAX(LastUpdateTime) FROM CCRClientToClient WITH(NOLOCK) WHERE FromClientId = 2 AND serviceType = 0 GROUP BY ToClientId
)
UPDATE clientTbl
SET nwReadiness = CASE WHEN flag = 1 THEN 1 ELSE 2 END, lastOnlineTime = CCR.lastOnlineTime, lastOfflineTime = CCR.lastOfflineTime, nwReadinessUpdatedTime = CCR.lastUpdateTime
FROM  nwReadniess R
		INNER JOIN CCRClientToClient CCR WITH(NOLOCK)
			ON R.clientId = CCR.ToClientId AND R.latestUpdateTime = CCR.LastUpdateTime
		INNER JOIN @FinalClientList clientTbl
			ON clientTbl.clientid = CCR.ToClientId AND FromClientId = 2 AND serviceType = 0
UPDATE clientTbl
SET nwReadiness = 3			-- 3 -> Not Applicable for Pseudo client
FROM @FinalClientList clientTbl
		INNER JOIN App_Client C WITH(NOLOCK)
ON clientTbl.clientid = C.id AND C.specialClientFlags & CONVERT(INT,0x2) <> 0
INSERT INTO @clientClusterInfoTbl
 SELECT distinct clientTbl.clientid, min(AIP.attrVal), min(AIP.componentNameId)
FROM @FinalClientList clientTbl
INNER JOIN APP_Application APP WITH (NOLOCK)
	ON APP.clientId = clientTbl.clientid
INNER JOIN APP_InstanceName AIN WITH (NOLOCK)
	ON APP.instance = AIN.id
INNER JOIN APP_InstanceProp AIP WITH (NOLOCK)
	ON AIN.id = AIP.componentNameId
	AND AIP.attrName = 'Distributed Cluster Type'
	AND AIP.modified = 0
	group by clientTbl.clientid
IF @getAllProperties = 1
BEGIN
SET @xmlQuery = (SELECT
							(SELECT TmpFClList.vmStatusInfoXML TYPE),
							(SELECT TmpFinalClientList.CPUCount AS '@CPUCount',
									TmpFinalClientList.BinarySetID AS '@BinarySetID',
									TmpFinalClientList.ByteOrder AS '@byteOrder',
									TmpFinalClientList.ClientInterface AS '@ClientInterface',
									TmpFinalClientList.IsCommServer AS '@IsCommServer',
									TmpFinalClientList.IsMA AS '@isMA',
									TmpFinalClientList.IsDeletedClient	AS '@IsDeletedClient',
									TmpFinalClientList.IsPseudoRAC	AS '@IsPseudoRAC',
									TmpFinalClientList.IsPseudoSAPHANA	AS '@IsPseudoSAPHANA',
									TmpFinalClientList.IsPseudoMDM	AS '@IsPseudoMDM',
									TmpFinalClientList.IsDCInstalled AS '@IsDCInstalled',
									TmpFinalClientList.IsPseudoDPF	AS '@IsPseudoDPF',
									TmpFinalClientList.IsPseudoSRM AS '@isPseudoSRM',
									TmpFinalClientList.IsPseudoDAG AS '@isPseudoDAG',
									TmpFinalClientList.IsDummyClientForFirewallSetup AS '@isDummyClientForFirewallSetup',
									TmpFinalClientList.IsDAGAssociatedClient AS '@isDAGAssociatedClient',
									TmpFinalClientList.IsObjectServer AS '@isObjectServer',
									TmpFinalClientList.IsCCpHold  AS '@isCCpHold',
									TmpFinalClientList.IsCCP  AS '@isCCP',
									TmpFinalClientList.IsSQLAlwaysON	AS '@IsSQLAlwaysON',
									TmpFinalClientList.IsClientHiddenInGUI AS '@isClientHiddenInGUI',
									TmpFinalClientList.IsCommCellPackageAbsent  AS '@isCommCellPackageAbsent',
									TmpFinalClientList.IsClientCountedOnScaleLimits  AS '@isClientCountedOnScaleLimits',
									TmpFinalClientList.ClientRequiresLicense AS '@clientRequiresLicense',
									TmpFinalClientList.grcMigratedClient AS '@grcMigratedClient',
									TmpFinalClientList.grcDeconfigureInSourceClient AS '@grcDeconfigureInSourceClient',
									-- Client Flags
									TmpFinalClientList.IsFastCIEnabled AS '@isFastSearchSupported',
									TmpFinalClientList.IscxbfInstalled AS '@iscxbfInstalled',
									TmpFinalClientList.IsPersonalWorkstation AS '@isPersonalWorkstation',
									TmpFinalClientList.IsAdvancedFSPackageInstalled AS '@isAdvancedFSPackageInstalled',
									TmpFinalClientList.IsVirtualServerDiscoveredClient AS '@isVirtualServerDiscoveredClient',
									TmpFinalClientList.IsEdcDiscoveredClient AS '@isEdcDiscoveredClient',
									TmpFinalClientList.IsMiniSRMClient AS '@isMiniSRMClient',
									TmpFinalClientList.IsAddInClient AS '@isAddInClient',
									TmpFinalClientList.NoValidIdaPresent AS '@NoValidIdaPresent',					--Fix me add & UNLICENSED_IDAS_PRESENT
									TmpFinalClientList.ContentIndexEngineInstalled AS '@ContentIndexEngineInstalled',
									TmpFinalClientList.FastServerInstalled AS '@FastServerInstalled',			--Fix me add & CV_STATUS_FAST_SERVER
									TmpFinalClientList.DesktopServerInstalled AS '@DesktopServerInstalled',				--Fix me add & DESKTOP_SEARCH_SNAPVAULT
									TmpFinalClientList.IsPreConfigured AS '@IsPreConfigured',				--Fix me add & CV_STATUS_PRECONFIGURED
									TmpFinalClientList.IsVirtualClient AS '@IsVirtualClient',
									TmpFinalClientList.IsQsnapUNIX AS '@IsQsnapUNIX',
									TmpFinalClientList.JobPriority AS '@JobPriority',
									TmpFinalClientList.JobResultsRetentionDays AS '@JobResultsRetentionDays',
									TmpFinalClientList.JobResultsDiskCapThreshold AS '@JobResultsDiskCapThreshold',
									TmpFinalClientList.JobResultsThresholdMB AS '@JobResultsThresholdMB',
									--TmpFinalClientList.EnableEncryption AS '@EnableEncryption',
									--TmpFinalClientList.RestoreAccessPubKey AS '@RestoreAccessPubKey',
									--TmpFinalClientList.RestoreAccessSynFull AS '@RestoreAccessSynFull',
									TmpFinalClientList.CipherType AS '@CipherType',
									TmpFinalClientList.EncryptKeyLength AS '@EncryptKeyLength',
									TmpFinalClientList.RestoreAccessFlag AS '@RestoreAccessFlag',
									TmpFinalClientList.DirectMediaAccessFlag AS '@DirectMediaAccessFlag',
									TmpFinalClientList.ClientNoPhysicalMachine AS '@ClientNoPhysicalMachine',
									TmpFinalClientList.CDRLogFileLocation AS '@CDRLogFileLocation',
									TmpFinalClientList.AltCachePartitionForQSnap AS '@AltCachePartitionForQSnap',
									TmpFinalClientList.EnableContentIndexing AS '@EnableContentIndexing',
									TmpFinalClientList.EnableSnapBackups AS '@EnableSnapBackups',
									TmpFinalClientList.SnapBackupMAInstalled AS '@SnapBackupMAInstalled',
									TmpFinalClientList.OptimizeDataForSearch AS '@OptimizeDataForSearch',
									TmpFinalClientList.fileLevelAnalyticsLicense AS '@fileLevelAnalyticsLicense',
									TmpFinalClientList.EnableRetryOnNetError AS '@EnableRetryOnNetworkError',
									TmpFinalClientList.RetryFrequencyInSecOnNetError AS '@RetryFrequencyInSecOnNetworkError',
									TmpFinalClientList.RetryCountOnNetError AS '@RetryCountOnNetworkError',
									TmpFinalClientList.IsExchangeOnePassClient AS '@IsExchangeOnePassClient',
									TmpFinalClientList.PathToExchangeMiningTool AS '@PathToExchangeMiningTool',
									TmpFinalClientList.AutoPatchUpdateLocation AS '@AutoUpdateLocation',
									TmpFinalClientList.StorePatchLocally AS '@StorePatchLocally',
									TmpFinalClientList.CenteraResourceFilename AS '@CenteraResourceFilename',
									TmpFinalClientList.recallService AS '@recallService',
									TmpFinalClientList.IswebSearchServerInstalled as '@iswebSearchServerInstalled',
									TmpFinalClientList.IsMergedExchangePackageInstalled as '@isMergedExchangePackageInstalled',
									TmpFinalClientList.IswebSearchClientInstalled as '@iswebSearchClientInstalled',
									TmpFinalClientList.isWebServerInstalled AS '@isWebServerInstalled',
									TmpFinalClientList.isQsnapInstalled as '@isQsnapInstalled',
									TmpFinalClientList.is1TouchClient  as '@is1TouchClient',
									TmpFinalClientList.isDescriptionInHTMLFormat AS '@isDescriptionInHTMLFormat',
									TmpFinalClientList.encryptionSettings AS '@encryptionSettings',
									TmpFinalClientList.isExchangePseudoClient AS '@isExchangePseudoClient',
									TmpFinalClientList.queueJobsIfOtherConflictingJobsAreActive AS '@queueJobsIfOtherConflictingJobsAreActive',
									TmpFinalClientList.dm2CacheRetentionDays AS '@dm2CacheRetentionDays',
									TmpFinalClientList.dm2CacheDiskCapThreshold AS '@dm2CacheDiskCapThreshold',
									TmpFinalClientList.dm2CacheThresholdMB AS '@dm2CacheThresholdMB',
									TmpFinalClientList.copyMgmtLicense AS '@copyManagementLicense',
									TmpFinalClientList.devsnapInitiatorIQN AS '@devsnapInitiatorIQN',
									TmpFinalClientList.devsnapTargetPort AS '@devsnapTargetPort',
									TmpFinalClientList.devsnapServerType AS '@devsnapServerType',
									TmpFinalClientList.IsFarmClient AS '@isFarmClient',
									TmpFinalClientList.maxStreams AS '@maxStreams',
									TmpFinalClientList.forceClientSideDownload AS '@forceClientSideDownload',
									TmpFinalClientList.overrideGlobalEncryptionSettings AS '@overrideGlobalEncryptionSettings',
									TmpFinalClientList.iSCSIPort AS '@iSCSIPort',
									TmpFinalClientList.jobStartTime AS '@jobStartTime',
									TmpFinalClientList.SLAStatus AS '@slaStatus',
									TmpFinalClientList.SLACategory AS '@slaCategory',
									TmpFinalClientList.SLACategoryDescription AS '@slaCategoryDescription',
									TmpFinalClientList.isClientBasePackageInstalled '@isClientBasePackageInstalled',
									TmpFinalClientList.isUserCentricClient AS '@isUserCentricClient',
									ISNULL(IsInfrastructureMachine,0) AS '@isInfrastructure',
									(CASE TmpFinalClientList.EnableCollectDelegateInfo
									WHEN 0 THEN 'false'
									ELSE 'true'
									END
									)as '@EnableCollectDelegateInfo',
									TmpFinalClientList.CacheSource AS '@cacheSource',
									TmpFinalClientList.IsRemoteCacheEnabled as '@isRemoteCacheEnabled',
									(CASE TmpFinalClientList.overrideGlobalDesktopGuiProperties
									WHEN 0 THEN 'false'
									ELSE 'true'
									END
									)as '@overrideGlobalDesktopGuiProperties',
									(CASE TmpFinalClientList.isIndexingV2 WHEN 0 THEN 'false' ELSE 'true' END) as '@isIndexingV2',
									(CASE TmpFinalClientList.isIndexingV2NAS WHEN 0 THEN 'false' ELSE 'true' END) as '@isIndexingV2NAS',
									(CASE TmpFinalClientList.isIndexingV2VSA WHEN 0 THEN 'false' ELSE 'true' END) as '@isIndexingV2VSA',
									TmpFinalClientList.indexingV2EnabledMask AS '@indexingV2EnabledMask',
									-- This is only for 10.0 and above.
									(case when (SELECT releaseId FROM APP_Client WHERE id = TmpFinalClientList.clientId) > 14
										  then
											(CASE TmpFinalClientList.enableAccessControlCollection
											WHEN 0 THEN 'false'
											ELSE   'true'
											END )
										   else
											null
									 end)
									 AS '@enableAccessControl',
									BlockLevelCacheDir AS '@BlockLevelCacheDir',
									TmpFinalClientList.retireClientPhase AS '@retireClientPhase',
									slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList,
									(SELECT
										pkg.id AS '@packageId',
										 pkg.DisplayName AS '@packageName',
											infrastructureClientFlag AS 'infrastructureMachineType'
											FROM App_InfrastructurePkgToFlagMap PkgToMap INNER JOIN
											simPackage pkg ON pkg.id = PkgToMap.infrastructureClientPkgId
											WHERE InfrastructureMachineType & PkgToMap.infrastructureClientFlag = PkgToMap.infrastructureClientFlag
									FOR XML PATH('infrastructureMachineDetails'), TYPE),
									(SELECT
									(SELECT xmlblob.value('@latitude', 'NVARCHAR(MAX)') as '@latitude', xmlblob.value('@longitude', 'NVARCHAR(MAX)') as '@longitude'
										FROM (
												SELECT CAST(TmpFinalClientList.geoLocation AS XML) as xmlValue
												FROM @FinalClientList AS TmpFinalClientList1
												WHERE TmpFinalClientList1.clientid = TmpFinalClientList.clientid
											) T
									CROSS APPLY T.xmlValue.nodes('App_GeoLocation') M(xmlblob)
									WHERE xmlblob.value('@status_code', 'NVARCHAR(MAX)') = 'SUCCESS'
									FOR XML pATH ('geoLocation'), TYPE),
									(SELECT TmpFinalClientList.regionId AS '@regionId', r.name AS '@regionName' , r.displayName as '@displayName'
										FROM App_Region r where r.Id = TmpFinalClientList.regionId FOR XML pATH ('region'), TYPE)
										 FOR XML PATH ('clientRegionInfo'), TYPE),
									(SELECT
										u.hostName AS '@connectName',
										(SELECT u.id AS '@id', u.domainName AS '@domainName'
											FOR XML PATH ('shortName'), TYPE)
										FROM UMDSProviders u where u.Id = TmpFinalClientList.companyId
										FOR XML PATH ('company'), TYPE),
									(SELECT TmpFinalClientList.ComplianceUrl as 'ComplianceUrl'
									WHERE TmpFinalClientList.IswebSearchClientInstalled = 1
									FOR XML PATH(''),TYPE),
									(SELECT (CASE when (SELECT releaseId FROM APP_Client WHERE id = TmpFinalClientList.clientId) > 14
												then TmpFinalClientList.WebURL
												else TmpFinalClientList.EndUserUrl
												end) as 'EndUserUrl'
									WHERE TmpFinalClientList.IswebSearchClientInstalled = 1 or TmpFinalClientList.IsWebConsoleInstalled=1
									FOR XML PATH(''),TYPE),
									(SELECT TmpFinalClientList.AdminUrl AS 'AdminUrl'
									WHERE TmpFinalClientList.IswebSearchClientInstalled = 1
									FOR XML PATH(''),TYPE),
									(SELECT dbo.AppFetchWebServiceURL(TmpFinalClientList.webserverClientId, 1, 0) AS 'webSearchServiceUrl'
									WHERE TmpFinalClientList.IswebSearchServerInstalled = 1
									FOR XML PATH(''),TYPE),
									 (SELECT TmpFinalClientList.webserverClientId as '@clientId',
											TmpFinalClientList.webserverClientName as '@hostName'
											WHERE TmpFinalClientList.IswebSearchServerInstalled = 1
											FOR XML PATH('webSearchServer'),TYPE),
									(SELECT	APP_Client.id AS '@clientId',
											APP_Client.name AS '@clientName'
										FROM	APP_Client
										WHERE APP_Client.id = TmpFinalClientList.webSearchServerForRecallClientId
										FOR XML PATH('webClient'), TYPE),
									(SELECT	APP_Client.id AS '@clientId',
										APP_Client.name AS '@clientName'
									FROM	APP_Client
									WHERE APP_Client.id = TmpFinalClientList.webSearchServerForSuperSearch
									FOR XML PATH('webSearchServerForSuperSearch'),TYPE),
								(SELECT
									   (case D.allowBackupControl
										WHEN 0 THEN 'false'
										ELSE 'true'
										END) as '@allowBackupControl',
										D.successiveBackupJobsFailed as '@successiveBackupJobsFailed',
										(case D.isRecoveryPageDisplayed
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@isRecoveryPageDisplayed',
										(case D.isSchedulingPageDisplayed
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@isSchedulingPageDisplayed',
										D.bandwidthBeforeBackupAttempted as '@bandwidthBeforeBackupAttempted',
										D.journalChunkSize as '@journalChunkSize',
										(case D.allowContentManagement
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@allowContentManagement',
										(case D.allowCompareDataBeforeBackup
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@allowCompareDataBeforeBackup',
										(case D.allowToGenerateDataVerificationReport
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@allowToGenerateDataVerificationReport',
										(case D.allowToRunDataVerificationJobs
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@allowToRunDataVerificationJobs',
										(case D.allowToChangeSmartSchedulingParameters
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@allowToChangeSmartSchedulingParameters',
										 (case D.isChainingEnabled
										WHEN 0 THEN 'false'
										ELSE 'true'
										END)
										as '@isChainingEnabled'
									 FROM @DesktopGuiProperties as D
									 WHERE D.clientId = TmpFinalClientList.clientId
									 FOR XML PATH('deskTopGuiProperties'),TYPE),
									(SELECT TmpFinalClientList1.EnableDataManagement AS '@EnableDataManagement',
											TmpFinalClientList1.EnableDataRecovery AS '@EnableDataRecovery',
											TmpFinalClientList1.EnableOnlineContentIndex AS '@EnableOnlineContentIndex'
										FROM @FinalClientList AS TmpFinalClientList1
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList.clientid
										FOR XML PATH('activityControl'), TYPE),
									(SELECT TmpFinalClientList1.sharePointWebServerUrl AS '@sharePointWebServerUrl',
											(case TmpFinalClientList1.enableOnlineSearch
											WHEN 0 THEN 'false'
											ELSE   'true'
											END
											)AS '@enableOnlineSearch',
											(SELECT
												TmpFinalClientList1.sharePointWebServerUserName AS '@sharePointWebServerUserName',
												TmpFinalClientList1.sharePointWebServerPassword AS '@sharePointWebServerPassword'
												FOR XML PATH('spWebServerUserPassword'),TYPE)
										FROM @FinalClientList AS TmpFinalClientList1
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList.clientid
										FOR XML PATH('spWebServerProperties'), TYPE),
									(SELECT
									        TmpFinalClientList.enableEmailWebApp AS '@enableEmailWebApp',
										    TmpFinalClientList.ExchangeAdminSmtpAddress AS '@exchangeAdminSmtpAddress',
											(SELECT
												TmpFinalClientList.ExchangeAdminUserName AS '@userName'
												--FROM @FinalClientList AS TmpFinalClientList1
												--WHERE TmpFinalClientList1.clientid = TmpFinalClientList.clientid
												FOR XML PATH('exchangeAdministratorAccount'), TYPE
											)
								    FOR XML PATH('emailWebAppProperties'),TYPE),
									(SELECT
									        TmpFinalClientList.excludeFromSLA AS '@excludeFromSLA',
											TmpFinalClientList.mailServerRole AS '@mailServerRole',
									        TmpFinalClientList.slaCopyRedundancy AS '@slaCopyRedundancy',
									        TmpFinalClientList.slaCopyFallenBehindDays AS '@slaCopyFallenBehindDays',
									        TmpFinalClientList.rpoMinutes AS '@rpoMinutes',
									        TmpFinalClientList.rtoMinutes AS '@rtoMinutes'
								    FOR XML PATH('advancedClientProperties'),TYPE),
									(SELECT	APP_Client.id AS '@clientId',
											APP_Client.name AS '@clientName',
											APP_Client.net_hostname AS '@hostName'
										FROM	APP_Client, @FinalClientList AS TmpFinalClientList1
										WHERE APP_Client.id = TmpFinalClientList1.ProxyHostForExchange
												AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
										FOR XML PATH('ProxyHostForExchange'), TYPE),
									(SELECT	APP_Client.id AS '@clientId',
											APP_Client.name AS '@clientName',
											APP_Client.net_hostname AS '@hostName'
										FROM	APP_Client, @FinalClientList AS TmpFinalClientList1
										WHERE APP_Client.id = TmpFinalClientList1.WebServer
												AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
										FOR XML PATH('WebServer'), TYPE),
									(SELECT	APP_Client.id AS '@clientId',
											APP_Client.name AS '@clientName',
											APP_Client.net_hostname AS '@hostName'
										FROM	APP_Client, @FinalClientList AS TmpFinalClientList1
										WHERE APP_Client.id = TmpFinalClientList1.ProxyHostForContentSearch
												AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
										FOR XML PATH('ProxyHostForContentSearch'), TYPE),
									(SELECT	APP_Client.id AS '@clientId',
											APP_Client.name AS '@clientName',
											APP_Client.net_hostname AS '@hostName'
										FROM	APP_Client, @FinalClientList AS TmpFinalClientList1
										WHERE APP_Client.id = TmpFinalClientList1.ProxyHostForFileSystem
												AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
										FOR XML PATH('ProxyHostForFileSystem'), TYPE),
									-- we are referring to App_Client table Hundered and one times. cant we do it one shot? Find a way
									(SELECT	APP_Client.id AS '@clientId',
										APP_Client.name AS '@clientName',
										APP_Client.net_hostname AS '@hostName'
									FROM	APP_Client, @FinalClientList AS TmpFinalClientList1
									WHERE APP_Client.id = TmpFinalClientList1.GlobalZoneHost
											AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
									FOR XML PATH('globalZoneHost'), TYPE),
									(SELECT	APP_Client.id AS '@clientId',
										APP_Client.name AS '@clientName',
										APP_Client.net_hostname AS '@hostName'
									FROM	APP_Client, @FinalClientList AS TmpFinalClientList1,
									patchupdateagentinfo updateCacheAgent
									WHERE updateCacheAgent.id = TmpFinalClientList1.UpdateCacheAgent
									and APP_Client.id = updateCacheAgent.clientId
											AND TmpFinalClientList1.clientId = TmpFinalClientList.clientId
										FOR XML PATH('UpdateCacheAgent'), TYPE),
									(SELECT TmpFinalUpdateAgentList.UpdateAgentID AS '@clientId',
											TmpFinalUpdateAgentList.UpdateAgentName AS '@clientName'
										FROM @FinalUpdateAgentList AS TmpFinalUpdateAgentList
										WHERE TmpFinalUpdateAgentList.clientid = TmpFinalClientList.clientid
										FOR XML PATH('UpdateCacheAgentList'), TYPE),
									(SELECT
										TmpFinalDataInterfacePair.isActive '@active',
										(SELECT
											TmpFinalDataInterfacePair.srcClientID AS '@ClientId',
											TmpFinalDataInterfacePair.srcInterface AS '@Interface'
											FOR XML PATH('SourceInterface'), TYPE),
										(SELECT
											TmpFinalDataInterfacePair.destClientID AS '@ClientId',
											TmpFinalDataInterfacePair.destInterface AS 'Interface'
											FOR XML PATH('DestInterface'), TYPE)
									FROM @FinalDataInterfacePair AS TmpFinalDataInterfacePair
									WHERE TmpFinalDataInterfacePair.clientid = TmpFClList.clientid
									FOR XML PATH('dataInterfacePair'), TYPE),
									--Write Fw Config and Network trhottling in separate Protocol
									(SELECT	C.SMTPAddressOfTheRMSSuperUser as '@SMTPAddressOfTheRMSSuperUser',
											C.SMTPAddressOfTheRMSSuperUser as '@smtpAddressOfRMSSuperUser',
											(case C.decryptRMSDocumentDuringContentIndexing
												WHEN 0 THEN 'false'
												ELSE 'true'
												END
											) as '@decryptRMSDocumentDuringContentIndexing',
											(select C.rmsCredentailsUser as '@userName',
											C.rmsCredentailsPassword as '@password'
											FOR XML PATH('rmsCredentials'),TYPE)
											FROM @FinalClientList as C
											WHERE C.clientid = TmpFClList.clientid
									FOR XML PATH('rightManagementServiceProperties'), TYPE),
									(SELECT
											( case C.performClientSideDeduplication
											when 0 then 1
											when 1 then 1
											when 2 then 0
											end )as '@performClientSideDeduplication',
											C.performClientSideDeduplication as '@clientSideDeduplication',
											C.cacheBufferSize as '@cacheBufferSize',
											C.enableClientSideDiskCache as '@enableClientSideDiskCache',
											C.maxCacheDb as '@maxCacheDb',
											C.enableVariableContentAlignment as '@enableVariableContentAlignment',
											C.enableHighLatencyOptimization as '@enableHighLatencyOptimization'
									FROM @FinalClientList as C
									WHERE C.clientid = TmpFClList.clientid
									FOR XML PATH('deDuplicationProperties'), TYPE),
									(SELECT activityControlXML AS 'clientActivityControl'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid
									FOR XML PATH(''),TYPE),
									-- XML Query should contain 1 for enable and 0 for disable hence converting the encrypted attribute value to 1 and 0 respectively
(SELECT CASE TmpFinalClientList.dataSecurityEnabled when 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' then 1 else 0 end
									as '@enableDataSecurity', securityXML.query('.')
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid
									FOR XML PATH ('clientSecurity'),TYPE),
									(SELECT entitySecurityAssociation AS 'securityAssociations'
									FROM @FinalXMLList AS TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientId
									FOR XML PATH(''), TYPE),
									(SELECT firewallXML AS 'firewallConfiguration'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid
									FOR XML PATH (''),TYPE),
									(SELECT networkthrottlingXML AS 'networkThrottle'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid
									FOR XML PATH (''),TYPE),
									(SELECT
											TmpFinalClientList.enableDLP AS '@enableDLP',
											TmpFinalClientList.dlpStolen AS '@dlpStolen',
											TmpFinalClientList.dlpEnableAutomaticDecryption AS '@dlpEnableAutomaticDecryption',
											TmpFinalClientList.dlpUnlockMethod AS '@dlpUnlockMethod',
											TmpFinalClientList.dlpEnableClientKeys AS '@dlpEnableClientKeys',
											TmpFinalClientList.dlpScanIntervalMins AS '@dlpScanIntervalMins',
											TmpFinalClientList.dlpMinFileAgeMins AS '@dlpMinFileAgeMins',
											(SELECT TmpDLPContent.dlpContents AS 'dlpContents'
												FROM @DLPContentTbl AS TmpDLPContent
												WHERE TmpDLPContent.clientid = TmpFinalClientList.clientid
											FOR XML PATH(''), TYPE),
											(SELECT TmpDLPFilter.dlpFilters AS 'dlpFilters'
												FROM @DLPFilterTbl AS TmpDLPFilter
												WHERE TmpDLPFilter.clientid = TmpFinalClientList.clientid
											FOR XML PATH(''), TYPE),
											(SELECT
												TmpFinalClientList.enableRmDLP AS '@enableRmDLP',
												TmpFinalClientList.dlpRmOfflineDays AS '@dlpRmOfflineDays',
												TmpFinalClientList.dlpRmNow AS '@dlpRmNow',
												(SELECT TmpDLPRMContent.dlpRmContents AS 'dlpRmContents'
													FROM @DLPRMContentTbl AS TmpDLPRMContent
													WHERE TmpDLPRMContent.clientid = TmpFinalClientList.clientid
													FOR XML PATH(''), TYPE),
												(SELECT TmpDLPRMFilter.dlpRmFilters AS 'dlpRmFilters'
													FROM @DLPRMFilterTbl AS TmpDLPRMFilter
													WHERE TmpDLPRMFilter.clientid = TmpFinalClientList.clientid
												FOR XML PATH(''), TYPE)
											FOR XML PATH('dlpRMProperties'),TYPE)
										FOR XML PATH('dlpPropertise'),TYPE),
									(SELECT
										 CR.keyName as '@keyName',
										 CR.type as '@type',
										 (CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE dbo.EncodeInvalidXMLChar(CR.value) END) as '@value',
										 CR.relativepath as '@relativepath',
										 --CR.deleted as '@deleted',
										 CR.enabled as '@enabled',
  										 ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
										 (CASE CR.sourceId WHEN 0 THEN 0 ELSE 1 END) as '@isInheritedFromClientGroup', --source entityType assumed as 28 i.e CLIENT_GROUP_ENTITY
										  (SELECT
											CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
											CASE CR.sourceEntityType WHEN 28 THEN CR.sourceId ELSE NULL END AS '@clientGroupId',
											CASE CR.sourceEntityType WHEN 28 THEN (SELECT name FROM APP_ClientGroup WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@clientGroupName',
											CASE CR.sourceEntityType WHEN 3 THEN  CR.sourceId ELSE NULL END AS '@clientId',
											CASE CR.sourceEntityType WHEN 3 THEN  (SELECT name FROM APP_Client WITH(NOLOCK) WHERE id = CR.sourceId) ELSE NULL END AS '@clientName'
										 FOR XML PATH('sourceEntity'),TYPE)
										 FROM APP_AdvanceSettings as CR
										 LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx
										 ON CR.id = AdvEx.keyId
										 WHERE CR.entityId = TmpFClList.clientid AND CR.entityType = 3 --CLIENT_ENTITY
										 and CR.deleted = 0 and ISNULL(AdvEx.hidden,0) = 0
										 FOR XML PATH('registryKeys'),TYPE),
										 (SELECT TmpFinalClientList2.dm2CacheDirectory AS '@path',
											(SELECT TmpFinalClientList2.dm2CacheImpersonateUser AS '@userName'
											FOR XML PATH('userAccount'), TYPE)
										FROM @FinalClientList AS TmpFinalClientList2
										WHERE TmpFinalClientList.clientid = TmpFinalClientList2.clientid
										FOR XML PATH('dm2CacheDir'), TYPE),
									(SELECT
											ISNULL((SELECT value FROM GxGlobalParam WITH(NOLOCK) WHERE name LIKE 'ThrottleJobsFeature'),0) AS '@isJobThrottleEnabledAtCS',
									        TmpFinalClientList.isJobThrottleEnabled AS '@isJobThrottleEnabled',
											TmpFinalClientList.excludeImmidiateJobs AS '@excludeImmidiateJobs',
										    TmpFinalClientList.dataJobThrottle AS '@dataThreshold',
											TmpFinalClientList.logJobThrottle AS '@logThreshold'
								    FOR XML PATH('jobThrottleSettings'),TYPE),
									(SELECT TmpDAGClient.pseudo_clientid AS '@clientId',
											TmpDAGClient.pseudo_clientName AS '@clientName',
											TmpDAGClient.physical_hostname AS '@hostName'
											FROM @DAGClient AS TmpDAGClient
											WHERE TmpFinalClientList.clientid = TmpDAGClient.physical_clientid
									FOR XML PATH('DAGpseudoClient'), TYPE),
									(SELECT nwReadiness AS '@status',
										(SELECT nwReadinessUpdatedTime AS '@time', 55 AS '@_type_' FOR XML PATH('lastUpdatedTime'), TYPE),
										(SELECT lastOnlineTime AS '@time', 55 AS '@_type_' FOR XML PATH('lastOnlineTime'), TYPE),
										(SELECT lastOfflineTime AS '@time', 55 AS '@_type_' FOR XML PATH('offlineTime'), TYPE)
									FOR XML PATH('networkReadiness'), TYPE)
								FROM @FinalClientList AS TmpFinalClientList
								where TmpFinalClientList.clientid = TmpFClList.clientid
								FOR XML PATH('clientProps'), TYPE),
								------------------------------------------------------------------------------------------------
								(SELECT --TmpFinalClientList1.FixMe AS '@clientPassword', --Fix me get password
										TmpFinalClientList1.ClientDescription AS '@clientDescription',
										TmpFinalClientList1.displayName AS '@displayName',
										TmpFinalClientList1.timezoneSetByUser AS '@timezoneSetByUser',
										--TmpFinalClientList1.TimeZone AS '@TimeZone',
										--'hours:' + TmpFinalClientList1.ClockSkewInHours  + ', mins:' + TmpFinalClientList1.ClockSkewInMin AS '@ClockSkewInSeconds',
										TmpFinalClientList1.ClockSkewInSeconds AS '@ClockSkewInSeconds',
										TmpFinalClientList1.PortForCVD AS '@cvdPort',
										TmpFinalClientList1.PortForEvMgrC AS '@evmgrcPort',
										-- TmpFinalClientList1.UpdateStatus AS '@Status', -- Fix me, it appears this variable is same as UpdateStatus.
										TmpFinalClientList1.InstallDirectory AS '@installDirectory',
										(SELECT TmpFinalClientList1.TimeZone AS '@TimeZoneName',
										TmpFinalClientList1.timezoneId AS '@TimeZoneID'
										FROM @FinalClientList AS TmpFinalClientList2
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
										FOR XML PATH('TimeZone'), TYPE),
										(SELECT TmpFinalClientList2.JobResultsDirectory AS '@path',
											(SELECT TmpFinalClientList2.JobResultsImpersonateUser AS '@userName'
											FOR XML PATH('userAccount'), TYPE)
										FROM @FinalClientList AS TmpFinalClientList2
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
										FOR XML PATH('jobResulsDir'), TYPE),
										(SELECT TmpFinalClientList2.clientid AS '@clientId',
												TmpFinalClientList2.ClientName AS '@clientName',
												TmpFinalClientList2.ClientHostName AS '@hostName',
												TmpFinalClientList2.ClientCSHostName AS '@commCellName',
												TmpFinalClientList2.clientGuid as '@clientGUID'
										FROM @FinalClientList AS TmpFinalClientList2
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
										FOR XML PATH('clientEntity'), TYPE),
										(SELECT
											(SELECT
												I.r_appId  '@applicationId',
												I.r_appName        '@appName',
4 as '@_type_'
												FOR XML PATH('idaEntity'),TYPE) ,
											(SELECT
												I.r_SLAStatus			'@slaStatus',
												I.r_SLADescription      '@slaCategoryDescription',
												I.r_slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList
												FOR XML PATH('summary'),TYPE)
												FROM #idaInfoTbl I    WHERE  I.r_clientId  = TmpFinalClientList1.clientid
											FOR XML PATH('idaList'),TYPE),
										(SELECT
												S.id as '@osId',
												S.Type as '@Type',
												S.SubType as '@SubType',
												--dbo.GetClientOSName(TmpFinalClientList2.clientid, NULL) AS '@PlatformType',
												(SELECT TmpFinalClientList3.OSName AS '@OSName',
														dbo.GetClientHardwareName(TmpFinalClientList3.clientid, NULL) AS '@ProcessorType'--Fix me
												FROM @FinalClientList AS TmpFinalClientList3
												WHERE TmpFinalClientList3.clientid = TmpFinalClientList2.clientid
												FOR XML PATH('OsDisplayInfo'), TYPE)
										FROM @FinalClientList AS TmpFinalClientList2,
										simOperatingSystem as S
										WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
										and S.id = (SELECT simOperatingSystemId FROM APP_Client WHERE id = TmpFinalClientList1.clientId)
										FOR XML PATH('osInfo'), TYPE),
										(SELECT TmpFinalClientList2.ClientCSHostName AS '@commCellId'
										FROM @FinalClientList AS TmpFinalClientList2
										WHERE TmpFinalClientList2.clientid = TmpFinalClientList1.clientid
										FOR XML PATH('origCommCell'), TYPE),
										TmpFinalClientList1.VersionInfo AS 'versionInfo'
								FROM @FinalClientList AS TmpFinalClientList1
								WHERE TmpFinalClientList1.clientid = TmpFClList.clientid
								FOR XML PATH('client'), TYPE),
								----------------------------------------------------------------------------
								(SELECT     c_id AS '@clientGroupId',
											c_name AS '@clientGroupName'
								FROM         @clientGroupList
								WHERE     (c_id IN (SELECT	clientGroupId
													FROM	APP_ClientGroupAssoc
													WHERE      (clientId = TmpFClList.clientid)))
								FOR XML PATH('clientGroups'), TYPE),
								----------------------------------------------------------------------------
								(SELECT TmpFinalVM_PM.VMPMClientID AS '@clientId',
										TmpFinalVM_PM.VMPMClientName AS '@clientName'
								FROM @FinalVM_PM AS TmpFinalVM_PM
								WHERE TmpFinalVM_PM.clientid = TmpFClList.clientid
								FOR XML PATH('VM_PM_Association'), TYPE),
								(SELECT (case TmpFClList.configureClusterClient
											WHEN 0 THEN 'false'
											WHEN 1 THEN 'true'
											ELSE null
										end)
										AS 'configureClusterClient',
										(case TmpFClList.showAllAgents
														WHEN 0 THEN 'false'
														WHEN 1 THEN 'true'
														ELSE null
										end)
										AS 'showAllAgents',
										(SELECT TmpFinalVM_PM.VMPMClientID AS '@clientId',
												TmpFinalVM_PM.VMPMClientName AS '@clientName'
										FROM @FinalVM_PM AS TmpFinalVM_PM
										WHERE TmpFinalVM_PM.clientid = TmpFClList.clientid
										FOR XML PATH('clusterGroupAssociation'), TYPE),
										(SELECT t_packageId as '@ComponentId',
										t_packageName as '@ComponentName',
										t_osType as '@osType',
										t_releaseId as '@releaseIdForPackage',
										t_bInstalled as '@installedState'
										FROM @clientPackages as ClientPackages
										WHERE ClientPackages.clientid = TmpFClList.clientid
										FOR XML PATH('configuredAgents'), TYPE)
								FOR XML PATH('clusterClientProperties'),TYPE),
								----------------------------------------------------------------------------
								--get installed packages and agents for the client
								(SELECT (case TmpFClList.IsMergedExchangePackageInstalled
											WHEN 0 THEN 'false'
											WHEN 1 THEN 'true'
											ELSE null
										end)
										AS 'isMergedExchangePackageInstalled',
										(SELECT  tmpAgents.t_type AS '@applicationId', tmpAgents.t_displayname AS '@appName'
									    FROM @clientAgents tmpAgents
									    where tmpAgents.clientId=	TmpFClList.clientid
										FOR XML PATH('agents'), TYPE),
										(SELECT t_packageId as '@ComponentId',
										t_packageName as '@ComponentName',
										t_osType as '@osType',
										t_releaseId as '@releaseIdForPackage',
										t_bInstalled as '@installedState'
										FROM @clientComponents as ClientComponents
										WHERE ClientComponents.clientid = TmpFClList.clientid
										FOR XML PATH('components'), TYPE)
								FOR XML PATH('clientConfiguration'),TYPE),
								----------------------------------------------------------------------------
								(SELECT
									TmpFClList.pseudoClientType	 as '@clientType',
									TmpFClList.clientAppType as '@clientAppType',
									(SELECT S.clusterType AS '@clusterType',
											(SELECT
												(SELECT  S.cloudServerType AS '@type',
                                        S.cloudStatus '@status',
                                    (select S.nodeStatus '@status',
                                        (SELECT
                                            S.clientId AS '@clientId',
                                            S.clientName AS '@clientName',
											S.clientDisplayName AS '@displayName'
                                        FOR XML PATH ('nodeClientEntity'), TYPE),
                                        (SELECT
                                            'ISENABLED' AS '@name',
                                            S.analyticsEnabled AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'JVMMAXMEMORY' AS '@name',
                                            S.javaMaxMem AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'INDEXLOCATION' AS '@name',
                                            S.indexDirectory AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'URL' AS '@name',
                                            S.URL AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
										(SELECT
                                            'WEBSERVER' AS '@name',
                                            S.isWebserver AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'PORTNO' AS '@name',
                                            S.portNo AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE)
                                        FROM #nodeProperties S
                                    FOR XML PATH('cloudNodes'), TYPE),
									(select S.zkNodeStatus '@status',
                                        (SELECT
                                            S.clientId AS '@clientId',
                                            S.zkClientName AS '@clientName',
											S.zkDisplayName AS '@displayName'
                                        FOR XML PATH ('nodeClientEntity'), TYPE),
                                        (SELECT
                                            'ZKLISTENERPORT' AS '@name',
                                            S.zkListenerPort AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'ZKDATAPORT' AS '@name',
                                            S.zkDataPort AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'ZKELECTIONPORT' AS '@name',
                                            S.zkElectionPort AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
										(SELECT
                                            'ZKDATADIR' AS '@name',
                                            S.zkDataDir AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
										(SELECT
                                            'ZKSERVERID' AS '@name',
                                            S.zkServerID AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE)
                                        FROM #zkNodes S
                                    FOR XML PATH('cloudNodes'), TYPE),
                                    (select
                                    (SELECT
                                            R.roleId AS '@roleId',
                                            R.roleName AS '@roleName',
                                            R.roleStatus AS '@status',
                                            (SELECT
                                                'ISENABLED' AS '@name',
                                                R.isEnabled AS '@value'
                                            FOR XML PATH ('roleMetaInfos'), TYPE),
											(SELECT
                                                'ISCLOUDMODE' AS '@name',
                                                R.isCloudSupported AS '@value'
                                            FOR XML PATH ('roleMetaInfos'), TYPE),
											(SELECT
                                                'ISASSOCIATED' AS '@name',
                                                R.isAssocToEdgeClient AS '@value'
                                            FOR XML PATH ('roleMetaInfos'), TYPE)
                                            FROM #rolesList R
                                        FOR XML PATH ('roles'), TYPE),
										(SELECT
											S.indexServerPoolId AS '@cloudId',
											S.indexServerPoolName AS '@cloudName'
											FOR XML PATH ('cloudPoolInfo'), TYPE)
                                    FOR XML PATH('solrCloudInfo'), TYPE),
									(SELECT S.t_nodeStatus '@status',
										(SELECT
											S.t_clientId AS '@clientId',
											S.t_clientName AS '@clientName'
											FOR XML PATH ('nodeClientEntity'), TYPE),
											(SELECT
                                            'JVMMAXMEMORY'  AS '@name',
										    S.t_jvmMax AS '@value'
											FOR XML PATH ('nodeMetaInfos'), TYPE),
											(SELECT
                                            'PORTNO'  AS '@name',
										    S.t_caPortNo AS '@value'
											FOR XML PATH ('nodeMetaInfos'), TYPE),
											(SELECT
                                            'INDEXLOCATION'  AS '@name',
										    S.t_indexLocation AS '@value'
											FOR XML PATH ('nodeMetaInfos'), TYPE),
										(SELECT
                                            'URL'  AS '@name',
										    S.t_caURL AS '@value'
											FOR XML PATH ('nodeMetaInfos'), TYPE),
										(SELECT
                                            'ISENABLED'  AS '@name',
											'true' AS '@value'
											FOR XML PATH ('nodeMetaInfos'), TYPE)
											FROM #contentAnalyzerTbl S
                                    FOR XML PATH ('cloudNodes'), TYPE),
                                    (SELECT
                                            S.cloudName AS '@cloudName',
                                            S.cloudDisplayName AS '@cloudDisplayName',
                                            S.cloudId AS '@cloudId'
                                        FOR XML PATH ('cloudInfoEntity'), TYPE),
									(SELECT
                                            S.planId AS '@planId',
                                            S.planName AS '@planName'
                                        FOR XML PATH ('planInfo'), TYPE),
									(SELECT
                                            S.storagePolicyId AS '@storagePolicyId',
                                            S.storagePolicyName AS '@storagePolicyName'
                                        FOR XML PATH ('storagePolicy'), TYPE),
                                        (SELECT
                                            'INDEXLOCATION' AS '@name',
                                            S.indexDirectory AS '@value'
                                        FOR XML PATH ('cloudMetaInfos'), TYPE),
										(SELECT
                                            'REPLICATION' AS '@name',
                                            S.replicationFactor AS '@value'
                                        FOR XML PATH ('cloudMetaInfos'), TYPE),
										(SELECT
                                            'LANGUAGE' AS '@name',
                                            S.indexServerLanguage AS '@value'
                                        FOR XML PATH ('cloudMetaInfos'), TYPE),
										(SELECT
											(SELECT DISTINCT
												S.zkCloudId AS '@clientGroupId',
												S.zkCloudName AS '@clientGroupName'
												FOR XML PATH ('zookerEntity'), TYPE)
											FOR XML PATH('solrCloudPoolInfo'), TYPE)
												FOR XML PATH('cloudInfo'), TYPE)
											FOR XML PATH('clusterConfig'), TYPE)
											FROM #indexServer S
											WHERE clusterType IS NOT NULL
									FOR XML PATH('distributedClusterInstanceProperties'),TYPE),
									(SELECT CCIT.clusterType AS '@clusterType',
											(SELECT
												CCIT.defaultInstanceIdForClusterClient AS '@instanceId'
												FOR XML PATH ('instance'), TYPE)
											FROM @clientClusterInfoTbl CCIT
											WHERE CCIT.clientid = TmpFClList.clientid
									FOR XML PATH('clusterTypeInfo'),TYPE),
									(SELECT TOP 1 S.cloudServerType AS '@cloudServerType',
											S.cloudStatus '@status',
                                    (SELECT
                                        (SELECT
                                            'JVMMAXMEMORY' AS '@name',
                                            S.javaMaxMem AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'INDEXLOCATION' AS '@name',
                                            S.indexDirectory AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE),
                                        (SELECT
                                            'PORTNO' AS '@name',
                                            S.portNo AS '@value'
                                        FOR XML PATH ('nodeMetaInfos'), TYPE)
                                        FROM #nodeProperties S
                                    FOR XML PATH(''), TYPE),
									    (SELECT
                                            S.cloudName AS '@clientName',
                                            S.cloudDisplayName AS '@displayName',
											S.indexServerClientId AS '@clientId'
                                        FOR XML PATH ('indexServerClients'), TYPE)
											FROM #indexServer S
											WHERE clusterType IS NULL
									FOR XML PATH('indexServerProperties'),TYPE),
									(SELECT  TmpFClList.PortForCVD AS '@cvdPort', TmpFClList.baseInstallFolder AS 'baseInstallFolder',
											(SELECT TmpProxyCLients.clientid AS '@clientId',
													TmpProxyCLients.clientName AS '@clientName'
											FROM @ProxyClients AS TmpProxyCLients
											WHERE TmpProxyCLients.clientid = TmpFClList.openVMSProxyClientId
											FOR XML PATH('proxyClient'), TYPE),
											(SELECT TmpFClList.openVMSProxyClientList.query('/App_BackupConfigurationNodes/*')
											FOR XML PATH('proxyClients'), TYPE),
											(SELECT TmpFClList.openVMSUserName as '@userName',
											TmpFClList.openVMSUserPassword as '@password'
											FOR XML PATH('userAccount'), TYPE)
									FOR XML PATH('openVMSProperties'),TYPE),
									(SELECT
										(SELECT TmpFClList.dbThinClientProxyClientList.query('/App_BackupConfigurationNodes/*')
										FOR XML PATH('proxyClients'), TYPE)
									FOR XML PATH('dbThinClientProperties'),TYPE),
									(SELECT
										TmpFClList.SubsystemDesc as '@subsysDescription',
										TmpFClList.JobQueue as '@jobQueue',
										TmpFClList.IsCreateJobQueue as '@createJobQueue',
										TmpFClList.IBMiDataFolder as '@dataFolder',
										TmpFClList.IBMIJobPriority as '@jobProirity',
										TmpFClList.RunPriority as '@runPriority',
										(SELECT TmpFClList.IBMiUserProfile as '@userName'
										FOR XML PATH('userProfile'), TYPE)
									FOR XML PATH('ibmiInstallOptions'), TYPE),
									(SELECT
										(SELECT	TmpFClList.vmTotalCount AS '@vmTotalCount',
												TmpFClList.vmProtectedCount AS '@vmProtectedCount',
												TmpFClList.vmNotProtectedCount AS '@vmNotProtectedCount',
												TmpFClList.vmPendingCount AS '@vmPendingCount',
												TmpFClList.vmBackedUpWithErrorCount AS '@vmBackedUpWithErrorCount',
												TmpFClList.vmNeverBackedUpCount AS '@vmNeverBackedUpCount'
										FOR XML PATH('vmBackupInfo'), TYPE),
										(SELECT
											TmpFClList.cloudHyperVisorType AS '@vsInstanceType',
											(SELECT po.query('.')
												FROM (SELECT CAST(TmpFClList.memberServers AS XML) memberServers ) PROP
												CROSS APPLY PROP.memberServers.nodes('./App_MemberServers/memberServers') P(po)
											FOR XML PATH('associatedClients'),TYPE),
											(SELECT TmpFClList.awsAccessKey AS '@accessKey'
											FOR XML PATH('amazonInstanceInfo'), TYPE),
											(SELECT
												(SELECT TmpFClList.azureSubscriptionId as '@userName'
														--azureThumbprint as '@password'
												FOR XML PATH('credentials'),TYPE)
											FOR XML PATH('azure'), TYPE),
											(SELECT
												TmpFClList.azureSubscriptionId as '@subscriptionId',
												TmpFClList.azureTenantId as '@tenantId',
												(SELECT TmpFClList.azureAppId as '@userName'
														--azureAppPassword as '@password'
												FOR XML PATH('credentials'),TYPE)
											FOR XML PATH('azureResourceManager'), TYPE),
											(SELECT TmpFClList.virtualServerCredId as '@credentialId',
													TmpFClList.virtualServerCredName as '@credentialName'
												FOR XML PATH('virtualServerCredentialinfo'),TYPE)
										FOR XML PATH('virtualServerInstanceInfo'), TYPE)
									FOR XML PATH('virtualServerClientProperties'),TYPE),
									(SELECT	TmpFClList.edgeSystemDriveType AS '@systemDriveType',
											TmpFClList.isDisableEdgeDriveVersions AS '@disableVersions',
											TmpFClList.isEdgeDriveAuditEnabled AS '@auditDriveActivities',
											TmpFClList.isEdgeDrivePushNotificationEnabled AS '@enableNotificationsForShares',
											TmpFClList.edgeDriveStagingDir AS '@stagingDirectory',
											(select TmpFClList.edgeDriveClientAssoc type),	--Edge Drive Associations
											(
											 SELECT
												(
												 SELECT UG.id as 'externalGroup/@id',
														UG.name as 'externalGroup/@name',
														UP.id as 'externalGroup/@umdsProviderId',
														UP.domainName as 'externalGroup/@umdsProviderName'
												 FROM APP_ClientProp CP cross apply
dbo.SplitIDString(replace(CP.attrVal,':',',')) T
												 INNER JOIN UMGroups UG on UG.id = T._ID
												 INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
												 WHERE CP.componentNameId = TmpFClList.clientid
												 AND CP.attrName = 'OutlookAddin ContentStore UserGroups'
												 AND CP.modified = 0
												 FOR XML PATH('userGroups'), TYPE
												 )
											 FOR XML PATH('outlookAddinStoreInfo'), TYPE
											 ),
											 (
												SELECT C.id AS '@clientId',
													   C.name AS '@clientName'
												FROM App_Client C
												WHERE C.id = TmpFClList.edgeDriveStagingMachine
												FOR XML PATH('stagingMachine'), TYPE
											 ),
											 (
												SELECT impersonateUserName AS '@userName'
												FOR XML PATH('impersonateUser'), TYPE
											 ),
											 (
												SELECT itemPath AS '@itemPath'
												FROM #selectiveSyncContent
												FOR XML PATH('selectiveItemsToSync'), TYPE
											 )
										FOR XML PATH('edgeDrivePseudoClientProperties'),TYPE),
									(SELECT propertyTypeId       AS '@clientCustomAttributeType',
											stringVal            AS '@attributeValue'
											FROM @PseudoClientComponentTbl
									 FOR XML PATH('customAttributes'), TYPE),
									(SELECT
									(SELECT c.id as '@clientId',
										C.name as '@clientName'
									from APP_ClientProp CP cross apply
dbo.SplitIDString(replace(CP.attrVal,':',',')) T
									inner join App_Client C
									on c.id = T._ID
									where CP.componentNameId = TmpFClList.clientid
									and CP.attrName='Object Server Member Servers List'
									and CP.modified=0
										FOR XML PATH('proxyServers'), TYPE),
										(SELECT
											(SELECT
												(SELECT
													(SELECT
														C.name as '@clientName',
														C.id as '@clientId'
													FROM APP_ClientProp CP
													INNER JOIN App_Client C
ON C.id = CP.attrVal AND CP.attrName = 'Cloud Indexing Server'
													WHERE CP.componentNameId = TmpFClList.clientid
														AND CP.modified = 0
													FOR XML PATH('indexServer'), TYPE)
												FOR XML PATH('generalCloudProperties'), TYPE)
											FOR XML PATH('cloudAppsInstance'), TYPE)
										FOR XML PATH('instance'), TYPE)
									FOR XML PATH('cloudClonnectorProperties'), TYPE),
									(SELECT S.ControlHostId			AS '@arrayId',
											S.SMArrayId				AS '@arrayName'
										FROM SMControlHost S WHERE S.ControlHostId = TmpFClList.nutanixFileServerId OR S.ClientId = TmpFClList.clientid
									 FOR XML PATH('fileServerInfo'), TYPE),
									(SELECT TmpFClList.nasClusterClientPropertiesXML TYPE),
									(SELECT	TmpFClList.sharePointPseudoClientProps TYPE),
									(SELECT po.value('@credentialId', 'int') as '@credentialId', po.value('@credentialName', 'NVARCHAR(MAX)') as '@credentialName'
										FROM (SELECT TmpFClList.fileServerCredential fsc ) PROP
										CROSS APPLY PROP.fsc.nodes('CvEntities_CredentialEntity') P(po)
									FOR XML PATH('userSavedCredentials'), TYPE),
									(SELECT po.value('@userName', 'NVARCHAR(MAX)') as '@userName'
										FROM (SELECT TmpFClList.fileServerCredential fsc ) PROP
										CROSS APPLY PROP.fsc.nodes('Common_UserPassword') P(po)
									FOR XML PATH('userCredentials'), TYPE),
									(SELECT(
										(SELECT
											(SELECT sqlOverride '@overrideGlobalAuthentication',
													sqlUseLocalSystem '@useLocalSystemAccount',
													(SELECT sqlUsername '@userName', sqlPassword '@password' FOR XML PATH('userAccount'), TYPE)
												FOR XML PATH('overrideHigherLevelSettings'), TYPE),
											(SELECT	azureStorageConnectionString '@azureStorageConnectionString',
												(SELECT azureSQLUsername as '@userName'
												FOR XML PATH('azureSqlInstanceCredentials'),TYPE)
											FOR XML PATH('azureInfo'),TYPE),
											(SELECT	s3BucketName '@s3BucketName',
												(SELECT awsSqlInstanceUsername as '@userName'
												FOR XML PATH('sqlInstanceCredentials'),TYPE)
											FOR XML PATH('awsSqlInfo'),TYPE)
										FOR XML PATH('sql61Prop'),TYPE))
									FOR XML PATH('idaInfo'),TYPE),
									-- pseudoClientInfo.nasClientProperties
									(SELECT
										NasVendorType '@vendorType'
										WHERE NasVendorType IS NOT NULL
										FOR XML PATH('nasClientProperties'),TYPE),
									-- migrate Server details.
									(SELECT migrationServerXML.query('.')
									FOR XML PATH (''), TYPE)
									FOR XML PATH('pseudoClientInfo'),TYPE),
								----------------------------------------------------------------------------
								(SELECT TmpFinalActivePhyNode.ActPhyNodeclientID AS '@clientId',-- Fix me
										TmpFinalActivePhyNode.ActPhyNodeclientName AS '@clientName',-- Fix me
										TmpFinalActivePhyNode.ActPhyNodeclientHostName AS '@hostName'-- Fix me
								FROM @FinalActivePhyNode AS TmpFinalActivePhyNode
								WHERE TmpFinalActivePhyNode.clientid = TmpFClList.clientid
								FOR XML PATH('ActivePhysicalNode'), TYPE),
								--------------------------------------------------------------------------
								(SELECT TmpFinalLicenseEntity.LicenseID AS '@LicenseId',
										TmpFinalLicenseEntity.LicenseName AS '@LicenseName'
								FROM @FinalLicenseEntity AS TmpFinalLicenseEntity
								WHERE TmpFinalLicenseEntity.clientid = TmpFClList.clientid
								FOR XML PATH('AdvancedFeatures'), TYPE),
								--------------------------------------------------------------------------
								(SELECT tmpPseudoClients.clientid AS '@id',
										tmpPseudoClients.proxyClientName AS '@name'
								FROM @PseudoClients AS tmpPseudoClients
								FOR XML PATH('PseudoClients'), TYPE)
FROM @FinalClientList AS TmpFClList
FOR XML PATH('clients'), TYPE)
END
ELSE
BEGIN
	SET @xmlQuery = (SELECT
								(SELECT
									(SELECT activityControlXML AS 'clientActivityControl'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid AND @getActivityControlProperty =1
									FOR XML PATH(''),TYPE),
									(SELECT securityXML AS 'clientSecurity'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid AND @getSecurityProperty =1
									FOR XML PATH (''),TYPE),
									(SELECT firewallXML AS 'firewallConfiguration'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid AND @getFirewallProperty =1
									FOR XML PATH (''),TYPE),
									(SELECT networkthrottlingXML AS 'networkThrottle'
									FROM @FinalXMLList as TmpXmlList
									WHERE TmpXmlList.clientId = TmpFinalClientList.clientid AND @getNetworkThrottleProperty =1
									FOR XML PATH (''),TYPE),
										(SELECT
											 CR.keyName as '@keyName',
											 CR.type as '@type',
											 (CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
											 CR.relativepath as '@relativepath',
											 --CR.deleted as '@deleted',
											 CR.enabled as '@enabled',
											 ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
											 (CASE CR.sourceId WHEN 0 THEN 0 ELSE 1 END) as '@isInheritedFromClientGroup', --source entityType assumed as 28 i.e CLIENT_GROUP_ENTITY
											 (SELECT
												CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
												CASE CR.sourceEntityType WHEN 28 THEN CR.sourceId ELSE NULL END AS '@clientGroupId',
												CASE CR.sourceEntityType WHEN 3 THEN  CR.sourceId ELSE NULL END AS '@clientId'
											 FOR XML PATH('sourceEntity'),TYPE)
											 FROM APP_AdvanceSettings as CR
											 LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx
										     	 ON CR.id = AdvEx.keyId
											 WHERE CR.entityId = TmpFClList.clientid AND CR.entityType = 3 --CLIENT_ENTITY
											 and CR.deleted = 0 and ISNULL(AdvEx.hidden,0) = 0
											 AND @getRegistryProperty = 1
											 FOR XML PATH('registryKeys'),TYPE),
									(SELECT stp.storagePolicyId AS '@storagePolicyId',
									stp.storagePolicyName AS '@storagePolicyName'
									FROM @storagePolicyTbl AS stp
									WHERE stp.clientId = TmpFinalClientList.clientid AND @getStoragePolicyProperty = 1
									FOR XML PATH('dataBackupStoragePolicy'), TYPE)
									FROM @FinalClientList AS TmpFinalClientList
									where TmpFinalClientList.clientid = TmpFClList.clientid
									FOR XML PATH('clientProps'), TYPE),
									------------------------------------------------------------------------------------------------
									(SELECT
                                                                           (SELECT TmpFinalClientList2.clientid AS '@clientId',
                                                                                         TmpFinalClientList2.ClientName AS '@clientName',
                                                                                         TmpFinalClientList2.ClientHostName AS '@hostName',
                                                                                         TmpFinalClientList2.ClientCSHostName AS '@commCellName',
												TmpFinalClientList2.clientGuid as '@clientGUID'
                                                                           FROM @FinalClientList AS TmpFinalClientList2
                                                                           WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
                                                                           FOR XML PATH('clientEntity'), TYPE),
                                                                            (SELECT
																				(SELECT
																					 I.r_appId  '@applicationId',
																			 		 I.r_appName        '@appName',
4 as '@_type_'
																				 FOR XML PATH('idaEntity'),TYPE) ,
																				(SELECT
																					 I.r_SLAStatus			'@slaStatus',
																					 I.r_SLADescription      '@slaCategoryDescription',
																					 I.r_slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList
																				 FOR XML PATH('summary'),TYPE)
																			FROM #idaInfoTbl I    WHERE  I.r_clientId  = TmpFinalClientList1.clientid and @getidaList=1
																			FOR XML PATH('idaList'),TYPE) ,
                                                                           (SELECT
                                                                                  S.id as '@osId',
                                                                                  S.Type as '@Type',
                                                                                  S.SubType as '@SubType',
                                                                                  (SELECT dbo.GetClientOSName(TmpFinalClientList3.clientid, NULL) AS '@OSName',
                                                                                  --(SELECT TmpFinalClientList3.OSName AS '@OSName',
                                                                                                dbo.GetClientHardwareName(TmpFinalClientList3.clientid, NULL) AS '@ProcessorType'--Fix me
                                                                                  FROM @FinalClientList AS TmpFinalClientList3
                                                                                  WHERE TmpFinalClientList3.clientid = TmpFinalClientList2.clientid
                                                                                  FOR XML PATH('OsDisplayInfo'), TYPE)
                                                                     FROM @FinalClientList AS TmpFinalClientList2,
                                                                     simOperatingSystem as S
                                                                     WHERE TmpFinalClientList1.clientid = TmpFinalClientList2.clientid
                                                                     and S.id = (SELECT simOperatingSystemId FROM APP_Client WHERE id = TmpFinalClientList1.clientId) and @getOsInfoProperty=1
                                                                     FOR XML PATH('osInfo'), TYPE),
                                                                     (SELECT TmpFinalClientList4.VersionInfo AS 'versionInfo' from @FinalClientList as TmpFinalClientList4 where  @getVersionInfoProperty=1 and TmpFinalClientList4.clientid=TmpFinalClientList1.clientid FOR XML PATH(''), TYPE)
                                                              FROM @FinalClientList AS TmpFinalClientList1
                                                              WHERE TmpFinalClientList1.clientid = TmpFClList.clientid
                                                              FOR XML PATH('client'), TYPE),
									----------------------------------------------------------------------------
									(SELECT     c_id AS '@clientGroupId',
												c_name AS '@clientGroupName'
									FROM         @clientGroupList
									WHERE     (c_id IN (SELECT	clientGroupId
														FROM	APP_ClientGroupAssoc
														WHERE      (clientId = TmpFClList.clientid)))
									AND @getAssociatedCGProperty = 1
									FOR XML PATH('clientGroups'), TYPE)
		FROM @FinalClientList AS TmpFClList
		FOR XML PATH('clients'), TYPE)
END
ALL_DONE:
--This is needed as the req and response is changed.
-- Once Reports team and SIM team confirms we can remove extra processing.
IF @Clientprop = 1
BEGIN
	SET @errorXML = (SELECT errorString as '@errorString',
							errorCode as '@errorCode',
							(SELECT clientid as '@clientId',
									clientName as '@clientName'
									FOR XML PATH('entity'),TYPE)
					 FROM @ErrorTable
					 FOR XML PATH('errors'),TYPE)
	SET @outvar = CONVERT (nvarchar(max),@xmlQuery)
	SET @outvar = (SELECT REPLACE(@outvar,'<clients>','<clientProperties>'))
	SET @outvar = (SELECT REPLACE(@outvar,'</clients>','</clientProperties>'))
	SEt @xmlQuery =	@outvar
	SET @xmlQuery = (select @xmlQuery,@errorXML
	FOR XML PATH(''),ROOT('App_GetClientPropertiesResponse'))
END
ELSE
BEGIN
	SET @xmlQuery = (select @xmlQuery
	FOR XML PATH(''),ROOT('App_ClientsList'))
END
SELECT @xmlQuery AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetClientProperties')
	delete from GxQscripts where name = 'AppGetClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetClientProperties'
GO

insert into GXDBVersions values(2, 'AppGetClientProperties',  'v1.147.2.151.4.1', 'AppGetClientProperties', 'v1.147.2.151.4.1')
GO

