

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetClientListforInstallUpdate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetClientListforInstallUpdate.sp,v $ $Id: AppGetClientListforInstallUpdate.sp,v 1.18.80.10 2020/09/17 01:52:57 mnalamothu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetClientListforInstallUpdate')
BEGIN
	print '>>> Drop Stored Procedure: APPGetClientListforInstallUpdate <<<'
	drop procedure APPGetClientListforInstallUpdate
END
IF EXISTS (select * from GxQscripts where name='APPGetClientListforInstallUpdate')
	delete from GxQscripts where name = 'APPGetClientListforInstallUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientListforInstallUpdate')
	delete from GXDBVersions where aliasname = 'APPGetClientListforInstallUpdate'
GO
print '... Creating Procedure: APPGetClientListforInstallUpdate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetClientListforInstallUpdate
  @inIsJMContext INT,
  @inOpType INT,
  @inJobID integer,
  @inIsUpgrade INT = 0
AS
  DECLARE @errorCode integer
DECLARE @clientsAndGroups XML
DECLARE @clientOrGroupID int
DECLARE @entityType	INT
IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL
    DROP TABLE #ClientList
IF OBJECT_ID('tempdb.dbo.#excludeList') IS NOT NULL
    DROP TABLE #excludeList
IF OBJECT_ID('tempdb.dbo.#entityTableList') IS NOT NULL
    DROP TABLE #entityTableList
CREATE TABLE #ClientList
(
	id INTEGER,
	name nvarchar(256),
	primary key(id)
);
CREATE TABLE #excludeList
(
	id INTEGER,
	primary key(id)
)
CREATE TABLE #entityTableList
(
	entityType INTEGER, clientID INTEGER,clientGroupID INTEGER,exclude INTEGER DEFAULT 0,
);
CREATE INDEX TempEntityTable_EntityType_idx ON #entityTableList(entityType)
CREATE INDEX TempEntityTable_Client_Exclude_idx ON #entityTableList(clientID,exclude)
CREATE INDEX TempEntityTable_ClientGroup_Exclude_idx ON #entityTableList(clientGroupID,exclude)
DECLARE @entityXML XML
DECLARE @excludeFlag INT
SET @errorCode = 0
SET NOCOUNT ON
-- This means scheduler is calling during option insert. So insert all the client IDs in TM_JobOptions
IF @inIsJMContext = 0
BEGIN
	IF @inOpType = 35 -- Install Update
	BEGIN
		SET @entityXML = (select CONVERT(xml,value) as 'node()' from dbo.GetAllJobOptions(@inJobID)
where optionId = 239177580  FOR XML PATH(''), ROOT('entityXML'))
		INSERT INTO #entityTableList(entityType,clientID,clientGroupID,exclude)
		SELECT CASE
WHEN ISNULL(ref.value('@clientId','int'),0) > 0 THEN 3
WHEN ISNULL(ref.value('@clientGroupId','int'),0) > 0 THEN 28
				ELSE
					ref.value('@_type_','int')
			    END,
				ISNULL(ref.value('@clientId','int'),0),
				ISNULL(ref.value('@clientGroupId','int'),0),
				ISNULL(F.C.value('@exclude','int'),0)
		FROM @entityXML.nodes('entityXML/clientAndClientGroups') R(ref)
				outer apply R.ref.nodes('flags') as F(C)
	INSERT INTO #ClientList
	SELECT DISTINCT client.id, client.name FROM App_Client client WITH(NOLOCK)
INNER JOIN #entityTableList E ON entityType = 2
							LEFT JOIN #ClientList T ON T.id = client.id
	WHERE client.id > 1 AND T.id IS NULL
	INSERT INTO #ClientList
	SELECT client.id,client.name FROM APP_Client client WITH(NOLOCK)
						LEFT JOIN #ClientList T ON T.id = client.id
INNER JOIN #entityTableList E ON E.clientID  > 1 AND E.entityType = 3 AND E.exclude = 0 AND E.clientID = client.id
	WHERE T.id IS NULL
	INSERT INTO #ClientList
	SELECT DISTINCT APP_ClientGroupAssoc.clientId, APP_Client.name FROM APP_ClientGroupAssoc WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 27 AND E.exclude = 0
					INNER JOIN APP_Client WITH(NOLOCK) ON APP_ClientGroupAssoc.clientId = APP_Client.id
					LEFT JOIN #ClientList T ON T.id = APP_Client.id
	WHERE T.id IS NULL
	INSERT INTO #ClientList
	SELECT DISTINCT A.clientId,C.name FROM APP_ClientGroupAssoc A WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 28 AND E.clientGroupID =  A.clientGroupId AND E.exclude = 0
					INNER JOIN APP_Client C WITH(NOLOCK) ON A.clientId=C.id
					LEFT JOIN #ClientList T ON T.id = C.id
	WHERE T.id IS NULL
	INSERT INTO #excludeList
	SELECT DISTINCT client.id FROM APP_Client client WITH(NOLOCK)
						LEFT JOIN #excludeList T ON T.id = client.id
INNER JOIN #entityTableList E ON E.clientID  > 1 AND E.entityType = 3 AND E.exclude = 1 AND E.clientID = client.id
	WHERE T.id IS NULL
	INSERT INTO #excludeList
	SELECT DISTINCT A.clientId FROM APP_ClientGroupAssoc A WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 28 AND E.clientGroupID =  A.clientGroupId AND E.exclude = 1
					INNER JOIN APP_Client C WITH(NOLOCK) ON A.clientId=C.id
					LEFT JOIN #excludeList T ON T.id = C.id
	WHERE T.id IS NULL
DONE_FOR_INSTALLUPDATES:
		-- For user centric clients, install update request should be routed to Physical clients
		UPDATE C
			SET C.id=CAST(ACP1.attrVal AS INT)
		FROM #ClientList C
		INNER JOIN APP_ClientProp ACP
ON ACP.componentNameId=C.id AND ACP.attrName='User Centric Client' AND ACP.attrVal='1' AND ACP.modified=0
		INNER JOIN APP_ClientProp ACP1
ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Physical Client Id' AND ACP1.modified=0
		LEFT OUTER JOIN #ClientList C2
			ON CAST(C2.id AS NVARCHAR(32))=ACP1.attrVal
		WHERE (ACP1.attrVal IS NOT NULL) AND (ACP1.attrVal<>'0') AND C2.id IS NULL
		SELECT DISTINCT C.id
		from #ClientList C INNER JOIN simInstalledPackages P WITH(NOLOCK) ON C.id = P.ClientId
		LEFT JOIN #excludeList E ON C.id = E.id
		WHERE E.id IS NULL
		SELECT @errorCode = @@ERROR
	END
END
ELSE IF @inIsJMContext = 1
BEGIN
	IF @inOpType = 35 -- Install Updates
	BEGIN
		INSERT INTO JMQinetixUpdateStatus
		SELECT DISTINCT OPT.jobId, 2 /*commcellId*/, CL.id, CL.name, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0
		FROM TM_JobOptions OPT WITH (NOLOCK)
INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = CAST(OPT.value AS INT) AND OPT.optionId = 130007
		LEFT OUTER JOIN JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)ON OPT.jobId = JUPDATE.jobId AND CAST(OPT.value AS INT) = JUPDATE.clientId
		WHERE OPT.jobId = @inJobID
		AND JUPDATE.jobId is null
		AND (@inIsUpgrade = 0 OR CL.id > 2) -- Dont include CS client in upgrade job.
		-- Support to add failover clients to the same job when CommServe client is selected
		IF EXISTS (SELECT 1 FROM JMQinetixUpdateStatus WITH (NOLOCK) WHERE clientId = 2 AND jobId = @inJobID)
		AND NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'DisableAutomaticUpdateFailoverClients' AND value = 1)
		BEGIN
			INSERT INTO JMQinetixUpdateStatus
			SELECT DISTINCT @inJobID, 2 /*commcellId*/, CL.id, CL.name, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0
			FROM APP_Client CL WITH (NOLOCK)
			INNER JOIN APP_ClientProp CLP WITH (NOLOCK) ON CLP.attrName = 'Linked CS Client' AND CLP.componentNameId = CL.id  AND CLP.modified = 0
			WHERE CL.id NOT IN
			(SELECT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK) WHERE JUPDATE.jobId = @inJobID)
		END
		SELECT @errorCode = @@ERROR
	END
	ELSE IF @inOpType = 68 --Uninstall Software
	BEGIN
		SET @entityXML = (select CONVERT(xml,value) as 'node()' from dbo.GetAllJobOptions(@inJobID)
where optionId = 150015  FOR XML PATH(''), ROOT('entityXML'))
		INSERT INTO #entityTableList(entityType,clientID,clientGroupID,exclude)
		SELECT CASE
WHEN ISNULL(ref.value('@clientId','int'),0) > 0 THEN 3
WHEN ISNULL(ref.value('@clientGroupId','int'),0) > 0 THEN 28
				ELSE
					ref.value('@_type_','int')
			    END,
				ISNULL(ref.value('@clientId','int'),0),
				ISNULL(ref.value('@clientGroupId','int'),0),
				ISNULL(F.C.value('@exclude','int'),0)
		FROM @entityXML.nodes('entityXML/clientDetails/clientEntity') R(ref)
				outer apply R.ref.nodes('flags') as F(C)
	INSERT INTO #ClientList
	SELECT DISTINCT client.id, client.name FROM App_Client client WITH(NOLOCK)
INNER JOIN #entityTableList E ON entityType = 2
							LEFT JOIN #ClientList T ON T.id = client.id
	WHERE client.id > 1 AND T.id IS NULL
	INSERT INTO #ClientList
	SELECT client.id,client.name FROM APP_Client client WITH(NOLOCK)
						LEFT JOIN #ClientList T ON T.id = client.id
INNER JOIN #entityTableList E ON E.clientID  > 1 AND E.entityType = 3 AND E.exclude = 0 AND E.clientID = client.id
	WHERE T.id IS NULL
	INSERT INTO #ClientList
	SELECT DISTINCT APP_ClientGroupAssoc.clientId, APP_Client.name FROM APP_ClientGroupAssoc WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 27 AND E.exclude = 0
					INNER JOIN APP_Client WITH(NOLOCK) ON APP_ClientGroupAssoc.clientId = APP_Client.id
					LEFT JOIN #ClientList T ON T.id = APP_Client.id
	WHERE T.id IS NULL
	INSERT INTO #ClientList
	SELECT DISTINCT A.clientId,C.name FROM APP_ClientGroupAssoc A WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 28 AND E.clientGroupID =  A.clientGroupId AND E.exclude = 0
					INNER JOIN APP_Client C WITH(NOLOCK) ON A.clientId=C.id
					LEFT JOIN #ClientList T ON T.id = C.id
	WHERE T.id IS NULL
	INSERT INTO #excludeList
	SELECT DISTINCT client.id FROM APP_Client client WITH(NOLOCK)
						LEFT JOIN #excludeList T ON T.id = client.id
INNER JOIN #entityTableList E ON E.clientID  > 1 AND E.entityType = 3 AND E.exclude = 1 AND E.clientID = client.id
	WHERE T.id IS NULL
	INSERT INTO #excludeList
	SELECT DISTINCT A.clientId FROM APP_ClientGroupAssoc A WITH(NOLOCK)
INNER JOIN #entityTableList E ON E.entityType = 28 AND E.clientGroupID =  A.clientGroupId AND E.exclude = 1
					INNER JOIN APP_Client C WITH(NOLOCK) ON A.clientId=C.id
					LEFT JOIN #excludeList T ON T.id = C.id
	WHERE T.id IS NULL
		DONE_FOR_UNINSTALL_SW:
			INSERT INTO JMQinetixUpdateStatus
			SELECT DISTINCT @inJobID, 2 /*commCellId*/, C.id, C.name, 5001 /*QGENERIC_TO_BE_DONE*/, 7 /*QCATECORY_WAITING*/, 0, 0, '', '', '', '', 0
			FROM #ClientList C LEFT JOIN #excludeList E ON C.id = E.id
			WHERE E.id IS NULL
			SELECT @errorCode = @@ERROR
	END
END
DROP TABLE #ClientList
DROP TABLE #excludeList
DROP TABLE #entityTableList
SELECT @errorCode
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'AppGetClientListforInstallUpdate')
	delete from GxQscripts where name = 'AppGetClientListforInstallUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetClientListforInstallUpdate')
	delete from GXDBVersions where aliasname = 'AppGetClientListforInstallUpdate'
GO

insert into GXDBVersions values(2, 'AppGetClientListforInstallUpdate',  '00010018008000100000', 'AppGetClientListforInstallUpdate', '00010018008000100000')
GO

